/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.records.reader;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.datavec.api.records.listener.RecordListener;
import org.datavec.api.records.reader.RecordReader;
import org.datavec.api.writable.Writable;

public abstract class BaseRecordReader
implements RecordReader {
    protected List<RecordListener> listeners = new ArrayList<RecordListener>();

    protected void invokeListeners(Object record) {
        for (RecordListener listener : this.listeners) {
            listener.recordRead(this, record);
        }
    }

    @Override
    public List<RecordListener> getListeners() {
        return this.listeners;
    }

    @Override
    public void setListeners(Collection<RecordListener> listeners) {
        this.listeners = listeners instanceof List ? (List<Object>)listeners : new ArrayList<RecordListener>(listeners);
    }

    @Override
    public void setListeners(RecordListener ... listeners) {
        this.setListeners(Arrays.asList(listeners));
    }

    @Override
    public boolean batchesSupported() {
        return false;
    }

    @Override
    public List<Writable> next(int num) {
        throw new UnsupportedOperationException();
    }
}

