/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.split;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import org.datavec.api.io.filters.PathFilter;
import org.datavec.api.split.CollectionInputSplit;
import org.datavec.api.split.InputSplit;

public abstract class BaseInputSplit
implements InputSplit {
    protected URI[] locations;
    protected long length = 0L;

    @Override
    public URI[] locations() {
        return this.locations;
    }

    @Override
    public long length() {
        return 0L;
    }

    @Override
    public double toDouble() {
        throw new UnsupportedOperationException();
    }

    @Override
    public float toFloat() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int toInt() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long toLong() {
        throw new UnsupportedOperationException();
    }

    public InputSplit[] sample(PathFilter pathFilter, double ... weights) {
        URI[] paths;
        URI[] uRIArray = paths = pathFilter != null ? pathFilter.filter(this.locations()) : this.locations();
        if (weights != null && weights.length > 0 && weights[0] != 1.0) {
            int i;
            InputSplit[] splits = new InputSplit[weights.length];
            double totalWeight = 0.0;
            for (int i2 = 0; i2 < weights.length; ++i2) {
                totalWeight += weights[i2];
            }
            double cumulWeight = 0.0;
            int[] partitions = new int[weights.length + 1];
            for (i = 0; i < weights.length; ++i) {
                partitions[i] = (int)Math.round(cumulWeight * (double)paths.length / totalWeight);
                cumulWeight += weights[i];
            }
            partitions[weights.length] = paths.length;
            for (i = 0; i < weights.length; ++i) {
                ArrayList<URI> uris = new ArrayList<URI>();
                for (int j = partitions[i]; j < partitions[i + 1]; ++j) {
                    uris.add(paths[j]);
                }
                splits[i] = new CollectionInputSplit(uris);
            }
            return splits;
        }
        return new InputSplit[]{new CollectionInputSplit(Arrays.asList(paths))};
    }
}

