/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.records.metadata;

import java.beans.ConstructorProperties;
import java.net.URI;
import org.apache.commons.io.FilenameUtils;
import org.datavec.api.records.metadata.RecordMetaData;

public class RecordMetaDataLineInterval
implements RecordMetaData {
    private int lineNumberStart;
    private int lineNumberEnd;
    private URI uri;
    private Class<?> readerClass;

    @Override
    public String getLocation() {
        String filename;
        if (this.uri != null) {
            String str = this.uri.toString();
            filename = FilenameUtils.getBaseName((String)str) + "." + FilenameUtils.getExtension((String)str) + " ";
        } else {
            filename = "";
        }
        return filename + "lines " + this.lineNumberStart + "-" + this.lineNumberEnd;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public Class<?> getReaderClass() {
        return this.readerClass;
    }

    @ConstructorProperties(value={"lineNumberStart", "lineNumberEnd", "uri", "readerClass"})
    public RecordMetaDataLineInterval(int lineNumberStart, int lineNumberEnd, URI uri, Class<?> readerClass) {
        this.lineNumberStart = lineNumberStart;
        this.lineNumberEnd = lineNumberEnd;
        this.uri = uri;
        this.readerClass = readerClass;
    }

    public int getLineNumberStart() {
        return this.lineNumberStart;
    }

    public int getLineNumberEnd() {
        return this.lineNumberEnd;
    }

    public void setLineNumberStart(int lineNumberStart) {
        this.lineNumberStart = lineNumberStart;
    }

    public void setLineNumberEnd(int lineNumberEnd) {
        this.lineNumberEnd = lineNumberEnd;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public void setReaderClass(Class<?> readerClass) {
        this.readerClass = readerClass;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RecordMetaDataLineInterval)) {
            return false;
        }
        RecordMetaDataLineInterval other = (RecordMetaDataLineInterval)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLineNumberStart() != other.getLineNumberStart()) {
            return false;
        }
        if (this.getLineNumberEnd() != other.getLineNumberEnd()) {
            return false;
        }
        URI this$uri = this.getURI();
        URI other$uri = other.getURI();
        if (this$uri == null ? other$uri != null : !((Object)this$uri).equals(other$uri)) {
            return false;
        }
        Class<?> this$readerClass = this.getReaderClass();
        Class<?> other$readerClass = other.getReaderClass();
        return !(this$readerClass == null ? other$readerClass != null : !this$readerClass.equals(other$readerClass));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RecordMetaDataLineInterval;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLineNumberStart();
        result = result * 59 + this.getLineNumberEnd();
        URI $uri = this.getURI();
        result = result * 59 + ($uri == null ? 43 : ((Object)$uri).hashCode());
        Class<?> $readerClass = this.getReaderClass();
        result = result * 59 + ($readerClass == null ? 43 : $readerClass.hashCode());
        return result;
    }

    public String toString() {
        return "RecordMetaDataLineInterval(lineNumberStart=" + this.getLineNumberStart() + ", lineNumberEnd=" + this.getLineNumberEnd() + ", uri=" + this.getURI() + ", readerClass=" + this.getReaderClass() + ")";
    }
}

