/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.sequence.comparator;

import java.util.List;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.transform.sequence.SequenceComparator;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.jackson.annotation.JsonIgnoreProperties;

@JsonIgnoreProperties(value={"schema", "columnIdx"})
public abstract class BaseColumnComparator
implements SequenceComparator {
    protected Schema schema;
    protected final String columnName;
    protected int columnIdx = -1;

    protected BaseColumnComparator(String columnName) {
        this.columnName = columnName;
    }

    @Override
    public void setSchema(Schema sequenceSchema) {
        this.schema = sequenceSchema;
        this.columnIdx = sequenceSchema.getIndexOfColumn(this.columnName);
    }

    @Override
    public int compare(List<Writable> o1, List<Writable> o2) {
        return this.compare(BaseColumnComparator.get(o1, this.columnIdx), BaseColumnComparator.get(o2, this.columnIdx));
    }

    private static Writable get(List<Writable> c, int idx) {
        return c.get(idx);
    }

    @Override
    protected abstract int compare(Writable var1, Writable var2);

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseColumnComparator)) {
            return false;
        }
        BaseColumnComparator other = (BaseColumnComparator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$columnName = this.columnName;
        String other$columnName = other.columnName;
        return !(this$columnName == null ? other$columnName != null : !this$columnName.equals(other$columnName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseColumnComparator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $columnName = this.columnName;
        result = result * 59 + ($columnName == null ? 43 : $columnName.hashCode());
        return result;
    }
}

