/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.time;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.datavec.api.transform.ColumnType;
import org.datavec.api.transform.Transform;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.metadata.IntegerMetaData;
import org.datavec.api.transform.metadata.StringMetaData;
import org.datavec.api.transform.metadata.TimeMetaData;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.util.jackson.DateTimeFieldTypeDeserializer;
import org.datavec.api.util.jackson.DateTimeFieldTypeSerializer;
import org.datavec.api.writable.IntWritable;
import org.datavec.api.writable.Text;
import org.datavec.api.writable.Writable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@JsonIgnoreProperties(value={"inputSchema", "insertAfterIdx", "deriveFromIdx"})
public class DeriveColumnsFromTimeTransform
implements Transform {
    private final String columnName;
    private final String insertAfter;
    private DateTimeZone inputTimeZone;
    private final List<DerivedColumn> derivedColumns;
    private Schema inputSchema;
    private int insertAfterIdx = -1;
    private int deriveFromIdx = -1;

    private DeriveColumnsFromTimeTransform(Builder builder) {
        this.derivedColumns = builder.derivedColumns;
        this.columnName = builder.columnName;
        this.insertAfter = builder.insertAfter;
    }

    public DeriveColumnsFromTimeTransform(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="insertAfter") String insertAfter, @JsonProperty(value="inputTimeZone") DateTimeZone inputTimeZone, @JsonProperty(value="derivedColumns") List<DerivedColumn> derivedColumns) {
        this.columnName = columnName;
        this.insertAfter = insertAfter;
        this.inputTimeZone = inputTimeZone;
        this.derivedColumns = derivedColumns;
    }

    @Override
    public Schema transform(Schema inputSchema) {
        List<ColumnMetaData> oldMeta = inputSchema.getColumnMetaData();
        ArrayList<ColumnMetaData> newMeta = new ArrayList<ColumnMetaData>(oldMeta.size() + this.derivedColumns.size());
        List<String> oldNames = inputSchema.getColumnNames();
        for (int i = 0; i < oldMeta.size(); ++i) {
            String current = oldNames.get(i);
            newMeta.add(oldMeta.get(i));
            if (!this.insertAfter.equals(current)) continue;
            block5: for (DerivedColumn d : this.derivedColumns) {
                switch (d.columnType) {
                    case String: {
                        newMeta.add(new StringMetaData(d.columnName));
                        continue block5;
                    }
                    case Integer: {
                        newMeta.add(new IntegerMetaData(d.columnName));
                        continue block5;
                    }
                }
                throw new IllegalStateException("Unexpected column type: " + (Object)((Object)d.columnType));
            }
        }
        return inputSchema.newSchema(newMeta);
    }

    @Override
    public void setInputSchema(Schema inputSchema) {
        this.insertAfterIdx = inputSchema.getColumnNames().indexOf(this.insertAfter);
        if (this.insertAfterIdx == -1) {
            throw new IllegalStateException("Invalid schema/insert after column: input schema does not contain column \"" + this.insertAfter + "\"");
        }
        this.deriveFromIdx = inputSchema.getColumnNames().indexOf(this.columnName);
        if (this.deriveFromIdx == -1) {
            throw new IllegalStateException("Invalid source column: input schema does not contain column \"" + this.columnName + "\"");
        }
        this.inputSchema = inputSchema;
        if (!(inputSchema.getMetaData(this.columnName) instanceof TimeMetaData)) {
            throw new IllegalStateException("Invalid state: input column \"" + this.columnName + "\" is not a time column. Is: " + inputSchema.getMetaData(this.columnName));
        }
        TimeMetaData meta = (TimeMetaData)inputSchema.getMetaData(this.columnName);
        this.inputTimeZone = meta.getTimeZone();
    }

    @Override
    public Schema getInputSchema() {
        return this.inputSchema;
    }

    @Override
    public List<Writable> map(List<Writable> writables) {
        if (writables.size() != this.inputSchema.numColumns()) {
            throw new IllegalStateException("Cannot execute transform: input writables list length (" + writables.size() + ") does not match expected number of elements (schema: " + this.inputSchema.numColumns() + "). Transform = " + this.toString());
        }
        int i = 0;
        Writable source = writables.get(this.deriveFromIdx);
        ArrayList<Writable> list = new ArrayList<Writable>(writables.size() + this.derivedColumns.size());
        for (Writable w : writables) {
            list.add(w);
            if (i++ != this.insertAfterIdx) continue;
            block5: for (DerivedColumn d : this.derivedColumns) {
                switch (d.columnType) {
                    case String: {
                        list.add(new Text(d.dateTimeFormatter.print(source.toLong())));
                        continue block5;
                    }
                    case Integer: {
                        DateTime dt = new DateTime(source.toLong(), this.inputTimeZone);
                        list.add(new IntWritable(dt.get(d.fieldType)));
                        continue block5;
                    }
                }
                throw new IllegalStateException("Unexpected column type: " + (Object)((Object)d.columnType));
            }
        }
        return list;
    }

    @Override
    public List<List<Writable>> mapSequence(List<List<Writable>> sequence) {
        ArrayList<List<Writable>> out = new ArrayList<List<Writable>>(sequence.size());
        for (List<Writable> step : sequence) {
            out.add(this.map(step));
        }
        return out;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DeriveColumnsFromTimeTransform(timeColumn=\"").append(this.columnName).append("\",insertAfter=\"").append(this.insertAfter).append("\",derivedColumns=(");
        boolean first = true;
        for (DerivedColumn d : this.derivedColumns) {
            if (!first) {
                sb.append(",");
            }
            sb.append(d);
            first = false;
        }
        sb.append("))");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeriveColumnsFromTimeTransform)) {
            return false;
        }
        DeriveColumnsFromTimeTransform other = (DeriveColumnsFromTimeTransform)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$columnName = this.columnName;
        String other$columnName = other.columnName;
        if (this$columnName == null ? other$columnName != null : !this$columnName.equals(other$columnName)) {
            return false;
        }
        String this$insertAfter = this.insertAfter;
        String other$insertAfter = other.insertAfter;
        if (this$insertAfter == null ? other$insertAfter != null : !this$insertAfter.equals(other$insertAfter)) {
            return false;
        }
        DateTimeZone this$inputTimeZone = this.inputTimeZone;
        DateTimeZone other$inputTimeZone = other.inputTimeZone;
        if (this$inputTimeZone == null ? other$inputTimeZone != null : !this$inputTimeZone.equals(other$inputTimeZone)) {
            return false;
        }
        List<DerivedColumn> this$derivedColumns = this.derivedColumns;
        List<DerivedColumn> other$derivedColumns = other.derivedColumns;
        return !(this$derivedColumns == null ? other$derivedColumns != null : !((Object)this$derivedColumns).equals(other$derivedColumns));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeriveColumnsFromTimeTransform;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $columnName = this.columnName;
        result = result * 59 + ($columnName == null ? 43 : $columnName.hashCode());
        String $insertAfter = this.insertAfter;
        result = result * 59 + ($insertAfter == null ? 43 : $insertAfter.hashCode());
        DateTimeZone $inputTimeZone = this.inputTimeZone;
        result = result * 59 + ($inputTimeZone == null ? 43 : $inputTimeZone.hashCode());
        List<DerivedColumn> $derivedColumns = this.derivedColumns;
        result = result * 59 + ($derivedColumns == null ? 43 : ((Object)$derivedColumns).hashCode());
        return result;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class DerivedColumn
    implements Serializable {
        private final String columnName;
        private final ColumnType columnType;
        private final String format;
        private final DateTimeZone dateTimeZone;
        @JsonSerialize(using=DateTimeFieldTypeSerializer.class)
        @JsonDeserialize(using=DateTimeFieldTypeDeserializer.class)
        private final DateTimeFieldType fieldType;
        private transient DateTimeFormatter dateTimeFormatter;

        public DerivedColumn(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="columnType") ColumnType columnType, @JsonProperty(value="format") String format, @JsonProperty(value="dateTimeZone") DateTimeZone dateTimeZone, @JsonProperty(value="fieldType") DateTimeFieldType fieldType) {
            this.columnName = columnName;
            this.columnType = columnType;
            this.format = format;
            this.dateTimeZone = dateTimeZone;
            this.fieldType = fieldType;
            if (format != null) {
                this.dateTimeFormatter = DateTimeFormat.forPattern((String)this.format).withZone(dateTimeZone);
            }
        }

        public String toString() {
            return "(name=" + this.columnName + ",type=" + (Object)((Object)this.columnType) + ",derived=" + (this.format != null ? this.format : this.fieldType) + ")";
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            if (this.format != null) {
                this.dateTimeFormatter = DateTimeFormat.forPattern((String)this.format).withZone(this.dateTimeZone);
            }
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DerivedColumn)) {
                return false;
            }
            DerivedColumn other = (DerivedColumn)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$columnName = this.columnName;
            String other$columnName = other.columnName;
            if (this$columnName == null ? other$columnName != null : !this$columnName.equals(other$columnName)) {
                return false;
            }
            ColumnType this$columnType = this.columnType;
            ColumnType other$columnType = other.columnType;
            if (this$columnType == null ? other$columnType != null : !((Object)((Object)this$columnType)).equals((Object)other$columnType)) {
                return false;
            }
            String this$format = this.format;
            String other$format = other.format;
            if (this$format == null ? other$format != null : !this$format.equals(other$format)) {
                return false;
            }
            DateTimeZone this$dateTimeZone = this.dateTimeZone;
            DateTimeZone other$dateTimeZone = other.dateTimeZone;
            if (this$dateTimeZone == null ? other$dateTimeZone != null : !this$dateTimeZone.equals(other$dateTimeZone)) {
                return false;
            }
            DateTimeFieldType this$fieldType = this.fieldType;
            DateTimeFieldType other$fieldType = other.fieldType;
            return !(this$fieldType == null ? other$fieldType != null : !this$fieldType.equals(other$fieldType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DerivedColumn;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $columnName = this.columnName;
            result = result * 59 + ($columnName == null ? 43 : $columnName.hashCode());
            ColumnType $columnType = this.columnType;
            result = result * 59 + ($columnType == null ? 43 : ((Object)((Object)$columnType)).hashCode());
            String $format = this.format;
            result = result * 59 + ($format == null ? 43 : $format.hashCode());
            DateTimeZone $dateTimeZone = this.dateTimeZone;
            result = result * 59 + ($dateTimeZone == null ? 43 : $dateTimeZone.hashCode());
            DateTimeFieldType $fieldType = this.fieldType;
            result = result * 59 + ($fieldType == null ? 43 : $fieldType.hashCode());
            return result;
        }
    }

    public static class Builder {
        private final String columnName;
        private String insertAfter;
        private final List<DerivedColumn> derivedColumns = new ArrayList<DerivedColumn>();

        public Builder(String timeColumnName) {
            this.columnName = timeColumnName;
            this.insertAfter = timeColumnName;
        }

        public Builder insertAfter(String columnName) {
            this.insertAfter = columnName;
            return this;
        }

        public Builder addStringDerivedColumn(String columnName, String format, DateTimeZone timeZone) {
            this.derivedColumns.add(new DerivedColumn(columnName, ColumnType.String, format, timeZone, null));
            return this;
        }

        public Builder addIntegerDerivedColumn(String columnName, DateTimeFieldType type) {
            this.derivedColumns.add(new DerivedColumn(columnName, ColumnType.Integer, null, null, type));
            return this;
        }

        public DeriveColumnsFromTimeTransform build() {
            return new DeriveColumnsFromTimeTransform(this);
        }
    }
}

