/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.longtransform;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.datavec.api.transform.MathOp;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.metadata.LongMetaData;
import org.datavec.api.transform.transform.BaseColumnTransform;
import org.datavec.api.writable.LongWritable;
import org.datavec.api.writable.Writable;

public class LongMathOpTransform
extends BaseColumnTransform {
    private final MathOp mathOp;
    private final long scalar;

    public LongMathOpTransform(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="mathOp") MathOp mathOp, @JsonProperty(value="scalar") long scalar) {
        super(columnName);
        this.mathOp = mathOp;
        this.scalar = scalar;
    }

    @Override
    public ColumnMetaData getNewColumnMetaData(String newName, ColumnMetaData oldColumnType) {
        if (!(oldColumnType instanceof LongMetaData)) {
            throw new IllegalStateException("Column is not an Long column");
        }
        LongMetaData meta = (LongMetaData)oldColumnType;
        Long minValue = meta.getMinAllowedValue();
        Long maxValue = meta.getMaxAllowedValue();
        if (minValue != null) {
            minValue = this.doOp(minValue);
        }
        if (maxValue != null) {
            maxValue = this.doOp(maxValue);
        }
        if (minValue != null && maxValue != null && minValue > maxValue) {
            Long temp = minValue;
            minValue = maxValue;
            maxValue = temp;
        }
        return new LongMetaData(newName, minValue, maxValue);
    }

    private long doOp(long input) {
        switch (this.mathOp) {
            case Add: {
                return input + this.scalar;
            }
            case Subtract: {
                return input - this.scalar;
            }
            case Multiply: {
                return input * this.scalar;
            }
            case Divide: {
                return input / this.scalar;
            }
            case Modulus: {
                return input % this.scalar;
            }
            case ReverseSubtract: {
                return this.scalar - input;
            }
            case ReverseDivide: {
                return this.scalar / input;
            }
            case ScalarMin: {
                return Math.min(input, this.scalar);
            }
            case ScalarMax: {
                return Math.max(input, this.scalar);
            }
        }
        throw new IllegalStateException("Unknown or not implemented math op: " + (Object)((Object)this.mathOp));
    }

    @Override
    public Writable map(Writable columnWritable) {
        return new LongWritable(this.doOp(columnWritable.toLong()));
    }

    @Override
    public String toString() {
        return "LongMathOpTransform(mathOp=" + (Object)((Object)this.mathOp) + ",scalar=" + this.scalar + ")";
    }
}

