/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.column;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.transform.transform.BaseTransform;
import org.datavec.api.writable.Writable;

@JsonIgnoreProperties(value={"inputSchema", "columnsToRemoveIdx", "indicesToRemove"})
public class RemoveColumnsTransform
extends BaseTransform {
    private int[] columnsToRemoveIdx;
    private String[] columnsToRemove;
    private Set<Integer> indicesToRemove;

    public RemoveColumnsTransform(String ... columnsToRemove) {
        this.columnsToRemove = columnsToRemove;
    }

    @Override
    public void setInputSchema(Schema schema) {
        super.setInputSchema(schema);
        this.indicesToRemove = new HashSet<Integer>();
        int i = 0;
        this.columnsToRemoveIdx = new int[this.columnsToRemove.length];
        for (String s : this.columnsToRemove) {
            int idx = schema.getIndexOfColumn(s);
            if (idx < 0) {
                throw new RuntimeException("Column \"" + s + "\" not found");
            }
            this.columnsToRemoveIdx[i++] = idx;
            this.indicesToRemove.add(idx);
        }
    }

    @Override
    public Schema transform(Schema schema) {
        int nToRemove = this.columnsToRemove.length;
        int newNumColumns = schema.numColumns() - nToRemove;
        if (newNumColumns <= 0) {
            throw new IllegalStateException("Number of columns after executing operation is " + newNumColumns + " (is <= 0). origColumns = " + schema.getColumnNames() + ", toRemove = " + Arrays.toString(this.columnsToRemove));
        }
        List<String> origNames = schema.getColumnNames();
        List<ColumnMetaData> origMeta = schema.getColumnMetaData();
        HashSet set = new HashSet();
        Collections.addAll(set, this.columnsToRemove);
        ArrayList<ColumnMetaData> newMeta = new ArrayList<ColumnMetaData>(newNumColumns);
        Iterator<String> namesIter = origNames.iterator();
        Iterator<ColumnMetaData> metaIter = origMeta.iterator();
        while (namesIter.hasNext()) {
            String n = namesIter.next();
            ColumnMetaData t = metaIter.next();
            if (set.contains(n)) continue;
            newMeta.add(t);
        }
        return schema.newSchema(newMeta);
    }

    @Override
    public List<Writable> map(List<Writable> writables) {
        if (writables.size() != this.inputSchema.numColumns()) {
            throw new IllegalStateException("Cannot execute transform: input writables list length (" + writables.size() + ") does not match expected number of elements (schema: " + this.inputSchema.numColumns() + "). Transform = " + this.toString());
        }
        ArrayList<Writable> outList = new ArrayList<Writable>(writables.size() - this.columnsToRemove.length);
        int i = 0;
        for (Writable w : writables) {
            if (this.indicesToRemove.contains(i++)) continue;
            outList.add(w);
        }
        return outList;
    }

    @Override
    public String toString() {
        return "RemoveColumnsTransform(" + Arrays.toString(this.columnsToRemove) + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoveColumnsTransform o2 = (RemoveColumnsTransform)o;
        return Arrays.equals(this.columnsToRemove, o2.columnsToRemove);
    }

    public int hashCode() {
        return Arrays.hashCode(this.columnsToRemove);
    }
}

