/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.schema;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.datavec.api.transform.ColumnType;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.schema.Schema;

public class SequenceSchema
extends Schema {
    private final Integer minSequenceLength;
    private final Integer maxSequenceLength;

    public SequenceSchema(List<ColumnMetaData> columnMetaData) {
        this(columnMetaData, null, null);
    }

    public SequenceSchema(@JsonProperty(value="columns") List<ColumnMetaData> columnMetaData, @JsonProperty(value="minSequenceLength") Integer minSequenceLength, @JsonProperty(value="maxSequenceLength") Integer maxSequenceLength) {
        super(columnMetaData);
        this.minSequenceLength = minSequenceLength;
        this.maxSequenceLength = maxSequenceLength;
    }

    private SequenceSchema(Builder builder) {
        super(builder);
        this.minSequenceLength = builder.minSequenceLength;
        this.maxSequenceLength = builder.maxSequenceLength;
    }

    @Override
    public SequenceSchema newSchema(List<ColumnMetaData> columnMetaData) {
        return new SequenceSchema(columnMetaData, this.minSequenceLength, this.maxSequenceLength);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        int nCol = this.numColumns();
        int maxNameLength = 0;
        for (String s : this.getColumnNames()) {
            maxNameLength = Math.max(maxNameLength, s.length());
        }
        sb.append("SequenceSchema(");
        if (this.minSequenceLength != null) {
            sb.append("minSequenceLength=").append(this.minSequenceLength);
        }
        if (this.maxSequenceLength != null) {
            if (this.minSequenceLength != null) {
                sb.append(",");
            }
            sb.append("maxSequenceLength=").append(this.maxSequenceLength);
        }
        sb.append(")\n");
        sb.append(String.format("%-6s", "idx")).append(String.format("%-" + (maxNameLength + 8) + "s", "name")).append(String.format("%-15s", "type")).append("meta data").append("\n");
        for (int i = 0; i < nCol; ++i) {
            String colName = this.getName(i);
            ColumnType type = this.getType(i);
            ColumnMetaData meta = this.getMetaData(i);
            String paddedName = String.format("%-" + (maxNameLength + 8) + "s", "\"" + colName + "\"");
            sb.append(String.format("%-6d", i)).append(paddedName).append(String.format("%-15s", new Object[]{type})).append(meta).append("\n");
        }
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SequenceSchema)) {
            return false;
        }
        SequenceSchema other = (SequenceSchema)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$minSequenceLength = this.getMinSequenceLength();
        Integer other$minSequenceLength = other.getMinSequenceLength();
        if (this$minSequenceLength == null ? other$minSequenceLength != null : !((Object)this$minSequenceLength).equals(other$minSequenceLength)) {
            return false;
        }
        Integer this$maxSequenceLength = this.getMaxSequenceLength();
        Integer other$maxSequenceLength = other.getMaxSequenceLength();
        return !(this$maxSequenceLength == null ? other$maxSequenceLength != null : !((Object)this$maxSequenceLength).equals(other$maxSequenceLength));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SequenceSchema;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        Integer $minSequenceLength = this.getMinSequenceLength();
        result = result * 59 + ($minSequenceLength == null ? 43 : ((Object)$minSequenceLength).hashCode());
        Integer $maxSequenceLength = this.getMaxSequenceLength();
        result = result * 59 + ($maxSequenceLength == null ? 43 : ((Object)$maxSequenceLength).hashCode());
        return result;
    }

    public Integer getMinSequenceLength() {
        return this.minSequenceLength;
    }

    public Integer getMaxSequenceLength() {
        return this.maxSequenceLength;
    }

    public static class Builder
    extends Schema.Builder {
        private Integer minSequenceLength;
        private Integer maxSequenceLength;

        public Builder minSequenceLength(int minSequenceLength) {
            this.minSequenceLength = minSequenceLength;
            return this;
        }

        public Builder maxSequenceLength(int maxSequenceLength) {
            this.maxSequenceLength = maxSequenceLength;
            return this;
        }

        @Override
        public SequenceSchema build() {
            return new SequenceSchema(this);
        }
    }
}

