/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.metadata;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.datavec.api.transform.ColumnType;
import org.datavec.api.transform.metadata.BaseColumnMetaData;
import org.datavec.api.writable.IntWritable;
import org.datavec.api.writable.LongWritable;
import org.datavec.api.writable.Writable;

public class LongMetaData
extends BaseColumnMetaData {
    private final Long minAllowedValue;
    private final Long maxAllowedValue;

    public LongMetaData(String name) {
        this(name, null, null);
    }

    public LongMetaData(@JsonProperty(value="name") String name, @JsonProperty(value="minAllowedValue") Long minAllowedValue, @JsonProperty(value="maxAllowedValue") Long maxAllowedValue) {
        super(name);
        this.minAllowedValue = minAllowedValue;
        this.maxAllowedValue = maxAllowedValue;
    }

    @Override
    public ColumnType getColumnType() {
        return ColumnType.Long;
    }

    @Override
    public boolean isValid(Writable writable) {
        long value;
        if (writable instanceof IntWritable || writable instanceof LongWritable) {
            value = writable.toLong();
        } else {
            try {
                value = Long.parseLong(writable.toString());
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        if (this.minAllowedValue != null && value < this.minAllowedValue) {
            return false;
        }
        return this.maxAllowedValue == null || value <= this.maxAllowedValue;
    }

    @Override
    public LongMetaData clone() {
        return new LongMetaData(this.name, this.minAllowedValue, this.maxAllowedValue);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LongMetaData(name=\"").append(this.name).append("\",");
        if (this.minAllowedValue != null) {
            sb.append("minAllowed=").append(this.minAllowedValue);
        }
        if (this.maxAllowedValue != null) {
            if (this.minAllowedValue != null) {
                sb.append(",");
            }
            sb.append("maxAllowed=").append(this.maxAllowedValue);
        }
        sb.append(")");
        return sb.toString();
    }

    public Long getMinAllowedValue() {
        return this.minAllowedValue;
    }

    public Long getMaxAllowedValue() {
        return this.maxAllowedValue;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LongMetaData)) {
            return false;
        }
        LongMetaData other = (LongMetaData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$minAllowedValue = this.getMinAllowedValue();
        Long other$minAllowedValue = other.getMinAllowedValue();
        if (this$minAllowedValue == null ? other$minAllowedValue != null : !((Object)this$minAllowedValue).equals(other$minAllowedValue)) {
            return false;
        }
        Long this$maxAllowedValue = this.getMaxAllowedValue();
        Long other$maxAllowedValue = other.getMaxAllowedValue();
        return !(this$maxAllowedValue == null ? other$maxAllowedValue != null : !((Object)this$maxAllowedValue).equals(other$maxAllowedValue));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof LongMetaData;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        Long $minAllowedValue = this.getMinAllowedValue();
        result = result * 59 + ($minAllowedValue == null ? 43 : ((Object)$minAllowedValue).hashCode());
        Long $maxAllowedValue = this.getMaxAllowedValue();
        result = result * 59 + ($maxAllowedValue == null ? 43 : ((Object)$maxAllowedValue).hashCode());
        return result;
    }
}

