/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.doubletransform;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.List;
import org.datavec.api.transform.MathOp;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.metadata.DoubleMetaData;
import org.datavec.api.transform.transform.BaseColumnsMathOpTransform;
import org.datavec.api.writable.DoubleWritable;
import org.datavec.api.writable.Writable;

public class DoubleColumnsMathOpTransform
extends BaseColumnsMathOpTransform {
    public DoubleColumnsMathOpTransform(@JsonProperty(value="newColumnName") String newColumnName, @JsonProperty(value="mathOp") MathOp mathOp, @JsonProperty(value="columns") List<String> columns) {
        this(newColumnName, mathOp, columns.toArray(new String[columns.size()]));
    }

    public DoubleColumnsMathOpTransform(String newColumnName, MathOp mathOp, String ... columns) {
        super(newColumnName, mathOp, columns);
    }

    @Override
    protected ColumnMetaData derivedColumnMetaData(String newColumnName) {
        return new DoubleMetaData(newColumnName);
    }

    @Override
    protected Writable doOp(Writable ... input) {
        switch (this.mathOp) {
            case Add: {
                double sum = 0.0;
                for (Writable w : input) {
                    sum += w.toDouble();
                }
                return new DoubleWritable(sum);
            }
            case Subtract: {
                return new DoubleWritable(input[0].toDouble() - input[1].toDouble());
            }
            case Multiply: {
                double product = 1.0;
                for (Writable w : input) {
                    product *= w.toDouble();
                }
                return new DoubleWritable(product);
            }
            case Divide: {
                return new DoubleWritable(input[0].toDouble() / input[1].toDouble());
            }
            case Modulus: {
                return new DoubleWritable(input[0].toDouble() % input[1].toDouble());
            }
        }
        throw new RuntimeException("Invalid mathOp: " + (Object)((Object)this.mathOp));
    }

    @Override
    public String toString() {
        return "DoubleColumnsMathOpTransform(newColumnName=\"" + this.newColumnName + "\",mathOp=" + (Object)((Object)this.mathOp) + ",columns=" + Arrays.toString(this.columns) + ")";
    }
}

