/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.column;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.datavec.api.transform.Transform;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.writable.Writable;

@JsonIgnoreProperties(value={"columnsToDuplicateSet", "columnIndexesToDuplicateSet", "inputSchema"})
public class DuplicateColumnsTransform
implements Transform {
    private final List<String> columnsToDuplicate;
    private final List<String> newColumnNames;
    private final Set<String> columnsToDuplicateSet;
    private final Set<Integer> columnIndexesToDuplicateSet;
    private Schema inputSchema;

    public DuplicateColumnsTransform(@JsonProperty(value="columnsToDuplicate") List<String> columnsToDuplicate, @JsonProperty(value="newColumnNames") List<String> newColumnNames) {
        if (columnsToDuplicate == null || newColumnNames == null) {
            throw new IllegalArgumentException("Columns/names cannot be null");
        }
        if (columnsToDuplicate.size() != newColumnNames.size()) {
            throw new IllegalArgumentException("Invalid input: columns to duplicate and the new names must have equal lengths");
        }
        this.columnsToDuplicate = columnsToDuplicate;
        this.newColumnNames = newColumnNames;
        this.columnsToDuplicateSet = new HashSet<String>(columnsToDuplicate);
        this.columnIndexesToDuplicateSet = new HashSet<Integer>();
    }

    @Override
    public Schema transform(Schema inputSchema) {
        List<ColumnMetaData> oldMeta = inputSchema.getColumnMetaData();
        ArrayList<ColumnMetaData> newMeta = new ArrayList<ColumnMetaData>(oldMeta.size() + this.newColumnNames.size());
        List<String> oldNames = inputSchema.getColumnNames();
        int dupCount = 0;
        for (int i = 0; i < oldMeta.size(); ++i) {
            String current = oldNames.get(i);
            newMeta.add(oldMeta.get(i));
            if (!this.columnsToDuplicateSet.contains(current)) continue;
            String dupName = this.newColumnNames.get(dupCount);
            ColumnMetaData m = oldMeta.get(i).clone();
            m.setName(dupName);
            newMeta.add(m);
            ++dupCount;
        }
        return inputSchema.newSchema(newMeta);
    }

    @Override
    public void setInputSchema(Schema inputSchema) {
        this.columnIndexesToDuplicateSet.clear();
        List<String> schemaColumnNames = inputSchema.getColumnNames();
        for (String s : this.columnsToDuplicate) {
            int idx = schemaColumnNames.indexOf(s);
            if (idx == -1) {
                throw new IllegalStateException("Invalid state: column to duplicate \"" + s + "\" does not appear " + "in input schema");
            }
            this.columnIndexesToDuplicateSet.add(idx);
        }
        this.inputSchema = inputSchema;
    }

    @Override
    public Schema getInputSchema() {
        return this.inputSchema;
    }

    @Override
    public List<Writable> map(List<Writable> writables) {
        if (writables.size() != this.inputSchema.numColumns()) {
            throw new IllegalStateException("Cannot execute transform: input writables list length (" + writables.size() + ") does not " + "match expected number of elements (schema: " + this.inputSchema.numColumns() + "). Transform = " + this.toString());
        }
        ArrayList<Writable> out = new ArrayList<Writable>(writables.size() + this.columnsToDuplicate.size());
        int i = 0;
        for (Writable w : writables) {
            out.add(w);
            if (!this.columnIndexesToDuplicateSet.contains(i++)) continue;
            out.add(w);
        }
        return out;
    }

    @Override
    public List<List<Writable>> mapSequence(List<List<Writable>> sequence) {
        ArrayList<List<Writable>> out = new ArrayList<List<Writable>>(sequence.size());
        for (List<Writable> l : sequence) {
            out.add(this.map(l));
        }
        return out;
    }

    public String toString() {
        return "DuplicateColumnsTransform(toDuplicate=" + this.columnsToDuplicate + ",newNames=" + this.newColumnNames + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DuplicateColumnsTransform o2 = (DuplicateColumnsTransform)o;
        if (!this.columnsToDuplicate.equals(o2.columnsToDuplicate)) {
            return false;
        }
        return this.newColumnNames.equals(o2.newColumnNames);
    }

    public int hashCode() {
        int result = this.columnsToDuplicate.hashCode();
        result = 31 * result + this.newColumnNames.hashCode();
        return result;
    }
}

