/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.analysis.columns;

import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Map;
import org.datavec.api.transform.ColumnType;
import org.datavec.api.transform.analysis.columns.ColumnAnalysis;

public class CategoricalAnalysis
implements ColumnAnalysis {
    private final Map<String, Long> mapOfCounts;

    public String toString() {
        return "CategoricalAnalysis(CategoryCounts=" + this.mapOfCounts + ")";
    }

    @Override
    public long getCountTotal() {
        Collection<Long> counts = this.mapOfCounts.values();
        long sum = 0L;
        for (Long l : counts) {
            sum += l.longValue();
        }
        return sum;
    }

    @Override
    public ColumnType getColumnType() {
        return ColumnType.Categorical;
    }

    @ConstructorProperties(value={"mapOfCounts"})
    public CategoricalAnalysis(Map<String, Long> mapOfCounts) {
        this.mapOfCounts = mapOfCounts;
    }

    public Map<String, Long> getMapOfCounts() {
        return this.mapOfCounts;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CategoricalAnalysis)) {
            return false;
        }
        CategoricalAnalysis other = (CategoricalAnalysis)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, Long> this$mapOfCounts = this.getMapOfCounts();
        Map<String, Long> other$mapOfCounts = other.getMapOfCounts();
        return !(this$mapOfCounts == null ? other$mapOfCounts != null : !((Object)this$mapOfCounts).equals(other$mapOfCounts));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CategoricalAnalysis;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Long> $mapOfCounts = this.getMapOfCounts();
        result = result * 59 + ($mapOfCounts == null ? 43 : ((Object)$mapOfCounts).hashCode());
        return result;
    }
}

