/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.categorical;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.datavec.api.transform.metadata.CategoricalMetaData;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.transform.BaseColumnTransform;
import org.datavec.api.writable.Text;
import org.datavec.api.writable.Writable;

public class IntegerToCategoricalTransform
extends BaseColumnTransform {
    private final Map<Integer, String> map;

    public IntegerToCategoricalTransform(String columnName, Map<Integer, String> map) {
        super(columnName);
        this.map = map;
    }

    public IntegerToCategoricalTransform(String columnName, List<String> list) {
        super(columnName);
        this.map = new LinkedHashMap<Integer, String>();
        int i = 0;
        for (String s : list) {
            this.map.put(i++, s);
        }
    }

    @Override
    public ColumnMetaData getNewColumnMetaData(ColumnMetaData oldColumnType) {
        return new CategoricalMetaData(new ArrayList<String>(this.map.values()));
    }

    @Override
    public Writable map(Writable columnWritable) {
        return new Text(this.map.get(columnWritable.toInt()));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("IntegerToCategoricalTransform(map=[");
        ArrayList<Integer> list = new ArrayList<Integer>(this.map.keySet());
        Collections.sort(list);
        boolean first = true;
        for (Integer i : list) {
            if (!first) {
                sb.append(",");
            }
            sb.append(i).append("=\"").append(this.map.get(i)).append("\"");
            first = false;
        }
        sb.append("])");
        return sb.toString();
    }
}

