/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.records.reader.impl.misc;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import org.datavec.api.conf.Configuration;
import org.datavec.api.records.reader.impl.LineRecordReader;
import org.datavec.api.split.InputSplit;
import org.datavec.api.writable.DoubleWritable;
import org.datavec.api.writable.IntWritable;
import org.datavec.api.writable.Text;
import org.datavec.api.writable.Writable;

public class LibSvmRecordReader
extends LineRecordReader {
    public static final String CLASSIFICATION = "libsvm.classification";
    public static final String NAME_SPACE = LibSvmRecordReader.class.getName();
    public static final String NUM_FEATURES = NAME_SPACE + ".numfeatures";
    private boolean appendLabel = false;
    private boolean classification = true;
    private int numFeatures;

    @Override
    public void initialize(InputSplit split) throws IOException, InterruptedException {
        super.initialize(split);
    }

    @Override
    public void initialize(Configuration conf, InputSplit split) throws IOException, InterruptedException {
        super.initialize(conf, split);
        this.appendLabel = conf.getBoolean(APPEND_LABEL, false);
        this.classification = conf.getBoolean(CLASSIFICATION, true);
        this.numFeatures = conf.getInt(NUM_FEATURES, 0);
    }

    @Override
    public Collection<Writable> next() {
        Double response;
        Text record2 = (Text)super.next().iterator().next();
        String line = record2.toString();
        String[] tokens = line.trim().split("\\s+");
        try {
            response = Integer.valueOf(tokens[0]).doubleValue();
        }
        catch (NumberFormatException e) {
            try {
                response = Double.valueOf(tokens[0]);
                this.classification = false;
            }
            catch (NumberFormatException ex) {
                System.err.println(ex);
                throw new NumberFormatException("Unrecognized response variable value: " + tokens[0]);
            }
        }
        tokens = line.trim().split("\\s+");
        ArrayList<Writable> record = new ArrayList<Writable>();
        int read = 0;
        for (int k = 1; k < tokens.length; ++k) {
            String[] pair = tokens[k].split(":");
            if (pair.length != 2) {
                throw new NumberFormatException("Invalid data: " + tokens[k]);
            }
            int j = Integer.valueOf(pair[0]) - 1;
            while (j != read) {
                record.add(new DoubleWritable(0.0));
                ++read;
            }
            try {
                int x = Integer.valueOf(pair[1]);
                record.add(new IntWritable(x));
            }
            catch (NumberFormatException e) {
                double x = Double.valueOf(pair[1]);
                record.add(new DoubleWritable(x));
            }
            ++read;
        }
        while (read < this.numFeatures) {
            record.add(new DoubleWritable(0.0));
            ++read;
        }
        if (this.classification && this.appendLabel || !this.classification) {
            record.add(new DoubleWritable(response));
        }
        return record;
    }

    @Override
    public boolean hasNext() {
        return super.hasNext();
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    @Override
    public void setConf(Configuration conf) {
        super.setConf(conf);
    }

    @Override
    public Configuration getConf() {
        return super.getConf();
    }

    @Override
    public Collection<Writable> record(URI uri, DataInputStream dataInputStream) throws IOException {
        throw new UnsupportedOperationException("Reading LibSVM data from DataInputStream not yet implemented");
    }
}

