/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.xml.fieldmanager;

import java.util.Collection;
import javax.xml.bind.JAXBException;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;
import org.datanucleus.store.xml.XMLStoreManager;
import org.datanucleus.store.xml.XMLUtils;
import org.datanucleus.util.NucleusLogger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FetchFieldManager
extends AbstractFieldManager {
    ObjectProvider op;
    Object value;
    Document doc;
    Node node;

    public FetchFieldManager(ObjectProvider op, Document doc) {
        this.op = op;
        this.doc = doc;
        ExecutionContext ec = op.getExecutionContext();
        this.node = XMLUtils.findNode(doc, op);
        try {
            this.value = ((XMLStoreManager)ec.getStoreManager()).getJAXBHandler().unmarshall(op.getObject().getClass(), this.node, op.getExecutionContext().getClassLoaderResolver());
        }
        catch (JAXBException e) {
            NucleusLogger.DATASTORE_RETRIEVE.warn((Object)"Exception unmarshalling XML", (Throwable)e);
        }
    }

    public String fetchStringField(int fieldNumber) {
        this.op.copyFieldsFromObject(this.value, new int[]{fieldNumber});
        return (String)this.op.provideField(fieldNumber);
    }

    public Object fetchObjectField(int fieldNumber) {
        ExecutionContext ec = this.op.getExecutionContext();
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        AbstractMemberMetaData mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        RelationType relationType = mmd.getRelationType(clr);
        if (relationType == RelationType.NONE) {
            this.op.copyFieldsFromObject(this.value, new int[]{fieldNumber});
            return this.op.provideField(fieldNumber);
        }
        if (mmd.getEmbeddedMetaData() == null) {
            if (relationType == RelationType.ONE_TO_ONE_UNI || relationType == RelationType.ONE_TO_ONE_BI || relationType == RelationType.MANY_TO_ONE_BI) {
                AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(mmd.getType(), clr);
                NodeList nList = ((Element)this.node).getElementsByTagName(mmd.getName());
                if (nList.getLength() == 1) {
                    Object id = ec.getNucleusContext().getIdentityManager().getApplicationId(clr.classForName(cmd.getFullClassName(), true), (Object)nList.item(0).getFirstChild().getNodeValue());
                    Object related = ec.findObject(id, true, true, null);
                    if (relationType == RelationType.ONE_TO_ONE_BI) {
                        ObjectProvider relatedSM = ec.findObjectProvider(related);
                        AbstractMemberMetaData relatedMmd = mmd.getRelatedMemberMetaDataForObject(clr, this.op.getObject(), related);
                        relatedSM.replaceField(relatedMmd.getAbsoluteFieldNumber(), this.op.getObject());
                    }
                    return related;
                }
                return null;
            }
            if (relationType == RelationType.ONE_TO_MANY_UNI || relationType == RelationType.ONE_TO_MANY_BI) {
                if (mmd.hasCollection()) {
                    AbstractClassMetaData cmd2 = ec.getMetaDataManager().getMetaDataForClass(mmd.getCollection().getElementType(), clr);
                    this.op.copyFieldsFromObject(this.value, new int[]{fieldNumber});
                    Collection collection = (Collection)this.op.provideField(fieldNumber);
                    NodeList nLists = ((Element)this.node).getElementsByTagName(XMLUtils.getElementNameForMember(mmd, 3));
                    for (int i = 0; i < nLists.getLength(); ++i) {
                        String nodeValue = nLists.item(i).getFirstChild().getNodeValue();
                        if (nodeValue == null || nodeValue.trim().length() <= 0) continue;
                        AbstractClassMetaData elementCmd = XMLUtils.findMetaDataForNode(this.doc, cmd2, ec.getMetaDataManager(), nodeValue, clr);
                        if (elementCmd == null && cmd2 != null) {
                            throw new NucleusException("Unable to find object of type " + cmd2.getFullClassName() + " with id=" + nodeValue);
                        }
                        Object id = ec.getNucleusContext().getIdentityManager().getApplicationId(clr.classForName(elementCmd.getFullClassName(), true), (Object)nodeValue);
                        Object related = ec.findObject(id, true, true, null);
                        if (relationType == RelationType.ONE_TO_MANY_BI) {
                            ObjectProvider relatedSM = ec.findObjectProvider(related);
                            AbstractMemberMetaData relatedMmd = relatedSM.getClassMetaData().getMetaDataForMember(mmd.getMappedBy());
                            relatedSM.replaceField(relatedMmd.getAbsoluteFieldNumber(), this.op.getObject());
                        }
                        collection.add(related);
                    }
                    return this.op.wrapSCOField(fieldNumber, (Object)collection, false, false, true);
                }
                if (mmd.hasArray() || mmd.hasMap()) {
                    // empty if block
                }
            }
        }
        return null;
    }

    public boolean fetchBooleanField(int fieldNumber) {
        this.op.copyFieldsFromObject(this.value, new int[]{fieldNumber});
        return (Boolean)this.op.provideField(fieldNumber);
    }

    public byte fetchByteField(int fieldNumber) {
        this.op.copyFieldsFromObject(this.value, new int[]{fieldNumber});
        return (Byte)this.op.provideField(fieldNumber);
    }

    public char fetchCharField(int fieldNumber) {
        this.op.copyFieldsFromObject(this.value, new int[]{fieldNumber});
        return ((Character)this.op.provideField(fieldNumber)).charValue();
    }

    public double fetchDoubleField(int fieldNumber) {
        this.op.copyFieldsFromObject(this.value, new int[]{fieldNumber});
        return (Double)this.op.provideField(fieldNumber);
    }

    public float fetchFloatField(int fieldNumber) {
        this.op.copyFieldsFromObject(this.value, new int[]{fieldNumber});
        return ((Float)this.op.provideField(fieldNumber)).floatValue();
    }

    public int fetchIntField(int fieldNumber) {
        this.op.copyFieldsFromObject(this.value, new int[]{fieldNumber});
        return (Integer)this.op.provideField(fieldNumber);
    }

    public long fetchLongField(int fieldNumber) {
        this.op.copyFieldsFromObject(this.value, new int[]{fieldNumber});
        return (Long)this.op.provideField(fieldNumber);
    }

    public short fetchShortField(int fieldNumber) {
        this.op.copyFieldsFromObject(this.value, new int[]{fieldNumber});
        return (Short)this.op.provideField(fieldNumber);
    }
}

