/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.xml.fieldmanager;

import java.util.Collection;
import javax.jdo.spi.PersistenceCapable;
import javax.xml.bind.JAXBException;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;
import org.datanucleus.store.xml.XMLUtils;
import org.datanucleus.store.xml.binder.JAXBRuntimeBinder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FetchFieldManager
extends AbstractFieldManager {
    StateManager sm;
    Object value;
    Document doc;
    Node node;

    public FetchFieldManager(StateManager sm, Document doc) {
        this.sm = sm;
        this.doc = doc;
        this.node = XMLUtils.findNode(doc, sm);
        try {
            this.value = JAXBRuntimeBinder.unmarshall(sm.getObject().getClass(), this.node, sm.getMetaDataManager(), sm.getObjectManager().getClassLoaderResolver());
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
    }

    public String fetchStringField(int fieldNumber) {
        this.sm.copyFieldsFromObject((PersistenceCapable)this.value, new int[]{fieldNumber});
        return (String)this.sm.provideField(fieldNumber);
    }

    public Object fetchObjectField(int fieldNumber) {
        ObjectManager om = this.sm.getObjectManager();
        ClassLoaderResolver clr = om.getClassLoaderResolver();
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        int relationType = mmd.getRelationType(clr);
        if (relationType == 0) {
            this.sm.copyFieldsFromObject((PersistenceCapable)this.value, new int[]{fieldNumber});
            return this.sm.provideField(fieldNumber);
        }
        if (mmd.getEmbeddedMetaData() == null) {
            switch (relationType) {
                case 1: 
                case 2: 
                case 6: {
                    AbstractClassMetaData cmd = this.sm.getMetaDataManager().getMetaDataForClass(mmd.getType(), clr);
                    NodeList nList = ((Element)this.node).getElementsByTagName(mmd.getName());
                    if (nList.getLength() == 1) {
                        Object idRelated = this.getIdentityFromIdREFString(cmd, nList.item(0).getFirstChild().getNodeValue());
                        Object related = om.findObject(idRelated, true, true, null);
                        if (relationType == 2) {
                            StateManager relatedSM = om.findStateManager(related);
                            AbstractMemberMetaData relatedMmd = mmd.getRelatedMemberMetaDataForObject(clr, this.sm.getObject(), related);
                            relatedSM.replaceField(relatedMmd.getAbsoluteFieldNumber(), this.sm.getObject(), false);
                        }
                        return related;
                    }
                    return null;
                }
                case 3: 
                case 4: {
                    if (mmd.hasCollection()) {
                        AbstractClassMetaData cmd = this.sm.getMetaDataManager().getMetaDataForClass(mmd.getCollection().getElementType(), clr);
                        this.sm.copyFieldsFromObject((PersistenceCapable)this.value, new int[]{fieldNumber});
                        Collection collection = (Collection)this.sm.provideField(fieldNumber);
                        NodeList nLists = ((Element)this.node).getElementsByTagName(XMLUtils.getElementNameForMember(mmd, 3));
                        for (int i = 0; i < nLists.getLength(); ++i) {
                            String nodeValue = nLists.item(i).getFirstChild().getNodeValue();
                            if (nodeValue == null || nodeValue.trim().length() <= 0) continue;
                            AbstractClassMetaData elementCmd = XMLUtils.findMetaDataForNode(this.doc, cmd, om.getMetaDataManager(), nodeValue);
                            if (elementCmd == null && cmd != null) {
                                throw new NucleusException("Unable to find object of type " + cmd.getFullClassName() + " with id=" + nodeValue);
                            }
                            Object idRelated = this.getIdentityFromIdREFString(elementCmd, nodeValue);
                            Object related = om.findObject(idRelated, true, true, null);
                            if (relationType == 4) {
                                StateManager relatedSM = om.findStateManager(related);
                                AbstractMemberMetaData relatedMmd = relatedSM.getClassMetaData().getMetaDataForMember(mmd.getMappedBy());
                                relatedSM.replaceField(relatedMmd.getAbsoluteFieldNumber(), this.sm.getObject(), false);
                            }
                            collection.add(related);
                        }
                        return this.sm.wrapSCOField(fieldNumber, (Object)collection, false, false, true);
                    }
                    if (!mmd.hasArray() && !mmd.hasMap()) break;
                }
            }
        }
        return null;
    }

    protected Object getIdentityFromIdREFString(AbstractClassMetaData cmd, String idREFString) {
        if (cmd.getIdentityType() != IdentityType.DATASTORE && cmd.getIdentityType() == IdentityType.APPLICATION) {
            return this.sm.getObjectManager().getApiAdapter().getNewApplicationIdentityObjectId(this.sm.getObjectManager().getClassLoaderResolver(), cmd, idREFString);
        }
        return null;
    }

    public boolean fetchBooleanField(int fieldNumber) {
        this.sm.copyFieldsFromObject((PersistenceCapable)this.value, new int[]{fieldNumber});
        return (Boolean)this.sm.provideField(fieldNumber);
    }

    public byte fetchByteField(int fieldNumber) {
        this.sm.copyFieldsFromObject((PersistenceCapable)this.value, new int[]{fieldNumber});
        return (Byte)this.sm.provideField(fieldNumber);
    }

    public char fetchCharField(int fieldNumber) {
        this.sm.copyFieldsFromObject((PersistenceCapable)this.value, new int[]{fieldNumber});
        return ((Character)this.sm.provideField(fieldNumber)).charValue();
    }

    public double fetchDoubleField(int fieldNumber) {
        this.sm.copyFieldsFromObject((PersistenceCapable)this.value, new int[]{fieldNumber});
        return (Double)this.sm.provideField(fieldNumber);
    }

    public float fetchFloatField(int fieldNumber) {
        this.sm.copyFieldsFromObject((PersistenceCapable)this.value, new int[]{fieldNumber});
        return ((Float)this.sm.provideField(fieldNumber)).floatValue();
    }

    public int fetchIntField(int fieldNumber) {
        this.sm.copyFieldsFromObject((PersistenceCapable)this.value, new int[]{fieldNumber});
        return (Integer)this.sm.provideField(fieldNumber);
    }

    public long fetchLongField(int fieldNumber) {
        this.sm.copyFieldsFromObject((PersistenceCapable)this.value, new int[]{fieldNumber});
        return (Long)this.sm.provideField(fieldNumber);
    }

    public short fetchShortField(int fieldNumber) {
        this.sm.copyFieldsFromObject((PersistenceCapable)this.value, new int[]{fieldNumber});
        return (Short)this.sm.provideField(fieldNumber);
    }
}

