/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.xml;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.state.StateManagerFactory;
import org.datanucleus.store.xml.XMLManager;
import org.datanucleus.store.xml.binder.JAXBRuntimeBinder;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLUtils {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.xml.Localisation", (ClassLoader)XMLManager.class.getClassLoader());
    private static XPath xpath = XPathFactory.newInstance().newXPath();

    public static StateManager prepareXMLObjectForUse(Object obj, ObjectManager om, AbstractClassMetaData acmd) {
        if (!om.getApiAdapter().isPersistable(obj)) {
            return null;
        }
        StateManager sm = om.findStateManager(obj);
        if (sm == null) {
            Object id = null;
            if (acmd.getIdentityType() == IdentityType.DATASTORE) {
                throw new NucleusException(LOCALISER.msg("XML.DatastoreID"));
            }
            id = om.getApiAdapter().getNewApplicationIdentityObjectId(obj, acmd);
            sm = StateManagerFactory.newStateManagerForPersistentClean((ObjectManager)om, (Object)id, (Object)obj);
        }
        sm.replaceAllLoadedSCOFieldsWithWrappers();
        return sm;
    }

    public static List getObjectsOfCandidateType(ObjectManager om, ManagedConnection mconn, Class candidateClass, boolean subclasses, boolean ignoreCache) {
        String[] subclassNames;
        Document doc = (Document)mconn.getConnection();
        ClassLoaderResolver clr = om.getClassLoaderResolver();
        AbstractClassMetaData cmd = om.getMetaDataManager().getMetaDataForClass(candidateClass, clr);
        List results = XMLUtils.getObjectsOfCandidateType(om, doc, cmd, ignoreCache);
        if (subclasses && (subclassNames = om.getMetaDataManager().getSubclassesForClass(candidateClass.getName(), true)) != null) {
            for (int i = 0; i < subclassNames.length; ++i) {
                AbstractClassMetaData acmd = om.getMetaDataManager().getMetaDataForClass(subclassNames[i], clr);
                results.addAll(XMLUtils.getObjectsOfCandidateType(om, doc, acmd, ignoreCache));
            }
        }
        return results;
    }

    private static List getObjectsOfCandidateType(ObjectManager om, Document doc, AbstractClassMetaData acmd, boolean ignoreCache) {
        ClassLoaderResolver clr = om.getClassLoaderResolver();
        Class candidateClass = clr.classForName(acmd.getFullClassName());
        ArrayList<Object> results = new ArrayList<Object>();
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            MetaDataManager mmgr = om.getMetaDataManager();
            Element el = null;
            String expression = acmd.getValueForExtension("xpath");
            if (expression == null) {
                el = doc.getDocumentElement();
            } else {
                try {
                    el = (Element)xpath.evaluate(expression, doc, XPathConstants.NODE);
                }
                catch (XPathExpressionException e) {
                    e.printStackTrace();
                }
            }
            if (el != null) {
                for (int i = 0; i < el.getChildNodes().getLength(); ++i) {
                    if (!(el.getChildNodes().item(i) instanceof Element)) continue;
                    Object obj = JAXBRuntimeBinder.unmarshall(candidateClass, el.getChildNodes().item(i), mmgr, clr);
                    XMLUtils.prepareXMLObjectForUse(obj, om, acmd);
                    results.add(obj);
                }
            }
        }
        catch (JAXBException jbe) {
            jbe.printStackTrace();
        }
        return results;
    }

    public static Node findNode(Document doc, StateManager sm) {
        AbstractClassMetaData cmd;
        Node node = null;
        long startTime = System.currentTimeMillis();
        if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
            NucleusLogger.DATASTORE_RETRIEVE.debug((Object)LOCALISER.msg("XML.Fetch.Start", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), sm.getInternalObjectId()));
        }
        if ((cmd = sm.getClassMetaData()).getIdentityType() == IdentityType.DATASTORE) {
            throw new NucleusException(LOCALISER.msg("XML.DatastoreID"));
        }
        if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            try {
                String expression = sm.getClassMetaData().getValueForExtension("xpath");
                String[] pk = sm.getClassMetaData().getPrimaryKeyMemberNames();
                if (pk.length < 1) {
                    throw new NucleusDataStoreException("No ID defined for " + cmd.getFullClassName());
                }
                if (expression == null) {
                    expression = "/root";
                }
                expression = sm.getClassMetaData().hasExtension("name") ? expression + "/" + sm.getClassMetaData().getValueForExtension("name") : expression + "/" + sm.getClassMetaData().getName().substring(0, 1).toLowerCase() + sm.getClassMetaData().getName().substring(1);
                for (int i = 0; i < pk.length; ++i) {
                    Object obj = sm.provideField(sm.getClassMetaData().getPKMemberPositions()[i]);
                    expression = expression + "/" + pk[i] + "[text()='" + obj.toString() + "']";
                }
                expression = expression + "/..";
                node = (Node)xpath.evaluate(expression, doc, XPathConstants.NODE);
            }
            catch (Exception e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
        }
        if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
            NucleusLogger.DATASTORE_RETRIEVE.debug((Object)LOCALISER.msg("XML.ExecutionTime", System.currentTimeMillis() - startTime));
        }
        return node;
    }
}

