/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.xml;

import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ConnectionFactory;
import org.datanucleus.ManagedConnection;
import org.datanucleus.OMFContext;
import org.datanucleus.ObjectManager;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.store.AbstractStoreManager;
import org.datanucleus.store.DefaultCandidateExtent;
import org.datanucleus.store.Extent;
import org.datanucleus.store.NucleusConnection;
import org.datanucleus.store.NucleusConnectionImpl;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.exceptions.NoExtentException;
import org.datanucleus.store.xml.XMLPersistenceHandler;
import org.datanucleus.util.ClassUtils;

public class XMLManager
extends AbstractStoreManager {
    public XMLManager(ClassLoaderResolver clr, OMFContext omfContext) {
        super("xml", clr, omfContext);
        ClassUtils.assertClassForJarExistsInClasspath((ClassLoaderResolver)clr, (String)"javax.xml.bind.JAXBContext", (String)"jaxb-api.jar");
        ClassUtils.assertClassForJarExistsInClasspath((ClassLoaderResolver)clr, (String)"com.sun.xml.bind.api.JAXBRIContext", (String)"jaxb-impl.jar");
        this.persistenceHandler = new XMLPersistenceHandler((StoreManager)this);
        this.logConfiguration();
    }

    public Date getDatastoreDate() {
        throw new UnsupportedOperationException();
    }

    public Extent getExtent(ObjectManager om, Class c, boolean subclasses) {
        AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(c, om.getClassLoaderResolver());
        if (!cmd.isRequiresExtent()) {
            throw new NoExtentException(c.getName());
        }
        return new DefaultCandidateExtent(om, c, subclasses, cmd);
    }

    public NucleusConnection getNucleusConnection(ObjectManager om) {
        ConnectionFactory cf = this.getOMFContext().getConnectionFactoryRegistry().lookupConnectionFactory(this.txConnectionFactoryName);
        final boolean enlisted = om.getTransaction().isActive();
        final ManagedConnection mc = cf.getConnection((ObjectManager)(enlisted ? om : null), null);
        mc.lock();
        Runnable closeRunnable = new Runnable(){

            public void run() {
                mc.unlock();
                if (!enlisted) {
                    // empty if block
                }
            }
        };
        return new NucleusConnectionImpl(mc.getConnection(), closeRunnable);
    }

    public Collection getSupportedOptions() {
        HashSet<String> set = new HashSet<String>();
        set.add("ApplicationIdentity");
        set.add("TransactionIsolationLevel.read-committed");
        return set;
    }
}

