/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.valuegenerator;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.JdbcType;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.identifier.DatastoreIdentifier;
import org.datanucleus.store.rdbms.identifier.IdentifierFactory;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.TableImpl;
import org.datanucleus.store.valuegenerator.ValueGenerationException;
import org.datanucleus.util.Localiser;

public class SequenceTable
extends TableImpl {
    private JavaTypeMapping sequenceNameMapping = null;
    private JavaTypeMapping nextValMapping = null;
    private String insertStmt = null;
    private String incrementByStmt = null;
    private String fetchStmt = null;
    private String sequenceNameColumnName;
    private String nextValColumnName;

    public SequenceTable(DatastoreIdentifier identifier, RDBMSStoreManager storeMgr, String seqNameColName, String nextValColName) {
        super(identifier, storeMgr);
        this.sequenceNameColumnName = seqNameColName;
        this.nextValColumnName = nextValColName;
    }

    @Override
    public void initialize(ClassLoaderResolver clr) {
        this.assertIsUninitialized();
        IdentifierFactory idFactory = this.storeMgr.getIdentifierFactory();
        this.sequenceNameMapping = this.storeMgr.getMappingManager().getMapping(String.class);
        Column colSequenceName = this.addColumn(String.class.getName(), idFactory.newColumnIdentifier(this.sequenceNameColumnName), this.sequenceNameMapping, null);
        colSequenceName.setPrimaryKey();
        colSequenceName.getColumnMetaData().setLength(Integer.valueOf("255"));
        colSequenceName.getColumnMetaData().setJdbcType(JdbcType.VARCHAR);
        this.getStoreManager().getMappingManager().createColumnMapping(this.sequenceNameMapping, colSequenceName, String.class.getName());
        this.nextValMapping = this.storeMgr.getMappingManager().getMapping(Long.class);
        Column colNextVal = this.addColumn(Long.class.getName(), idFactory.newColumnIdentifier(this.nextValColumnName), this.nextValMapping, null);
        this.getStoreManager().getMappingManager().createColumnMapping(this.nextValMapping, colNextVal, Long.class.getName());
        this.insertStmt = "INSERT INTO " + this.identifier.getFullyQualifiedName(false) + " (" + colSequenceName.getIdentifier() + "," + colNextVal.getIdentifier() + ") VALUES (?,?)";
        this.incrementByStmt = "UPDATE " + this.identifier.getFullyQualifiedName(false) + " SET " + colNextVal.getIdentifier() + "=(" + colNextVal.getIdentifier() + "+?) WHERE " + colSequenceName.getIdentifier() + "=?";
        this.fetchStmt = "SELECT " + colNextVal.getIdentifier() + " FROM " + this.identifier.getFullyQualifiedName(false);
        if (this.dba.supportsOption("LockRowUsingOptionAfterFrom")) {
            this.fetchStmt = this.fetchStmt + " WITH " + this.dba.getSelectWithLockOption();
        }
        this.fetchStmt = this.fetchStmt + " WHERE " + colSequenceName.getIdentifier() + "=?";
        if (this.dba.supportsOption("LockRowUsingSelectForUpdate")) {
            this.fetchStmt = this.fetchStmt + " FOR UPDATE";
        }
        this.storeMgr.registerTableInitialized(this);
        this.state = (short)2;
    }

    @Override
    public JavaTypeMapping getIdMapping() {
        throw new NucleusException("Attempt to get ID mapping of Sequence table!").setFatal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Long getNextVal(String sequenceName, ManagedConnection conn, int incrementBy, DatastoreIdentifier tableIdentifier, String columnName, int initialValue) throws SQLException {
        Long nextVal;
        block22: {
            PreparedStatement ps = null;
            nextVal = null;
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                ps = sqlControl.getStatementForQuery(conn, this.fetchStmt);
                this.sequenceNameMapping.setString(null, ps, new int[]{1}, sequenceName);
                try (ResultSet rs = sqlControl.executeStatementQuery(null, conn, this.fetchStmt, ps);){
                    block24: {
                        if (rs.next()) break block24;
                        boolean addedSequence = false;
                        if (initialValue >= 0) {
                            this.addSequence(sequenceName, Long.valueOf(incrementBy + initialValue), conn);
                            nextVal = initialValue;
                            break block22;
                        }
                        if (columnName != null && tableIdentifier != null) {
                            PreparedStatement ps2;
                            block23: {
                                ps2 = null;
                                ResultSet rs2 = null;
                                try {
                                    String fetchInitStmt = "SELECT MAX(" + columnName + ") FROM " + tableIdentifier.getFullyQualifiedName(false);
                                    ps2 = sqlControl.getStatementForQuery(conn, fetchInitStmt);
                                    rs2 = sqlControl.executeStatementQuery(null, conn, fetchInitStmt, ps2);
                                    if (rs2.next()) {
                                        long val = rs2.getLong(1);
                                        this.addSequence(sequenceName, (long)(incrementBy + 1) + val, conn);
                                        nextVal = 1L + val;
                                        addedSequence = true;
                                    }
                                    if (rs2 == null) break block23;
                                }
                                catch (Exception exception) {
                                    if (rs2 != null) {
                                        rs2.close();
                                    }
                                    if (ps2 != null) {
                                        sqlControl.closeStatement(conn, ps2);
                                    }
                                    catch (Throwable throwable) {
                                        if (rs2 != null) {
                                            rs2.close();
                                        }
                                        if (ps2 != null) {
                                            sqlControl.closeStatement(conn, ps2);
                                        }
                                        throw throwable;
                                    }
                                }
                                rs2.close();
                            }
                            if (ps2 != null) {
                                sqlControl.closeStatement(conn, ps2);
                            }
                        }
                        if (!addedSequence) {
                            this.addSequence(sequenceName, Long.valueOf(incrementBy + 0), conn);
                            nextVal = initialValue;
                        }
                        break block22;
                    }
                    nextVal = rs.getLong(1);
                    this.incrementSequence(sequenceName, incrementBy, conn);
                }
            }
            catch (SQLException e) {
                throw new ValueGenerationException(Localiser.msg((String)"061001", (Object[])new Object[]{e.getMessage()}), (Throwable)e);
            }
            finally {
                if (ps != null) {
                    sqlControl.closeStatement(conn, ps);
                }
            }
        }
        return nextVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementSequence(String sequenceName, long incrementBy, ManagedConnection conn) throws SQLException {
        PreparedStatement ps = null;
        SQLController sqlControl = this.storeMgr.getSQLController();
        try {
            ps = sqlControl.getStatementForUpdate(conn, this.incrementByStmt, false);
            this.nextValMapping.setLong(null, ps, new int[]{1}, incrementBy);
            this.sequenceNameMapping.setString(null, ps, new int[]{2}, sequenceName);
            sqlControl.executeStatementUpdate(null, conn, this.incrementByStmt, ps, true);
        }
        finally {
            if (ps != null) {
                sqlControl.closeStatement(conn, ps);
            }
        }
    }

    private void addSequence(String sequenceName, Long nextVal, ManagedConnection conn) throws SQLException {
        PreparedStatement ps = null;
        SQLController sqlControl = this.storeMgr.getSQLController();
        try {
            ps = sqlControl.getStatementForUpdate(conn, this.insertStmt, false);
            this.sequenceNameMapping.setString(null, ps, new int[]{1}, sequenceName);
            this.nextValMapping.setLong(null, ps, new int[]{2}, nextVal);
            sqlControl.executeStatementUpdate(null, conn, this.insertStmt, ps, true);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (ps != null) {
                sqlControl.closeStatement(conn, ps);
            }
        }
    }

    @Override
    public JavaTypeMapping getMemberMapping(AbstractMemberMetaData mmd) {
        return null;
    }
}

