/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.column;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Iterator;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.column.AbstractColumnMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.util.Localiser;

public class TimestampColumnMapping
extends AbstractColumnMapping {
    public TimestampColumnMapping(JavaTypeMapping mapping, RDBMSStoreManager storeMgr, Column col) {
        super(storeMgr, mapping);
        this.column = col;
        this.initialize();
    }

    private void initialize() {
        if (this.column != null) {
            this.column.checkPrimitive();
        }
        this.initTypeInfo();
    }

    @Override
    public int getJDBCType() {
        return 93;
    }

    @Override
    public void setObject(PreparedStatement ps, int param, Object value) {
        block18: {
            try {
                Calendar cal = this.storeMgr.getCalendarForDateTimezone();
                if (value == null) {
                    ps.setNull(param, this.getJDBCType());
                    break block18;
                }
                if (value instanceof Timestamp) {
                    if (cal != null) {
                        ps.setTimestamp(param, (Timestamp)value, cal);
                    } else {
                        ps.setTimestamp(param, (Timestamp)value);
                    }
                    break block18;
                }
                if (value instanceof Time) {
                    if (cal != null) {
                        ps.setTimestamp(param, new Timestamp(((Time)value).getTime()), cal);
                    } else {
                        ps.setTimestamp(param, new Timestamp(((Time)value).getTime()));
                    }
                    break block18;
                }
                if (value instanceof Date) {
                    if (cal != null) {
                        ps.setTimestamp(param, new Timestamp(((Date)value).getTime()), cal);
                    } else {
                        ps.setTimestamp(param, new Timestamp(((Date)value).getTime()));
                    }
                    break block18;
                }
                if (value instanceof Calendar) {
                    if (cal != null) {
                        ps.setTimestamp(param, new Timestamp(((Calendar)value).getTime().getTime()), cal);
                    } else {
                        ps.setTimestamp(param, new Timestamp(((Calendar)value).getTime().getTime()));
                    }
                    break block18;
                }
                if (value instanceof java.util.Date) {
                    if (cal != null) {
                        ps.setTimestamp(param, new Timestamp(((java.util.Date)value).getTime()), cal);
                    } else {
                        ps.setTimestamp(param, new Timestamp(((java.util.Date)value).getTime()));
                    }
                    break block18;
                }
                throw new NucleusDataStoreException("Cannot set TIMESTAMP RDBMS type with value of type " + value.getClass().getName());
            }
            catch (SQLException e) {
                throw new NucleusDataStoreException(Localiser.msg((String)"055001", (Object[])new Object[]{"Timestamp", "" + value, this.column, e.getMessage()}), (Throwable)e);
            }
        }
    }

    protected Timestamp getTimestamp(ResultSet rs, int param) {
        Timestamp value;
        Calendar cal = this.storeMgr.getCalendarForDateTimezone();
        try {
            value = cal != null ? rs.getTimestamp(param, cal) : rs.getTimestamp(param);
        }
        catch (SQLException e) {
            try {
                String s = rs.getString(param);
                value = rs.wasNull() ? null : (s == null ? null : TimestampColumnMapping.stringToTimestamp(s, cal));
            }
            catch (SQLException nestedEx) {
                throw new NucleusDataStoreException(Localiser.msg((String)"055002", (Object[])new Object[]{"Timestamp", "" + param, this.column, e.getMessage()}), (Throwable)nestedEx);
            }
        }
        return value;
    }

    @Override
    public Object getObject(ResultSet rs, int param) {
        Timestamp value = this.getTimestamp(rs, param);
        if (value == null) {
            return null;
        }
        if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_UTIL_DATE)) {
            return new java.util.Date(this.getDatastoreAdapter().getAdapterTime(value));
        }
        if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_SQL_DATE)) {
            return new Date(this.getDatastoreAdapter().getAdapterTime(value));
        }
        if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_SQL_TIME)) {
            return new Time(this.getDatastoreAdapter().getAdapterTime(value));
        }
        return value;
    }

    private static Timestamp stringToTimestamp(String s, Calendar cal) {
        int[] numbers = TimestampColumnMapping.convertStringToIntArray(s);
        if (numbers == null || numbers.length < 6) {
            throw new IllegalArgumentException(Localiser.msg((String)"030003", (Object[])new Object[]{s}));
        }
        int year = numbers[0];
        int month = numbers[1];
        int day = numbers[2];
        int hour = numbers[3];
        int minute = numbers[4];
        int second = numbers[5];
        int nanos = 0;
        if (numbers.length > 6) {
            StringBuilder zeroedNanos = new StringBuilder("" + numbers[6]);
            if (zeroedNanos.length() < 9) {
                int numZerosToAdd = 9 - zeroedNanos.length();
                for (int i = 0; i < numZerosToAdd; ++i) {
                    zeroedNanos.append("0");
                }
                nanos = Integer.valueOf(zeroedNanos.toString());
            } else {
                nanos = numbers[6];
            }
        }
        Calendar thecal = cal;
        if (cal == null) {
            thecal = new GregorianCalendar();
        }
        thecal.set(0, 1);
        thecal.set(1, year);
        thecal.set(2, month - 1);
        thecal.set(5, day);
        thecal.set(11, hour);
        thecal.set(12, minute);
        thecal.set(13, second);
        Timestamp ts = new Timestamp(thecal.getTime().getTime());
        ts.setNanos(nanos);
        return ts;
    }

    private static int[] convertStringToIntArray(String str) {
        if (str == null) {
            return null;
        }
        int[] values = null;
        ArrayList<Integer> list = new ArrayList<Integer>();
        int start = -1;
        for (int i = 0; i < str.length(); ++i) {
            if (start == -1 && Character.isDigit(str.charAt(i))) {
                start = i;
            }
            if (start != i && start >= 0 && !Character.isDigit(str.charAt(i))) {
                list.add(Integer.valueOf(str.substring(start, i)));
                start = -1;
            }
            if (i != str.length() - 1 || start < 0) continue;
            list.add(Integer.valueOf(str.substring(start)));
        }
        if (!list.isEmpty()) {
            values = new int[list.size()];
            Iterator iter = list.iterator();
            int n = 0;
            while (iter.hasNext()) {
                values[n++] = (Integer)iter.next();
            }
        }
        return values;
    }
}

