/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.adapter;

import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.DatastoreId;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.rdbms.adapter.BaseDatastoreAdapter;
import org.datanucleus.store.rdbms.adapter.DB2TypeInfo;
import org.datanucleus.store.rdbms.identifier.IdentifierType;
import org.datanucleus.store.rdbms.mapping.column.BigIntColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.BinaryStreamColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.BitColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.BlobColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.BooleanColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.CharColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.ClobColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.DB2DatalinkColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.DateColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.DecimalColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.DoubleColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.IntegerColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.LongVarBinaryColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.LongVarcharColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.NCharColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.NVarcharColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.NumericColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.RealColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.SmallIntColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.SqlXmlColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.TimeColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.TimestampColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.VarBinaryColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.VarCharColumnMapping;
import org.datanucleus.store.rdbms.schema.RDBMSColumnInfo;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.sql.method.SQLCubeFunction;
import org.datanucleus.store.rdbms.sql.method.SQLRollupFunction;
import org.datanucleus.store.rdbms.sql.method.StringConcat2Method;
import org.datanucleus.store.rdbms.sql.method.StringIndexOf3Method;
import org.datanucleus.store.rdbms.sql.method.StringLength3Method;
import org.datanucleus.store.rdbms.sql.method.StringSubstring3Method;
import org.datanucleus.store.rdbms.sql.method.StringTranslateMethod;
import org.datanucleus.store.rdbms.sql.method.StringTrim2Method;
import org.datanucleus.store.rdbms.sql.operation.Concat3Operation;
import org.datanucleus.store.rdbms.sql.operation.Mod3Operation;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.store.schema.StoreSchemaHandler;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.StringUtils;

public class DB2Adapter
extends BaseDatastoreAdapter {
    public static final String DB2_RESERVED_WORDS = "ACCESS,ALIAS,ALLOW,ASUTIME,AUDIT,AUX,AUXILIARY,BUFFERPOOL,CAPTURE,CCSID,CLUSTER,COLLECTION,COLLID,COMMENT,CONCAT,CONTAINS,COUNT_BIG,CURRENT_LC_PATH,CURRENT_SERVER,CURRENT_TIMEZONE,DATABASE,DAYS,DB2GENERAL,DB2SQL,DBA,DBINFO,DBSPACE,DISALLOW,DSSIZE,EDITPROC,ERASE,EXCLUSIVE,EXPLAIN,FENCED,FIELDPROC,FILE,FINAL,GENERATED,GRAPHIC,HOURS,IDENTIFIED,INDEX,INTEGRITY,ISOBID,JAVA,LABEL,LC_CTYPE,LINKTYPE,LOCALE,LOCATORS,LOCK,LOCKSIZE,LONG,MICROSECOND,MICROSECONDS,MINUTES,MODE,MONTHS,NAME,NAMED,NHEADER,NODENAME,NODENUMBER,NULLS,NUMPARTS,OBID,OPTIMIZATION,OPTIMIZE,PACKAGE,PAGE,PAGES,PART,PCTFREE,PCTINDEX,PIECESIZE,PLAN,PRIQTY,PRIVATE,PROGRAM,PSID,QYERYNO,RECOVERY,RENAME,RESET,RESOURCE,RRN,RUN,SCHEDULE,SCRATCHPAD,SECONDS,SECQTY,SECURITY,SHARE,SIMPLE,SOURCE,STANDARD,STATISTICS,STAY,STOGROUP,STORES,STORPOOL,STYLE,SUBPAGES,SYNONYM,TABLESPACE,TYPE,VALIDPROC,VARIABLE,VARIANT,VCAT,VOLUMES,WLM,YEARS";

    public DB2Adapter(DatabaseMetaData metadata) {
        super(metadata);
        this.reservedKeywords.addAll(StringUtils.convertCommaSeparatedStringToSet((String)DB2_RESERVED_WORDS));
        this.supportedOptions.add("LockRowUsingSelectForUpdate");
        this.supportedOptions.add("IdentityColumns");
        this.supportedOptions.add("Sequences");
        this.supportedOptions.add("StoredProcs");
        this.supportedOptions.add("UseUnionAll");
        this.supportedOptions.add("OrderByWithNullsDirectives");
        this.supportedOptions.remove("BooleanExpression");
        this.supportedOptions.remove("DeferredConstraints");
        this.supportedOptions.remove("NullsInCandidateKeys");
        this.supportedOptions.remove("ColumnOptions_NullsKeyword");
        this.supportedOptions.remove("DistinctWithSelectForUpdate");
        this.supportedOptions.remove("GroupingWithSelectForUpdate");
        this.supportedOptions.remove("HavingWithSelectForUpdate");
        this.supportedOptions.remove("OrderingWithSelectForUpdate");
        this.supportedOptions.remove("MultipleTablesWithSelectForUpdate");
        this.supportedOptions.remove("CreateIndexColumnOrdering");
        this.supportedOptions.remove("FkDeleteActionDefault");
        this.supportedOptions.remove("FkUpdateActionDefault");
        this.supportedOptions.remove("FkUpdateActionCascade");
        this.supportedOptions.remove("FkUpdateActionNull");
    }

    @Override
    public void initialiseTypes(StoreSchemaHandler handler, ManagedConnection mconn) {
        super.initialiseTypes(handler, mconn);
        DB2TypeInfo sqlType = new DB2TypeInfo("FLOAT", 6, 53, null, null, null, 1, false, 2, false, false, false, null, 0, 0, 0);
        this.addSQLTypeForJDBCType(handler, mconn, (short)6, sqlType, true);
        sqlType = new DB2TypeInfo("NUMERIC", 2, 31, null, null, "PRECISION,SCALE", 1, false, 2, false, false, false, null, 0, 31, 0);
        this.addSQLTypeForJDBCType(handler, mconn, (short)2, sqlType, true);
        sqlType = new DB2TypeInfo("BIGINT", -5, 20, null, null, null, 1, false, 2, false, true, false, null, 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)-5, sqlType, true);
        sqlType = new DB2TypeInfo("XML", 2009, Integer.MAX_VALUE, null, null, null, 1, false, 2, false, false, false, null, 0, 0, 0);
        this.addSQLTypeForJDBCType(handler, mconn, (short)2009, sqlType, true);
        sqlType = new DB2TypeInfo("SMALLINT", 5, 5, null, null, null, 1, false, 2, false, true, false, null, 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)-7, sqlType, true);
    }

    @Override
    public String getVendorID() {
        return "db2";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSchemaName(Connection conn) throws SQLException {
        try (Statement stmt = conn.createStatement();){
            String string;
            String stmtText = "VALUES (CURRENT SCHEMA)";
            ResultSet rs = stmt.executeQuery(stmtText);
            try {
                if (!rs.next()) {
                    throw new NucleusDataStoreException("No result returned from " + stmtText).setFatal();
                }
                string = rs.getString(1).trim();
            }
            catch (Throwable throwable) {
                rs.close();
                throw throwable;
            }
            rs.close();
            return string;
        }
    }

    @Override
    public int getDatastoreIdentifierMaxLength(IdentifierType identifierType) {
        if (identifierType == IdentifierType.CANDIDATE_KEY) {
            return 18;
        }
        if (identifierType == IdentifierType.FOREIGN_KEY) {
            return 18;
        }
        if (identifierType == IdentifierType.INDEX) {
            return 18;
        }
        if (identifierType == IdentifierType.PRIMARY_KEY) {
            return 18;
        }
        return super.getDatastoreIdentifierMaxLength(identifierType);
    }

    @Override
    public SQLTypeInfo newSQLTypeInfo(ResultSet rs) {
        return new DB2TypeInfo(rs);
    }

    @Override
    public RDBMSColumnInfo newRDBMSColumnInfo(ResultSet rs) {
        RDBMSColumnInfo info = new RDBMSColumnInfo(rs);
        short dataType = info.getDataType();
        switch (dataType) {
            case 91: 
            case 92: 
            case 93: {
                info.setDecimalDigits(0);
                break;
            }
        }
        return info;
    }

    @Override
    public String getDropDatabaseStatement(String schemaName, String catalogName) {
        throw new UnsupportedOperationException("DB2 does not support dropping schema with cascade. You need to drop all tables first");
    }

    @Override
    public String getDropTableStatement(Table table) {
        return "DROP TABLE " + table.toString();
    }

    @Override
    public String getContinuationString() {
        return "";
    }

    @Override
    public String getIdentityLastValueStmt(Table table, String columnName) {
        return "VALUES IDENTITY_VAL_LOCAL()";
    }

    @Override
    public String getIdentityKeyword(StoreManager storeMgr) {
        return "generated always as identity (start with 1)";
    }

    @Override
    public String getSequenceCreateStmt(String sequenceName, Integer min, Integer max, Integer start, Integer increment, Integer cacheSize) {
        if (sequenceName == null) {
            throw new NucleusUserException(Localiser.msg((String)"051028"));
        }
        StringBuilder stmt = new StringBuilder("CREATE SEQUENCE ");
        stmt.append(sequenceName);
        stmt.append(" AS INTEGER ");
        if (start != null) {
            stmt.append(" START WITH " + start);
        }
        if (increment != null) {
            stmt.append(" INCREMENT BY " + increment);
        }
        if (min != null) {
            stmt.append(" MINVALUE " + min);
        }
        if (max != null) {
            stmt.append(" MAXVALUE " + max);
        }
        if (cacheSize != null) {
            stmt.append(" CACHE " + cacheSize);
        } else {
            stmt.append(" NOCACHE");
        }
        return stmt.toString();
    }

    @Override
    public String getSequenceNextStmt(String sequenceName) {
        if (sequenceName == null) {
            throw new NucleusUserException(Localiser.msg((String)"051028"));
        }
        StringBuilder stmt = new StringBuilder("VALUES NEXTVAL FOR ");
        stmt.append(sequenceName);
        return stmt.toString();
    }

    @Override
    public String getRangeByRowNumberColumn() {
        return "row_number()over()";
    }

    @Override
    public boolean isStatementCancel(SQLException sqle) {
        return sqle.getErrorCode() == -952;
    }

    @Override
    public boolean isStatementTimeout(SQLException sqle) {
        if (sqle.getSQLState() != null && sqle.getSQLState().equalsIgnoreCase("57014") && (sqle.getErrorCode() == -952 || sqle.getErrorCode() == -905)) {
            return true;
        }
        return super.isStatementTimeout(sqle);
    }

    @Override
    public Class getSQLOperationClass(String operationName) {
        if ("mod".equals(operationName)) {
            return Mod3Operation.class;
        }
        if ("concat".equals(operationName)) {
            return Concat3Operation.class;
        }
        return super.getSQLOperationClass(operationName);
    }

    @Override
    public Class getSQLMethodClass(String className, String methodName, ClassLoaderResolver clr) {
        if (className == null) {
            if ("SQL_cube".equals(methodName)) {
                return SQLCubeFunction.class;
            }
            if ("SQL_rollup".equals(methodName)) {
                return SQLRollupFunction.class;
            }
        } else if ("java.lang.String".equals(className)) {
            if ("concat".equals(methodName)) {
                return StringConcat2Method.class;
            }
            if ("indexOf".equals(methodName)) {
                return StringIndexOf3Method.class;
            }
            if ("length".equals(methodName)) {
                return StringLength3Method.class;
            }
            if ("substring".equals(methodName)) {
                return StringSubstring3Method.class;
            }
            if ("translate".equals(methodName)) {
                return StringTranslateMethod.class;
            }
            if ("trim".equals(methodName)) {
                return StringTrim2Method.class;
            }
        }
        return super.getSQLMethodClass(className, methodName, clr);
    }

    @Override
    protected void loadColumnMappings(PluginManager mgr, ClassLoaderResolver clr) {
        this.registerColumnMapping(Boolean.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", true);
        this.registerColumnMapping(Boolean.class.getName(), BitColumnMapping.class, JDBCType.BIT, "BIT", false);
        this.registerColumnMapping(Boolean.class.getName(), BooleanColumnMapping.class, JDBCType.BOOLEAN, "BOOLEAN", false);
        this.registerColumnMapping(Boolean.class.getName(), SmallIntColumnMapping.class, JDBCType.SMALLINT, "SMALLINT", false);
        this.registerColumnMapping(Byte.class.getName(), SmallIntColumnMapping.class, JDBCType.SMALLINT, "SMALLINT", true);
        this.registerColumnMapping(Character.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", true);
        this.registerColumnMapping(Character.class.getName(), IntegerColumnMapping.class, JDBCType.INTEGER, "INTEGER", false);
        this.registerColumnMapping(Double.class.getName(), DoubleColumnMapping.class, JDBCType.DOUBLE, "DOUBLE", true);
        this.registerColumnMapping(Double.class.getName(), DecimalColumnMapping.class, JDBCType.DECIMAL, "DECIMAL", false);
        this.registerColumnMapping(Float.class.getName(), RealColumnMapping.class, JDBCType.REAL, "REAL", true);
        this.registerColumnMapping(Float.class.getName(), DoubleColumnMapping.class, JDBCType.DOUBLE, "DOUBLE", false);
        this.registerColumnMapping(Float.class.getName(), DecimalColumnMapping.class, JDBCType.DECIMAL, "DECIMAL", false);
        this.registerColumnMapping(Integer.class.getName(), IntegerColumnMapping.class, JDBCType.INTEGER, "INTEGER", true);
        this.registerColumnMapping(Integer.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerColumnMapping(Integer.class.getName(), NumericColumnMapping.class, JDBCType.NUMERIC, "NUMERIC", false);
        this.registerColumnMapping(Integer.class.getName(), SmallIntColumnMapping.class, JDBCType.SMALLINT, "SMALLINT", false);
        this.registerColumnMapping(Long.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, "BIGINT", true);
        this.registerColumnMapping(Long.class.getName(), IntegerColumnMapping.class, JDBCType.INTEGER, "INT", false);
        this.registerColumnMapping(Long.class.getName(), NumericColumnMapping.class, JDBCType.NUMERIC, "NUMERIC", false);
        this.registerColumnMapping(Long.class.getName(), SmallIntColumnMapping.class, JDBCType.SMALLINT, "SMALLINT", false);
        this.registerColumnMapping(Short.class.getName(), SmallIntColumnMapping.class, JDBCType.SMALLINT, "SMALLINT", true);
        this.registerColumnMapping(Short.class.getName(), IntegerColumnMapping.class, JDBCType.INTEGER, "INTEGER", false);
        this.registerColumnMapping(String.class.getName(), VarCharColumnMapping.class, JDBCType.VARCHAR, "VARCHAR", true);
        this.registerColumnMapping(String.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerColumnMapping(String.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerColumnMapping(String.class.getName(), LongVarcharColumnMapping.class, JDBCType.LONGVARCHAR, "LONGVARCHAR", false);
        this.registerColumnMapping(String.class.getName(), ClobColumnMapping.class, JDBCType.CLOB, "CLOB", false);
        this.registerColumnMapping(String.class.getName(), BlobColumnMapping.class, JDBCType.BLOB, "BLOB", false);
        this.registerColumnMapping(String.class.getName(), DB2DatalinkColumnMapping.class, JDBCType.DATALINK, "DATALINK", false);
        this.registerColumnMapping(String.class.getName(), SqlXmlColumnMapping.class, JDBCType.SQLXML, "SQLXML", false);
        this.registerColumnMapping(String.class.getName(), NVarcharColumnMapping.class, JDBCType.NVARCHAR, "NVARCHAR", false);
        this.registerColumnMapping(String.class.getName(), NCharColumnMapping.class, JDBCType.NCHAR, "NCHAR", false);
        this.registerColumnMapping(BigDecimal.class.getName(), DecimalColumnMapping.class, JDBCType.DECIMAL, "DECIMAL", true);
        this.registerColumnMapping(BigDecimal.class.getName(), NumericColumnMapping.class, JDBCType.NUMERIC, "NUMERIC", false);
        this.registerColumnMapping(BigInteger.class.getName(), NumericColumnMapping.class, JDBCType.NUMERIC, "NUMERIC", true);
        this.registerColumnMapping(BigInteger.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerColumnMapping(Date.class.getName(), DateColumnMapping.class, JDBCType.DATE, "DATE", true);
        this.registerColumnMapping(Date.class.getName(), TimestampColumnMapping.class, JDBCType.TIMESTAMP, "TIMESTAMP", false);
        this.registerColumnMapping(Date.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerColumnMapping(Date.class.getName(), VarCharColumnMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        this.registerColumnMapping(Date.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerColumnMapping(Time.class.getName(), TimeColumnMapping.class, JDBCType.TIME, "TIME", true);
        this.registerColumnMapping(Time.class.getName(), TimestampColumnMapping.class, JDBCType.TIMESTAMP, "TIMESTAMP", false);
        this.registerColumnMapping(Time.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerColumnMapping(Time.class.getName(), VarCharColumnMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        this.registerColumnMapping(Time.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerColumnMapping(Timestamp.class.getName(), TimestampColumnMapping.class, JDBCType.TIMESTAMP, "TIMESTAMP", true);
        this.registerColumnMapping(Timestamp.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerColumnMapping(Timestamp.class.getName(), VarCharColumnMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        this.registerColumnMapping(Timestamp.class.getName(), DateColumnMapping.class, JDBCType.DATE, "DATE", false);
        this.registerColumnMapping(Timestamp.class.getName(), TimeColumnMapping.class, JDBCType.TIME, "TIME", false);
        this.registerColumnMapping(java.util.Date.class.getName(), TimestampColumnMapping.class, JDBCType.TIMESTAMP, "TIMESTAMP", true);
        this.registerColumnMapping(java.util.Date.class.getName(), DateColumnMapping.class, JDBCType.DATE, "DATE", false);
        this.registerColumnMapping(java.util.Date.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerColumnMapping(java.util.Date.class.getName(), VarCharColumnMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        this.registerColumnMapping(java.util.Date.class.getName(), TimeColumnMapping.class, JDBCType.TIME, "TIME", false);
        this.registerColumnMapping(java.util.Date.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerColumnMapping(Serializable.class.getName(), LongVarBinaryColumnMapping.class, JDBCType.LONGVARBINARY, "LONGVARBINARY", true);
        this.registerColumnMapping(Serializable.class.getName(), BlobColumnMapping.class, JDBCType.BLOB, "BLOB", false);
        this.registerColumnMapping(Serializable.class.getName(), VarBinaryColumnMapping.class, JDBCType.VARBINARY, "VARBINARY", false);
        this.registerColumnMapping(byte[].class.getName(), LongVarBinaryColumnMapping.class, JDBCType.LONGVARBINARY, "LONGVARBINARY", true);
        this.registerColumnMapping(byte[].class.getName(), BlobColumnMapping.class, JDBCType.BLOB, "BLOB", false);
        this.registerColumnMapping(byte[].class.getName(), VarBinaryColumnMapping.class, JDBCType.VARBINARY, "VARBINARY", false);
        this.registerColumnMapping(File.class.getName(), BinaryStreamColumnMapping.class, JDBCType.LONGVARBINARY, "LONGVARBINARY", true);
        this.registerColumnMapping(DatastoreId.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, "BIGINT", true);
        this.registerColumnMapping(DatastoreId.class.getName(), IntegerColumnMapping.class, JDBCType.INTEGER, "INTEGER", false);
        this.registerColumnMapping(DatastoreId.class.getName(), NumericColumnMapping.class, JDBCType.NUMERIC, "NUMERIC", false);
        this.registerColumnMapping(DatastoreId.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerColumnMapping(DatastoreId.class.getName(), VarCharColumnMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        super.loadColumnMappings(mgr, clr);
    }
}

