/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.FetchPlan;
import org.datanucleus.exceptions.NotYetFlushedException;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.FieldRole;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.rdbms.JDBCUtils;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.exceptions.MappedDatastoreException;
import org.datanucleus.store.rdbms.fieldmanager.DynamicSchemaFieldManager;
import org.datanucleus.store.rdbms.mapping.java.ReferenceMapping;
import org.datanucleus.store.rdbms.query.StatementClassMapping;
import org.datanucleus.store.rdbms.scostore.AbstractSetStore;
import org.datanucleus.store.rdbms.scostore.BackingStoreHelper;
import org.datanucleus.store.rdbms.scostore.ComponentInfo;
import org.datanucleus.store.rdbms.scostore.ElementIteratorStatement;
import org.datanucleus.store.rdbms.sql.DiscriminatorStatementGenerator;
import org.datanucleus.store.rdbms.sql.SQLStatementHelper;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.SelectStatement;
import org.datanucleus.store.rdbms.sql.UnionStatementGenerator;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.table.CollectionTable;
import org.datanucleus.store.rdbms.table.DatastoreClass;
import org.datanucleus.store.types.SCO;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class JoinSetStore<E>
extends AbstractSetStore<E> {
    protected String locateStmt;
    protected String maxOrderColumnIdStmt;

    public JoinSetStore(AbstractMemberMetaData mmd, CollectionTable joinTable, ClassLoaderResolver clr) {
        super(joinTable.getStoreManager(), clr);
        this.containerTable = joinTable;
        this.setOwner(mmd);
        this.ownerMapping = joinTable.getOwnerMapping();
        this.elementMapping = joinTable.getElementMapping();
        this.orderMapping = joinTable.getOrderMapping();
        this.relationDiscriminatorMapping = joinTable.getRelationDiscriminatorMapping();
        this.relationDiscriminatorValue = joinTable.getRelationDiscriminatorValue();
        this.elementType = mmd.getCollection().getElementType();
        this.elementsAreEmbedded = joinTable.isEmbeddedElement();
        this.elementsAreSerialised = joinTable.isSerialisedElement();
        if (this.elementsAreSerialised) {
            this.elementInfo = null;
        } else {
            Class element_class = clr.classForName(this.elementType);
            if (ClassUtils.isReferenceType((Class)element_class)) {
                String[] implNames = MetaDataUtils.getInstance().getImplementationNamesForReferenceField(this.ownerMemberMetaData, FieldRole.ROLE_COLLECTION_ELEMENT, clr, this.storeMgr.getMetaDataManager());
                this.elementInfo = new ComponentInfo[implNames.length];
                for (int i = 0; i < implNames.length; ++i) {
                    DatastoreClass table = this.storeMgr.getDatastoreClass(implNames[i], clr);
                    AbstractClassMetaData cmd = this.storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForClass(implNames[i], clr);
                    this.elementInfo[i] = new ComponentInfo(cmd, table);
                }
            } else {
                this.elementCmd = this.storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForClass(element_class, clr);
                this.elementInfo = this.elementCmd != null && !this.elementsAreEmbedded ? this.getComponentInformationForClass(this.elementType, this.elementCmd) : null;
            }
        }
    }

    @Override
    public void update(DNStateManager sm, Collection coll) {
        if (coll == null || coll.isEmpty()) {
            this.clear(sm);
            return;
        }
        if (this.ownerMemberMetaData.getCollection().isSerializedElement() || this.ownerMemberMetaData.getCollection().isEmbeddedElement()) {
            this.clear(sm);
            this.addAll(sm, coll, 0);
            return;
        }
        Iterator<E> elemIter = this.iterator(sm);
        HashSet<E> existing = new HashSet<E>();
        while (elemIter.hasNext()) {
            E elem = elemIter.next();
            if (!coll.contains(elem)) {
                this.remove(sm, elem, -1, true);
                continue;
            }
            existing.add(elem);
        }
        if (existing.size() != coll.size()) {
            for (Object elem : coll) {
                if (existing.contains(elem)) continue;
                this.add(sm, elem, 0);
            }
        }
    }

    private boolean elementAlreadyContainsOwnerInMtoN(DNStateManager ownerSM, Object element) {
        ExecutionContext ec = ownerSM.getExecutionContext();
        if (ec.getOperationQueue() != null) {
            if (this.locate(ownerSM, element)) {
                NucleusLogger.DATASTORE.info((Object)Localiser.msg((String)"056040", (Object[])new Object[]{this.ownerMemberMetaData.getFullFieldName(), StringUtils.toJVMIDString((Object)ownerSM.getObject()), element}));
                return true;
            }
            return false;
        }
        DNStateManager elementOP = ec.findStateManager(element);
        if (elementOP != null) {
            AbstractMemberMetaData[] relatedMmds = this.ownerMemberMetaData.getRelatedMemberMetaData(ec.getClassLoaderResolver());
            Object elementColl = elementOP.provideField(relatedMmds[0].getAbsoluteFieldNumber());
            if (elementColl != null && elementColl instanceof Collection && elementColl instanceof SCO && ((Collection)elementColl).contains(ownerSM.getObject())) {
                NucleusLogger.DATASTORE.info((Object)Localiser.msg((String)"056040", (Object[])new Object[]{this.ownerMemberMetaData.getFullFieldName(), StringUtils.toJVMIDString((Object)ownerSM.getObject()), element}));
                return true;
            }
        } else if (this.locate(ownerSM, element)) {
            NucleusLogger.DATASTORE.info((Object)Localiser.msg((String)"056040", (Object[])new Object[]{this.ownerMemberMetaData.getFullFieldName(), StringUtils.toJVMIDString((Object)ownerSM.getObject()), element}));
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(DNStateManager sm, E element, int size) {
        DNStateManager elementOP;
        ExecutionContext ec = sm.getExecutionContext();
        this.validateElementForWriting(ec, element, null);
        if (this.relationType == RelationType.ONE_TO_MANY_BI && (elementOP = ec.findStateManager(element)) != null) {
            AbstractMemberMetaData[] relatedMmds = this.ownerMemberMetaData.getRelatedMemberMetaData(this.clr);
            Object elementOwner = elementOP.provideField(relatedMmds[0].getAbsoluteFieldNumber());
            if (elementOwner == null) {
                NucleusLogger.PERSISTENCE.info((Object)Localiser.msg((String)"056037", (Object[])new Object[]{sm.getObjectAsPrintable(), this.ownerMemberMetaData.getFullFieldName(), StringUtils.toJVMIDString((Object)elementOP.getObject())}));
                elementOP.replaceField(relatedMmds[0].getAbsoluteFieldNumber(), sm.getObject());
            } else if (elementOwner != sm.getObject() && sm.getReferencedPC() == null) {
                throw new NucleusUserException(Localiser.msg((String)"056038", (Object[])new Object[]{sm.getObjectAsPrintable(), this.ownerMemberMetaData.getFullFieldName(), StringUtils.toJVMIDString((Object)elementOP.getObject()), StringUtils.toJVMIDString((Object)elementOwner)}));
            }
        }
        boolean modified = false;
        boolean toBeInserted = true;
        if (this.relationType == RelationType.MANY_TO_MANY_BI) {
            boolean bl = toBeInserted = !this.elementAlreadyContainsOwnerInMtoN(sm, element);
        }
        if (toBeInserted) {
            try {
                ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec);
                try {
                    int orderID = this.orderMapping != null ? this.getNextIDForOrderColumn(sm) : -1;
                    int[] returnCode = this.doInternalAdd(sm, element, mconn, false, orderID, true);
                    if (returnCode[0] > 0) {
                        modified = true;
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (MappedDatastoreException e) {
                String msg = Localiser.msg((String)"056009", (Object[])new Object[]{e.getMessage()});
                NucleusLogger.DATASTORE.error((Object)msg, (Throwable)e);
                throw new NucleusDataStoreException(msg, (Throwable)e);
            }
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(DNStateManager sm, Collection<E> elements, int size) {
        if (elements == null || elements.size() == 0) {
            return false;
        }
        ArrayList<MappedDatastoreException> exceptions = new ArrayList<MappedDatastoreException>();
        boolean batched = elements.size() > 1;
        ExecutionContext ec = sm.getExecutionContext();
        for (E element : elements) {
            DNStateManager elementOP;
            this.validateElementForWriting(ec, element, null);
            if (this.relationType != RelationType.ONE_TO_MANY_BI || (elementOP = sm.getExecutionContext().findStateManager(element)) == null) continue;
            AbstractMemberMetaData[] relatedMmds = this.ownerMemberMetaData.getRelatedMemberMetaData(this.clr);
            Object elementOwner = elementOP.provideField(relatedMmds[0].getAbsoluteFieldNumber());
            if (elementOwner == null) {
                NucleusLogger.PERSISTENCE.info((Object)Localiser.msg((String)"056037", (Object[])new Object[]{sm.getObjectAsPrintable(), this.ownerMemberMetaData.getFullFieldName(), StringUtils.toJVMIDString((Object)elementOP.getObject())}));
                elementOP.replaceField(relatedMmds[0].getAbsoluteFieldNumber(), sm.getObject());
                continue;
            }
            if (elementOwner == sm.getObject() || sm.getReferencedPC() != null) continue;
            throw new NucleusUserException(Localiser.msg((String)"056038", (Object[])new Object[]{sm.getObjectAsPrintable(), this.ownerMemberMetaData.getFullFieldName(), StringUtils.toJVMIDString((Object)elementOP.getObject()), StringUtils.toJVMIDString((Object)elementOwner)}));
        }
        boolean modified = false;
        try {
            ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec);
            try {
                SQLController sqlControl = this.storeMgr.getSQLController();
                try {
                    sqlControl.processStatementsForConnection(mconn);
                }
                catch (SQLException e) {
                    throw new MappedDatastoreException("SQLException", e);
                }
                int nextOrderID = this.orderMapping != null ? this.getNextIDForOrderColumn(sm) : 0;
                Iterator<E> iter = elements.iterator();
                E element = null;
                while (iter.hasNext()) {
                    element = iter.next();
                    try {
                        boolean toBeInserted = true;
                        if (this.relationType == RelationType.MANY_TO_MANY_BI) {
                            boolean bl = toBeInserted = !this.elementAlreadyContainsOwnerInMtoN(sm, element);
                        }
                        if (!toBeInserted) continue;
                        int[] rc = this.doInternalAdd(sm, element, mconn, batched, nextOrderID, !batched || batched && !iter.hasNext());
                        if (rc != null) {
                            for (int i = 0; i < rc.length; ++i) {
                                if (rc[i] <= 0) continue;
                                modified = true;
                            }
                        }
                        ++nextOrderID;
                    }
                    catch (MappedDatastoreException mde) {
                        exceptions.add(mde);
                        NucleusLogger.DATASTORE.error((Object)"Exception thrown", (Throwable)mde);
                    }
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (MappedDatastoreException e) {
            exceptions.add(e);
            NucleusLogger.DATASTORE.error((Object)"Exception thrown", (Throwable)e);
        }
        if (!exceptions.isEmpty()) {
            String msg = Localiser.msg((String)"056009", (Object[])new Object[]{((Exception)exceptions.get(0)).getMessage()});
            NucleusLogger.DATASTORE.error((Object)msg);
            throw new NucleusDataStoreException(msg, exceptions.toArray(new Throwable[exceptions.size()]), sm.getObject());
        }
        return modified;
    }

    @Override
    public boolean removeAll(DNStateManager sm, Collection elements, int size) {
        if (elements == null || elements.size() == 0) {
            return false;
        }
        boolean modified = this.removeAllInternal(sm, elements, size);
        boolean dependent = this.ownerMemberMetaData.getCollection().isDependentElement();
        if (this.ownerMemberMetaData.isCascadeRemoveOrphans()) {
            dependent = true;
        }
        if (dependent) {
            sm.getExecutionContext().deleteObjects(elements.toArray());
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeAllInternal(DNStateManager sm, Collection elements, int size) {
        boolean modified = false;
        String removeAllStmt = this.getRemoveAllStmt(sm, elements);
        try {
            ExecutionContext ec = sm.getExecutionContext();
            ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, removeAllStmt, false);
                try {
                    int jdbcPosition = 1;
                    for (Object element : elements) {
                        jdbcPosition = BackingStoreHelper.populateOwnerInStatement(sm, ec, ps, jdbcPosition, this);
                        jdbcPosition = BackingStoreHelper.populateElementForWhereClauseInStatement(ec, ps, element, jdbcPosition, this.elementMapping);
                        if (this.relationDiscriminatorMapping == null) continue;
                        jdbcPosition = BackingStoreHelper.populateRelationDiscriminatorInStatement(ec, ps, jdbcPosition, this);
                    }
                    int[] number = sqlControl.executeStatementUpdate(ec, mconn, removeAllStmt, ps, true);
                    if (number[0] > 0) {
                        modified = true;
                    }
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            NucleusLogger.DATASTORE.error((Object)"Exception on removeAll", (Throwable)e);
            throw new NucleusDataStoreException(Localiser.msg((String)"056012", (Object[])new Object[]{removeAllStmt}), (Throwable)e);
        }
        return modified;
    }

    @Override
    protected String getRemoveStmt(Object element) {
        StringBuilder stmt = new StringBuilder("DELETE FROM ").append(this.containerTable.toString()).append(" WHERE ");
        BackingStoreHelper.appendWhereClauseForMapping(stmt, this.ownerMapping, null, true);
        BackingStoreHelper.appendWhereClauseForElement(stmt, this.elementMapping, element, this.elementsAreSerialised, null, false);
        if (this.relationDiscriminatorMapping != null) {
            BackingStoreHelper.appendWhereClauseForMapping(stmt, this.relationDiscriminatorMapping, null, false);
        }
        return stmt.toString();
    }

    protected String getRemoveAllStmt(DNStateManager sm, Collection elements) {
        if (elements == null || elements.size() == 0) {
            return null;
        }
        StringBuilder stmt = new StringBuilder("DELETE FROM ").append(this.containerTable.toString()).append(" WHERE ");
        Iterator elementsIter = elements.iterator();
        boolean first = true;
        while (elementsIter.hasNext()) {
            Object element = elementsIter.next();
            stmt.append(first ? "(" : " OR (");
            BackingStoreHelper.appendWhereClauseForMapping(stmt, this.ownerMapping, null, true);
            BackingStoreHelper.appendWhereClauseForElement(stmt, this.elementMapping, element, this.elementsAreSerialised, null, false);
            if (this.relationDiscriminatorMapping != null) {
                BackingStoreHelper.appendWhereClauseForMapping(stmt, this.relationDiscriminatorMapping, null, false);
            }
            stmt.append(")");
            first = false;
        }
        return stmt.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean locate(DNStateManager sm, Object element) {
        boolean exists = true;
        String stmt = this.getLocateStmt(element);
        try {
            ExecutionContext ec = sm.getExecutionContext();
            ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForQuery(mconn, stmt);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = BackingStoreHelper.populateOwnerInStatement(sm, ec, ps, jdbcPosition, this);
                    jdbcPosition = BackingStoreHelper.populateElementForWhereClauseInStatement(ec, ps, element, jdbcPosition, this.elementMapping);
                    if (this.relationDiscriminatorMapping != null) {
                        jdbcPosition = BackingStoreHelper.populateRelationDiscriminatorInStatement(ec, ps, jdbcPosition, this);
                    }
                    ResultSet rs = sqlControl.executeStatementQuery(ec, mconn, stmt, ps);
                    try {
                        if (!rs.next()) {
                            exists = false;
                        }
                    }
                    catch (SQLException sqle) {
                        rs.close();
                    }
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            NucleusLogger.DATASTORE.error((Object)Localiser.msg((String)"RDBMS.SCO.LocateRequestFailed", (Object[])new Object[]{stmt}), (Throwable)e);
            throw new NucleusDataStoreException(Localiser.msg((String)"RDBMS.SCO.LocateRequestFailed", (Object[])new Object[]{stmt}), (Throwable)e);
        }
        return exists;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int[] doInternalAdd(DNStateManager sm, E element, ManagedConnection conn, boolean batched, int orderId, boolean executeNow) throws MappedDatastoreException {
        if (this.storeMgr.getBooleanObjectProperty("datanucleus.rdbms.dynamicSchemaUpdates").booleanValue()) {
            DynamicSchemaFieldManager dynamicSchemaFM = new DynamicSchemaFieldManager(this.storeMgr, sm);
            HashSet<E> coll = new HashSet<E>();
            coll.add(element);
            dynamicSchemaFM.storeObjectField(this.ownerMemberMetaData.getAbsoluteFieldNumber(), coll);
            if (dynamicSchemaFM.hasPerformedSchemaUpdates()) {
                this.invalidateAddStmt();
            }
        }
        String addStmt = this.getAddStmtForJoinTable();
        boolean notYetFlushedError = false;
        ExecutionContext ec = sm.getExecutionContext();
        SQLController sqlControl = this.storeMgr.getSQLController();
        try {
            PreparedStatement ps = sqlControl.getStatementForUpdate(conn, addStmt, batched);
            try {
                int jdbcPosition = 1;
                jdbcPosition = BackingStoreHelper.populateOwnerInStatement(sm, ec, ps, jdbcPosition, this);
                jdbcPosition = BackingStoreHelper.populateElementInStatement(ec, ps, element, jdbcPosition, this.elementMapping);
                if (this.orderMapping != null) {
                    jdbcPosition = BackingStoreHelper.populateOrderInStatement(ec, ps, orderId, jdbcPosition, this.orderMapping);
                }
                if (this.relationDiscriminatorMapping != null) {
                    jdbcPosition = BackingStoreHelper.populateRelationDiscriminatorInStatement(ec, ps, jdbcPosition, this);
                }
                int[] nArray = sqlControl.executeStatementUpdate(ec, conn, addStmt, ps, executeNow);
                return nArray;
            }
            catch (NotYetFlushedException nfe) {
                notYetFlushedError = true;
                throw nfe;
            }
            finally {
                if (notYetFlushedError) {
                    sqlControl.abortStatementForConnection(conn, ps);
                } else {
                    sqlControl.closeStatement(conn, ps);
                }
            }
        }
        catch (SQLException e) {
            throw new MappedDatastoreException(addStmt, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized String getLocateStmt(Object element) {
        if (this.elementMapping instanceof ReferenceMapping && this.elementMapping.getNumberOfColumnMappings() > 1) {
            return this.getLocateStatementString(element);
        }
        if (this.locateStmt == null) {
            JoinSetStore joinSetStore = this;
            synchronized (joinSetStore) {
                this.locateStmt = this.getLocateStatementString(element);
            }
        }
        return this.locateStmt;
    }

    private String getLocateStatementString(Object element) {
        StringBuilder stmt = new StringBuilder("SELECT 1 FROM ").append(this.containerTable.toString()).append(" WHERE ");
        BackingStoreHelper.appendWhereClauseForMapping(stmt, this.ownerMapping, null, true);
        BackingStoreHelper.appendWhereClauseForElement(stmt, this.elementMapping, element, this.elementsAreSerialised, null, false);
        if (this.relationDiscriminatorMapping != null) {
            BackingStoreHelper.appendWhereClauseForMapping(stmt, this.relationDiscriminatorMapping, null, false);
        }
        return stmt.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getNextIDForOrderColumn(DNStateManager sm) {
        int nextID;
        ExecutionContext ec = sm.getExecutionContext();
        String stmt = this.getMaxOrderColumnIdStmt();
        try {
            ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForQuery(mconn, stmt);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = BackingStoreHelper.populateOwnerInStatement(sm, ec, ps, jdbcPosition, this);
                    if (this.relationDiscriminatorMapping != null) {
                        BackingStoreHelper.populateRelationDiscriminatorInStatement(ec, ps, jdbcPosition, this);
                    }
                    try (ResultSet rs = sqlControl.executeStatementQuery(ec, mconn, stmt, ps);){
                        nextID = !rs.next() ? 1 : rs.getInt(1) + 1;
                        JDBCUtils.logWarnings(rs);
                    }
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"056020", (Object[])new Object[]{stmt}), (Throwable)e);
        }
        return nextID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized String getMaxOrderColumnIdStmt() {
        if (this.maxOrderColumnIdStmt == null) {
            JoinSetStore joinSetStore = this;
            synchronized (joinSetStore) {
                StringBuilder stmt = new StringBuilder("SELECT MAX(" + this.orderMapping.getColumnMapping(0).getColumn().getIdentifier().toString() + ")");
                stmt.append(" FROM ").append(this.containerTable.toString()).append(" WHERE ");
                BackingStoreHelper.appendWhereClauseForMapping(stmt, this.ownerMapping, null, true);
                if (this.relationDiscriminatorMapping != null) {
                    BackingStoreHelper.appendWhereClauseForMapping(stmt, this.relationDiscriminatorMapping, null, false);
                }
                this.maxOrderColumnIdStmt = stmt.toString();
            }
        }
        return this.maxOrderColumnIdStmt;
    }

    /*
     * Exception decompiling
     */
    @Override
    public Iterator<E> iterator(DNStateManager ownerSM) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 7 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ElementIteratorStatement getIteratorStatement(ExecutionContext ec, FetchPlan fp, boolean addRestrictionOnOwner) {
        SelectStatement sqlStmt = null;
        SQLExpressionFactory exprFactory = this.storeMgr.getSQLExpressionFactory();
        StatementClassMapping elementClsMapping = null;
        if (this.elementsAreEmbedded || this.elementsAreSerialised) {
            sqlStmt = new SelectStatement(this.storeMgr, this.containerTable, null, null);
            sqlStmt.setClassLoaderResolver(this.clr);
            sqlStmt.select(sqlStmt.getPrimaryTable(), this.elementMapping, null);
        } else if (this.elementMapping instanceof ReferenceMapping) {
            sqlStmt = new SelectStatement(this.storeMgr, this.containerTable, null, null);
            sqlStmt.setClassLoaderResolver(this.clr);
            sqlStmt.select(sqlStmt.getPrimaryTable(), this.elementMapping, null);
        } else {
            elementClsMapping = new StatementClassMapping();
            for (int i = 0; i < this.elementInfo.length; ++i) {
                SQLTable elementSqlTbl;
                int elementNo = i;
                Class elementCls = this.clr.classForName(this.elementInfo[elementNo].getClassName());
                SelectStatement elementStmt = null;
                if (this.elementInfo[elementNo].getDiscriminatorStrategy() != null && this.elementInfo[elementNo].getDiscriminatorStrategy() != DiscriminatorStrategy.NONE) {
                    String elementType = this.ownerMemberMetaData.getCollection().getElementType();
                    if (ClassUtils.isReferenceType((Class)this.clr.classForName(elementType))) {
                        String[] clsNames = this.storeMgr.getNucleusContext().getMetaDataManager().getClassesImplementingInterface(elementType, this.clr);
                        Class[] cls = new Class[clsNames.length];
                        for (int j = 0; j < clsNames.length; ++j) {
                            cls[j] = this.clr.classForName(clsNames[j]);
                        }
                        DiscriminatorStatementGenerator stmtGen = new DiscriminatorStatementGenerator(this.storeMgr, this.clr, cls, true, null, null, this.containerTable, null, this.elementMapping);
                        if (this.allowNulls) {
                            stmtGen.setOption("allowNulls");
                        }
                        elementStmt = stmtGen.getStatement(ec);
                    } else {
                        DiscriminatorStatementGenerator stmtGen = new DiscriminatorStatementGenerator(this.storeMgr, this.clr, elementCls, true, null, null, this.containerTable, null, this.elementMapping);
                        if (this.allowNulls) {
                            stmtGen.setOption("allowNulls");
                        }
                        elementStmt = stmtGen.getStatement(ec);
                    }
                    this.iterateUsingDiscriminator = true;
                } else {
                    UnionStatementGenerator stmtGen = new UnionStatementGenerator(this.storeMgr, this.clr, elementCls, true, null, null, this.containerTable, null, this.elementMapping);
                    stmtGen.setOption("selectDnType");
                    elementClsMapping.setNucleusTypeColumnName("DN_TYPE");
                    elementStmt = stmtGen.getStatement(ec);
                }
                if (sqlStmt == null) {
                    sqlStmt = elementStmt;
                    elementSqlTbl = sqlStmt.getTable(this.elementInfo[i].getDatastoreClass(), sqlStmt.getPrimaryTable().getGroupName());
                    SQLStatementHelper.selectFetchPlanOfSourceClassInStatement(sqlStmt, elementClsMapping, fp, elementSqlTbl, this.elementCmd, fp.getMaxFetchDepth());
                    continue;
                }
                elementSqlTbl = elementStmt.getTable(this.elementInfo[i].getDatastoreClass(), elementStmt.getPrimaryTable().getGroupName());
                SQLStatementHelper.selectFetchPlanOfSourceClassInStatement(elementStmt, elementClsMapping, fp, elementSqlTbl, this.elementCmd, fp.getMaxFetchDepth());
                sqlStmt.union(elementStmt);
            }
        }
        if (sqlStmt == null) {
            throw new NucleusException("Error in generation of SQL statement for iterator over (Join) set. Statement is null");
        }
        if (addRestrictionOnOwner) {
            SQLTable ownerSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(sqlStmt, sqlStmt.getPrimaryTable(), this.ownerMapping);
            SQLExpression ownerExpr = exprFactory.newExpression(sqlStmt, ownerSqlTbl, this.ownerMapping);
            SQLExpression ownerVal = exprFactory.newLiteralParameter(sqlStmt, this.ownerMapping, null, "OWNER");
            sqlStmt.whereAnd(ownerExpr.eq(ownerVal), true);
        }
        if (this.relationDiscriminatorMapping != null) {
            SQLTable distSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(sqlStmt, sqlStmt.getPrimaryTable(), this.relationDiscriminatorMapping);
            SQLExpression distExpr = exprFactory.newExpression(sqlStmt, distSqlTbl, this.relationDiscriminatorMapping);
            SQLExpression distVal = exprFactory.newLiteral(sqlStmt, this.relationDiscriminatorMapping, this.relationDiscriminatorValue);
            sqlStmt.whereAnd(distExpr.eq(distVal), true);
        }
        if (this.orderMapping != null) {
            SQLTable orderSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(sqlStmt, sqlStmt.getPrimaryTable(), this.orderMapping);
            SQLExpression[] orderExprs = new SQLExpression[this.orderMapping.getNumberOfColumnMappings()];
            boolean[] descendingOrder = new boolean[this.orderMapping.getNumberOfColumnMappings()];
            orderExprs[0] = exprFactory.newExpression(sqlStmt, orderSqlTbl, this.orderMapping);
            sqlStmt.setOrdering(orderExprs, descendingOrder);
        }
        return new ElementIteratorStatement(this, sqlStmt, elementClsMapping);
    }
}

