/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.util.ArrayList;
import java.util.Collection;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.InheritanceStrategy;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.adapter.DatastoreAdapter;
import org.datanucleus.store.rdbms.mapping.java.DatastoreIdMapping;
import org.datanucleus.store.rdbms.mapping.java.InterfaceMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.java.PersistableMapping;
import org.datanucleus.store.rdbms.scostore.ComponentInfo;
import org.datanucleus.store.rdbms.table.DatastoreClass;
import org.datanucleus.store.types.scostore.Store;

public abstract class BaseContainerStore
implements Store {
    protected RDBMSStoreManager storeMgr;
    protected DatastoreAdapter dba;
    protected JavaTypeMapping ownerMapping;
    protected AbstractMemberMetaData ownerMemberMetaData;
    protected RelationType relationType;
    protected boolean allowNulls = false;
    protected ClassLoaderResolver clr;

    protected BaseContainerStore(RDBMSStoreManager storeMgr, ClassLoaderResolver clr) {
        this.storeMgr = storeMgr;
        this.dba = this.storeMgr.getDatastoreAdapter();
        this.clr = clr;
    }

    protected void setOwner(AbstractMemberMetaData mmd) {
        this.ownerMemberMetaData = mmd;
        if (Boolean.TRUE.equals(this.ownerMemberMetaData.getContainer().allowNulls())) {
            this.allowNulls = true;
        }
        this.relationType = this.ownerMemberMetaData.getRelationType(this.clr);
    }

    public RDBMSStoreManager getStoreManager() {
        return this.storeMgr;
    }

    public JavaTypeMapping getOwnerMapping() {
        return this.ownerMapping;
    }

    public RelationType getRelationType() {
        return this.relationType;
    }

    public AbstractMemberMetaData getOwnerMemberMetaData() {
        return this.ownerMemberMetaData;
    }

    public DatastoreAdapter getDatastoreAdapter() {
        return this.dba;
    }

    protected boolean isEmbeddedMapping(JavaTypeMapping mapping) {
        return !InterfaceMapping.class.isAssignableFrom(mapping.getClass()) && !DatastoreIdMapping.class.isAssignableFrom(mapping.getClass()) && !PersistableMapping.class.isAssignableFrom(mapping.getClass());
    }

    public DNStateManager getStateManagerForEmbeddedPCObject(DNStateManager sm, Object obj, AbstractMemberMetaData ownerMmd, short pcType) {
        ExecutionContext ec = sm.getExecutionContext();
        DNStateManager objOP = ec.findStateManager(obj);
        if (objOP == null) {
            objOP = ec.getNucleusContext().getStateManagerFactory().newForEmbedded(ec, obj, false, sm, ownerMmd.getAbsoluteFieldNumber());
        }
        objOP.setPcObjectType(pcType);
        return objOP;
    }

    protected boolean allowsBatching() {
        return this.storeMgr.allowsBatching();
    }

    protected ComponentInfo[] getComponentInformationForClass(String componentType, AbstractClassMetaData componentCmd) {
        DatastoreClass rootTbl;
        String[] clsNames;
        ComponentInfo[] info = null;
        if (this.clr.classForName(componentType).isInterface()) {
            clsNames = this.storeMgr.getNucleusContext().getMetaDataManager().getClassesImplementingInterface(componentType, this.clr);
            rootTbl = null;
        } else {
            clsNames = new String[]{componentType};
            rootTbl = this.storeMgr.getDatastoreClass(componentType, this.clr);
        }
        if (componentCmd.getBaseAbstractClassMetaData().getInheritanceMetaData().getStrategy() == InheritanceStrategy.COMPLETE_TABLE) {
            Collection elementSubclassNames;
            ArrayList<ComponentInfo> infos = new ArrayList<ComponentInfo>();
            if (rootTbl != null) {
                infos.add(new ComponentInfo(componentCmd, rootTbl));
            }
            if ((elementSubclassNames = this.storeMgr.getSubClassesForClass(componentCmd.getFullClassName(), true, this.clr)) != null) {
                for (String elementSubclassName : elementSubclassNames) {
                    AbstractClassMetaData elemSubCmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(elementSubclassName, this.clr);
                    DatastoreClass elemSubTbl = this.storeMgr.getDatastoreClass(elementSubclassName, this.clr);
                    if (elemSubTbl == null) continue;
                    infos.add(new ComponentInfo(elemSubCmd, elemSubTbl));
                }
            }
            info = new ComponentInfo[infos.size()];
            int infoNo = 0;
            for (ComponentInfo ci : infos) {
                info[infoNo++] = ci;
            }
        } else if (rootTbl == null) {
            if (this.clr.classForName(componentType).isInterface()) {
                info = new ComponentInfo[clsNames.length];
                for (int i = 0; i < clsNames.length; ++i) {
                    AbstractClassMetaData implCmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(clsNames[i], this.clr);
                    DatastoreClass table = this.storeMgr.getDatastoreClass(clsNames[i], this.clr);
                    info[i] = new ComponentInfo(implCmd, table);
                }
            } else {
                AbstractClassMetaData[] subclassCmds = this.storeMgr.getClassesManagingTableForClass(componentCmd, this.clr);
                info = new ComponentInfo[subclassCmds.length];
                for (int i = 0; i < subclassCmds.length; ++i) {
                    DatastoreClass table = this.storeMgr.getDatastoreClass(subclassCmds[i].getFullClassName(), this.clr);
                    info[i] = new ComponentInfo(subclassCmds[i], table);
                }
            }
        } else {
            info = new ComponentInfo[clsNames.length];
            for (int i = 0; i < clsNames.length; ++i) {
                AbstractClassMetaData cmd = this.storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForClass(clsNames[i], this.clr);
                DatastoreClass table = this.storeMgr.getDatastoreClass(cmd.getFullClassName(), this.clr);
                info[i] = new ComponentInfo(cmd, table);
            }
        }
        return info;
    }
}

