/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.valuegenerator;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.adapter.DatastoreAdapter;
import org.datanucleus.store.rdbms.identifier.DatastoreIdentifier;
import org.datanucleus.store.rdbms.identifier.IdentifierFactory;
import org.datanucleus.store.valuegenerator.AbstractConnectedGenerator;
import org.datanucleus.store.valuegenerator.ValueGenerationBlock;
import org.datanucleus.store.valuegenerator.ValueGenerationException;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public final class SequenceGenerator
extends AbstractConnectedGenerator<Long> {
    protected ManagedConnection connection;
    protected boolean repositoryExists = false;
    protected String sequenceName = null;

    public SequenceGenerator(StoreManager storeMgr, String name, Properties props) {
        super(storeMgr, name, props);
        this.allocationSize = 1;
        if (this.properties != null) {
            if (this.properties.containsKey("key-cache-size")) {
                try {
                    this.allocationSize = Integer.parseInt((String)this.properties.get("key-cache-size"));
                }
                catch (Exception e) {
                    throw new ValueGenerationException(Localiser.msg((String)"040006", (Object[])new Object[]{this.properties.get("key-cache-size")}));
                }
            }
            if (!this.properties.containsKey("sequence-name")) {
                throw new ValueGenerationException(Localiser.msg((String)"040007", (Object[])new Object[]{this.properties.get("sequence-name")}));
            }
        }
        String inputSeqCatalogName = null;
        String inputSeqSchemaName = null;
        String inputSeqName = null;
        if (this.properties != null) {
            inputSeqCatalogName = this.properties.getProperty("sequence-catalog-name");
            if (inputSeqCatalogName == null) {
                inputSeqCatalogName = this.properties.getProperty("catalog-name");
            }
            if ((inputSeqSchemaName = this.properties.getProperty("sequence-schema-name")) == null) {
                inputSeqSchemaName = this.properties.getProperty("schema-name");
            }
            inputSeqName = this.properties.getProperty("sequence-name");
        }
        RDBMSStoreManager rdbmsMgr = (RDBMSStoreManager)storeMgr;
        DatastoreAdapter dba = rdbmsMgr.getDatastoreAdapter();
        DatastoreIdentifier identifier = rdbmsMgr.getIdentifierFactory().newSequenceIdentifier(inputSeqName);
        if (dba.supportsOption("CatalogInTableDefinition") && inputSeqCatalogName != null) {
            identifier.setCatalogName(inputSeqCatalogName);
        }
        if (dba.supportsOption("SchemaInTableDefinition") && inputSeqSchemaName != null) {
            identifier.setSchemaName(inputSeqSchemaName);
        }
        this.sequenceName = identifier.getFullyQualifiedName(true);
    }

    public static Class getStorageClass() {
        return Long.class;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized ValueGenerationBlock<Long> reserveBlock(long size) {
        ValueGenerationBlock valueGenerationBlock;
        if (size < 1L) {
            return null;
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<Long> oid = new ArrayList<Long>();
        RDBMSStoreManager srm = (RDBMSStoreManager)this.storeMgr;
        SQLController sqlControl = srm.getSQLController();
        try {
            DatastoreAdapter dba = srm.getDatastoreAdapter();
            String stmt = dba.getSequenceNextStmt(this.sequenceName);
            ps = sqlControl.getStatementForQuery(this.connection, stmt);
            rs = sqlControl.executeStatementQuery(null, this.connection, stmt, ps);
            Long nextId = 0L;
            if (rs.next()) {
                nextId = rs.getLong(1);
                oid.add(nextId);
            }
            int i = 1;
            while ((long)i < size) {
                nextId = nextId + 1L;
                oid.add(nextId);
                ++i;
            }
            if (NucleusLogger.VALUEGENERATION.isDebugEnabled()) {
                NucleusLogger.VALUEGENERATION.debug((Object)Localiser.msg((String)"040004", (Object[])new Object[]{"" + size}));
            }
            valueGenerationBlock = new ValueGenerationBlock(oid);
        }
        catch (SQLException e) {
            try {
                throw new ValueGenerationException(Localiser.msg((String)"061001", (Object[])new Object[]{e.getMessage()}), (Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (ps == null) throw throwable;
                    sqlControl.closeStatement(this.connection, ps);
                    throw throwable;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            if (rs != null) {
                rs.close();
            }
            if (ps == null) return valueGenerationBlock;
            sqlControl.closeStatement(this.connection, ps);
            return valueGenerationBlock;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return valueGenerationBlock;
    }

    protected boolean repositoryExists() {
        String sequenceSchemaName;
        String sequenceCatalogName = this.properties.getProperty("sequence-catalog-name");
        if (sequenceCatalogName == null) {
            sequenceCatalogName = this.properties.getProperty("catalog-name");
        }
        if (!StringUtils.isWhitespace((String)sequenceCatalogName)) {
            IdentifierFactory idFactory = ((RDBMSStoreManager)this.storeMgr).getIdentifierFactory();
            sequenceCatalogName = idFactory.getIdentifierInAdapterCase(sequenceCatalogName);
        }
        if ((sequenceSchemaName = this.properties.getProperty("sequence-schema-name")) == null) {
            sequenceSchemaName = this.properties.getProperty("schema-name");
        }
        if (!StringUtils.isWhitespace((String)sequenceSchemaName)) {
            IdentifierFactory idFactory = ((RDBMSStoreManager)this.storeMgr).getIdentifierFactory();
            sequenceSchemaName = idFactory.getIdentifierInAdapterCase(sequenceSchemaName);
        }
        String seqName = this.properties.getProperty("sequence-name");
        IdentifierFactory idFactory = ((RDBMSStoreManager)this.storeMgr).getIdentifierFactory();
        seqName = idFactory.getIdentifierInAdapterCase(seqName);
        return ((RDBMSStoreManager)this.storeMgr).getDatastoreAdapter().sequenceExists((Connection)this.connection.getConnection(), sequenceCatalogName, sequenceSchemaName, seqName);
    }

    protected boolean createRepository() {
        PreparedStatement ps = null;
        RDBMSStoreManager srm = (RDBMSStoreManager)this.storeMgr;
        DatastoreAdapter dba = srm.getDatastoreAdapter();
        SQLController sqlControl = srm.getSQLController();
        if (!srm.getSchemaHandler().isAutoCreateTables()) {
            throw new NucleusUserException(Localiser.msg((String)"040010", (Object[])new Object[]{this.sequenceName}));
        }
        Integer min = this.properties.containsKey("key-min-value") ? Integer.valueOf(this.properties.getProperty("key-min-value")) : null;
        Integer max = this.properties.containsKey("key-max-value") ? Integer.valueOf(this.properties.getProperty("key-max-value")) : null;
        Integer start = this.properties.containsKey("key-initial-value") ? Integer.valueOf(this.properties.getProperty("key-initial-value")) : null;
        Integer incr = this.properties.containsKey("key-cache-size") ? Integer.valueOf(this.properties.getProperty("key-cache-size")) : null;
        Integer cacheSize = this.properties.containsKey("key-database-cache-size") ? Integer.valueOf(this.properties.getProperty("key-database-cache-size")) : null;
        String stmt = dba.getSequenceCreateStmt(this.sequenceName, min, max, start, incr, cacheSize);
        try {
            ps = sqlControl.getStatementForUpdate(this.connection, stmt, false);
            sqlControl.executeStatementUpdate(null, this.connection, stmt, ps, true);
        }
        catch (SQLException e) {
            NucleusLogger.DATASTORE.error((Object)e);
            throw new ValueGenerationException(Localiser.msg((String)"061000", (Object[])new Object[]{e.getMessage()}) + stmt);
        }
        finally {
            try {
                if (ps != null) {
                    sqlControl.closeStatement(this.connection, ps);
                }
            }
            catch (SQLException sQLException) {}
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ValueGenerationBlock<Long> obtainGenerationBlock(int number) {
        boolean repository_exists;
        ValueGenerationBlock<Long> block;
        block17: {
            block = null;
            repository_exists = true;
            try {
                this.connection = this.connectionProvider.retrieveConnection();
                if (!this.repositoryExists) {
                    this.repositoryExists = this.repositoryExists();
                    if (!this.repositoryExists) {
                        this.createRepository();
                        this.repositoryExists = true;
                    }
                }
                try {
                    if (number < 0) {
                        block = this.reserveBlock();
                        break block17;
                    }
                    block = this.reserveBlock(number);
                }
                catch (ValueGenerationException vge) {
                    NucleusLogger.VALUEGENERATION.info((Object)Localiser.msg((String)"040003", (Object[])new Object[]{vge.getMessage()}));
                    if (NucleusLogger.VALUEGENERATION.isDebugEnabled()) {
                        NucleusLogger.VALUEGENERATION.debug((Object)"Caught exception", (Throwable)vge);
                    }
                    repository_exists = false;
                }
                catch (RuntimeException ex) {
                    NucleusLogger.VALUEGENERATION.info((Object)Localiser.msg((String)"040003", (Object[])new Object[]{ex.getMessage()}));
                    if (NucleusLogger.VALUEGENERATION.isDebugEnabled()) {
                        NucleusLogger.VALUEGENERATION.debug((Object)"Caught exception", (Throwable)ex);
                    }
                    repository_exists = false;
                }
            }
            finally {
                if (this.connection != null) {
                    this.connectionProvider.releaseConnection();
                    this.connection = null;
                }
            }
        }
        if (!repository_exists) {
            try {
                this.connection = this.connectionProvider.retrieveConnection();
                NucleusLogger.VALUEGENERATION.info((Object)Localiser.msg((String)"040005"));
                if (!this.createRepository()) {
                    throw new ValueGenerationException(Localiser.msg((String)"040002"));
                }
                block = number < 0 ? this.reserveBlock() : this.reserveBlock(number);
            }
            finally {
                this.connectionProvider.releaseConnection();
                this.connection = null;
            }
        }
        return block;
    }
}

