/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.adapter;

import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.DatastoreId;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.store.rdbms.adapter.BaseDatastoreAdapter;
import org.datanucleus.store.rdbms.identifier.IdentifierFactory;
import org.datanucleus.store.rdbms.key.CandidateKey;
import org.datanucleus.store.rdbms.key.ForeignKey;
import org.datanucleus.store.rdbms.key.PrimaryKey;
import org.datanucleus.store.rdbms.mapping.datastore.BigIntRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.BinaryStreamRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.BitRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.BlobRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.BooleanRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.CharRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.ClobRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.DateRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.DecimalRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.DoubleRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.FloatRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.IntegerRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.LongVarBinaryRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.LongVarcharRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.NCharRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.NVarcharRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.NumericRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.RealRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.SmallIntRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.TimeRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.TimestampRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.TinyIntRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.VarBinaryRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.VarCharRDBMSMapping;
import org.datanucleus.store.rdbms.schema.RDBMSColumnInfo;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.SQLText;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.store.rdbms.table.TableImpl;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.StringUtils;

public class SQLAnywhereAdapter
extends BaseDatastoreAdapter {
    protected int datastoreBuildVersion = -1;
    protected int driverBuildVersion = -1;
    protected boolean usingjConnect = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLAnywhereAdapter(DatabaseMetaData metadata) {
        super(metadata);
        try {
            this.datastoreBuildVersion = Integer.parseInt(this.datastoreProductVersion.substring(this.datastoreProductVersion.lastIndexOf(".") + 1));
            if (this.driverName.equals("SQL Anywhere JDBC Driver")) {
                this.usingjConnect = false;
                this.driverBuildVersion = Integer.parseInt(this.driverVersion.substring(this.driverVersion.lastIndexOf(".") + 1));
            } else {
                this.driverBuildVersion = -1;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = metadata.getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery("SELECT \"reserved_word\" FROM sa_reserved_words() ORDER BY \"reserved_word\"");
            while (rs.next()) {
                this.reservedKeywords.add(rs.getString(1).trim().toUpperCase());
            }
            rs.close();
            rs = stmt.executeQuery("SELECT \"option\", \"setting\" FROM SYS.SYSOPTION WHERE \"option\" = 'reserved_keywords' or \"option\" = 'non_keywords'");
            while (rs.next()) {
                if (rs.getString(1).toLowerCase().equals("reserved_keywords")) {
                    String originalUserKeywords = rs.getString(2).trim().toUpperCase();
                    StringTokenizer tokens = new StringTokenizer(originalUserKeywords, ",");
                    HashSet<String> userReservedWordSet = new HashSet<String>();
                    while (tokens.hasMoreTokens()) {
                        userReservedWordSet.add(tokens.nextToken().trim().toUpperCase());
                    }
                    if (!userReservedWordSet.contains("LIMIT")) {
                        userReservedWordSet.add("LIMIT");
                        try (Statement setOptionStmt = null;){
                            setOptionStmt = conn.createStatement();
                            setOptionStmt.executeUpdate("SET OPTION PUBLIC.reserved_keywords = 'LIMIT" + (originalUserKeywords.length() != 0 ? "," : "") + originalUserKeywords + "'");
                        }
                    }
                    this.reservedKeywords.addAll(userReservedWordSet);
                    continue;
                }
                if (!rs.getString(1).toLowerCase().equals("non_keywords")) continue;
                this.reservedKeywords.removeAll(StringUtils.convertCommaSeparatedStringToSet((String)rs.getString(2).trim().toUpperCase()));
            }
            rs.close();
            stmt.close();
        }
        catch (Throwable sqle) {
        }
        finally {
            try {
                if (rs != null && !rs.isClosed()) {
                    rs.close();
                }
            }
            catch (SQLException sqle) {
                rs = null;
            }
            try {
                if (stmt != null && !stmt.isClosed()) {
                    stmt.close();
                }
            }
            catch (SQLException sqle) {
                stmt = null;
            }
            try {
                if (conn != null && !conn.isClosed()) {
                    conn.close();
                }
            }
            catch (SQLException sqle) {
                conn = null;
            }
        }
        this.supportedOptions.add("IdentityColumns");
        this.supportedOptions.add("StoredProcs");
        if (this.datastoreMajorVersion >= 12) {
            this.supportedOptions.add("Sequences");
        }
        this.supportedOptions.add("ProjectionInTableReferenceJoins");
        this.supportedOptions.add("AnalysisMethods");
        this.supportedOptions.add("CatalogInTableDefinition");
        this.supportedOptions.add("SchemaInTableDefinition");
        this.supportedOptions.add("LowerCaseIdentifiers");
        this.supportedOptions.add("MixedCaseIdentifiers");
        this.supportedOptions.add("UpperCaseIdentifiers");
        this.supportedOptions.add("LowerCaseQuotedIdentifiers");
        this.supportedOptions.add("MixedCaseQuotedIdentifiers");
        this.supportedOptions.add("UpperCaseQuotedIdentifiers");
        this.supportedOptions.add("AlterTableDropForeignKey_Syntax");
        this.supportedOptions.add("StatementBatching");
        this.supportedOptions.add("PrimaryKeyInCreateStatements");
        this.supportedOptions.add("AutoIncrementPkInCreateTableColumnDef");
        this.supportedOptions.add("LockWithSelectForUpdate");
        this.supportedOptions.add("LockOptionAfterFromClause");
        this.supportedOptions.add("BitwiseAndOperator");
        this.supportedOptions.add("BitwiseOrOperator");
        this.supportedOptions.add("BitwiseXOrOperator");
        this.supportedOptions.remove("GetGeneratedKeysStatement");
        this.supportedOptions.remove("DeferredConstraints");
        this.supportedOptions.remove("ANSI_Join_Syntax");
        this.supportedOptions.remove("ANSI_CrossJoin_Syntax");
        this.supportedOptions.remove("AutoIncrementNullSpecification");
        this.supportedOptions.remove("BooleanExpression");
        this.supportedJdbcTypesById.clear();
        this.supportedJdbcTypesById.put(-5, "BIGINT");
        this.supportedJdbcTypesById.put(-2, "BINARY");
        this.supportedJdbcTypesById.put(-7, "BIT");
        this.supportedJdbcTypesById.put(2004, "LONG BINARY");
        this.supportedJdbcTypesById.put(16, "BIT");
        this.supportedJdbcTypesById.put(1, "CHAR");
        this.supportedJdbcTypesById.put(2005, "LONG VARCHAR");
        this.supportedJdbcTypesById.put(91, "DATE");
        this.supportedJdbcTypesById.put(3, "DECIMAL");
        this.supportedJdbcTypesById.put(8, "DOUBLE");
        this.supportedJdbcTypesById.put(6, "FLOAT");
        this.supportedJdbcTypesById.put(4, "INTEGER");
        this.supportedJdbcTypesById.put(-4, "LONG BINARY");
        this.supportedJdbcTypesById.put(-1, "LONG VARCHAR");
        this.supportedJdbcTypesById.put(2, "NUMERIC");
        this.supportedJdbcTypesById.put(7, "REAL");
        this.supportedJdbcTypesById.put(5, "SMALLINT");
        this.supportedJdbcTypesById.put(2009, "XML");
        this.supportedJdbcTypesById.put(92, "TIME");
        this.supportedJdbcTypesById.put(93, "TIMESTAMP");
        this.supportedJdbcTypesById.put(-6, "TINYINT");
        this.supportedJdbcTypesById.put(-3, "BINARY");
        this.supportedJdbcTypesById.put(12, "VARCHAR");
        this.supportedJdbcTypesById.put(-9, "NVARCHAR");
        this.supportedJdbcTypesById.put(-15, "NCHAR");
        this.supportedJdbcTypesById.put(2011, "LONG NVARCHAR");
        this.supportedJdbcTypesById.put(1111, "OTHER");
        this.unsupportedJdbcTypesById.clear();
        this.unsupportedJdbcTypesById.put(2003, "ARRAY");
        this.unsupportedJdbcTypesById.put(70, "DATALINK");
        this.unsupportedJdbcTypesById.put(2001, "DISTINCT");
        this.unsupportedJdbcTypesById.put(2000, "JAVA_OBJECT");
        this.unsupportedJdbcTypesById.put(0, "NULL");
        this.unsupportedJdbcTypesById.put(2006, "REF");
        this.unsupportedJdbcTypesById.put(2002, "STRUCT");
    }

    @Override
    public String getAddCandidateKeyStatement(CandidateKey ck, IdentifierFactory factory) {
        return super.getAddCandidateKeyStatement(ck, factory);
    }

    @Override
    public String getVendorID() {
        return "sqlanywhere";
    }

    @Override
    public String getCreateDatabaseStatement(String catalogName, String schemaName) {
        throw new UnsupportedOperationException("SQL Anywhere does not support CREATE DATABASE via a schema name");
    }

    @Override
    public String getDropDatabaseStatement(String catalogName, String schemaName) {
        throw new UnsupportedOperationException("SQL Anywhere does not support DROP DATABASE via a schema name");
    }

    @Override
    public String getCreateTableStatement(TableImpl table, Column[] columns, Properties props, IdentifierFactory factory) {
        PrimaryKey pk;
        StringBuilder createStmt = new StringBuilder();
        String indent = "    ";
        if (this.getContinuationString().length() == 0) {
            indent = "";
        }
        createStmt.append("CREATE TABLE ").append(table.toString()).append(this.getContinuationString()).append("(").append(this.getContinuationString());
        for (int i = 0; i < columns.length; ++i) {
            if (i > 0) {
                createStmt.append(",").append(this.getContinuationString());
            }
            createStmt.append(indent).append(columns[i].getSQLDefinition());
        }
        if (this.supportsOption("PrimaryKeyInCreateStatements") && (pk = table.getPrimaryKey()) != null && pk.size() > 0) {
            boolean includePk = true;
            if (this.supportsOption("AutoIncrementPkInCreateTableColumnDef")) {
                for (Column pkCol : pk.getColumns()) {
                    if (!pkCol.isIdentity()) continue;
                    includePk = false;
                    break;
                }
            }
            if (includePk) {
                createStmt.append(",").append(this.getContinuationString());
                if (pk.getName() != null) {
                    String identifier = factory.getIdentifierInAdapterCase(pk.getName());
                    createStmt.append(indent).append("CONSTRAINT ").append(identifier).append(" ").append(pk.toString());
                } else {
                    createStmt.append(indent).append(pk.toString());
                }
            }
        }
        if (this.supportsOption("UniqueInEndCreateStatements")) {
            StringBuilder uniqueConstraintStmt = new StringBuilder();
            for (int i = 0; i < columns.length; ++i) {
                if (!columns[i].isUnique()) continue;
                if (uniqueConstraintStmt.length() < 1) {
                    uniqueConstraintStmt.append(",").append(this.getContinuationString());
                    uniqueConstraintStmt.append(indent).append(" UNIQUE (");
                } else {
                    uniqueConstraintStmt.append(",");
                }
                uniqueConstraintStmt.append(columns[i].getIdentifier().toString());
            }
            if (uniqueConstraintStmt.length() > 1) {
                uniqueConstraintStmt.append(")");
                createStmt.append(uniqueConstraintStmt.toString());
            }
        }
        if (this.supportsOption("FKInEndCreateStatements")) {
            StringBuilder fkConstraintStmt = new StringBuilder();
            ClassLoaderResolver clr = table.getStoreManager().getNucleusContext().getClassLoaderResolver(null);
            List<ForeignKey> fks = table.getExpectedForeignKeys(clr);
            if (fks != null && !fks.isEmpty()) {
                for (ForeignKey fk : fks) {
                    createStmt.append(",").append(this.getContinuationString());
                    if (fk.getName() != null) {
                        String identifier = factory.getIdentifierInAdapterCase(fk.getName());
                        createStmt.append(indent).append("CONSTRAINT ").append(identifier).append(" ").append(fk.toString());
                        continue;
                    }
                    createStmt.append(indent).append(fk.toString());
                }
            }
            if (fkConstraintStmt.length() > 1) {
                createStmt.append(fkConstraintStmt.toString());
            }
        }
        if (this.supportsOption("CheckInEndCreateStatements")) {
            StringBuilder checkConstraintStmt = new StringBuilder();
            for (int i = 0; i < columns.length; ++i) {
                if (columns[i].getCheckConstraints() == null) continue;
                checkConstraintStmt.append(",").append(this.getContinuationString());
                checkConstraintStmt.append(indent).append(columns[i].getCheckConstraints());
            }
            if (checkConstraintStmt.length() > 1) {
                createStmt.append(checkConstraintStmt.toString());
            }
        }
        createStmt.append(this.getContinuationString()).append(")");
        return createStmt.toString();
    }

    @Override
    public String getDropTableStatement(Table table) {
        return "DROP TABLE " + table.toString();
    }

    @Override
    public String getSelectWithLockOption() {
        return "XLOCK";
    }

    @Override
    public String getDeleteTableStatement(SQLTable tbl) {
        return "DELETE " + tbl.getAlias() + " FROM " + tbl.toString();
    }

    @Override
    public String getAddPrimaryKeyStatement(PrimaryKey pk, IdentifierFactory factory) {
        return null;
    }

    @Override
    public String getAddForeignKeyStatement(ForeignKey fk, IdentifierFactory factory) {
        return null;
    }

    @Override
    public SQLText getUpdateTableStatement(SQLTable tbl, SQLText setSQL) {
        SQLText sql = new SQLText("UPDATE ").append(tbl.getAlias().toString());
        sql.append(" ").append(setSQL);
        sql.append(" FROM ").append(tbl.toString());
        return sql;
    }

    @Override
    public SQLTypeInfo newSQLTypeInfo(ResultSet rs) {
        SQLTypeInfo info = new SQLTypeInfo(rs);
        if (info.getTypeName().toLowerCase().startsWith("tinyint")) {
            return null;
        }
        return info;
    }

    @Override
    public RDBMSColumnInfo newRDBMSColumnInfo(ResultSet rs) {
        RDBMSColumnInfo info = new RDBMSColumnInfo(rs);
        short dataType = info.getDataType();
        switch (dataType) {
            case 91: 
            case 92: 
            case 93: {
                info.setDecimalDigits(0);
                break;
            }
        }
        return info;
    }

    @Override
    public String getAutoIncrementStmt(Table table, String columnName) {
        return "SELECT @@IDENTITY";
    }

    @Override
    public String getAutoIncrementKeyword() {
        return "NOT NULL DEFAULT AUTOINCREMENT";
    }

    @Override
    public String getSequenceCreateStmt(String sequence_name, Integer min, Integer max, Integer start, Integer increment, Integer cache_size) {
        if (sequence_name == null) {
            throw new NucleusUserException(Localiser.msg((String)"051028"));
        }
        StringBuilder stmt = new StringBuilder("CREATE SEQUENCE ");
        stmt.append(sequence_name);
        if (min != null) {
            stmt.append(" MINVALUE " + min);
        }
        if (max != null) {
            stmt.append(" MAXVALUE " + max);
        }
        if (start != null) {
            stmt.append(" START WITH " + start);
        }
        if (increment != null) {
            stmt.append(" INCREMENT BY " + increment);
        }
        if (cache_size != null) {
            stmt.append(" CACHE " + cache_size);
        } else {
            stmt.append(" NO CACHE");
        }
        return stmt.toString();
    }

    @Override
    public boolean sequenceExists(Connection conn, String catalogName, String schemaName, String seqName) {
        try {
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT 1 FROM SYS.SYSSEQUENCE WHERE SEQUENCENAME = '" + seqName + "'");
            boolean sequenceFound = rs.next();
            rs.close();
            stmt.close();
            return sequenceFound;
        }
        catch (Throwable t) {
            return false;
        }
    }

    @Override
    public String getSequenceNextStmt(String sequence_name) {
        if (sequence_name == null) {
            throw new NucleusUserException(Localiser.msg((String)"051028"));
        }
        StringBuilder stmt = new StringBuilder("SELECT ");
        stmt.append(sequence_name);
        stmt.append(".nextval");
        return stmt.toString();
    }

    @Override
    public String getSelectNewUUIDStmt() {
        return "SELECT newid()";
    }

    @Override
    public String getRangeByLimitEndOfStatementClause(long offset, long count, boolean hasOrdering) {
        if (offset >= 0L && count > 0L) {
            return "LIMIT " + offset + "," + count + " ";
        }
        if (offset <= 0L && count > 0L) {
            return "LIMIT " + count + " ";
        }
        if (offset >= 0L && count < 0L) {
            return "LIMIT " + offset + "," + Long.MAX_VALUE + " ";
        }
        return "";
    }

    @Override
    protected void loadDatastoreMappings(PluginManager mgr, ClassLoaderResolver clr) {
        this.registerDatastoreMapping(Boolean.class.getName(), BitRDBMSMapping.class, JDBCType.BIT, "BIT", true);
        this.registerDatastoreMapping(Boolean.class.getName(), CharRDBMSMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerDatastoreMapping(Boolean.class.getName(), BitRDBMSMapping.class, JDBCType.BOOLEAN, "BIT", true);
        this.registerDatastoreMapping(Boolean.class.getName(), BooleanRDBMSMapping.class, JDBCType.TINYINT, "TINYINT", false);
        this.registerDatastoreMapping(Boolean.class.getName(), SmallIntRDBMSMapping.class, JDBCType.SMALLINT, "SMALLINT", false);
        this.registerDatastoreMapping(Byte.class.getName(), TinyIntRDBMSMapping.class, JDBCType.TINYINT, "TINYINT", true);
        this.registerDatastoreMapping(Byte.class.getName(), SmallIntRDBMSMapping.class, JDBCType.SMALLINT, "SMALLINT", false);
        this.registerDatastoreMapping(Character.class.getName(), CharRDBMSMapping.class, JDBCType.CHAR, "CHAR", true);
        this.registerDatastoreMapping(Character.class.getName(), IntegerRDBMSMapping.class, JDBCType.INTEGER, "INTEGER", false);
        this.registerDatastoreMapping(Double.class.getName(), DoubleRDBMSMapping.class, JDBCType.DOUBLE, "DOUBLE", true);
        this.registerDatastoreMapping(Double.class.getName(), DecimalRDBMSMapping.class, JDBCType.DECIMAL, "DECIMAL", false);
        this.registerDatastoreMapping(Float.class.getName(), FloatRDBMSMapping.class, JDBCType.FLOAT, "FLOAT", true);
        this.registerDatastoreMapping(Float.class.getName(), DoubleRDBMSMapping.class, JDBCType.DOUBLE, "DOUBLE", false);
        this.registerDatastoreMapping(Float.class.getName(), RealRDBMSMapping.class, JDBCType.REAL, "REAL", false);
        this.registerDatastoreMapping(Float.class.getName(), DecimalRDBMSMapping.class, JDBCType.DECIMAL, "DECIMAL", false);
        this.registerDatastoreMapping(Integer.class.getName(), IntegerRDBMSMapping.class, JDBCType.INTEGER, "INTEGER", true);
        this.registerDatastoreMapping(Integer.class.getName(), BigIntRDBMSMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerDatastoreMapping(Integer.class.getName(), NumericRDBMSMapping.class, JDBCType.NUMERIC, "NUMERIC", false);
        this.registerDatastoreMapping(Integer.class.getName(), TinyIntRDBMSMapping.class, JDBCType.TINYINT, "TINYINT", false);
        this.registerDatastoreMapping(Integer.class.getName(), SmallIntRDBMSMapping.class, JDBCType.SMALLINT, "SMALLINT", false);
        this.registerDatastoreMapping(Integer.class.getName(), BigIntRDBMSMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerDatastoreMapping(Long.class.getName(), BigIntRDBMSMapping.class, JDBCType.BIGINT, "BIGINT", true);
        this.registerDatastoreMapping(Long.class.getName(), IntegerRDBMSMapping.class, JDBCType.INTEGER, "INT", false);
        this.registerDatastoreMapping(Long.class.getName(), NumericRDBMSMapping.class, JDBCType.NUMERIC, "NUMERIC", false);
        this.registerDatastoreMapping(Long.class.getName(), TinyIntRDBMSMapping.class, JDBCType.TINYINT, "TINYINT", false);
        this.registerDatastoreMapping(Long.class.getName(), SmallIntRDBMSMapping.class, JDBCType.SMALLINT, "SMALLINT", false);
        this.registerDatastoreMapping(Short.class.getName(), SmallIntRDBMSMapping.class, JDBCType.SMALLINT, "SMALLINT", true);
        this.registerDatastoreMapping(Short.class.getName(), IntegerRDBMSMapping.class, JDBCType.INTEGER, "INTEGER", false);
        this.registerDatastoreMapping(Short.class.getName(), TinyIntRDBMSMapping.class, JDBCType.TINYINT, "TINYINT", false);
        this.registerDatastoreMapping(String.class.getName(), VarCharRDBMSMapping.class, JDBCType.VARCHAR, "VARCHAR", true);
        this.registerDatastoreMapping(String.class.getName(), CharRDBMSMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerDatastoreMapping(String.class.getName(), BigIntRDBMSMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerDatastoreMapping(String.class.getName(), LongVarcharRDBMSMapping.class, JDBCType.LONGVARCHAR, "LONGVARCHAR", false);
        this.registerDatastoreMapping(String.class.getName(), ClobRDBMSMapping.class, JDBCType.CLOB, "CLOB", false);
        this.registerDatastoreMapping(String.class.getName(), BlobRDBMSMapping.class, JDBCType.BLOB, "BLOB", false);
        this.registerDatastoreMapping(String.class.getName(), NVarcharRDBMSMapping.class, JDBCType.NVARCHAR, "NVARCHAR", false);
        this.registerDatastoreMapping(String.class.getName(), NCharRDBMSMapping.class, JDBCType.NCHAR, "NCHAR", false);
        this.registerDatastoreMapping(BigDecimal.class.getName(), DecimalRDBMSMapping.class, JDBCType.DECIMAL, "DECIMAL", true);
        this.registerDatastoreMapping(BigDecimal.class.getName(), NumericRDBMSMapping.class, JDBCType.NUMERIC, "NUMERIC", false);
        this.registerDatastoreMapping(BigInteger.class.getName(), NumericRDBMSMapping.class, JDBCType.NUMERIC, "NUMERIC", true);
        this.registerDatastoreMapping(Date.class.getName(), DateRDBMSMapping.class, JDBCType.DATE, "DATE", true);
        this.registerDatastoreMapping(Date.class.getName(), TimestampRDBMSMapping.class, JDBCType.TIMESTAMP, "TIMESTAMP", false);
        this.registerDatastoreMapping(Date.class.getName(), CharRDBMSMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerDatastoreMapping(Date.class.getName(), VarCharRDBMSMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        this.registerDatastoreMapping(Date.class.getName(), BigIntRDBMSMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerDatastoreMapping(Time.class.getName(), TimeRDBMSMapping.class, JDBCType.TIME, "TIME", true);
        this.registerDatastoreMapping(Time.class.getName(), TimestampRDBMSMapping.class, JDBCType.TIMESTAMP, "TIMESTAMP", false);
        this.registerDatastoreMapping(Time.class.getName(), CharRDBMSMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerDatastoreMapping(Time.class.getName(), VarCharRDBMSMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        this.registerDatastoreMapping(Time.class.getName(), BigIntRDBMSMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerDatastoreMapping(Timestamp.class.getName(), TimestampRDBMSMapping.class, JDBCType.TIMESTAMP, "TIMESTAMP", true);
        this.registerDatastoreMapping(Timestamp.class.getName(), CharRDBMSMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerDatastoreMapping(Timestamp.class.getName(), VarCharRDBMSMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        this.registerDatastoreMapping(Timestamp.class.getName(), DateRDBMSMapping.class, JDBCType.DATE, "DATE", false);
        this.registerDatastoreMapping(Timestamp.class.getName(), TimeRDBMSMapping.class, JDBCType.TIME, "TIME", false);
        this.registerDatastoreMapping(java.util.Date.class.getName(), TimestampRDBMSMapping.class, JDBCType.TIMESTAMP, "TIMESTAMP", true);
        this.registerDatastoreMapping(java.util.Date.class.getName(), DateRDBMSMapping.class, JDBCType.DATE, "DATE", false);
        this.registerDatastoreMapping(java.util.Date.class.getName(), CharRDBMSMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerDatastoreMapping(java.util.Date.class.getName(), VarCharRDBMSMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        this.registerDatastoreMapping(java.util.Date.class.getName(), TimeRDBMSMapping.class, JDBCType.TIME, "TIME", false);
        this.registerDatastoreMapping(java.util.Date.class.getName(), BigIntRDBMSMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerDatastoreMapping(Serializable.class.getName(), LongVarBinaryRDBMSMapping.class, JDBCType.LONGVARBINARY, "LONGVARBINARY", true);
        this.registerDatastoreMapping(Serializable.class.getName(), BlobRDBMSMapping.class, JDBCType.BLOB, "BLOB", false);
        this.registerDatastoreMapping(Serializable.class.getName(), VarBinaryRDBMSMapping.class, JDBCType.VARBINARY, "VARBINARY", false);
        this.registerDatastoreMapping(byte[].class.getName(), LongVarBinaryRDBMSMapping.class, JDBCType.LONGVARBINARY, "LONGVARBINARY", true);
        this.registerDatastoreMapping(byte[].class.getName(), BlobRDBMSMapping.class, JDBCType.BLOB, "BLOB", false);
        this.registerDatastoreMapping(byte[].class.getName(), VarBinaryRDBMSMapping.class, JDBCType.VARBINARY, "VARBINARY", false);
        this.registerDatastoreMapping(File.class.getName(), BinaryStreamRDBMSMapping.class, JDBCType.LONGVARBINARY, "LONGVARBINARY", true);
        this.registerDatastoreMapping(DatastoreId.class.getName(), BigIntRDBMSMapping.class, JDBCType.BIGINT, "BIGINT", true);
        this.registerDatastoreMapping(DatastoreId.class.getName(), IntegerRDBMSMapping.class, JDBCType.INTEGER, "INTEGER", false);
        this.registerDatastoreMapping(DatastoreId.class.getName(), NumericRDBMSMapping.class, JDBCType.NUMERIC, "NUMERIC", false);
        this.registerDatastoreMapping(DatastoreId.class.getName(), CharRDBMSMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerDatastoreMapping(DatastoreId.class.getName(), VarCharRDBMSMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        super.loadDatastoreMappings(mgr, clr);
    }
}

