/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.java;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.FieldRole;
import org.datanucleus.metadata.InheritanceMetaData;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.rdbms.mapping.MappingManager;
import org.datanucleus.store.rdbms.mapping.datastore.DatastoreMapping;
import org.datanucleus.store.rdbms.mapping.java.AbstractContainerMapping;
import org.datanucleus.store.rdbms.mapping.java.BigIntegerMapping;
import org.datanucleus.store.rdbms.mapping.java.DiscriminatorMapping;
import org.datanucleus.store.rdbms.mapping.java.EmbeddedPCMapping;
import org.datanucleus.store.rdbms.mapping.java.IntegerMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.java.LongMapping;
import org.datanucleus.store.rdbms.mapping.java.ShortMapping;
import org.datanucleus.store.rdbms.mapping.java.SingleFieldMapping;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public abstract class EmbeddedMapping
extends SingleFieldMapping {
    protected DiscriminatorMetaData discrimMetaData;
    protected DiscriminatorMapping discrimMapping;
    protected List<JavaTypeMapping> javaTypeMappings;
    protected ClassLoaderResolver clr;
    protected EmbeddedMetaData emd;
    protected String typeName;
    protected short objectType = (short)-1;
    protected AbstractClassMetaData embCmd = null;

    @Override
    public void initialize(AbstractMemberMetaData mmd, Table table, ClassLoaderResolver clr) {
        throw new NucleusException("subclass must override this method").setFatal();
    }

    public void initialize(AbstractMemberMetaData mmd, Table table, ClassLoaderResolver clr, EmbeddedMetaData emd, String typeName, int objectType) {
        int i;
        super.initialize(mmd, table, clr);
        this.clr = clr;
        this.emd = emd;
        this.typeName = typeName;
        this.objectType = (short)objectType;
        MetaDataManager mmgr = table.getStoreManager().getMetaDataManager();
        AbstractClassMetaData rootEmbCmd = mmgr.getMetaDataForClass(typeName, clr);
        if (rootEmbCmd == null) {
            String[] fieldTypes = mmd.getFieldTypes();
            if (fieldTypes != null && fieldTypes.length == 1) {
                rootEmbCmd = mmgr.getMetaDataForClass(fieldTypes[0], clr);
            } else if (fieldTypes != null && fieldTypes.length > 1) {
                throw new NucleusUserException("Field " + mmd.getFullFieldName() + " is a reference field that is embedded with multiple possible implementations. DataNucleus doesnt support embedded reference fields that have more than 1 implementation");
            }
            if (rootEmbCmd == null && (rootEmbCmd = mmgr.getMetaDataForInterface(clr.classForName(typeName), clr)) == null && mmd.getFieldTypes() != null && mmd.getFieldTypes().length == 1) {
                rootEmbCmd = mmgr.getMetaDataForInterface(clr.classForName(mmd.getFieldTypes()[0]), clr);
            }
        }
        if (rootEmbCmd == null) {
            throw new NucleusUserException("Unable to find root class embedded metadata for field=" + mmd.getFullFieldName());
        }
        this.embCmd = rootEmbCmd;
        AbstractMemberMetaData[] embFmds = null;
        if (emd == null && rootEmbCmd.isEmbeddedOnly()) {
            embFmds = rootEmbCmd.getManagedMembers();
        } else if (emd != null) {
            embFmds = emd.getMemberMetaData();
        }
        String[] subclasses = mmgr.getSubclassesForClass(rootEmbCmd.getFullClassName(), true);
        if (subclasses != null && subclasses.length > 0) {
            if (rootEmbCmd.hasDiscriminatorStrategy()) {
                DiscriminatorMetaData embDismd;
                this.discrimMetaData = new DiscriminatorMetaData();
                InheritanceMetaData embInhMd = new InheritanceMetaData();
                embInhMd.setParent((MetaData)rootEmbCmd);
                this.discrimMetaData.setParent((MetaData)embInhMd);
                DiscriminatorMetaData dismd = rootEmbCmd.getDiscriminatorMetaDataRoot();
                if (dismd.getStrategy() != null && dismd.getStrategy() != DiscriminatorStrategy.NONE) {
                    this.discrimMetaData.setStrategy(dismd.getStrategy());
                } else {
                    this.discrimMetaData.setStrategy(DiscriminatorStrategy.CLASS_NAME);
                }
                ColumnMetaData disColmd = new ColumnMetaData();
                disColmd.setAllowsNull(Boolean.TRUE);
                DiscriminatorMetaData discriminatorMetaData = embDismd = emd != null ? emd.getDiscriminatorMetaData() : null;
                if (embDismd != null && embDismd.getColumnMetaData() != null) {
                    disColmd.setName(embDismd.getColumnMetaData().getName());
                } else {
                    ColumnMetaData colmd = dismd.getColumnMetaData();
                    if (colmd != null && colmd.getName() != null) {
                        disColmd.setName(colmd.getName());
                    }
                }
                this.discrimMetaData.setColumnMetaData(disColmd);
                this.discrimMapping = DiscriminatorMapping.createDiscriminatorMapping(table, this.discrimMetaData);
                this.addDatastoreMapping(this.discrimMapping.getDatastoreMapping(0));
            } else {
                NucleusLogger.PERSISTENCE.info((Object)("Member " + mmd.getFullFieldName() + " is embedded and the type (" + rootEmbCmd.getFullClassName() + ") has potential subclasses. Impossible to detect which is stored embedded. Add a discriminator to the embedded type"));
            }
        }
        int[] pcFieldNumbers = rootEmbCmd.getAllMemberPositions();
        for (i = 0; i < pcFieldNumbers.length; ++i) {
            AbstractMemberMetaData rootEmbMmd = rootEmbCmd.getMetaDataForManagedMemberAtAbsolutePosition(pcFieldNumbers[i]);
            if (rootEmbMmd.getPersistenceModifier() != FieldPersistenceModifier.PERSISTENT) continue;
            this.addMappingForMember(rootEmbCmd, rootEmbMmd, embFmds);
        }
        if (this.discrimMapping != null && subclasses != null && subclasses.length > 0) {
            for (i = 0; i < subclasses.length; ++i) {
                AbstractClassMetaData subEmbCmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(subclasses[i], clr);
                AbstractMemberMetaData[] subEmbMmds = subEmbCmd.getManagedMembers();
                if (subEmbMmds == null) continue;
                for (int j = 0; j < subEmbMmds.length; ++j) {
                    if (subEmbMmds[j].getPersistenceModifier() != FieldPersistenceModifier.PERSISTENT) continue;
                    this.addMappingForMember(subEmbCmd, subEmbMmds[j], embFmds);
                }
            }
        }
    }

    private void addMappingForMember(AbstractClassMetaData embCmd, AbstractMemberMetaData embMmd, AbstractMemberMetaData[] embMmds) {
        if (this.emd == null || this.emd.getOwnerMember() == null || !this.emd.getOwnerMember().equals(embMmd.getName())) {
            AbstractMemberMetaData embeddedMmd = null;
            for (int j = 0; j < embMmds.length; ++j) {
                if (embMmds[j] == null) {
                    throw new RuntimeException("embMmds[j] is null for class=" + embCmd.toString() + " type=" + this.typeName);
                }
                AbstractMemberMetaData embMmdForMmds = embCmd.getMetaDataForMember(embMmds[j].getName());
                if (embMmdForMmds == null || embMmdForMmds.getAbsoluteFieldNumber() != embMmd.getAbsoluteFieldNumber()) continue;
                embeddedMmd = embMmds[j];
            }
            MappingManager mapMgr = this.table.getStoreManager().getMappingManager();
            JavaTypeMapping embMmdMapping = embeddedMmd != null ? mapMgr.getMapping(this.table, embeddedMmd, this.clr, FieldRole.ROLE_FIELD) : mapMgr.getMapping(this.table, embMmd, this.clr, FieldRole.ROLE_FIELD);
            if (embMmd.getRelationType(this.clr) != RelationType.NONE && embMmdMapping instanceof AbstractContainerMapping) {
                NucleusLogger.PERSISTENCE.warn((Object)("Embedded object at " + this.getMemberMetaData().getFullFieldName() + " has a member " + embMmd.getFullFieldName() + " that is a container. Not fully supported as part of an embedded object!"));
            }
            embMmdMapping.setAbsFieldNumber(embMmd.getAbsoluteFieldNumber());
            this.addJavaTypeMapping(embMmdMapping);
            for (int j = 0; j < embMmdMapping.getNumberOfDatastoreMappings(); ++j) {
                Column col;
                DatastoreMapping datastoreMapping = embMmdMapping.getDatastoreMapping(j);
                this.addDatastoreMapping(datastoreMapping);
                if (!this.mmd.isPrimaryKey() || (col = datastoreMapping.getColumn()) == null) continue;
                col.setPrimaryKey();
            }
        }
    }

    @Override
    protected void prepareDatastoreMapping() {
    }

    public void addJavaTypeMapping(JavaTypeMapping mapping) {
        if (mapping == null) {
            throw new NucleusException("mapping argument in EmbeddedMapping.addJavaTypeMapping is null").setFatal();
        }
        if (this.javaTypeMappings == null) {
            this.javaTypeMappings = new ArrayList<JavaTypeMapping>();
        }
        this.javaTypeMappings.add(mapping);
    }

    public int getNumberOfJavaTypeMappings() {
        return this.javaTypeMappings != null ? this.javaTypeMappings.size() : 0;
    }

    public JavaTypeMapping getJavaTypeMapping(int i) {
        if (this.javaTypeMappings == null) {
            return null;
        }
        return this.javaTypeMappings.get(i);
    }

    public JavaTypeMapping getJavaTypeMapping(String fieldName) {
        if (this.javaTypeMappings == null) {
            return null;
        }
        for (JavaTypeMapping m : this.javaTypeMappings) {
            if (!m.getMemberMetaData().getName().equals(fieldName)) continue;
            return m;
        }
        return null;
    }

    public JavaTypeMapping getDiscriminatorMapping() {
        return this.discrimMapping;
    }

    @Override
    public void setObject(ExecutionContext ec, PreparedStatement ps, int[] param, Object value) {
        this.setObject(ec, ps, param, value, null, -1);
    }

    @Override
    public void setObject(ExecutionContext ec, PreparedStatement ps, int[] param, Object value, ObjectProvider ownerOP, int ownerFieldNumber) {
        if (value == null) {
            int n = 0;
            String nullColumn = null;
            String nullValue = null;
            if (this.emd != null) {
                nullColumn = this.emd.getNullIndicatorColumn();
                nullValue = this.emd.getNullIndicatorValue();
            }
            if (this.discrimMapping != null) {
                this.discrimMapping.setObject(ec, ps, new int[]{param[n]}, null);
                ++n;
            }
            for (int i = 0; i < this.javaTypeMappings.size(); ++i) {
                JavaTypeMapping mapping = this.javaTypeMappings.get(i);
                int[] posMapping = new int[mapping.getNumberOfDatastoreMappings()];
                for (int j = 0; j < posMapping.length; ++j) {
                    posMapping[j] = param[n++];
                }
                if (nullColumn != null && nullValue != null && mapping.getMemberMetaData().getColumnMetaData().length > 0 && mapping.getMemberMetaData().getColumnMetaData()[0].getName().equals(nullColumn)) {
                    if (mapping instanceof IntegerMapping || mapping instanceof BigIntegerMapping || mapping instanceof LongMapping || mapping instanceof ShortMapping) {
                        Number convertedValue = null;
                        try {
                            if (mapping instanceof IntegerMapping || mapping instanceof ShortMapping) {
                                convertedValue = Integer.valueOf(nullValue);
                            } else if (mapping instanceof LongMapping || mapping instanceof BigIntegerMapping) {
                                convertedValue = Long.valueOf(nullValue);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        mapping.setObject(ec, ps, posMapping, convertedValue);
                        continue;
                    }
                    mapping.setObject(ec, ps, posMapping, nullValue);
                    continue;
                }
                if (mapping.getNumberOfDatastoreMappings() <= 0) continue;
                mapping.setObject(ec, ps, posMapping, null);
            }
        } else {
            ApiAdapter api = ec.getApiAdapter();
            if (!api.isPersistable(value)) {
                throw new NucleusException(Localiser.msg((String)"041016", (Object[])new Object[]{value.getClass(), value})).setFatal();
            }
            AbstractClassMetaData embCmd = ec.getMetaDataManager().getMetaDataForClass(value.getClass(), ec.getClassLoaderResolver());
            ObjectProvider embOP = ec.findObjectProvider(value);
            if (embOP == null || api.getExecutionContext(value) == null) {
                embOP = ec.getNucleusContext().getObjectProviderFactory().newForEmbedded(ec, value, false, ownerOP, ownerFieldNumber);
                embOP.setPcObjectType(this.objectType);
            }
            int n = 0;
            if (this.discrimMapping != null) {
                if (this.discrimMetaData.getStrategy() != DiscriminatorStrategy.NONE) {
                    this.discrimMapping.setObject(ec, ps, new int[]{param[n]}, embCmd.getDiscriminatorValue());
                }
                ++n;
            }
            for (int i = 0; i < this.javaTypeMappings.size(); ++i) {
                JavaTypeMapping mapping = this.javaTypeMappings.get(i);
                int[] posMapping = new int[mapping.getNumberOfDatastoreMappings()];
                for (int j = 0; j < posMapping.length; ++j) {
                    posMapping[j] = param[n++];
                }
                int embAbsFieldNum = embCmd.getAbsolutePositionOfMember(mapping.getMemberMetaData().getName());
                if (embAbsFieldNum >= 0) {
                    Object fieldValue = embOP.provideField(embAbsFieldNum);
                    if (mapping instanceof EmbeddedPCMapping) {
                        mapping.setObject(ec, ps, posMapping, fieldValue, embOP, embAbsFieldNum);
                        continue;
                    }
                    if (mapping.getNumberOfDatastoreMappings() <= 0) continue;
                    mapping.setObject(ec, ps, posMapping, fieldValue);
                    continue;
                }
                mapping.setObject(ec, ps, posMapping, null);
            }
        }
    }

    @Override
    public Object getObject(ExecutionContext ec, ResultSet rs, int[] param) {
        return this.getObject(ec, rs, param, null, -1);
    }

    @Override
    public Object getObject(ExecutionContext ec, ResultSet rs, int[] param, ObjectProvider ownerOP, int ownerFieldNumber) {
        int ownerFieldNumberInElement;
        String ownerField;
        Object value = null;
        int n = 0;
        AbstractClassMetaData embCmd = this.embCmd;
        if (this.discrimMapping != null) {
            Object discrimValue = this.discrimMapping.getObject(ec, rs, new int[]{param[n]});
            String className = ec.getMetaDataManager().getClassNameFromDiscriminatorValue((String)discrimValue, this.discrimMetaData);
            embCmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(className, this.clr);
            ++n;
        }
        Class embeddedType = this.clr.classForName(embCmd.getFullClassName());
        if (this.mmd.getFieldTypes() != null && this.mmd.getFieldTypes().length > 0) {
            embeddedType = ec.getClassLoaderResolver().classForName(this.mmd.getFieldTypes()[0]);
        }
        ObjectProvider embOP = ec.getNucleusContext().getObjectProviderFactory().newForHollow(ec, embeddedType, null);
        embOP.setPcObjectType(this.objectType);
        value = embOP.getObject();
        String nullColumn = null;
        String nullValue = null;
        if (this.emd != null) {
            nullColumn = this.emd.getNullIndicatorColumn();
            nullValue = this.emd.getNullIndicatorValue();
        }
        for (int i = 0; i < this.javaTypeMappings.size(); ++i) {
            int numSubParams;
            JavaTypeMapping mapping = this.javaTypeMappings.get(i);
            int embAbsFieldNum = embCmd.getAbsolutePositionOfMember(mapping.getMemberMetaData().getName());
            if (embAbsFieldNum >= 0) {
                if (mapping instanceof EmbeddedPCMapping) {
                    numSubParams = mapping.getNumberOfDatastoreMappings();
                    int[] subParam = new int[numSubParams];
                    int k = 0;
                    for (int j = n; j < n + numSubParams; ++j) {
                        subParam[k++] = param[j];
                    }
                    n += numSubParams;
                    Object subValue = mapping.getObject(ec, rs, subParam, embOP, embAbsFieldNum);
                    if (subValue == null) continue;
                    embOP.replaceField(embAbsFieldNum, subValue);
                    continue;
                }
                if (mapping.getNumberOfDatastoreMappings() <= 0) continue;
                int[] posMapping = new int[mapping.getNumberOfDatastoreMappings()];
                for (int j = 0; j < posMapping.length; ++j) {
                    posMapping[j] = param[n++];
                }
                Object fieldValue = mapping.getObject(ec, rs, posMapping);
                if (nullColumn != null && mapping.getMemberMetaData().getColumnMetaData()[0].getName().equals(nullColumn) && (nullValue == null && fieldValue == null || nullValue != null && fieldValue != null && fieldValue.toString().equals(nullValue))) {
                    value = null;
                    break;
                }
                if (fieldValue != null) {
                    embOP.replaceField(embAbsFieldNum, fieldValue);
                    continue;
                }
                AbstractMemberMetaData embFmd = embCmd.getMetaDataForManagedMemberAtAbsolutePosition(embAbsFieldNum);
                if (embFmd.getType().isPrimitive()) continue;
                embOP.replaceField(embAbsFieldNum, fieldValue);
                continue;
            }
            numSubParams = mapping.getNumberOfDatastoreMappings();
            n += numSubParams;
        }
        if (this.emd != null && (ownerField = this.emd.getOwnerMember()) != null && (ownerFieldNumberInElement = embCmd.getAbsolutePositionOfMember(ownerField)) >= 0) {
            embOP.replaceField(ownerFieldNumberInElement, ownerOP != null ? ownerOP.getObject() : null);
        }
        if (value != null && ownerOP != null) {
            ec.registerEmbeddedRelation(ownerOP, ownerFieldNumber, embOP);
        }
        return value;
    }

    @Override
    public Class getJavaType() {
        return this.clr.classForName(this.typeName);
    }

    public AbstractMemberMetaData getRealMemberMetaData() {
        if (this.mmd.getParent() instanceof EmbeddedMetaData) {
            AbstractClassMetaData cmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(this.mmd.getClassName(), this.clr);
            return cmd.getMetaDataForMember(this.mmd.getName());
        }
        return this.mmd;
    }
}

