/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.adapter;

import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.UUID;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.DatastoreId;
import org.datanucleus.metadata.JdbcType;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.rdbms.adapter.BaseDatastoreAdapter;
import org.datanucleus.store.rdbms.adapter.H2TypeInfo;
import org.datanucleus.store.rdbms.identifier.IdentifierFactory;
import org.datanucleus.store.rdbms.identifier.IdentifierType;
import org.datanucleus.store.rdbms.key.PrimaryKey;
import org.datanucleus.store.rdbms.mapping.datastore.BigIntRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.BinaryRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.BinaryStreamRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.BlobRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.BooleanRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.CharRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.ClobRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.DateRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.DecimalRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.DoubleRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.FloatRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.IntegerRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.LongVarBinaryRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.LongVarcharRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.NCharRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.NVarcharRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.NumericRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.OtherRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.RealRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.SmallIntRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.TimeRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.TimestampRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.TinyIntRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.VarBinaryRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.VarCharRDBMSMapping;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.sql.method.AvgWithCastFunction;
import org.datanucleus.store.rdbms.sql.method.TemporalDayOfWeekMethod;
import org.datanucleus.store.rdbms.sql.operation.Mod2Operation;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.store.schema.StoreSchemaHandler;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class H2Adapter
extends BaseDatastoreAdapter {
    private String schemaName;

    public H2Adapter(DatabaseMetaData metadata) {
        super(metadata);
        try {
            ResultSet rs = metadata.getSchemas();
            while (rs.next()) {
                if (!rs.getBoolean("IS_DEFAULT")) continue;
                this.schemaName = rs.getString("TABLE_SCHEM");
            }
        }
        catch (SQLException e) {
            NucleusLogger.DATASTORE_SCHEMA.warn((Object)"Exception when trying to get default schema name for datastore", (Throwable)e);
        }
        this.supportedOptions.add("PrimaryKeyInCreateStatements");
        this.supportedOptions.add("LockWithSelectForUpdate");
        this.supportedOptions.add("IdentityColumns");
        this.supportedOptions.add("CheckInEndCreateStatements");
        this.supportedOptions.add("UniqueInEndCreateStatements");
        this.supportedOptions.add("OrderByWithNullsDirectives");
        this.supportedOptions.add("Sequences");
        this.supportedOptions.remove("DeferredConstraints");
        this.supportedOptions.remove("TxIsolationReadRepeatableRead");
        this.supportedOptions.remove("TxIsolationNone");
        this.supportedOptions.add("CreateIndexesBeforeForeignKeys");
    }

    @Override
    public void initialiseTypes(StoreSchemaHandler handler, ManagedConnection mconn) {
        super.initialiseTypes(handler, mconn);
        H2TypeInfo sqlType = new H2TypeInfo("UUID", 1111, Integer.MAX_VALUE, null, null, null, 1, true, 3, false, false, false, "UUID", 0, 0, 0);
        this.addSQLTypeForJDBCType(handler, mconn, (short)1111, sqlType, true);
        sqlType = new H2TypeInfo("GEOMETRY", 1111, Integer.MAX_VALUE, null, null, null, 1, true, 3, false, false, false, "GEOMETRY", 0, 0, 0);
        this.addSQLTypeForJDBCType(handler, mconn, (short)1111, sqlType, true);
    }

    @Override
    public String getVendorID() {
        return "h2";
    }

    @Override
    public SQLTypeInfo newSQLTypeInfo(ResultSet rs) {
        return new H2TypeInfo(rs);
    }

    @Override
    public int getDatastoreIdentifierMaxLength(IdentifierType identifierType) {
        if (identifierType == IdentifierType.TABLE) {
            return 128;
        }
        if (identifierType == IdentifierType.COLUMN) {
            return 128;
        }
        if (identifierType == IdentifierType.CANDIDATE_KEY) {
            return 128;
        }
        if (identifierType == IdentifierType.FOREIGN_KEY) {
            return 128;
        }
        if (identifierType == IdentifierType.INDEX) {
            return 128;
        }
        if (identifierType == IdentifierType.PRIMARY_KEY) {
            return 128;
        }
        if (identifierType == IdentifierType.SEQUENCE) {
            return 128;
        }
        return super.getDatastoreIdentifierMaxLength(identifierType);
    }

    @Override
    public String getCreateDatabaseStatement(String catalogName, String schemaName) {
        return "CREATE SCHEMA IF NOT EXISTS " + schemaName;
    }

    @Override
    public String getDropDatabaseStatement(String catalogName, String schemaName) {
        return "DROP SCHEMA IF EXISTS " + schemaName;
    }

    @Override
    public String getAddColumnStatement(Table table, Column col) {
        return "ALTER TABLE " + table.toString() + " ADD COLUMN " + col.getSQLDefinition();
    }

    @Override
    public String getRangeByLimitEndOfStatementClause(long offset, long count, boolean hasOrdering) {
        if (offset >= 0L && count > 0L) {
            return "LIMIT " + count + " OFFSET " + offset + " ";
        }
        if (offset <= 0L && count > 0L) {
            return "LIMIT " + count + " ";
        }
        if (offset >= 0L && count < 0L) {
            return "LIMIT 2147483647 OFFSET " + offset + " ";
        }
        return "";
    }

    @Override
    public String getSchemaName(Connection conn) throws SQLException {
        return this.schemaName;
    }

    @Override
    public String getAddPrimaryKeyStatement(PrimaryKey pk, IdentifierFactory factory) {
        return null;
    }

    @Override
    public String getAutoIncrementStmt(Table table, String columnName) {
        return "CALL IDENTITY()";
    }

    @Override
    public String getAutoIncrementKeyword() {
        return "IDENTITY";
    }

    @Override
    public String getInsertStatementForNoColumns(Table table) {
        return "INSERT INTO " + table.toString() + " VALUES(NULL)";
    }

    @Override
    public boolean isValidPrimaryKeyType(JdbcType datatype) {
        return true;
    }

    @Override
    public String getSequenceCreateStmt(String sequenceName, Integer min, Integer max, Integer start, Integer increment, Integer cacheSize) {
        if (sequenceName == null) {
            throw new NucleusUserException(Localiser.msg((String)"051028"));
        }
        StringBuilder stmt = new StringBuilder("CREATE SEQUENCE IF NOT EXISTS ");
        stmt.append(sequenceName);
        if (min != null) {
            stmt.append(" START WITH " + min);
        } else if (start != null) {
            stmt.append(" START WITH " + start);
        }
        if (max != null) {
            throw new NucleusUserException(Localiser.msg((String)"051022"));
        }
        if (increment != null) {
            stmt.append(" INCREMENT BY " + increment);
        }
        if (cacheSize != null) {
            stmt.append(" CACHE " + cacheSize);
        }
        return stmt.toString();
    }

    @Override
    public String getSequenceNextStmt(String sequenceName) {
        if (sequenceName == null) {
            throw new NucleusUserException(Localiser.msg((String)"051028"));
        }
        StringBuilder stmt = new StringBuilder("CALL NEXT VALUE FOR ");
        stmt.append(sequenceName);
        return stmt.toString();
    }

    @Override
    public boolean isStatementCancel(SQLException sqle) {
        return sqle.getErrorCode() == 90051;
    }

    @Override
    public Class getSQLOperationClass(String operationName) {
        if ("mod".equals(operationName)) {
            return Mod2Operation.class;
        }
        return super.getSQLOperationClass(operationName);
    }

    @Override
    public Class getSQLMethodClass(String className, String methodName, ClassLoaderResolver clr) {
        if (className == null) {
            if ("avg".equals(methodName)) {
                return AvgWithCastFunction.class;
            }
            if ("AVG".equals(methodName)) {
                return AvgWithCastFunction.class;
            }
            if ("DAY_OF_WEEK".equals(methodName)) {
                return TemporalDayOfWeekMethod.class;
            }
        } else {
            Class cls = null;
            try {
                cls = clr.classForName(className);
            }
            catch (ClassNotResolvedException classNotResolvedException) {
                // empty catch block
            }
            if ("java.util.Date".equals(className) || cls != null && java.util.Date.class.isAssignableFrom(cls)) {
                if ("getDayOfWeek".equals(methodName)) {
                    return TemporalDayOfWeekMethod.class;
                }
            } else {
                if ("java.time.LocalDate".equals(className) && "getDayOfWeek".equals(methodName)) {
                    return TemporalDayOfWeekMethod.class;
                }
                if ("java.time.LocalDateTime".equals(className) && "getDayOfWeek".equals(methodName)) {
                    return TemporalDayOfWeekMethod.class;
                }
            }
        }
        return super.getSQLMethodClass(className, methodName, clr);
    }

    @Override
    protected void loadDatastoreMappings(PluginManager mgr, ClassLoaderResolver clr) {
        this.registerDatastoreMapping(Boolean.class.getName(), BooleanRDBMSMapping.class, JDBCType.BOOLEAN, "BOOLEAN", true);
        this.registerDatastoreMapping(Boolean.class.getName(), CharRDBMSMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerDatastoreMapping(Boolean.class.getName(), BooleanRDBMSMapping.class, JDBCType.TINYINT, "TINYINT", false);
        this.registerDatastoreMapping(Boolean.class.getName(), SmallIntRDBMSMapping.class, JDBCType.SMALLINT, "SMALLINT", false);
        this.registerDatastoreMapping(Byte.class.getName(), TinyIntRDBMSMapping.class, JDBCType.TINYINT, "TINYINT", true);
        this.registerDatastoreMapping(Byte.class.getName(), SmallIntRDBMSMapping.class, JDBCType.SMALLINT, "SMALLINT", false);
        this.registerDatastoreMapping(Character.class.getName(), CharRDBMSMapping.class, JDBCType.CHAR, "CHAR", true);
        this.registerDatastoreMapping(Character.class.getName(), IntegerRDBMSMapping.class, JDBCType.INTEGER, "INTEGER", false);
        this.registerDatastoreMapping(Double.class.getName(), DoubleRDBMSMapping.class, JDBCType.DOUBLE, "DOUBLE", true);
        this.registerDatastoreMapping(Double.class.getName(), DecimalRDBMSMapping.class, JDBCType.DECIMAL, "DECIMAL", false);
        this.registerDatastoreMapping(Float.class.getName(), FloatRDBMSMapping.class, JDBCType.FLOAT, "FLOAT", true);
        this.registerDatastoreMapping(Float.class.getName(), DoubleRDBMSMapping.class, JDBCType.DOUBLE, "DOUBLE", false);
        this.registerDatastoreMapping(Float.class.getName(), RealRDBMSMapping.class, JDBCType.REAL, "REAL", false);
        this.registerDatastoreMapping(Float.class.getName(), DecimalRDBMSMapping.class, JDBCType.DECIMAL, "DECIMAL", false);
        this.registerDatastoreMapping(Integer.class.getName(), IntegerRDBMSMapping.class, JDBCType.INTEGER, "INTEGER", true);
        this.registerDatastoreMapping(Integer.class.getName(), BigIntRDBMSMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerDatastoreMapping(Integer.class.getName(), NumericRDBMSMapping.class, JDBCType.NUMERIC, "NUMERIC", false);
        this.registerDatastoreMapping(Integer.class.getName(), TinyIntRDBMSMapping.class, JDBCType.TINYINT, "TINYINT", false);
        this.registerDatastoreMapping(Integer.class.getName(), SmallIntRDBMSMapping.class, JDBCType.SMALLINT, "SMALLINT", false);
        this.registerDatastoreMapping(Long.class.getName(), BigIntRDBMSMapping.class, JDBCType.BIGINT, "BIGINT", true);
        this.registerDatastoreMapping(Long.class.getName(), IntegerRDBMSMapping.class, JDBCType.INTEGER, "INT", false);
        this.registerDatastoreMapping(Long.class.getName(), NumericRDBMSMapping.class, JDBCType.NUMERIC, "NUMERIC", false);
        this.registerDatastoreMapping(Long.class.getName(), TinyIntRDBMSMapping.class, JDBCType.TINYINT, "TINYINT", false);
        this.registerDatastoreMapping(Long.class.getName(), SmallIntRDBMSMapping.class, JDBCType.SMALLINT, "SMALLINT", false);
        this.registerDatastoreMapping(Short.class.getName(), SmallIntRDBMSMapping.class, JDBCType.SMALLINT, "SMALLINT", true);
        this.registerDatastoreMapping(Short.class.getName(), IntegerRDBMSMapping.class, JDBCType.INTEGER, "INTEGER", false);
        this.registerDatastoreMapping(Short.class.getName(), TinyIntRDBMSMapping.class, JDBCType.TINYINT, "TINYINT", false);
        this.registerDatastoreMapping(String.class.getName(), VarCharRDBMSMapping.class, JDBCType.VARCHAR, "VARCHAR", true);
        this.registerDatastoreMapping(String.class.getName(), CharRDBMSMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerDatastoreMapping(String.class.getName(), BigIntRDBMSMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerDatastoreMapping(String.class.getName(), LongVarcharRDBMSMapping.class, JDBCType.LONGVARCHAR, "LONGVARCHAR", false);
        this.registerDatastoreMapping(String.class.getName(), ClobRDBMSMapping.class, JDBCType.CLOB, "CLOB", false);
        this.registerDatastoreMapping(String.class.getName(), BlobRDBMSMapping.class, JDBCType.BLOB, "BLOB", false);
        this.registerDatastoreMapping(String.class.getName(), NVarcharRDBMSMapping.class, JDBCType.NVARCHAR, "NVARCHAR", false);
        this.registerDatastoreMapping(String.class.getName(), NCharRDBMSMapping.class, JDBCType.NCHAR, "NCHAR", false);
        this.registerDatastoreMapping(BigDecimal.class.getName(), DecimalRDBMSMapping.class, JDBCType.DECIMAL, "DECIMAL", true);
        this.registerDatastoreMapping(BigDecimal.class.getName(), NumericRDBMSMapping.class, JDBCType.NUMERIC, "NUMERIC", false);
        this.registerDatastoreMapping(BigInteger.class.getName(), NumericRDBMSMapping.class, JDBCType.NUMERIC, "NUMERIC", true);
        this.registerDatastoreMapping(Date.class.getName(), DateRDBMSMapping.class, JDBCType.DATE, "DATE", true);
        this.registerDatastoreMapping(Date.class.getName(), TimestampRDBMSMapping.class, JDBCType.TIMESTAMP, "TIMESTAMP", false);
        this.registerDatastoreMapping(Date.class.getName(), CharRDBMSMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerDatastoreMapping(Date.class.getName(), VarCharRDBMSMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        this.registerDatastoreMapping(Date.class.getName(), BigIntRDBMSMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerDatastoreMapping(Time.class.getName(), TimeRDBMSMapping.class, JDBCType.TIME, "TIME", true);
        this.registerDatastoreMapping(Time.class.getName(), TimestampRDBMSMapping.class, JDBCType.TIMESTAMP, "TIMESTAMP", false);
        this.registerDatastoreMapping(Time.class.getName(), CharRDBMSMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerDatastoreMapping(Time.class.getName(), VarCharRDBMSMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        this.registerDatastoreMapping(Time.class.getName(), BigIntRDBMSMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerDatastoreMapping(Timestamp.class.getName(), TimestampRDBMSMapping.class, JDBCType.TIMESTAMP, "TIMESTAMP", true);
        this.registerDatastoreMapping(Timestamp.class.getName(), CharRDBMSMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerDatastoreMapping(Timestamp.class.getName(), VarCharRDBMSMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        this.registerDatastoreMapping(Timestamp.class.getName(), DateRDBMSMapping.class, JDBCType.DATE, "DATE", false);
        this.registerDatastoreMapping(Timestamp.class.getName(), TimeRDBMSMapping.class, JDBCType.TIME, "TIME", false);
        this.registerDatastoreMapping(java.util.Date.class.getName(), TimestampRDBMSMapping.class, JDBCType.TIMESTAMP, "TIMESTAMP", true);
        this.registerDatastoreMapping(java.util.Date.class.getName(), DateRDBMSMapping.class, JDBCType.DATE, "DATE", false);
        this.registerDatastoreMapping(java.util.Date.class.getName(), CharRDBMSMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerDatastoreMapping(java.util.Date.class.getName(), VarCharRDBMSMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        this.registerDatastoreMapping(java.util.Date.class.getName(), BigIntRDBMSMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerDatastoreMapping(java.util.Date.class.getName(), TimeRDBMSMapping.class, JDBCType.TIME, "TIME", false);
        this.registerDatastoreMapping(UUID.class.getName(), OtherRDBMSMapping.class, JDBCType.OTHER, "UUID", false);
        this.registerDatastoreMapping(Serializable.class.getName(), LongVarBinaryRDBMSMapping.class, JDBCType.LONGVARBINARY, "LONGVARBINARY", true);
        this.registerDatastoreMapping(Serializable.class.getName(), BlobRDBMSMapping.class, JDBCType.BLOB, "BLOB", false);
        this.registerDatastoreMapping(Serializable.class.getName(), VarBinaryRDBMSMapping.class, JDBCType.VARBINARY, "VARBINARY", false);
        this.registerDatastoreMapping(Serializable.class.getName(), BinaryRDBMSMapping.class, JDBCType.BINARY, "BINARY", false);
        this.registerDatastoreMapping(byte[].class.getName(), LongVarBinaryRDBMSMapping.class, JDBCType.LONGVARBINARY, "LONGVARBINARY", true);
        this.registerDatastoreMapping(byte[].class.getName(), BlobRDBMSMapping.class, JDBCType.BLOB, "BLOB", false);
        this.registerDatastoreMapping(byte[].class.getName(), VarBinaryRDBMSMapping.class, JDBCType.VARBINARY, "VARBINARY", false);
        this.registerDatastoreMapping(byte[].class.getName(), BinaryRDBMSMapping.class, JDBCType.BINARY, "BINARY", false);
        this.registerDatastoreMapping(File.class.getName(), BinaryStreamRDBMSMapping.class, JDBCType.LONGVARBINARY, "LONGVARBINARY", true);
        this.registerDatastoreMapping(DatastoreId.class.getName(), BigIntRDBMSMapping.class, JDBCType.BIGINT, "BIGINT", true);
        this.registerDatastoreMapping(DatastoreId.class.getName(), IntegerRDBMSMapping.class, JDBCType.INTEGER, "INTEGER", false);
        this.registerDatastoreMapping(DatastoreId.class.getName(), NumericRDBMSMapping.class, JDBCType.NUMERIC, "NUMERIC", false);
        this.registerDatastoreMapping(DatastoreId.class.getName(), CharRDBMSMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerDatastoreMapping(DatastoreId.class.getName(), VarCharRDBMSMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        super.loadDatastoreMappings(mgr, clr);
    }
}

