/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.adapter;

import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.DatastoreId;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.rdbms.adapter.BaseDatastoreAdapter;
import org.datanucleus.store.rdbms.adapter.PostgreSQLTypeInfo;
import org.datanucleus.store.rdbms.identifier.IdentifierFactory;
import org.datanucleus.store.rdbms.key.Index;
import org.datanucleus.store.rdbms.key.PrimaryKey;
import org.datanucleus.store.rdbms.mapping.datastore.ArrayRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.BigIntRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.BinaryStreamRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.BitRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.BlobRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.BooleanRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.CharRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.ClobRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.DateRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.DoubleRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.IntegerRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.LongVarBinaryRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.LongVarcharRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.NCharRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.NVarcharRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.NumericRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.OtherRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.RealRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.SmallIntRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.SqlXmlRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.TimeRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.TimestampRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.TinyIntRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.datastore.VarCharRDBMSMapping;
import org.datanucleus.store.rdbms.schema.ForeignKeyInfo;
import org.datanucleus.store.rdbms.schema.RDBMSColumnInfo;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.sql.method.LogFunction2;
import org.datanucleus.store.rdbms.sql.method.StringConcat1Method;
import org.datanucleus.store.rdbms.sql.method.StringIndexOf5Method;
import org.datanucleus.store.rdbms.sql.method.StringSimilarPostgresqlMethod;
import org.datanucleus.store.rdbms.sql.method.StringSubstring5Method;
import org.datanucleus.store.rdbms.sql.method.StringTranslateMethod;
import org.datanucleus.store.rdbms.sql.method.StringTrim3Method;
import org.datanucleus.store.rdbms.sql.method.StringTrimLeft3Method;
import org.datanucleus.store.rdbms.sql.method.StringTrimRight3Method;
import org.datanucleus.store.rdbms.sql.method.TemporalDayMethod3;
import org.datanucleus.store.rdbms.sql.method.TemporalDayOfWeekMethod2;
import org.datanucleus.store.rdbms.sql.method.TemporalHourMethod3;
import org.datanucleus.store.rdbms.sql.method.TemporalMinuteMethod3;
import org.datanucleus.store.rdbms.sql.method.TemporalMonthJavaMethod3;
import org.datanucleus.store.rdbms.sql.method.TemporalMonthMethod3;
import org.datanucleus.store.rdbms.sql.method.TemporalSecondMethod3;
import org.datanucleus.store.rdbms.sql.method.TemporalYearMethod3;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.store.schema.StoreSchemaHandler;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class PostgreSQLAdapter
extends BaseDatastoreAdapter {
    public static final String POSTGRESQL_RESERVED_WORDS = "ALL,ANALYSE,ANALYZE,DO,FREEZE,ILIKE,ISNULL,OFFSET,PLACING,VERBOSE";
    protected Map<String, String> psqlTypes;

    public PostgreSQLAdapter(DatabaseMetaData metadata) {
        super(metadata);
        if (this.datastoreMajorVersion < 7) {
            throw new NucleusDataStoreException("PostgreSQL version is " + this.datastoreMajorVersion + '.' + this.datastoreMinorVersion + ", 7.0 or later required");
        }
        if (this.datastoreMajorVersion == 7 && this.datastoreMinorVersion <= 2) {
            --this.maxTableNameLength;
            --this.maxConstraintNameLength;
            --this.maxIndexNameLength;
        }
        this.reservedKeywords.addAll(StringUtils.convertCommaSeparatedStringToSet((String)POSTGRESQL_RESERVED_WORDS));
        this.supportedOptions.add("LockWithSelectForUpdate");
        this.supportedOptions.add("SelectForUpdateNoWait");
        this.supportedOptions.add("PrimaryKeyInCreateStatements");
        this.supportedOptions.add("Sequences");
        this.supportedOptions.add("IdentityColumns");
        this.supportedOptions.add("OrderByWithNullsDirectives");
        this.supportedOptions.remove("AutoIncrementColumnTypeSpecification");
        this.supportedOptions.remove("AutoIncrementNullSpecification");
        this.supportedOptions.remove("DistinctWithSelectForUpdate");
        this.supportedOptions.remove("PersistOfUnassignedChar");
        if (this.datastoreMajorVersion < 7 || this.datastoreMajorVersion == 7 && this.datastoreMinorVersion < 2) {
            this.supportedOptions.remove("AlterTableDropConstraint_Syntax");
        } else {
            this.supportedOptions.add("AlterTableDropConstraint_Syntax");
        }
        this.supportedOptions.add("BitIsReallyBoolean");
        this.supportedOptions.add("CharColumnsPaddedWithSpaces");
        this.supportedOptions.add("StoredProcs");
        this.supportedOptions.remove("TxIsolationNone");
        this.supportedOptions.remove("UpdateStmtAllowTableAliasInSet");
        this.supportedOptions.remove("TxIsolationReadUncommitted");
        this.supportedOptions.remove("StoredProcs");
        this.supportedOptions.add("BitwiseAndOperator");
        this.supportedOptions.add("BitwiseOrOperator");
        this.supportedOptions.add("BitwiseXOrOperator");
        this.supportedOptions.remove("ValueGeneratorUUIDString");
    }

    @Override
    public void initialiseTypes(StoreSchemaHandler handler, ManagedConnection mconn) {
        super.initialiseTypes(handler, mconn);
        PostgreSQLTypeInfo sqlType = new PostgreSQLTypeInfo("char", 1, 65000, null, null, null, 0, false, 3, false, false, false, "char", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)1, sqlType, true);
        sqlType = new PostgreSQLTypeInfo("text", 2005, 9, null, null, null, 0, false, 3, false, false, false, "text", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)2005, sqlType, true);
        sqlType = new PostgreSQLTypeInfo("bytea", 2004, 9, null, null, null, 0, false, 3, false, false, false, "bytea", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)2004, sqlType, true);
        sqlType = new PostgreSQLTypeInfo("bool", 16, 0, null, null, null, 1, false, 3, true, false, false, "bool", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)16, sqlType, true);
        sqlType = new PostgreSQLTypeInfo("int2", -6, 0, null, null, null, 1, false, 3, false, false, false, "int2", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)-6, sqlType, true);
        sqlType = new PostgreSQLTypeInfo("text array", 2003, 0, null, null, null, 1, false, 3, false, false, false, "text array", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)2003, sqlType, true);
        sqlType = new PostgreSQLTypeInfo("int array", 2003, 0, null, null, null, 1, false, 3, false, false, false, "int array", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)2003, sqlType, true);
    }

    @Override
    public String getVendorID() {
        return "postgresql";
    }

    @Override
    public SQLTypeInfo newSQLTypeInfo(ResultSet rs) {
        String obj;
        PostgreSQLTypeInfo info = new PostgreSQLTypeInfo(rs);
        if (this.psqlTypes == null) {
            this.psqlTypes = new ConcurrentHashMap<String, String>();
            this.psqlTypes.put("-7", "bool");
            this.psqlTypes.put("93", "timestamptz");
            this.psqlTypes.put("-5", "int8");
            this.psqlTypes.put("1", "char");
            this.psqlTypes.put("91", "date");
            this.psqlTypes.put("8", "float8");
            this.psqlTypes.put("4", "int4");
            this.psqlTypes.put("-1", "text");
            this.psqlTypes.put("2005", "text");
            this.psqlTypes.put("2004", "bytea");
            this.psqlTypes.put("2", "numeric");
            this.psqlTypes.put("7", "float4");
            this.psqlTypes.put("5", "int2");
            this.psqlTypes.put("92", "time");
            this.psqlTypes.put("12", "varchar");
            this.psqlTypes.put("1111", "uuid");
            this.psqlTypes.put("2003", "VARCHAR(255) ARRAY");
            this.psqlTypes.put("2003", "INT ARRAY");
        }
        if ((obj = this.psqlTypes.get("" + info.getDataType())) != null) {
            String psql_type_name = obj;
            if (!info.getTypeName().equalsIgnoreCase(psql_type_name)) {
                NucleusLogger.DATASTORE.debug((Object)Localiser.msg((String)"051007", (Object[])new Object[]{info.getTypeName(), this.getNameForJDBCType(info.getDataType())}));
                return null;
            }
        }
        return info;
    }

    @Override
    public RDBMSColumnInfo newRDBMSColumnInfo(ResultSet rs) {
        String columnDef;
        int decimalDigits;
        RDBMSColumnInfo info = new RDBMSColumnInfo(rs);
        String typeName = info.getTypeName();
        if (typeName.equalsIgnoreCase("text")) {
            info.setDataType((short)-1);
        } else if (typeName.equalsIgnoreCase("bytea")) {
            info.setDataType((short)-4);
        }
        int columnSize = info.getColumnSize();
        if (columnSize > 65000) {
            info.setColumnSize(-1);
        }
        if ((decimalDigits = info.getDecimalDigits()) > 65000) {
            info.setDecimalDigits(-1);
        }
        if ((columnDef = info.getColumnDef()) != null) {
            if (columnDef.startsWith("nextval(")) {
                info.setColumnDef(null);
            } else if (!(columnDef.startsWith("'") && columnDef.endsWith("'") || !columnDef.contains("::"))) {
                info.setColumnDef(columnDef.substring(0, columnDef.indexOf("::")));
            }
        }
        return info;
    }

    @Override
    public ForeignKeyInfo newFKInfo(ResultSet rs) {
        ForeignKeyInfo info = super.newFKInfo(rs);
        String fkName = (String)info.getProperty("fk_name");
        int firstBackslashIdx = fkName.indexOf(92);
        if (firstBackslashIdx > 0) {
            info.addProperty("fk_name", fkName.substring(0, firstBackslashIdx));
        }
        return info;
    }

    @Override
    public String getDropDatabaseStatement(String catalogName, String schemaName) {
        return "DROP SCHEMA IF EXISTS " + schemaName + " CASCADE";
    }

    @Override
    public String getAddColumnStatement(Table table, Column col) {
        return "ALTER TABLE " + table.toString() + " ADD COLUMN " + col.getSQLDefinition();
    }

    @Override
    public String getInsertStatementForNoColumns(Table table) {
        return "INSERT INTO " + table.toString() + " VALUES (DEFAULT)";
    }

    @Override
    public String getAddPrimaryKeyStatement(PrimaryKey pk, IdentifierFactory factory) {
        return null;
    }

    @Override
    public String getDropTableStatement(Table table) {
        if (this.datastoreMajorVersion < 7 || this.datastoreMajorVersion == 7 && this.datastoreMinorVersion < 3) {
            return "DROP TABLE " + table.toString();
        }
        return super.getDropTableStatement(table);
    }

    @Override
    public String getCreateIndexStatement(Index idx, IdentifierFactory factory) {
        String idxIdentifier = factory.getIdentifierInAdapterCase(idx.getName());
        return "CREATE " + (idx.getUnique() ? "UNIQUE " : "") + "INDEX " + idxIdentifier + " ON " + idx.getTable().toString() + ' ' + idx + (idx.getExtendedIndexSettings() == null ? "" : " " + idx.getExtendedIndexSettings());
    }

    @Override
    public String getAutoIncrementStmt(Table table, String columnName) {
        String tableName;
        boolean quoted;
        StringBuilder stmt = new StringBuilder("SELECT currval('");
        if (table.getSchemaName() != null) {
            stmt.append(table.getSchemaName().replace(this.getIdentifierQuoteString(), ""));
            stmt.append(this.getCatalogSeparator());
        }
        if (quoted = (tableName = table.getIdentifier().toString()).startsWith(this.getIdentifierQuoteString())) {
            stmt.append(this.getIdentifierQuoteString());
        }
        stmt.append(tableName.replace(this.getIdentifierQuoteString(), ""));
        stmt.append("_");
        stmt.append(columnName.replace(this.getIdentifierQuoteString(), ""));
        stmt.append("_seq");
        if (quoted) {
            stmt.append(this.getIdentifierQuoteString());
        }
        stmt.append("')");
        return stmt.toString();
    }

    @Override
    public String getAutoIncrementKeyword() {
        return "SERIAL";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sequenceExists(Connection conn, String catalogName, String schemaName, String seqName) {
        String stmtStr = "SELECT relname FROM pg_class WHERE relname=?";
        Statement ps = null;
        ResultSet rs = null;
        String seqNameToSearch = seqName;
        if (seqName.startsWith("\"") && seqName.endsWith("\"")) {
            seqNameToSearch = seqName.substring(1, seqName.length() - 1);
        }
        try {
            NucleusLogger.DATASTORE_NATIVE.debug((Object)(stmtStr + " : for sequence=" + seqNameToSearch));
            ps = conn.prepareStatement(stmtStr);
            ps.setString(1, seqNameToSearch);
            rs = ps.executeQuery();
            if (rs.next()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException sqle) {
            NucleusLogger.DATASTORE_RETRIEVE.debug((Object)("Exception while executing query for sequence " + seqNameToSearch + " : " + stmtStr + " - " + sqle.getMessage()));
        }
        finally {
            try {
                try {
                    if (rs != null && !rs.isClosed()) {
                        rs.close();
                    }
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            catch (SQLException sQLException) {}
        }
        return super.sequenceExists(conn, catalogName, schemaName, seqName);
    }

    @Override
    public String getSequenceCreateStmt(String sequenceName, Integer min, Integer max, Integer start, Integer increment, Integer cacheSize) {
        if (sequenceName == null) {
            throw new NucleusUserException(Localiser.msg((String)"051028"));
        }
        StringBuilder stmt = new StringBuilder("CREATE SEQUENCE ");
        stmt.append(sequenceName);
        if (min != null) {
            stmt.append(" MINVALUE " + min);
        }
        if (max != null) {
            stmt.append(" MAXVALUE " + max);
        }
        if (start != null) {
            stmt.append(" START WITH " + start);
        }
        if (increment != null) {
            stmt.append(" INCREMENT BY " + increment);
        }
        if (cacheSize != null) {
            stmt.append(" CACHE " + cacheSize);
        } else {
            stmt.append(" CACHE 1");
        }
        return stmt.toString();
    }

    @Override
    public String getSequenceNextStmt(String sequenceName) {
        if (sequenceName == null) {
            throw new NucleusUserException(Localiser.msg((String)"051028"));
        }
        StringBuilder stmt = new StringBuilder("SELECT nextval('");
        stmt.append(sequenceName);
        stmt.append("')");
        return stmt.toString();
    }

    @Override
    public boolean supportsQueryFetchSize(int size) {
        return this.driverMajorVersion > 7;
    }

    @Override
    public String getRangeByLimitEndOfStatementClause(long offset, long count, boolean hasOrdering) {
        if (offset <= 0L && count <= 0L) {
            return "";
        }
        if (this.datastoreMajorVersion < 8 || this.datastoreMajorVersion == 8 && this.datastoreMinorVersion <= 3) {
            String str = "";
            if (count > 0L) {
                str = str + "LIMIT " + count + " ";
            }
            if (offset >= 0L) {
                str = str + "OFFSET " + offset + " ";
            }
            return str;
        }
        StringBuilder str = new StringBuilder();
        if (offset > 0L) {
            str.append("OFFSET " + offset + (offset > 1L ? " ROWS " : " ROW "));
        }
        if (count > 0L) {
            str.append("FETCH NEXT " + (count > 1L ? count + " ROWS ONLY " : "ROW ONLY "));
        }
        return str.toString();
    }

    @Override
    public String getEscapePatternExpression() {
        if (this.datastoreMajorVersion > 8 || this.datastoreMajorVersion == 8 && this.datastoreMinorVersion >= 3) {
            return "ESCAPE E'\\\\'";
        }
        return "ESCAPE '\\\\'";
    }

    @Override
    public boolean isStatementCancel(SQLException sqle) {
        return sqle.getErrorCode() == 57014;
    }

    @Override
    public Class getSQLMethodClass(String className, String methodName, ClassLoaderResolver clr) {
        if (className == null) {
            if ("log".equals(methodName)) {
                return LogFunction2.class;
            }
            if ("YEAR".equals(methodName)) {
                return TemporalYearMethod3.class;
            }
            if ("MONTH".equals(methodName)) {
                return TemporalMonthMethod3.class;
            }
            if ("MONTH_JAVA".equals(methodName)) {
                return TemporalMonthJavaMethod3.class;
            }
            if ("DAY".equals(methodName)) {
                return TemporalDayMethod3.class;
            }
            if ("DAY_OF_WEEK".equals(methodName)) {
                return TemporalDayOfWeekMethod2.class;
            }
            if ("HOUR".equals(methodName)) {
                return TemporalHourMethod3.class;
            }
            if ("MINUTE".equals(methodName)) {
                return TemporalMinuteMethod3.class;
            }
            if ("SECOND".equals(methodName)) {
                return TemporalSecondMethod3.class;
            }
        } else {
            Class cls = null;
            try {
                cls = clr.classForName(className);
            }
            catch (ClassNotResolvedException classNotResolvedException) {
                // empty catch block
            }
            if ("java.lang.String".equals(className)) {
                if ("concat".equals(methodName)) {
                    return StringConcat1Method.class;
                }
                if ("indexOf".equals(methodName)) {
                    return StringIndexOf5Method.class;
                }
                if ("similarTo".equals(methodName)) {
                    return StringSimilarPostgresqlMethod.class;
                }
                if ("substring".equals(methodName)) {
                    return StringSubstring5Method.class;
                }
                if ("translate".equals(methodName)) {
                    return StringTranslateMethod.class;
                }
                if ("trim".equals(methodName)) {
                    return StringTrim3Method.class;
                }
                if ("trimLeft".equals(methodName)) {
                    return StringTrimLeft3Method.class;
                }
                if ("trimRight".equals(methodName)) {
                    return StringTrimRight3Method.class;
                }
            } else if ("java.util.Date".equals(className) || cls != null && java.util.Date.class.isAssignableFrom(cls)) {
                if ("getDay".equals(methodName)) {
                    return TemporalDayMethod3.class;
                }
                if ("getDayOfWeek".equals(methodName)) {
                    return TemporalDayOfWeekMethod2.class;
                }
                if ("getDate".equals(methodName)) {
                    return TemporalDayMethod3.class;
                }
                if ("getMonth".equals(methodName)) {
                    return TemporalMonthJavaMethod3.class;
                }
                if ("getYear".equals(methodName)) {
                    return TemporalYearMethod3.class;
                }
                if ("getHour".equals(methodName)) {
                    return TemporalHourMethod3.class;
                }
                if ("getMinute".equals(methodName)) {
                    return TemporalMinuteMethod3.class;
                }
                if ("getSecond".equals(methodName)) {
                    return TemporalSecondMethod3.class;
                }
            } else if ("java.time.LocalTime".equals(className)) {
                if ("getHour".equals(methodName)) {
                    return TemporalHourMethod3.class;
                }
                if ("getMinute".equals(methodName)) {
                    return TemporalMinuteMethod3.class;
                }
                if ("getSecond".equals(methodName)) {
                    return TemporalSecondMethod3.class;
                }
            } else if ("java.time.LocalDate".equals(className)) {
                if ("getDayOfMonth".equals(methodName)) {
                    return TemporalDayMethod3.class;
                }
                if ("getDayOfWeek".equals(methodName)) {
                    return TemporalDayOfWeekMethod2.class;
                }
                if ("getMonthValue".equals(methodName)) {
                    return TemporalMonthMethod3.class;
                }
                if ("getYear".equals(methodName)) {
                    return TemporalYearMethod3.class;
                }
            } else if ("java.time.LocalDateTime".equals(className)) {
                if ("getDayOfMonth".equals(methodName)) {
                    return TemporalDayMethod3.class;
                }
                if ("getDayOfWeek".equals(methodName)) {
                    return TemporalDayOfWeekMethod2.class;
                }
                if ("getMonthValue".equals(methodName)) {
                    return TemporalMonthMethod3.class;
                }
                if ("getYear".equals(methodName)) {
                    return TemporalYearMethod3.class;
                }
                if ("getHour".equals(methodName)) {
                    return TemporalHourMethod3.class;
                }
                if ("getMinute".equals(methodName)) {
                    return TemporalMinuteMethod3.class;
                }
                if ("getSecond".equals(methodName)) {
                    return TemporalSecondMethod3.class;
                }
            } else if ("java.time.MonthDay".equals(className)) {
                if ("getDayOfMonth".equals(methodName)) {
                    return TemporalDayMethod3.class;
                }
                if ("getMonthValue".equals(methodName)) {
                    return TemporalMonthMethod3.class;
                }
            } else if ("java.time.Period".equals(className)) {
                if ("getMonths".equals(methodName)) {
                    return TemporalMonthMethod3.class;
                }
                if ("getDays".equals(methodName)) {
                    return TemporalDayMethod3.class;
                }
                if ("getYears".equals(methodName)) {
                    return TemporalYearMethod3.class;
                }
            } else if ("java.time.YearMonth".equals(className)) {
                if ("getMonthValue".equals(methodName)) {
                    return TemporalMonthMethod3.class;
                }
                if ("getYear".equals(methodName)) {
                    return TemporalYearMethod3.class;
                }
            }
        }
        return super.getSQLMethodClass(className, methodName, clr);
    }

    @Override
    protected void loadDatastoreMappings(PluginManager mgr, ClassLoaderResolver clr) {
        this.registerDatastoreMapping(Boolean.class.getName(), BitRDBMSMapping.class, JDBCType.BIT, "BIT", true);
        this.registerDatastoreMapping(Boolean.class.getName(), CharRDBMSMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerDatastoreMapping(Boolean.class.getName(), BooleanRDBMSMapping.class, JDBCType.BOOLEAN, "BOOLEAN", false);
        this.registerDatastoreMapping(Boolean.class.getName(), BooleanRDBMSMapping.class, JDBCType.TINYINT, "TINYINT", false);
        this.registerDatastoreMapping(Boolean.class.getName(), SmallIntRDBMSMapping.class, JDBCType.SMALLINT, "SMALLINT", false);
        this.registerDatastoreMapping(Byte.class.getName(), TinyIntRDBMSMapping.class, JDBCType.TINYINT, "TINYINT", true);
        this.registerDatastoreMapping(Byte.class.getName(), SmallIntRDBMSMapping.class, JDBCType.SMALLINT, "SMALLINT", false);
        this.registerDatastoreMapping(Character.class.getName(), CharRDBMSMapping.class, JDBCType.CHAR, "CHAR", true);
        this.registerDatastoreMapping(Character.class.getName(), IntegerRDBMSMapping.class, JDBCType.INTEGER, "INTEGER", false);
        this.registerDatastoreMapping(Double.class.getName(), DoubleRDBMSMapping.class, JDBCType.DOUBLE, "DOUBLE", true);
        this.registerDatastoreMapping(Float.class.getName(), DoubleRDBMSMapping.class, JDBCType.DOUBLE, "DOUBLE", false);
        this.registerDatastoreMapping(Float.class.getName(), RealRDBMSMapping.class, JDBCType.REAL, "REAL", false);
        this.registerDatastoreMapping(Float.class.getName(), DoubleRDBMSMapping.class, JDBCType.DOUBLE, "DOUBLE", true);
        this.registerDatastoreMapping(Integer.class.getName(), IntegerRDBMSMapping.class, JDBCType.INTEGER, "INTEGER", true);
        this.registerDatastoreMapping(Integer.class.getName(), BigIntRDBMSMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerDatastoreMapping(Integer.class.getName(), NumericRDBMSMapping.class, JDBCType.NUMERIC, "NUMERIC", false);
        this.registerDatastoreMapping(Integer.class.getName(), TinyIntRDBMSMapping.class, JDBCType.TINYINT, "TINYINT", false);
        this.registerDatastoreMapping(Integer.class.getName(), SmallIntRDBMSMapping.class, JDBCType.SMALLINT, "SMALLINT", false);
        this.registerDatastoreMapping(Long.class.getName(), BigIntRDBMSMapping.class, JDBCType.BIGINT, "BIGINT", true);
        this.registerDatastoreMapping(Long.class.getName(), IntegerRDBMSMapping.class, JDBCType.INTEGER, "INT", false);
        this.registerDatastoreMapping(Long.class.getName(), NumericRDBMSMapping.class, JDBCType.NUMERIC, "NUMERIC", false);
        this.registerDatastoreMapping(Long.class.getName(), TinyIntRDBMSMapping.class, JDBCType.TINYINT, "TINYINT", false);
        this.registerDatastoreMapping(Long.class.getName(), SmallIntRDBMSMapping.class, JDBCType.SMALLINT, "SMALLINT", false);
        this.registerDatastoreMapping(Short.class.getName(), SmallIntRDBMSMapping.class, JDBCType.SMALLINT, "SMALLINT", true);
        this.registerDatastoreMapping(Short.class.getName(), IntegerRDBMSMapping.class, JDBCType.INTEGER, "INTEGER", false);
        this.registerDatastoreMapping(Short.class.getName(), TinyIntRDBMSMapping.class, JDBCType.TINYINT, "TINYINT", false);
        this.registerDatastoreMapping(String.class.getName(), VarCharRDBMSMapping.class, JDBCType.VARCHAR, "VARCHAR", true);
        this.registerDatastoreMapping(String.class.getName(), CharRDBMSMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerDatastoreMapping(String.class.getName(), BigIntRDBMSMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerDatastoreMapping(String.class.getName(), LongVarcharRDBMSMapping.class, JDBCType.LONGVARCHAR, "LONGVARCHAR", false);
        this.registerDatastoreMapping(String.class.getName(), ClobRDBMSMapping.class, JDBCType.CLOB, "CLOB", false);
        this.registerDatastoreMapping(String.class.getName(), BlobRDBMSMapping.class, JDBCType.BLOB, "BLOB", false);
        this.registerDatastoreMapping(String.class.getName(), SqlXmlRDBMSMapping.class, JDBCType.SQLXML, "SQLXML", false);
        this.registerDatastoreMapping(String.class.getName(), NVarcharRDBMSMapping.class, JDBCType.NVARCHAR, "NVARCHAR", false);
        this.registerDatastoreMapping(String.class.getName(), NCharRDBMSMapping.class, JDBCType.NCHAR, "NCHAR", false);
        this.registerDatastoreMapping(BigDecimal.class.getName(), NumericRDBMSMapping.class, JDBCType.NUMERIC, "NUMERIC", true);
        this.registerDatastoreMapping(BigInteger.class.getName(), NumericRDBMSMapping.class, JDBCType.NUMERIC, "NUMERIC", true);
        this.registerDatastoreMapping(Date.class.getName(), DateRDBMSMapping.class, JDBCType.DATE, "DATE", true);
        this.registerDatastoreMapping(Date.class.getName(), TimestampRDBMSMapping.class, JDBCType.TIMESTAMP, "TIMESTAMP", false);
        this.registerDatastoreMapping(Date.class.getName(), CharRDBMSMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerDatastoreMapping(Date.class.getName(), VarCharRDBMSMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        this.registerDatastoreMapping(Date.class.getName(), BigIntRDBMSMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerDatastoreMapping(Time.class.getName(), TimeRDBMSMapping.class, JDBCType.TIME, "TIME", true);
        this.registerDatastoreMapping(Time.class.getName(), TimestampRDBMSMapping.class, JDBCType.TIMESTAMP, "TIMESTAMP", false);
        this.registerDatastoreMapping(Time.class.getName(), CharRDBMSMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerDatastoreMapping(Time.class.getName(), VarCharRDBMSMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        this.registerDatastoreMapping(Time.class.getName(), BigIntRDBMSMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerDatastoreMapping(Timestamp.class.getName(), TimestampRDBMSMapping.class, JDBCType.TIMESTAMP, "TIMESTAMP", true);
        this.registerDatastoreMapping(Timestamp.class.getName(), CharRDBMSMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerDatastoreMapping(Timestamp.class.getName(), VarCharRDBMSMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        this.registerDatastoreMapping(Timestamp.class.getName(), DateRDBMSMapping.class, JDBCType.DATE, "DATE", false);
        this.registerDatastoreMapping(Timestamp.class.getName(), TimeRDBMSMapping.class, JDBCType.TIME, "TIME", false);
        this.registerDatastoreMapping(java.util.Date.class.getName(), TimestampRDBMSMapping.class, JDBCType.TIMESTAMP, "TIMESTAMP", true);
        this.registerDatastoreMapping(java.util.Date.class.getName(), DateRDBMSMapping.class, JDBCType.DATE, "DATE", false);
        this.registerDatastoreMapping(java.util.Date.class.getName(), CharRDBMSMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerDatastoreMapping(java.util.Date.class.getName(), VarCharRDBMSMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        this.registerDatastoreMapping(java.util.Date.class.getName(), TimeRDBMSMapping.class, JDBCType.TIME, "TIME", false);
        this.registerDatastoreMapping(java.util.Date.class.getName(), BigIntRDBMSMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerDatastoreMapping(UUID.class.getName(), OtherRDBMSMapping.class, JDBCType.OTHER, "UUID", false);
        this.registerDatastoreMapping(Collection.class.getName(), ArrayRDBMSMapping.class, JDBCType.ARRAY, "TEXT ARRAY", false);
        this.registerDatastoreMapping(Collection.class.getName(), ArrayRDBMSMapping.class, JDBCType.ARRAY, "INT ARRAY", false);
        this.registerDatastoreMapping(Serializable.class.getName(), LongVarBinaryRDBMSMapping.class, JDBCType.LONGVARBINARY, "LONGVARBINARY", true);
        this.registerDatastoreMapping(Serializable.class.getName(), BlobRDBMSMapping.class, JDBCType.BLOB, "BLOB", false);
        this.registerDatastoreMapping(byte[].class.getName(), LongVarBinaryRDBMSMapping.class, JDBCType.LONGVARBINARY, "LONGVARBINARY", true);
        this.registerDatastoreMapping(byte[].class.getName(), BlobRDBMSMapping.class, JDBCType.BLOB, "BLOB", false);
        this.registerDatastoreMapping(File.class.getName(), BinaryStreamRDBMSMapping.class, JDBCType.LONGVARBINARY, "LONGVARBINARY", true);
        this.registerDatastoreMapping(DatastoreId.class.getName(), BigIntRDBMSMapping.class, JDBCType.BIGINT, "BIGINT", true);
        this.registerDatastoreMapping(DatastoreId.class.getName(), IntegerRDBMSMapping.class, JDBCType.INTEGER, "INTEGER", false);
        this.registerDatastoreMapping(DatastoreId.class.getName(), NumericRDBMSMapping.class, JDBCType.NUMERIC, "NUMERIC", false);
        this.registerDatastoreMapping(DatastoreId.class.getName(), CharRDBMSMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerDatastoreMapping(DatastoreId.class.getName(), VarCharRDBMSMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        super.loadDatastoreMappings(mgr, clr);
    }
}

