/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.lang.reflect.Modifier;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.CollectionMetaData;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.rdbms.JDBCUtils;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.mapping.datastore.AbstractDatastoreMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.scostore.BackingStoreHelper;
import org.datanucleus.store.rdbms.scostore.BaseContainerStore;
import org.datanucleus.store.rdbms.scostore.ComponentInfo;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.store.schema.table.SurrogateColumnType;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public abstract class ElementContainerStore
extends BaseContainerStore {
    protected boolean iterateUsingDiscriminator = false;
    protected String sizeStmt;
    protected String clearStmt;
    protected String addStmt;
    protected String removeStmt;
    protected ComponentInfo[] elementInfo;
    protected AbstractClassMetaData elementCmd;
    protected Table containerTable;
    protected JavaTypeMapping elementMapping;
    protected String elementType;
    protected boolean elementsAreEmbedded;
    protected boolean elementsAreSerialised;
    protected boolean elementIsPersistentInterface = false;
    protected JavaTypeMapping orderMapping;
    protected JavaTypeMapping relationDiscriminatorMapping;
    protected String relationDiscriminatorValue;

    protected ElementContainerStore(RDBMSStoreManager storeMgr, ClassLoaderResolver clr) {
        super(storeMgr, clr);
    }

    public JavaTypeMapping getElementMapping() {
        return this.elementMapping;
    }

    public JavaTypeMapping getRelationDiscriminatorMapping() {
        return this.relationDiscriminatorMapping;
    }

    public String getRelationDiscriminatorValue() {
        return this.relationDiscriminatorValue;
    }

    public Table getContainerTable() {
        return this.containerTable;
    }

    public AbstractClassMetaData getElementClassMetaData() {
        return this.elementCmd;
    }

    public boolean isElementsAreSerialised() {
        return this.elementsAreSerialised;
    }

    public boolean isElementsAreEmbedded() {
        return this.elementsAreEmbedded;
    }

    public boolean hasOrderMapping() {
        return this.orderMapping != null;
    }

    protected boolean validateElementType(ClassLoaderResolver clr, Object element) {
        String[] clsNames;
        if (element == null) {
            return true;
        }
        Class primitiveElementClass = ClassUtils.getPrimitiveTypeForType(element.getClass());
        if (primitiveElementClass != null) {
            String elementTypeWrapper = this.elementType;
            Class elementTypeClass = clr.classForName(this.elementType);
            if (elementTypeClass.isPrimitive()) {
                elementTypeWrapper = ClassUtils.getWrapperTypeForPrimitiveType((Class)elementTypeClass).getName();
            }
            return clr.isAssignableFrom(elementTypeWrapper, element.getClass());
        }
        String elementType = null;
        elementType = this.ownerMemberMetaData.hasCollection() ? this.ownerMemberMetaData.getCollection().getElementType() : (this.ownerMemberMetaData.hasArray() ? this.ownerMemberMetaData.getArray().getElementType() : this.elementType);
        Class elementCls = clr.classForName(elementType);
        if (!this.storeMgr.getNucleusContext().getMetaDataManager().isPersistentInterface(elementType) && elementCls.isInterface() && (clsNames = this.storeMgr.getNucleusContext().getMetaDataManager().getClassesImplementingInterface(elementType, clr)) != null && clsNames.length > 0) {
            for (int i = 0; i < clsNames.length; ++i) {
                if (!clsNames[i].equals(element.getClass().getName())) continue;
                return true;
            }
            return false;
        }
        return clr.isAssignableFrom(elementType, element.getClass());
    }

    protected boolean validateElementForReading(ObjectProvider op, Object element) {
        ExecutionContext ec;
        if (!this.validateElementType(op.getExecutionContext().getClassLoaderResolver(), element)) {
            return false;
        }
        return element == null || this.elementsAreEmbedded || this.elementsAreSerialised || (ec = op.getExecutionContext()).getApiAdapter().isPersistent(element) && ec == ec.getApiAdapter().getExecutionContext(element) || ec.getApiAdapter().isDetached(element);
    }

    protected boolean validateElementForWriting(ExecutionContext ec, Object element, FieldValues fieldValues) {
        if (!this.elementIsPersistentInterface && !this.validateElementType(ec.getClassLoaderResolver(), element)) {
            throw new ClassCastException(Localiser.msg((String)"056033", (Object[])new Object[]{element.getClass().getName(), this.ownerMemberMetaData.getFullFieldName(), this.elementType}));
        }
        boolean persisted = false;
        if (!this.elementsAreEmbedded && !this.elementsAreSerialised) {
            ObjectProvider elementSM = ec.findObjectProvider(element);
            if (elementSM != null && elementSM.isEmbedded()) {
                throw new NucleusUserException(Localiser.msg((String)"056028", (Object[])new Object[]{this.ownerMemberMetaData.getFullFieldName(), element}));
            }
            persisted = SCOUtils.validateObjectForWriting((ExecutionContext)ec, (Object)element, (FieldValues)fieldValues);
        }
        return persisted;
    }

    public abstract Iterator iterator(ObjectProvider var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(ObjectProvider ownerOP) {
        boolean elementSoftDelete;
        HashSet dependentElements = null;
        CollectionMetaData collmd = this.ownerMemberMetaData.getCollection();
        boolean dependent = collmd.isDependentElement();
        if (this.ownerMemberMetaData.isCascadeRemoveOrphans()) {
            dependent = true;
        }
        if (dependent && !collmd.isEmbeddedElement() && !collmd.isSerializedElement()) {
            dependentElements = new HashSet();
            Iterator iter = this.iterator(ownerOP);
            while (iter.hasNext()) {
                dependentElements.add(iter.next());
            }
        }
        boolean ownerSoftDelete = ownerOP.getClassMetaData().hasExtension("softdelete");
        boolean bl = elementSoftDelete = this.elementInfo != null ? this.elementInfo[0].cmd.hasExtension("softdelete") : false;
        if (!(ownerSoftDelete && elementSoftDelete || !dependent && ownerSoftDelete)) {
            String clearStmt = this.getClearStmt();
            try {
                ExecutionContext ec = ownerOP.getExecutionContext();
                ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec);
                SQLController sqlControl = this.storeMgr.getSQLController();
                try {
                    PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, clearStmt, false);
                    try {
                        int jdbcPosition = 1;
                        jdbcPosition = BackingStoreHelper.populateOwnerInStatement(ownerOP, ec, ps, jdbcPosition, this);
                        if (this.relationDiscriminatorMapping != null) {
                            BackingStoreHelper.populateRelationDiscriminatorInStatement(ec, ps, jdbcPosition, this);
                        }
                        sqlControl.executeStatementUpdate(ec, mconn, clearStmt, ps, true);
                    }
                    finally {
                        sqlControl.closeStatement(mconn, ps);
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (SQLException e) {
                throw new NucleusDataStoreException(Localiser.msg((String)"056013", (Object[])new Object[]{clearStmt}), (Throwable)e);
            }
        }
        if (dependentElements != null && dependentElements.size() > 0) {
            for (Object obj : dependentElements) {
                if (ownerOP.getExecutionContext().getApiAdapter().isDeleted(obj)) continue;
                ownerOP.getExecutionContext().deleteObjectInternal(obj);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getClearStmt() {
        if (this.clearStmt == null) {
            ElementContainerStore elementContainerStore = this;
            synchronized (elementContainerStore) {
                StringBuilder stmt = new StringBuilder("DELETE FROM ").append(this.containerTable.toString()).append(" WHERE ");
                BackingStoreHelper.appendWhereClauseForMapping(stmt, this.ownerMapping, null, true);
                if (this.getRelationDiscriminatorMapping() != null) {
                    BackingStoreHelper.appendWhereClauseForMapping(stmt, this.relationDiscriminatorMapping, null, false);
                }
                this.clearStmt = stmt.toString();
            }
        }
        return this.clearStmt;
    }

    protected void invalidateAddStmt() {
        this.addStmt = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getAddStmtForJoinTable() {
        if (this.addStmt == null) {
            ElementContainerStore elementContainerStore = this;
            synchronized (elementContainerStore) {
                int i;
                StringBuilder stmt = new StringBuilder("INSERT INTO ");
                stmt.append(this.containerTable.toString());
                stmt.append(" (");
                for (i = 0; i < this.getOwnerMapping().getNumberOfDatastoreMappings(); ++i) {
                    if (i > 0) {
                        stmt.append(",");
                    }
                    stmt.append(this.getOwnerMapping().getDatastoreMapping(i).getColumn().getIdentifier().toString());
                }
                for (i = 0; i < this.elementMapping.getNumberOfDatastoreMappings(); ++i) {
                    stmt.append(",").append(this.elementMapping.getDatastoreMapping(i).getColumn().getIdentifier().toString());
                }
                if (this.orderMapping != null) {
                    for (i = 0; i < this.orderMapping.getNumberOfDatastoreMappings(); ++i) {
                        stmt.append(",").append(this.orderMapping.getDatastoreMapping(i).getColumn().getIdentifier().toString());
                    }
                }
                if (this.relationDiscriminatorMapping != null) {
                    for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreMappings(); ++i) {
                        stmt.append(",").append(this.relationDiscriminatorMapping.getDatastoreMapping(i).getColumn().getIdentifier().toString());
                    }
                }
                stmt.append(") VALUES (");
                for (i = 0; i < this.getOwnerMapping().getNumberOfDatastoreMappings(); ++i) {
                    if (i > 0) {
                        stmt.append(",");
                    }
                    stmt.append(((AbstractDatastoreMapping)this.getOwnerMapping().getDatastoreMapping(i)).getInsertionInputParameter());
                }
                for (i = 0; i < this.elementMapping.getNumberOfDatastoreMappings(); ++i) {
                    stmt.append(",").append(((AbstractDatastoreMapping)this.elementMapping.getDatastoreMapping(0)).getInsertionInputParameter());
                }
                if (this.orderMapping != null) {
                    for (i = 0; i < this.orderMapping.getNumberOfDatastoreMappings(); ++i) {
                        stmt.append(",").append(((AbstractDatastoreMapping)this.orderMapping.getDatastoreMapping(0)).getInsertionInputParameter());
                    }
                }
                if (this.relationDiscriminatorMapping != null) {
                    for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreMappings(); ++i) {
                        stmt.append(",").append(((AbstractDatastoreMapping)this.relationDiscriminatorMapping.getDatastoreMapping(0)).getInsertionInputParameter());
                    }
                }
                stmt.append(") ");
                this.addStmt = stmt.toString();
            }
        }
        return this.addStmt;
    }

    public int size(ObjectProvider op) {
        return this.getSize(op);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize(ObjectProvider ownerOP) {
        int numRows;
        String sizeStmt = this.getSizeStmt();
        try {
            ExecutionContext ec = ownerOP.getExecutionContext();
            ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForQuery(mconn, sizeStmt);
                try {
                    int jdbcPosition = 1;
                    if (this.elementInfo == null) {
                        jdbcPosition = BackingStoreHelper.populateOwnerInStatement(ownerOP, ec, ps, jdbcPosition, this);
                    } else if (this.usingJoinTable()) {
                        jdbcPosition = BackingStoreHelper.populateOwnerInStatement(ownerOP, ec, ps, jdbcPosition, this);
                        if (this.elementInfo[0].getDiscriminatorMapping() != null) {
                            jdbcPosition = BackingStoreHelper.populateElementDiscriminatorInStatement(ec, ps, jdbcPosition, true, this.elementInfo[0], this.clr);
                        }
                        if (this.relationDiscriminatorMapping != null) {
                            jdbcPosition = BackingStoreHelper.populateRelationDiscriminatorInStatement(ec, ps, jdbcPosition, this);
                        }
                    } else {
                        for (int i = 0; i < this.elementInfo.length; ++i) {
                            jdbcPosition = BackingStoreHelper.populateOwnerInStatement(ownerOP, ec, ps, jdbcPosition, this);
                            if (this.elementInfo[i].getDiscriminatorMapping() != null) {
                                jdbcPosition = BackingStoreHelper.populateElementDiscriminatorInStatement(ec, ps, jdbcPosition, true, this.elementInfo[i], this.clr);
                            }
                            if (this.relationDiscriminatorMapping == null) continue;
                            jdbcPosition = BackingStoreHelper.populateRelationDiscriminatorInStatement(ec, ps, jdbcPosition, this);
                        }
                    }
                    try (ResultSet rs = sqlControl.executeStatementQuery(ec, mconn, sizeStmt, ps);){
                        if (!rs.next()) {
                            throw new NucleusDataStoreException(Localiser.msg((String)"056007", (Object[])new Object[]{sizeStmt}));
                        }
                        numRows = rs.getInt(1);
                        if (this.elementInfo != null && this.elementInfo.length > 1) {
                            while (rs.next()) {
                                numRows += rs.getInt(1);
                            }
                        }
                        JDBCUtils.logWarnings(rs);
                    }
                }
                catch (SQLException sqle) {
                    NucleusLogger.GENERAL.error((Object)"Exception in size", (Throwable)sqle);
                    throw sqle;
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"056007", (Object[])new Object[]{sizeStmt}), (Throwable)e);
        }
        return numRows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getSizeStmt() {
        if (this.sizeStmt != null) {
            return this.sizeStmt;
        }
        ElementContainerStore elementContainerStore = this;
        synchronized (elementContainerStore) {
            boolean usingDiscriminatorInSizeStmt = false;
            String containerAlias = "THIS";
            StringBuilder stmt = new StringBuilder();
            if (this.elementInfo == null) {
                JavaTypeMapping softDeleteMapping;
                stmt.append("SELECT COUNT(*) FROM ").append(this.containerTable.toString()).append(" ").append(containerAlias);
                stmt.append(" WHERE ");
                BackingStoreHelper.appendWhereClauseForMapping(stmt, this.ownerMapping, containerAlias, true);
                if (this.orderMapping != null) {
                    for (int i = 0; i < this.orderMapping.getNumberOfDatastoreMappings(); ++i) {
                        stmt.append(" AND ");
                        stmt.append(containerAlias).append(".").append(this.orderMapping.getDatastoreMapping(i).getColumn().getIdentifier().toString());
                        stmt.append(">=0");
                    }
                }
                if ((softDeleteMapping = this.containerTable.getSurrogateMapping(SurrogateColumnType.SOFTDELETE, false)) != null) {
                    stmt.append(" AND ").append(containerAlias).append(".");
                    stmt.append(softDeleteMapping.getDatastoreMapping(0).getColumn().getIdentifier().toString());
                    stmt.append("=FALSE");
                }
                if (this.relationDiscriminatorMapping != null) {
                    BackingStoreHelper.appendWhereClauseForMapping(stmt, this.relationDiscriminatorMapping, containerAlias, false);
                }
                this.sizeStmt = stmt.toString();
                return this.sizeStmt;
            }
            if (this.usingJoinTable()) {
                JavaTypeMapping softDeleteMapping;
                String joinedElementAlias = "ELEM";
                ComponentInfo elemInfo = this.elementInfo[0];
                stmt.append("SELECT COUNT(*) FROM ").append(this.containerTable.toString()).append(" ").append(containerAlias);
                boolean joinedDiscrim = false;
                if (elemInfo.getDiscriminatorMapping() != null) {
                    joinedDiscrim = true;
                    JavaTypeMapping elemIdMapping = elemInfo.getDatastoreClass().getIdMapping();
                    stmt.append(this.allowNulls ? " LEFT OUTER JOIN " : " INNER JOIN ");
                    stmt.append(elemInfo.getDatastoreClass().toString()).append(" ").append(joinedElementAlias).append(" ON ");
                    for (int j = 0; j < this.elementMapping.getNumberOfDatastoreMappings(); ++j) {
                        if (j > 0) {
                            stmt.append(" AND ");
                        }
                        stmt.append(containerAlias).append(".").append(this.elementMapping.getDatastoreMapping(j).getColumn().getIdentifier());
                        stmt.append("=");
                        stmt.append(joinedElementAlias).append(".").append(elemIdMapping.getDatastoreMapping(j).getColumn().getIdentifier());
                    }
                }
                stmt.append(" WHERE ");
                BackingStoreHelper.appendWhereClauseForMapping(stmt, this.ownerMapping, containerAlias, true);
                if (this.orderMapping != null) {
                    for (int j = 0; j < this.orderMapping.getNumberOfDatastoreMappings(); ++j) {
                        stmt.append(" AND ");
                        stmt.append(containerAlias).append(".").append(this.orderMapping.getDatastoreMapping(j).getColumn().getIdentifier().toString());
                        stmt.append(">=0");
                    }
                }
                if ((softDeleteMapping = this.containerTable.getSurrogateMapping(SurrogateColumnType.SOFTDELETE, false)) != null) {
                    stmt.append(" AND ").append(containerAlias).append(".");
                    stmt.append(softDeleteMapping.getDatastoreMapping(0).getColumn().getIdentifier().toString());
                    stmt.append("=FALSE");
                }
                StringBuilder discrStmt = new StringBuilder();
                if (elemInfo.getDiscriminatorMapping() != null) {
                    usingDiscriminatorInSizeStmt = true;
                    JavaTypeMapping discrimMapping = elemInfo.getDiscriminatorMapping();
                    Collection classNames = this.storeMgr.getSubClassesForClass(elemInfo.getClassName(), true, this.clr);
                    classNames.add(elemInfo.getClassName());
                    for (String className : classNames) {
                        Class cls = this.clr.classForName(className);
                        if (Modifier.isAbstract(cls.getModifiers())) continue;
                        for (int j = 0; j < discrimMapping.getNumberOfDatastoreMappings(); ++j) {
                            if (discrStmt.length() > 0) {
                                discrStmt.append(" OR ");
                            }
                            discrStmt.append(joinedDiscrim ? joinedElementAlias : containerAlias);
                            discrStmt.append(".");
                            discrStmt.append(discrimMapping.getDatastoreMapping(j).getColumn().getIdentifier().toString());
                            discrStmt.append("=");
                            discrStmt.append(((AbstractDatastoreMapping)discrimMapping.getDatastoreMapping(j)).getUpdateInputParameter());
                        }
                    }
                }
                if (discrStmt.length() > 0) {
                    stmt.append(" AND (");
                    stmt.append((CharSequence)discrStmt);
                    if (this.allowNulls) {
                        stmt.append(" OR ");
                        stmt.append(elemInfo.getDiscriminatorMapping().getDatastoreMapping(0).getColumn().getIdentifier().toString());
                        stmt.append(" IS NULL");
                    }
                    stmt.append(")");
                }
                if (this.relationDiscriminatorMapping != null) {
                    BackingStoreHelper.appendWhereClauseForMapping(stmt, this.relationDiscriminatorMapping, containerAlias, false);
                }
            } else {
                for (int i = 0; i < this.elementInfo.length; ++i) {
                    JavaTypeMapping softDeleteMapping;
                    if (i > 0) {
                        stmt.append(" UNION ");
                    }
                    ComponentInfo elemInfo = this.elementInfo[i];
                    stmt.append("SELECT COUNT(*),").append("'" + elemInfo.getAbstractClassMetaData().getName() + "'");
                    stmt.append(" FROM ").append(elemInfo.getDatastoreClass().toString()).append(" ").append(containerAlias);
                    stmt.append(" WHERE ");
                    BackingStoreHelper.appendWhereClauseForMapping(stmt, this.ownerMapping, containerAlias, true);
                    if (this.orderMapping != null) {
                        for (int j = 0; j < this.orderMapping.getNumberOfDatastoreMappings(); ++j) {
                            stmt.append(" AND ");
                            stmt.append(containerAlias).append(".").append(this.orderMapping.getDatastoreMapping(j).getColumn().getIdentifier().toString());
                            stmt.append(">=0");
                        }
                    }
                    if ((softDeleteMapping = this.containerTable.getSurrogateMapping(SurrogateColumnType.SOFTDELETE, false)) != null) {
                        stmt.append(" AND ").append(containerAlias).append(".");
                        stmt.append(softDeleteMapping.getDatastoreMapping(0).getColumn().getIdentifier().toString());
                        stmt.append("=FALSE");
                    }
                    StringBuilder discrStmt = new StringBuilder();
                    if (elemInfo.getDiscriminatorMapping() != null) {
                        usingDiscriminatorInSizeStmt = true;
                        JavaTypeMapping discrimMapping = elemInfo.getDiscriminatorMapping();
                        Collection classNames = this.storeMgr.getSubClassesForClass(elemInfo.getClassName(), true, this.clr);
                        classNames.add(elemInfo.getClassName());
                        for (String className : classNames) {
                            Class cls = this.clr.classForName(className);
                            if (Modifier.isAbstract(cls.getModifiers())) continue;
                            for (int j = 0; j < discrimMapping.getNumberOfDatastoreMappings(); ++j) {
                                if (discrStmt.length() > 0) {
                                    discrStmt.append(" OR ");
                                }
                                discrStmt.append(containerAlias).append(".").append(discrimMapping.getDatastoreMapping(j).getColumn().getIdentifier().toString());
                                discrStmt.append("=");
                                discrStmt.append(((AbstractDatastoreMapping)discrimMapping.getDatastoreMapping(j)).getUpdateInputParameter());
                            }
                        }
                    }
                    if (discrStmt.length() > 0) {
                        stmt.append(" AND (");
                        stmt.append((CharSequence)discrStmt);
                        if (this.allowNulls) {
                            stmt.append(" OR ");
                            stmt.append(elemInfo.getDiscriminatorMapping().getDatastoreMapping(0).getColumn().getIdentifier().toString());
                            stmt.append(" IS NULL");
                        }
                        stmt.append(")");
                    }
                    if (this.relationDiscriminatorMapping == null) continue;
                    BackingStoreHelper.appendWhereClauseForMapping(stmt, this.relationDiscriminatorMapping, containerAlias, false);
                }
            }
            if (!usingDiscriminatorInSizeStmt) {
                this.sizeStmt = stmt.toString();
            }
            return stmt.toString();
        }
    }

    protected ComponentInfo getComponentInfoForElement(Object element) {
        if (this.elementInfo == null) {
            return null;
        }
        ComponentInfo elemInfo = null;
        for (int i = 0; i < this.elementInfo.length; ++i) {
            if (!this.elementInfo[i].getClassName().equals(element.getClass().getName())) continue;
            elemInfo = this.elementInfo[i];
            break;
        }
        if (elemInfo == null) {
            Class<?> elementCls = element.getClass();
            for (int i = 0; i < this.elementInfo.length; ++i) {
                Class elemInfoCls = this.clr.classForName(this.elementInfo[i].getClassName());
                if (!elemInfoCls.isAssignableFrom(elementCls)) continue;
                elemInfo = this.elementInfo[i];
                break;
            }
        }
        return elemInfo;
    }

    protected boolean usingJoinTable() {
        return this.elementInfo == null || this.elementInfo[0].getDatastoreClass() != this.containerTable;
    }
}

