/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.metadata.CollectionMetaData;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.rdbms.JDBCUtils;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.exceptions.MappedDatastoreException;
import org.datanucleus.store.rdbms.mapping.datastore.AbstractDatastoreMapping;
import org.datanucleus.store.rdbms.mapping.java.ReferenceMapping;
import org.datanucleus.store.rdbms.scostore.AbstractCollectionStore;
import org.datanucleus.store.rdbms.scostore.BackingStoreHelper;
import org.datanucleus.store.types.scostore.ListStore;
import org.datanucleus.util.Localiser;

public abstract class AbstractListStore<E>
extends AbstractCollectionStore<E>
implements ListStore<E> {
    protected boolean indexedList = true;
    protected String indexOfStmt;
    protected String lastIndexOfStmt;
    protected String removeAtStmt;
    protected String shiftStmt;

    protected AbstractListStore(RDBMSStoreManager storeMgr, ClassLoaderResolver clr) {
        super(storeMgr, clr);
    }

    @Override
    public Iterator<E> iterator(ObjectProvider op) {
        return this.listIterator(op);
    }

    public ListIterator<E> listIterator(ObjectProvider op) {
        return this.listIterator(op, -1, -1);
    }

    protected abstract ListIterator<E> listIterator(ObjectProvider var1, int var2, int var3);

    public boolean add(ObjectProvider op, E element, int size) {
        return this.internalAdd(op, 0, true, Collections.singleton(element), size);
    }

    public void add(ObjectProvider op, E element, int index, int size) {
        this.internalAdd(op, index, false, Collections.singleton(element), size);
    }

    public boolean addAll(ObjectProvider op, Collection<E> elements, int size) {
        return this.internalAdd(op, 0, true, elements, size);
    }

    public boolean addAll(ObjectProvider op, Collection<E> elements, int index, int size) {
        return this.internalAdd(op, index, false, elements, size);
    }

    protected abstract boolean internalAdd(ObjectProvider var1, int var2, boolean var3, Collection<E> var4, int var5);

    public E get(ObjectProvider op, int index) {
        ListIterator<E> iter = this.listIterator(op, index, index);
        if (iter == null || !iter.hasNext()) {
            return null;
        }
        if (!this.indexedList) {
            E obj = null;
            int position = 0;
            while (iter.hasNext()) {
                obj = iter.next();
                if (position == index) {
                    return obj;
                }
                ++position;
            }
        }
        return iter.next();
    }

    public int indexOf(ObjectProvider op, Object element) {
        this.validateElementForReading(op, element);
        return this.internalIndexOf(op, element, this.getIndexOfStmt(element));
    }

    public int lastIndexOf(ObjectProvider op, Object element) {
        this.validateElementForReading(op, element);
        return this.internalIndexOf(op, element, this.getLastIndexOfStmt(element));
    }

    public boolean remove(ObjectProvider op, Object element, int size, boolean allowDependentField) {
        if (!this.validateElementForReading(op, element)) {
            return false;
        }
        Object elementToRemove = element;
        ExecutionContext ec = op.getExecutionContext();
        if (ec.getApiAdapter().isDetached(element)) {
            elementToRemove = ec.findObject(ec.getApiAdapter().getIdForObject(element), true, false, element.getClass().getName());
        }
        boolean modified = this.internalRemove(op, elementToRemove, size);
        if (allowDependentField) {
            CollectionMetaData collmd = this.ownerMemberMetaData.getCollection();
            boolean dependent = collmd.isDependentElement();
            if (this.ownerMemberMetaData.isCascadeRemoveOrphans()) {
                dependent = true;
            }
            if (dependent && !collmd.isEmbeddedElement()) {
                op.getExecutionContext().deleteObjectInternal(elementToRemove);
            }
        }
        return modified;
    }

    public E remove(ObjectProvider op, int index, int size) {
        E element = this.get(op, index);
        if (this.indexedList) {
            this.internalRemoveAt(op, index, size);
        } else {
            this.internalRemove(op, element, size);
        }
        CollectionMetaData collmd = this.ownerMemberMetaData.getCollection();
        boolean dependent = collmd.isDependentElement();
        if (this.ownerMemberMetaData.isCascadeRemoveOrphans()) {
            dependent = true;
        }
        if (dependent && !collmd.isEmbeddedElement() && !this.contains(op, element)) {
            op.getExecutionContext().deleteObjectInternal(element);
        }
        return element;
    }

    protected abstract boolean internalRemove(ObjectProvider var1, Object var2, int var3);

    protected abstract void internalRemoveAt(ObjectProvider var1, int var2, int var3);

    public List<E> subList(ObjectProvider op, int startIdx, int endIdx) {
        ListIterator<E> iter = this.listIterator(op, startIdx, endIdx);
        ArrayList<E> list = new ArrayList<E>();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        if (!this.indexedList && list.size() > endIdx - startIdx) {
            return list.subList(startIdx, endIdx);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    protected int[] getIndicesOf(ObjectProvider op, Collection elements) {
        if (elements == null || elements.isEmpty()) {
            return null;
        }
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            this.validateElementForReading(op, iter.next());
        }
        String stmt = this.getIndicesOfStmt(elements);
        try {
            ExecutionContext ec = op.getExecutionContext();
            ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                Object object;
                ArrayList<Integer> indexes;
                PreparedStatement ps;
                block19: {
                    ps = sqlControl.getStatementForUpdate(mconn, stmt, false);
                    Iterator elemIter = elements.iterator();
                    int jdbcPosition = 1;
                    while (elemIter.hasNext()) {
                        Object element = elemIter.next();
                        jdbcPosition = BackingStoreHelper.populateOwnerInStatement(op, ec, ps, jdbcPosition, this);
                        jdbcPosition = BackingStoreHelper.populateElementForWhereClauseInStatement(ec, ps, element, jdbcPosition, this.elementMapping);
                        if (this.relationDiscriminatorMapping == null) continue;
                        jdbcPosition = BackingStoreHelper.populateRelationDiscriminatorInStatement(ec, ps, jdbcPosition, this);
                    }
                    indexes = new ArrayList<Integer>();
                    try (ResultSet rs = sqlControl.executeStatementQuery(ec, mconn, stmt, ps);){
                        while (rs.next()) {
                            indexes.add(rs.getInt(1));
                        }
                        JDBCUtils.logWarnings(rs);
                    }
                    if (!indexes.isEmpty()) break block19;
                    int[] nArray = null;
                    sqlControl.closeStatement(mconn, ps);
                    return nArray;
                }
                try {
                    int i = 0;
                    int[] indicesReturn = new int[indexes.size()];
                    for (Integer idx : indexes) {
                        indicesReturn[i++] = idx;
                    }
                    object = indicesReturn;
                }
                catch (Throwable throwable) {
                    sqlControl.closeStatement(mconn, ps);
                    throw throwable;
                }
                sqlControl.closeStatement(mconn, ps);
                return object;
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"056017", (Object[])new Object[]{stmt}), (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    protected int internalIndexOf(ObjectProvider op, Object element, String stmt) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalRemoveAt(ObjectProvider op, int index, String stmt, int size) {
        int currentListSize = 0;
        currentListSize = size < 0 ? this.size(op) : size;
        ExecutionContext ec = op.getExecutionContext();
        try {
            ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, stmt, false);
                try {
                    int[] rowsDeleted;
                    int jdbcPosition = 1;
                    jdbcPosition = BackingStoreHelper.populateOwnerInStatement(op, ec, ps, jdbcPosition, this);
                    jdbcPosition = BackingStoreHelper.populateOrderInStatement(ec, ps, index, jdbcPosition, this.orderMapping);
                    if (this.relationDiscriminatorMapping != null) {
                        jdbcPosition = BackingStoreHelper.populateRelationDiscriminatorInStatement(ec, ps, jdbcPosition, this);
                    }
                    if ((rowsDeleted = sqlControl.executeStatementUpdate(ec, mconn, stmt, ps, true))[0] == 0) {
                        // empty if block
                    }
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
                if (index != currentListSize - 1) {
                    for (int i = index + 1; i < currentListSize; ++i) {
                        this.internalShift(op, mconn, false, i, -1, true);
                    }
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"056012", (Object[])new Object[]{stmt}), (Throwable)e);
        }
        catch (MappedDatastoreException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"056012", (Object[])new Object[]{stmt}), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int[] internalShift(ObjectProvider op, ManagedConnection conn, boolean batched, int oldIndex, int amount, boolean executeNow) throws MappedDatastoreException {
        int[] nArray;
        ExecutionContext ec = op.getExecutionContext();
        SQLController sqlControl = this.storeMgr.getSQLController();
        String shiftStmt = this.getShiftStmt();
        PreparedStatement ps = sqlControl.getStatementForUpdate(conn, shiftStmt, batched);
        try {
            int jdbcPosition = 1;
            jdbcPosition = BackingStoreHelper.populateOrderInStatement(ec, ps, amount, jdbcPosition, this.orderMapping);
            jdbcPosition = BackingStoreHelper.populateOwnerInStatement(op, ec, ps, jdbcPosition, this);
            jdbcPosition = BackingStoreHelper.populateOrderInStatement(ec, ps, oldIndex, jdbcPosition, this.orderMapping);
            if (this.relationDiscriminatorMapping != null) {
                jdbcPosition = BackingStoreHelper.populateRelationDiscriminatorInStatement(ec, ps, jdbcPosition, this);
            }
            nArray = sqlControl.executeStatementUpdate(ec, conn, shiftStmt, ps, executeNow);
        }
        catch (Throwable throwable) {
            try {
                sqlControl.closeStatement(conn, ps);
                throw throwable;
            }
            catch (SQLException sqle) {
                throw new MappedDatastoreException(shiftStmt, sqle);
            }
        }
        sqlControl.closeStatement(conn, ps);
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getIndexOfStmt(Object element) {
        if (this.elementMapping instanceof ReferenceMapping && this.elementMapping.getNumberOfDatastoreMappings() > 1) {
            return this.getIndexOfStatementString(element);
        }
        if (this.indexOfStmt == null) {
            AbstractListStore abstractListStore = this;
            synchronized (abstractListStore) {
                this.indexOfStmt = this.getIndexOfStatementString(element);
            }
        }
        return this.indexOfStmt;
    }

    private String getIndexOfStatementString(Object element) {
        int i;
        StringBuilder stmt = new StringBuilder("SELECT ");
        for (i = 0; i < this.orderMapping.getNumberOfDatastoreMappings(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(this.orderMapping.getDatastoreMapping(i).getColumn().getIdentifier().toString());
        }
        stmt.append(" FROM ").append(this.containerTable.toString()).append(" WHERE ");
        BackingStoreHelper.appendWhereClauseForMapping(stmt, this.ownerMapping, null, true);
        BackingStoreHelper.appendWhereClauseForElement(stmt, this.elementMapping, element, this.isElementsAreSerialised(), null, false);
        if (this.relationDiscriminatorMapping != null) {
            BackingStoreHelper.appendWhereClauseForMapping(stmt, this.relationDiscriminatorMapping, null, false);
        }
        stmt.append(" ORDER BY ");
        for (i = 0; i < this.orderMapping.getNumberOfDatastoreMappings(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(this.orderMapping.getDatastoreMapping(i).getColumn().getIdentifier().toString());
        }
        return stmt.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getLastIndexOfStmt(Object element) {
        if (this.elementMapping instanceof ReferenceMapping && this.elementMapping.getNumberOfDatastoreMappings() > 1) {
            return this.getLastIndexOfStatementString(element);
        }
        if (this.lastIndexOfStmt == null) {
            AbstractListStore abstractListStore = this;
            synchronized (abstractListStore) {
                this.lastIndexOfStmt = this.getLastIndexOfStatementString(element);
            }
        }
        return this.lastIndexOfStmt;
    }

    private String getLastIndexOfStatementString(Object element) {
        int i;
        StringBuilder stmt = new StringBuilder("SELECT ");
        for (i = 0; i < this.orderMapping.getNumberOfDatastoreMappings(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(this.orderMapping.getDatastoreMapping(i).getColumn().getIdentifier().toString());
        }
        stmt.append(" FROM ").append(this.containerTable.toString()).append(" WHERE ");
        BackingStoreHelper.appendWhereClauseForMapping(stmt, this.ownerMapping, null, true);
        BackingStoreHelper.appendWhereClauseForElement(stmt, this.elementMapping, element, this.isElementsAreSerialised(), null, false);
        if (this.relationDiscriminatorMapping != null) {
            BackingStoreHelper.appendWhereClauseForMapping(stmt, this.relationDiscriminatorMapping, null, false);
        }
        stmt.append(" ORDER BY ");
        for (i = 0; i < this.orderMapping.getNumberOfDatastoreMappings(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(this.orderMapping.getDatastoreMapping(i).getColumn().getIdentifier().toString());
            stmt.append(" DESC ");
        }
        return stmt.toString();
    }

    protected String getIndicesOfStmt(Collection elements) {
        StringBuilder stmt = new StringBuilder("SELECT ");
        for (int i = 0; i < this.orderMapping.getNumberOfDatastoreMappings(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(this.orderMapping.getDatastoreMapping(i).getColumn().getIdentifier().toString());
        }
        stmt.append(" FROM ").append(this.containerTable.toString()).append(" WHERE ");
        Iterator iter = elements.iterator();
        boolean first_element = true;
        while (iter.hasNext()) {
            Object element = iter.next();
            stmt.append(first_element ? "(" : " OR (");
            BackingStoreHelper.appendWhereClauseForMapping(stmt, this.ownerMapping, null, true);
            BackingStoreHelper.appendWhereClauseForElement(stmt, this.elementMapping, element, this.isElementsAreSerialised(), null, false);
            if (this.relationDiscriminatorMapping != null) {
                BackingStoreHelper.appendWhereClauseForMapping(stmt, this.relationDiscriminatorMapping, null, false);
            }
            stmt.append(")");
            first_element = false;
        }
        stmt.append(" ORDER BY ");
        for (int i = 0; i < this.orderMapping.getNumberOfDatastoreMappings(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(this.orderMapping.getDatastoreMapping(i).getColumn().getIdentifier().toString()).append(" DESC");
        }
        return stmt.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getRemoveAtStmt() {
        if (this.removeAtStmt == null) {
            AbstractListStore abstractListStore = this;
            synchronized (abstractListStore) {
                StringBuilder stmt = new StringBuilder("DELETE FROM ").append(this.containerTable.toString()).append(" WHERE ");
                BackingStoreHelper.appendWhereClauseForMapping(stmt, this.ownerMapping, null, true);
                if (this.orderMapping != null) {
                    BackingStoreHelper.appendWhereClauseForMapping(stmt, this.orderMapping, null, false);
                }
                if (this.relationDiscriminatorMapping != null) {
                    BackingStoreHelper.appendWhereClauseForMapping(stmt, this.relationDiscriminatorMapping, null, false);
                }
                this.removeAtStmt = stmt.toString();
            }
        }
        return this.removeAtStmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getShiftStmt() {
        if (this.shiftStmt == null) {
            AbstractListStore abstractListStore = this;
            synchronized (abstractListStore) {
                StringBuilder stmt = new StringBuilder("UPDATE ").append(this.containerTable.toString()).append(" SET ");
                for (int i = 0; i < this.orderMapping.getNumberOfDatastoreMappings(); ++i) {
                    if (i > 0) {
                        stmt.append(",");
                    }
                    stmt.append(this.orderMapping.getDatastoreMapping(i).getColumn().getIdentifier().toString());
                    stmt.append(" = ");
                    stmt.append(((AbstractDatastoreMapping)this.orderMapping.getDatastoreMapping(i)).getUpdateInputParameter());
                    stmt.append(" + ");
                    stmt.append(this.orderMapping.getDatastoreMapping(i).getColumn().getIdentifier().toString());
                }
                stmt.append(" WHERE ");
                BackingStoreHelper.appendWhereClauseForMapping(stmt, this.ownerMapping, null, true);
                BackingStoreHelper.appendWhereClauseForMapping(stmt, this.orderMapping, null, false);
                if (this.relationDiscriminatorMapping != null) {
                    BackingStoreHelper.appendWhereClauseForMapping(stmt, this.relationDiscriminatorMapping, null, false);
                }
                this.shiftStmt = stmt.toString();
            }
        }
        return this.shiftStmt;
    }
}

