/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.util.ArrayList;
import java.util.List;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.rdbms.sql.expression.ExpressionUtils;
import org.datanucleus.store.rdbms.sql.expression.NumericExpression;
import org.datanucleus.store.rdbms.sql.expression.ParameterLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.StringExpression;
import org.datanucleus.store.rdbms.sql.method.AbstractSQLMethod;
import org.datanucleus.util.Localiser;

public class StringSubstring4Method
extends AbstractSQLMethod {
    @Override
    public SQLExpression getExpression(SQLExpression expr, List<SQLExpression> args) {
        if (args == null || args.size() == 0 || args.size() > 2) {
            throw new NucleusException(Localiser.msg((String)"060003", (Object[])new Object[]{"substring", "StringExpression", 0, "NumericExpression/IntegerLiteral/ParameterLiteral"}));
        }
        if (args.size() == 1) {
            SQLExpression startExpr = args.get(0);
            if (!(startExpr instanceof NumericExpression) && !(startExpr instanceof ParameterLiteral)) {
                throw new NucleusException(Localiser.msg((String)"060003", (Object[])new Object[]{"substring", "StringExpression", 0, "NumericExpression/IntegerLiteral/ParameterLiteral"}));
            }
            SQLExpression one = ExpressionUtils.getLiteralForOne(this.stmt);
            ArrayList<SQLExpression> lengthFuncArgs = new ArrayList<SQLExpression>();
            lengthFuncArgs.add(expr);
            SQLExpression lengthExpression = new NumericExpression(this.stmt, this.getMappingForClass(Integer.TYPE), "LEN", lengthFuncArgs);
            lengthExpression = ((SQLExpression)lengthExpression).sub(startExpr);
            ArrayList<SQLExpression> funcArgs = new ArrayList<SQLExpression>();
            funcArgs.add(expr);
            funcArgs.add(startExpr.add(one));
            funcArgs.add(lengthExpression);
            StringExpression exp = new StringExpression(this.stmt, this.getMappingForClass(String.class), "SUBSTRING", funcArgs);
            return exp;
        }
        SQLExpression startExpr = args.get(0);
        if (!(startExpr instanceof NumericExpression)) {
            throw new NucleusException(Localiser.msg((String)"060003", (Object[])new Object[]{"substring", "StringExpression", 0, "NumericExpression"}));
        }
        SQLExpression endExpr = args.get(1);
        if (!(endExpr instanceof NumericExpression)) {
            throw new NucleusException(Localiser.msg((String)"060003", (Object[])new Object[]{"substring", "StringExpression", 1, "NumericExpression"}));
        }
        SQLExpression one = ExpressionUtils.getLiteralForOne(this.stmt);
        ArrayList<SQLExpression> funcArgs = new ArrayList<SQLExpression>();
        funcArgs.add(expr);
        funcArgs.add(startExpr.add(one));
        funcArgs.add(endExpr.sub(startExpr));
        return new StringExpression(this.stmt, this.getMappingForClass(String.class), "SUBSTRING", funcArgs);
    }
}

