/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.adapter;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.JdbcType;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.rdbms.adapter.BaseDatastoreAdapter;
import org.datanucleus.store.rdbms.adapter.HSQLTypeInfo;
import org.datanucleus.store.rdbms.identifier.IdentifierFactory;
import org.datanucleus.store.rdbms.identifier.IdentifierType;
import org.datanucleus.store.rdbms.key.PrimaryKey;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.store.schema.StoreSchemaHandler;
import org.datanucleus.util.Localiser;

public class HSQLAdapter
extends BaseDatastoreAdapter {
    public HSQLAdapter(DatabaseMetaData metadata) {
        super(metadata);
        this.supportedOptions.add("PrimaryKeyInCreateStatements");
        this.supportedOptions.add("IdentityColumns");
        this.supportedOptions.add("Sequences");
        this.supportedOptions.add("UniqueInEndCreateStatements");
        if (this.datastoreMajorVersion < 2) {
            this.supportedOptions.remove("StatementBatching");
            this.supportedOptions.remove("GetGeneratedKeysStatement");
        }
        this.supportedOptions.remove("DeferredConstraints");
        this.supportedOptions.remove("CheckInCreateStatements");
        this.supportedOptions.remove("AutoIncrementNullSpecification");
        if (this.datastoreMajorVersion >= 2) {
            this.supportedOptions.add("LockWithSelectForUpdate");
            this.supportedOptions.add("OrderByWithNullsDirectives");
        }
        if (this.datastoreMajorVersion < 1 || this.datastoreMajorVersion == 1 && this.datastoreMinorVersion < 7 || this.datastoreMajorVersion == 1 && this.datastoreMinorVersion == 7 && this.datastoreRevisionVersion < 2) {
            this.supportedOptions.remove("CheckInEndCreateStatements");
        } else {
            this.supportedOptions.add("CheckInEndCreateStatements");
        }
        this.supportedOptions.remove("AccessParentQueryInSubquery");
        this.supportedOptions.remove("SubqueryInHaving");
        if (this.datastoreMajorVersion < 1 || this.datastoreMajorVersion == 1 && this.datastoreMinorVersion < 7) {
            this.supportedOptions.remove("FkDeleteActionCascade");
            this.supportedOptions.remove("FkDeleteActionRestrict");
            this.supportedOptions.remove("FkDeleteActionDefault");
            this.supportedOptions.remove("FkDeleteActionNull");
            this.supportedOptions.remove("FkUpdateActionCascade");
            this.supportedOptions.remove("FkUpdateActionRestrict");
            this.supportedOptions.remove("FkUpdateActionDefault");
            this.supportedOptions.remove("FkUpdateActionNull");
        } else if (this.datastoreMajorVersion < 2) {
            this.supportedOptions.remove("FkDeleteActionRestrict");
            this.supportedOptions.remove("FkUpdateActionRestrict");
        }
        if (this.datastoreMajorVersion < 2) {
            this.supportedOptions.remove("TxIsolationReadRepeatableRead");
            if (this.datastoreMinorVersion <= 7) {
                this.supportedOptions.remove("TxIsolationReadCommitted");
                this.supportedOptions.remove("TxIsolationSerializable");
            }
        }
        this.supportedOptions.remove("TxIsolationNone");
    }

    @Override
    public void initialiseTypes(StoreSchemaHandler handler, ManagedConnection mconn) {
        super.initialiseTypes(handler, mconn);
        SQLTypeInfo sqlType2 = new HSQLTypeInfo("LONGVARCHAR", 2005, Integer.MAX_VALUE, "'", "'", null, 1, true, 3, false, false, false, "LONGVARCHAR", 0, 0, 0);
        this.addSQLTypeForJDBCType(handler, mconn, (short)2005, sqlType2, true);
        sqlType2 = new HSQLTypeInfo("LONGVARBINARY", 2004, Integer.MAX_VALUE, "'", "'", null, 1, false, 3, false, false, false, "LONGVARBINARY", 0, 0, 0);
        this.addSQLTypeForJDBCType(handler, mconn, (short)2004, sqlType2, true);
        if (this.datastoreMajorVersion >= 2) {
            sqlType2 = new HSQLTypeInfo("LONGVARBINARY", -4, Integer.MAX_VALUE, "'", "'", null, 1, false, 3, false, false, false, "LONGVARBINARY", 0, 0, 0);
            this.addSQLTypeForJDBCType(handler, mconn, (short)-4, sqlType2, true);
        }
        sqlType2 = new HSQLTypeInfo("LONGVARCHAR", -1, Integer.MAX_VALUE, "'", "'", null, 1, true, 3, false, false, false, "LONGVARCHAR", 0, 0, 0);
        this.addSQLTypeForJDBCType(handler, mconn, (short)-1, sqlType2, true);
        Collection<SQLTypeInfo> sqlTypes = this.getSQLTypeInfoForJdbcType(handler, mconn, (short)2004);
        if (sqlTypes != null) {
            for (SQLTypeInfo sqlType2 : sqlTypes) {
                sqlType2.setAllowsPrecisionSpec(false);
            }
        }
        if ((sqlTypes = this.getSQLTypeInfoForJdbcType(handler, mconn, (short)2005)) != null) {
            for (SQLTypeInfo sqlType2 : sqlTypes) {
                sqlType2.setAllowsPrecisionSpec(false);
            }
        }
        if ((sqlTypes = this.getSQLTypeInfoForJdbcType(handler, mconn, (short)-4)) != null) {
            for (SQLTypeInfo sqlType2 : sqlTypes) {
                sqlType2.setAllowsPrecisionSpec(false);
            }
        }
        if ((sqlTypes = this.getSQLTypeInfoForJdbcType(handler, mconn, (short)-1)) != null) {
            for (SQLTypeInfo sqlType2 : sqlTypes) {
                sqlType2.setAllowsPrecisionSpec(false);
            }
        }
    }

    @Override
    public String getVendorID() {
        return "hsql";
    }

    @Override
    public int getDatastoreIdentifierMaxLength(IdentifierType identifierType) {
        if (identifierType == IdentifierType.TABLE) {
            return 128;
        }
        if (identifierType == IdentifierType.COLUMN) {
            return 128;
        }
        if (identifierType == IdentifierType.CANDIDATE_KEY) {
            return 128;
        }
        if (identifierType == IdentifierType.FOREIGN_KEY) {
            return 128;
        }
        if (identifierType == IdentifierType.INDEX) {
            return 128;
        }
        if (identifierType == IdentifierType.PRIMARY_KEY) {
            return 128;
        }
        if (identifierType == IdentifierType.SEQUENCE) {
            return 128;
        }
        return super.getDatastoreIdentifierMaxLength(identifierType);
    }

    @Override
    public String getDropDatabaseStatement(String catalogName, String schemaName) {
        return "DROP SCHEMA IF EXISTS " + schemaName + " CASCADE";
    }

    @Override
    public String getAddColumnStatement(Table table, Column col) {
        return "ALTER TABLE " + table.toString() + " ADD COLUMN " + col.getSQLDefinition();
    }

    @Override
    public String getRangeByLimitEndOfStatementClause(long offset, long count, boolean hasOrdering) {
        if (offset >= 0L && count > 0L) {
            return "LIMIT " + count + " OFFSET " + offset + " ";
        }
        if (offset <= 0L && count > 0L) {
            return "LIMIT " + count + " ";
        }
        if (offset >= 0L && count < 0L) {
            return "LIMIT 2147483647 OFFSET " + offset + " ";
        }
        return "";
    }

    @Override
    public SQLTypeInfo newSQLTypeInfo(ResultSet rs) {
        return new HSQLTypeInfo(rs);
    }

    @Override
    public String getSchemaName(Connection conn) throws SQLException {
        return "";
    }

    @Override
    public String getAddPrimaryKeyStatement(PrimaryKey pk, IdentifierFactory factory) {
        return null;
    }

    @Override
    public String getDropTableStatement(Table table) {
        return "DROP TABLE " + table.toString();
    }

    @Override
    public String getAutoIncrementStmt(Table table, String columnName) {
        return "CALL IDENTITY()";
    }

    @Override
    public String getAutoIncrementKeyword() {
        return "GENERATED BY DEFAULT AS IDENTITY";
    }

    @Override
    public String getInsertStatementForNoColumns(Table table) {
        return "INSERT INTO " + table.toString() + " VALUES (null)";
    }

    @Override
    public boolean isValidPrimaryKeyType(JdbcType datatype) {
        return datatype != JdbcType.BLOB && datatype != JdbcType.CLOB && datatype != JdbcType.LONGVARBINARY && datatype != JdbcType.OTHER && datatype != JdbcType.LONGVARCHAR;
    }

    @Override
    public String getDatastoreDateStatement() {
        return "CALL NOW()";
    }

    @Override
    public String getSequenceCreateStmt(String sequenceName, Integer min, Integer max, Integer start, Integer increment, Integer cacheSize) {
        if (sequenceName == null) {
            throw new NucleusUserException(Localiser.msg((String)"051028"));
        }
        StringBuilder stmt = new StringBuilder("CREATE SEQUENCE ");
        stmt.append(sequenceName);
        if (min != null) {
            stmt.append(" START WITH " + min);
        } else if (start != null) {
            stmt.append(" START WITH " + start);
        }
        if (max != null) {
            throw new NucleusUserException(Localiser.msg((String)"051022"));
        }
        if (increment != null) {
            stmt.append(" INCREMENT BY " + increment);
        }
        if (cacheSize != null) {
            throw new NucleusUserException(Localiser.msg((String)"051023"));
        }
        return stmt.toString();
    }

    @Override
    public String getSequenceNextStmt(String sequenceName) {
        if (sequenceName == null) {
            throw new NucleusUserException(Localiser.msg((String)"051028"));
        }
        StringBuilder stmt = new StringBuilder("CALL NEXT VALUE FOR ");
        stmt.append(sequenceName);
        return stmt.toString();
    }
}

