/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.adapter.DatastoreAdapter;
import org.datanucleus.store.rdbms.identifier.DatastoreIdentifier;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.query.QueryGenerator;
import org.datanucleus.store.rdbms.sql.SQLJoin;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.SQLTableGroup;
import org.datanucleus.store.rdbms.sql.SQLTableNamer;
import org.datanucleus.store.rdbms.sql.SQLText;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.BooleanLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.store.schema.table.SurrogateColumnType;
import org.datanucleus.util.NucleusLogger;

public abstract class SQLStatement {
    public static final String EXTENSION_SQL_TABLE_NAMING_STRATEGY = "table-naming-strategy";
    public static final String EXTENSION_LOCK_FOR_UPDATE = "lock-for-update";
    public static final String EXTENSION_LOCK_FOR_UPDATE_NOWAIT = "for-update-nowait";
    protected static final Map<String, SQLTableNamer> tableNamerByName = new ConcurrentHashMap<String, SQLTableNamer>();
    protected SQLText sql = null;
    protected RDBMSStoreManager rdbmsMgr;
    protected ClassLoaderResolver clr;
    protected QueryGenerator queryGenerator = null;
    protected SQLTableNamer namer = null;
    protected String candidateClassName = null;
    protected Map<String, Object> extensions;
    protected SQLStatement parent = null;
    protected SQLTable primaryTable;
    protected List<SQLJoin> joins;
    protected boolean requiresJoinReorder = false;
    protected Map<String, SQLTable> tables;
    protected Map<String, SQLTableGroup> tableGroups = new HashMap<String, SQLTableGroup>();
    protected BooleanExpression where;

    public SQLStatement(SQLStatement parentStmt, RDBMSStoreManager rdbmsMgr, Table table, DatastoreIdentifier alias, String tableGroupName, Map<String, Object> extensions) {
        String tableGrpName;
        this.parent = parentStmt;
        this.rdbmsMgr = rdbmsMgr;
        String namingStrategy = rdbmsMgr.getStringProperty("datanucleus.rdbms.sqlTableNamingStrategy");
        if (extensions != null && extensions.containsKey(EXTENSION_SQL_TABLE_NAMING_STRATEGY)) {
            namingStrategy = (String)extensions.get(EXTENSION_SQL_TABLE_NAMING_STRATEGY);
        }
        this.namer = this.getTableNamer(namingStrategy);
        String string = tableGrpName = tableGroupName != null ? tableGroupName : "Group0";
        if (alias == null) {
            alias = rdbmsMgr.getIdentifierFactory().newTableIdentifier(this.namer.getAliasForTable(this, table, tableGrpName));
        }
        this.primaryTable = new SQLTable(this, table, alias, tableGrpName);
        this.putSQLTableInGroup(this.primaryTable, tableGrpName, null);
        if (parentStmt != null) {
            this.queryGenerator = parentStmt.getQueryGenerator();
        }
    }

    public RDBMSStoreManager getRDBMSManager() {
        return this.rdbmsMgr;
    }

    public void setClassLoaderResolver(ClassLoaderResolver clr) {
        this.clr = clr;
    }

    public ClassLoaderResolver getClassLoaderResolver() {
        if (this.clr == null) {
            this.clr = this.rdbmsMgr.getNucleusContext().getClassLoaderResolver(null);
        }
        return this.clr;
    }

    public void setCandidateClassName(String name) {
        this.candidateClassName = name;
    }

    public String getCandidateClassName() {
        return this.candidateClassName;
    }

    public QueryGenerator getQueryGenerator() {
        return this.queryGenerator;
    }

    public void setQueryGenerator(QueryGenerator gen) {
        this.queryGenerator = gen;
    }

    public SQLExpressionFactory getSQLExpressionFactory() {
        return this.rdbmsMgr.getSQLExpressionFactory();
    }

    public DatastoreAdapter getDatastoreAdapter() {
        return this.rdbmsMgr.getDatastoreAdapter();
    }

    public SQLStatement getParentStatement() {
        return this.parent;
    }

    public boolean isChildStatementOf(SQLStatement stmt) {
        if (stmt == null || this.parent == null) {
            return false;
        }
        if (stmt == this.parent) {
            return true;
        }
        return this.isChildStatementOf(this.parent);
    }

    public void addExtension(String key, Object value) {
        if (key == null) {
            return;
        }
        this.invalidateStatement();
        if (key.equals(EXTENSION_SQL_TABLE_NAMING_STRATEGY)) {
            this.namer = this.getTableNamer((String)value);
            return;
        }
        if (this.extensions == null) {
            this.extensions = new HashMap<String, Object>();
        }
        this.extensions.put(key, value);
    }

    public Object getValueForExtension(String key) {
        if (this.extensions == null) {
            return this.extensions;
        }
        return this.extensions.get(key);
    }

    public SQLTable getPrimaryTable() {
        return this.primaryTable;
    }

    public SQLTable getTable(String alias) {
        if (alias.equals(this.primaryTable.alias.getName())) {
            return this.primaryTable;
        }
        if (this.tables != null) {
            return this.tables.get(alias);
        }
        return null;
    }

    public SQLTable getTableForDatastoreContainer(Table table) {
        for (SQLTableGroup grp : this.tableGroups.values()) {
            SQLTable[] tbls = grp.getTables();
            for (int i = 0; i < tbls.length; ++i) {
                if (tbls[i].getTable() != table) continue;
                return tbls[i];
            }
        }
        return null;
    }

    public SQLTable getTable(Table table, String groupName) {
        if (groupName == null) {
            return null;
        }
        SQLTableGroup tableGrp = this.tableGroups.get(groupName);
        if (tableGrp == null) {
            return null;
        }
        SQLTable[] tables = tableGrp.getTables();
        for (int i = 0; i < tables.length; ++i) {
            if (tables[i].getTable() != table) continue;
            return tables[i];
        }
        return null;
    }

    public SQLTableGroup getTableGroup(String groupName) {
        return this.tableGroups.get(groupName);
    }

    public int getNumberOfTableGroups() {
        return this.tableGroups.size();
    }

    public int getNumberOfTables() {
        return this.tables != null ? this.tables.size() : -1;
    }

    public SQLTable join(SQLJoin.JoinType joinType, SQLTable sourceTable, JavaTypeMapping sourceMapping, Table target, String targetAlias, JavaTypeMapping targetMapping, Object[] discrimValues, String tableGrpName) {
        return this.join(joinType, sourceTable, sourceMapping, null, target, targetAlias, targetMapping, null, discrimValues, tableGrpName, true);
    }

    public SQLTable join(SQLJoin.JoinType joinType, SQLTable sourceTable, JavaTypeMapping sourceMapping, Table target, String targetAlias, JavaTypeMapping targetMapping, Object[] discrimValues, String tableGrpName, boolean applyToUnions) {
        return this.join(joinType, sourceTable, sourceMapping, null, target, targetAlias, targetMapping, null, discrimValues, tableGrpName, applyToUnions);
    }

    public SQLTable join(SQLJoin.JoinType joinType, SQLTable sourceTable, JavaTypeMapping sourceMapping, JavaTypeMapping sourceParentMapping, Table target, String targetAlias, JavaTypeMapping targetMapping, JavaTypeMapping targetParentMapping, Object[] discrimValues, String tableGrpName, boolean applyToUnions) {
        this.invalidateStatement();
        if (this.tables == null) {
            this.tables = new HashMap<String, SQLTable>();
        }
        if (tableGrpName == null) {
            tableGrpName = "Group" + this.tableGroups.size();
        }
        if (targetAlias == null) {
            targetAlias = this.namer.getAliasForTable(this, target, tableGrpName);
        }
        if (sourceTable == null) {
            sourceTable = this.primaryTable;
        }
        DatastoreIdentifier targetId = this.rdbmsMgr.getIdentifierFactory().newTableIdentifier(targetAlias);
        SQLTable targetTbl = new SQLTable(this, target, targetId, tableGrpName);
        this.putSQLTableInGroup(targetTbl, tableGrpName, joinType);
        BooleanExpression joinCondition = this.getJoinConditionForJoin(sourceTable, sourceMapping, sourceParentMapping, targetTbl, targetMapping, targetParentMapping, discrimValues);
        this.addJoin(joinType, sourceTable, targetTbl, joinCondition);
        return targetTbl;
    }

    public SQLTable join(SQLJoin.JoinType joinType, SQLTable sourceTable, Table target, String targetAlias, String tableGrpName, BooleanExpression joinCondition, boolean applyToUnions) {
        this.invalidateStatement();
        if (this.tables == null) {
            this.tables = new HashMap<String, SQLTable>();
        }
        if (tableGrpName == null) {
            tableGrpName = "Group" + this.tableGroups.size();
        }
        if (targetAlias == null) {
            targetAlias = this.namer.getAliasForTable(this, target, tableGrpName);
        }
        if (sourceTable == null) {
            sourceTable = this.primaryTable;
        }
        DatastoreIdentifier targetId = this.rdbmsMgr.getIdentifierFactory().newTableIdentifier(targetAlias);
        SQLTable targetTbl = new SQLTable(this, target, targetId, tableGrpName);
        this.putSQLTableInGroup(targetTbl, tableGrpName, joinType);
        this.addJoin(joinType, sourceTable, targetTbl, joinCondition);
        return targetTbl;
    }

    public SQLTable innerJoin(SQLTable sourceTable, JavaTypeMapping sourceMapping, Table target, String targetAlias, JavaTypeMapping targetMapping, Object[] discrimValues, String tableGrpName) {
        return this.join(SQLJoin.JoinType.INNER_JOIN, sourceTable, sourceMapping, null, target, targetAlias, targetMapping, null, discrimValues, tableGrpName, true);
    }

    public SQLTable innerJoin(SQLTable sourceTable, JavaTypeMapping sourceMapping, JavaTypeMapping sourceParentMapping, Table target, String targetAlias, JavaTypeMapping targetMapping, JavaTypeMapping targetParentMapping, Object[] discrimValues, String tableGrpName) {
        return this.join(SQLJoin.JoinType.INNER_JOIN, sourceTable, sourceMapping, sourceParentMapping, target, targetAlias, targetMapping, targetParentMapping, discrimValues, tableGrpName, true);
    }

    public SQLTable leftOuterJoin(SQLTable sourceTable, JavaTypeMapping sourceMapping, Table target, String targetAlias, JavaTypeMapping targetMapping, Object[] discrimValues, String tableGrpName) {
        return this.join(SQLJoin.JoinType.LEFT_OUTER_JOIN, sourceTable, sourceMapping, null, target, targetAlias, targetMapping, null, discrimValues, tableGrpName, true);
    }

    public SQLTable leftOuterJoin(SQLTable sourceTable, JavaTypeMapping sourceMapping, JavaTypeMapping sourceParentMapping, Table target, String targetAlias, JavaTypeMapping targetMapping, JavaTypeMapping targetParentMapping, Object[] discrimValues, String tableGrpName) {
        return this.join(SQLJoin.JoinType.LEFT_OUTER_JOIN, sourceTable, sourceMapping, sourceParentMapping, target, targetAlias, targetMapping, targetParentMapping, discrimValues, tableGrpName, true);
    }

    public SQLTable rightOuterJoin(SQLTable sourceTable, JavaTypeMapping sourceMapping, Table target, String targetAlias, JavaTypeMapping targetMapping, Object[] discrimValues, String tableGrpName) {
        return this.join(SQLJoin.JoinType.RIGHT_OUTER_JOIN, sourceTable, sourceMapping, null, target, targetAlias, targetMapping, null, discrimValues, tableGrpName, true);
    }

    public SQLTable rightOuterJoin(SQLTable sourceTable, JavaTypeMapping sourceMapping, JavaTypeMapping sourceParentMapping, Table target, String targetAlias, JavaTypeMapping targetMapping, JavaTypeMapping targetParentMapping, Object[] discrimValues, String tableGrpName) {
        return this.join(SQLJoin.JoinType.RIGHT_OUTER_JOIN, sourceTable, sourceMapping, sourceParentMapping, target, targetAlias, targetMapping, targetParentMapping, discrimValues, tableGrpName, true);
    }

    public SQLTable crossJoin(Table target, String targetAlias, String tableGrpName) {
        this.invalidateStatement();
        if (this.tables == null) {
            this.tables = new HashMap<String, SQLTable>();
        }
        if (tableGrpName == null) {
            tableGrpName = "Group" + this.tableGroups.size();
        }
        if (targetAlias == null) {
            targetAlias = this.namer.getAliasForTable(this, target, tableGrpName);
        }
        DatastoreIdentifier targetId = this.rdbmsMgr.getIdentifierFactory().newTableIdentifier(targetAlias);
        SQLTable targetTbl = new SQLTable(this, target, targetId, tableGrpName);
        this.putSQLTableInGroup(targetTbl, tableGrpName, SQLJoin.JoinType.CROSS_JOIN);
        BooleanExpression joinCondition = this.getJoinConditionForJoin(this.primaryTable, null, null, targetTbl, null, null, null);
        this.addJoin(SQLJoin.JoinType.CROSS_JOIN, this.primaryTable, targetTbl, joinCondition);
        return targetTbl;
    }

    public SQLJoin.JoinType getJoinTypeForTable(SQLTable sqlTbl) {
        if (this.joins == null) {
            return null;
        }
        for (SQLJoin join : this.joins) {
            if (!join.getTargetTable().equals(sqlTbl)) continue;
            return join.getType();
        }
        return null;
    }

    public void addAndConditionToJoinForTable(SQLTable sqlTbl, BooleanExpression andCondition, boolean applyToUnions) {
        SQLJoin join = this.getJoinForTable(sqlTbl);
        if (join != null) {
            join.addAndCondition(andCondition);
        }
    }

    public SQLJoin getJoinForTable(SQLTable sqlTbl) {
        if (this.joins == null) {
            return null;
        }
        for (SQLJoin join : this.joins) {
            if (!join.getTargetTable().equals(sqlTbl)) continue;
            return join;
        }
        return null;
    }

    public String removeCrossJoin(SQLTable targetSqlTbl) {
        if (this.joins == null) {
            return null;
        }
        Iterator<SQLJoin> joinIter = this.joins.iterator();
        while (joinIter.hasNext()) {
            SQLJoin join = joinIter.next();
            if (!join.getTargetTable().equals(targetSqlTbl) || join.getType() != SQLJoin.JoinType.CROSS_JOIN) continue;
            joinIter.remove();
            this.requiresJoinReorder = true;
            this.tables.remove(join.getTargetTable().alias.getName());
            String removedAliasName = join.getTargetTable().alias.getName();
            return removedAliasName;
        }
        return null;
    }

    protected void putSQLTableInGroup(SQLTable sqlTbl, String groupName, SQLJoin.JoinType joinType) {
        SQLTableGroup tableGrp = this.tableGroups.get(groupName);
        if (tableGrp == null) {
            tableGrp = new SQLTableGroup(groupName, joinType);
        }
        tableGrp.addTable(sqlTbl);
        this.tableGroups.put(groupName, tableGrp);
    }

    protected void addJoin(SQLJoin.JoinType joinType, SQLTable sourceTable, SQLTable targetTable, BooleanExpression joinCondition) {
        if (this.tables == null) {
            throw new NucleusException("tables not set in statement!");
        }
        if (this.tables.containsValue(targetTable)) {
            NucleusLogger.DATASTORE.debug((Object)("Attempt to join to " + targetTable + " but join already exists"));
            return;
        }
        if (joinType == SQLJoin.JoinType.RIGHT_OUTER_JOIN && !this.rdbmsMgr.getDatastoreAdapter().supportsOption("RightOuterJoin")) {
            throw new NucleusUserException("RIGHT OUTER JOIN is not supported by this datastore");
        }
        this.tables.put(targetTable.alias.getName(), targetTable);
        if (this.rdbmsMgr.getDatastoreAdapter().supportsOption("ANSI_Join_Syntax")) {
            SQLJoin join = new SQLJoin(joinType, targetTable, sourceTable, joinCondition);
            if (this.joins == null) {
                this.joins = new ArrayList<SQLJoin>();
            }
            int position = -1;
            if (this.queryGenerator != null && this.queryGenerator.processingOnClause()) {
                if (this.primaryTable == sourceTable) {
                    if (this.joins.size() > 0) {
                        position = 0;
                    }
                } else {
                    int i = 1;
                    for (SQLJoin sqlJoin : this.joins) {
                        if (sqlJoin.getSourceTable() == sourceTable) {
                            position = i;
                            break;
                        }
                        ++i;
                    }
                }
            }
            if (position >= 0) {
                this.joins.add(position, join);
            } else {
                this.joins.add(join);
            }
        } else {
            SQLJoin join = new SQLJoin(SQLJoin.JoinType.NON_ANSI_JOIN, targetTable, sourceTable, null);
            if (this.joins == null) {
                this.joins = new ArrayList<SQLJoin>();
            }
            this.joins.add(join);
            this.whereAnd(joinCondition, false);
        }
    }

    protected BooleanExpression getJoinConditionForJoin(SQLTable sourceTable, JavaTypeMapping sourceMapping, JavaTypeMapping sourceParentMapping, SQLTable targetTable, JavaTypeMapping targetMapping, JavaTypeMapping targetParentMapping, Object[] discrimValues) {
        BooleanExpression joinCondition = null;
        if (sourceMapping != null && targetMapping != null) {
            if (sourceMapping.getNumberOfDatastoreMappings() != targetMapping.getNumberOfDatastoreMappings()) {
                throw new NucleusException("Cannot join from " + sourceMapping + " to " + targetMapping + " since they have different numbers of datastore columns!");
            }
            SQLExpressionFactory factory = this.rdbmsMgr.getSQLExpressionFactory();
            SQLExpression sourceExpr = null;
            sourceExpr = sourceParentMapping == null ? factory.newExpression(this, sourceTable != null ? sourceTable : this.primaryTable, sourceMapping) : factory.newExpression(this, sourceTable != null ? sourceTable : this.primaryTable, sourceMapping, sourceParentMapping);
            SQLExpression targetExpr = null;
            targetExpr = targetParentMapping == null ? factory.newExpression(this, targetTable, targetMapping) : factory.newExpression(this, targetTable, targetMapping, targetParentMapping);
            joinCondition = sourceExpr.eq(targetExpr);
            JavaTypeMapping discrimMapping = targetTable.getTable().getSurrogateMapping(SurrogateColumnType.DISCRIMINATOR, false);
            if (discrimMapping != null && discrimValues != null) {
                SQLExpression discrimExpr = factory.newExpression(this, targetTable, discrimMapping);
                SQLExpression discrimCondition = null;
                for (int i = 0; i < discrimValues.length; ++i) {
                    SQLExpression discrimVal = factory.newLiteral(this, discrimMapping, discrimValues[i]);
                    BooleanExpression condition = discrimExpr.eq(discrimVal);
                    discrimCondition = discrimCondition == null ? condition : ((BooleanExpression)discrimCondition).ior(condition);
                }
                if (discrimCondition != null) {
                    discrimCondition.encloseInParentheses();
                    joinCondition = joinCondition.and(discrimCondition);
                }
            }
        }
        return joinCondition;
    }

    protected synchronized SQLTableNamer getTableNamer(String namingSchema) {
        SQLTableNamer namer = tableNamerByName.get(namingSchema);
        if (namer == null) {
            try {
                namer = (SQLTableNamer)this.rdbmsMgr.getNucleusContext().getPluginManager().createExecutableExtension("org.datanucleus.store.rdbms.sql_tablenamer", "name", namingSchema, "class", null, null);
            }
            catch (Exception e) {
                throw new NucleusException("Attempt to find/instantiate SQL table namer " + namingSchema + " threw an exception", (Throwable)e);
            }
            tableNamerByName.put(namingSchema, namer);
        }
        return namer;
    }

    public void whereAnd(BooleanExpression expr, boolean applyToUnions) {
        if (expr instanceof BooleanLiteral && !expr.isParameter() && ((Boolean)((BooleanLiteral)expr).getValue()).booleanValue()) {
            return;
        }
        this.invalidateStatement();
        this.where = this.where == null ? expr : this.where.and(expr);
    }

    public void whereOr(BooleanExpression expr, boolean applyToUnions) {
        this.invalidateStatement();
        this.where = this.where == null ? expr : this.where.ior(expr);
    }

    public synchronized SQLText getSQLText() {
        return this.sql;
    }

    protected void invalidateStatement() {
        this.sql = null;
    }

    public void log(NucleusLogger logger) {
        logger.debug((Object)("SQLStatement : " + this.getSQLText()));
        for (String grpName : this.tableGroups.keySet()) {
            logger.debug((Object)("SQLStatement : TableGroup=" + this.tableGroups.get(grpName)));
        }
    }
}

