/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.table;

import java.util.ArrayList;
import java.util.Collection;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ForeignKeyAction;
import org.datanucleus.metadata.ForeignKeyMetaData;
import org.datanucleus.metadata.IndexMetaData;
import org.datanucleus.metadata.UniqueMetaData;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.identifier.DatastoreIdentifier;
import org.datanucleus.store.rdbms.identifier.IdentifierFactory;
import org.datanucleus.store.rdbms.identifier.IdentifierType;
import org.datanucleus.store.rdbms.key.CandidateKey;
import org.datanucleus.store.rdbms.key.ForeignKey;
import org.datanucleus.store.rdbms.key.Index;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.java.ReferenceMapping;
import org.datanucleus.store.rdbms.table.DatastoreClass;
import org.datanucleus.store.rdbms.table.Table;

public class TableUtils {
    private TableUtils() {
    }

    public static Collection getForeignKeysForReferenceField(JavaTypeMapping fieldMapping, AbstractMemberMetaData mmd, boolean autoMode, RDBMSStoreManager storeMgr, ClassLoaderResolver clr) {
        ReferenceMapping refMapping = (ReferenceMapping)fieldMapping;
        JavaTypeMapping[] refJavaTypeMappings = refMapping.getJavaTypeMapping();
        ArrayList<ForeignKey> fks = new ArrayList<ForeignKey>();
        for (int i = 0; i < refJavaTypeMappings.length; ++i) {
            ForeignKeyMetaData fkmd;
            DatastoreClass referencedTable;
            JavaTypeMapping implMapping = refJavaTypeMappings[i];
            if (storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForClass(implMapping.getType(), clr) == null || implMapping.getNumberOfDatastoreMappings() <= 0 || (referencedTable = storeMgr.getDatastoreClass(implMapping.getType(), clr)) == null || ((fkmd = mmd.getForeignKeyMetaData()) == null || fkmd.getDeleteAction() == ForeignKeyAction.NONE) && !autoMode) continue;
            ForeignKey fk = new ForeignKey(implMapping, storeMgr.getDatastoreAdapter(), referencedTable, true);
            fk.setForMetaData(fkmd);
            fks.add(fk);
        }
        return fks;
    }

    public static ForeignKey getForeignKeyForPCField(JavaTypeMapping fieldMapping, AbstractMemberMetaData mmd, boolean autoMode, RDBMSStoreManager storeMgr, ClassLoaderResolver clr) {
        ForeignKeyMetaData fkmd;
        AbstractClassMetaData[] refCmds;
        AbstractClassMetaData refCmd;
        DatastoreClass referencedTable = storeMgr.getDatastoreClass(mmd.getTypeName(), clr);
        if (referencedTable == null && (refCmd = storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForClass(mmd.getType(), clr)) != null && (refCmds = storeMgr.getClassesManagingTableForClass(refCmd, clr)) != null && refCmds.length == 1) {
            referencedTable = storeMgr.getDatastoreClass(refCmds[0].getFullClassName(), clr);
        }
        if (referencedTable != null && ((fkmd = mmd.getForeignKeyMetaData()) != null && (fkmd.getDeleteAction() != ForeignKeyAction.NONE || fkmd.getFkDefinitionApplies()) || autoMode)) {
            ForeignKey fk = new ForeignKey(fieldMapping, storeMgr.getDatastoreAdapter(), referencedTable, true);
            fk.setForMetaData(fkmd);
            if (fkmd != null && fkmd.getName() != null) {
                fk.setName(fkmd.getName());
            }
            return fk;
        }
        return null;
    }

    public static Index getIndexForField(Table table, IndexMetaData imd, JavaTypeMapping fieldMapping) {
        if (fieldMapping.getNumberOfDatastoreMappings() == 0) {
            return null;
        }
        if (!table.getStoreManager().getDatastoreAdapter().validToIndexMapping(fieldMapping)) {
            return null;
        }
        boolean unique = imd == null ? false : imd.isUnique();
        Index index = new Index(table, unique, imd != null ? imd.getValueForExtension("extended-setting") : null);
        if (imd != null && imd.getName() != null) {
            IdentifierFactory idFactory = table.getStoreManager().getIdentifierFactory();
            DatastoreIdentifier idxId = idFactory.newIdentifier(IdentifierType.INDEX, imd.getName());
            index.setName(idxId.toString());
        }
        int countFields = fieldMapping.getNumberOfDatastoreMappings();
        for (int j = 0; j < countFields; ++j) {
            index.addColumn(fieldMapping.getDatastoreMapping(j).getColumn());
        }
        return index;
    }

    public static CandidateKey getCandidateKeyForField(Table table, UniqueMetaData umd, JavaTypeMapping fieldMapping) {
        CandidateKey ck = new CandidateKey(table);
        if (umd.getName() != null) {
            IdentifierFactory idFactory = table.getStoreManager().getIdentifierFactory();
            DatastoreIdentifier ckId = idFactory.newIdentifier(IdentifierType.CANDIDATE_KEY, umd.getName());
            ck.setName(ckId.toString());
        }
        int countFields = fieldMapping.getNumberOfDatastoreMappings();
        for (int j = 0; j < countFields; ++j) {
            ck.addColumn(fieldMapping.getDatastoreMapping(j).getColumn());
        }
        return ck;
    }
}

