/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.java.PersistableIdMapping;
import org.datanucleus.store.rdbms.mapping.java.PersistableMapping;
import org.datanucleus.store.rdbms.query.RDBMSQueryUtils;
import org.datanucleus.store.rdbms.sql.DiscriminatorStatementGenerator;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLStatementHelper;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.SelectStatement;
import org.datanucleus.store.rdbms.sql.UnionStatementGenerator;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.table.DatastoreClass;
import org.datanucleus.util.NucleusLogger;

public class RDBMSStoreHelper {
    private RDBMSStoreHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getClassNameForIdUsingDiscriminator(RDBMSStoreManager storeMgr, ExecutionContext ec, Object id, AbstractClassMetaData cmd) {
        if (cmd == null) return null;
        if (id == null) {
            return null;
        }
        SQLExpressionFactory exprFactory = storeMgr.getSQLExpressionFactory();
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        DatastoreClass primaryTable = storeMgr.getDatastoreClass(cmd.getFullClassName(), clr);
        DiscriminatorStatementGenerator stmtGen = new DiscriminatorStatementGenerator(storeMgr, clr, clr.classForName(cmd.getFullClassName()), true, null, null);
        stmtGen.setOption("restrictDiscriminator");
        SelectStatement sqlStmt = stmtGen.getStatement(ec);
        JavaTypeMapping discrimMapping = primaryTable.getDiscriminatorMapping(true);
        SQLTable discrimSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(sqlStmt, sqlStmt.getPrimaryTable(), discrimMapping);
        sqlStmt.select(discrimSqlTbl, discrimMapping, null);
        JavaTypeMapping idMapping = primaryTable.getIdMapping();
        PersistableIdMapping idParamMapping = new PersistableIdMapping((PersistableMapping)idMapping);
        SQLExpression sqlFldExpr = exprFactory.newExpression(sqlStmt, sqlStmt.getPrimaryTable(), idMapping);
        SQLExpression sqlFldVal = exprFactory.newLiteralParameter(sqlStmt, idParamMapping, id, "ID");
        sqlStmt.whereAnd(sqlFldExpr.eq(sqlFldVal), true);
        try {
            ManagedConnection mconn = storeMgr.getConnection(ec);
            SQLController sqlControl = storeMgr.getSQLController();
            if (ec.getSerializeReadForClass(cmd.getFullClassName())) {
                sqlStmt.addExtension("lock-for-update", true);
            }
            try {
                PreparedStatement ps = SQLStatementHelper.getPreparedStatementForSQLStatement(sqlStmt, ec, mconn, null, null);
                String statement = sqlStmt.getSQLText().toSQL();
                try (ResultSet rs = sqlControl.executeStatementQuery(ec, mconn, statement, ps);){
                    if (rs == null) return null;
                    if (!rs.next()) return null;
                    DiscriminatorMetaData dismd = discrimMapping.getTable().getDiscriminatorMetaData();
                    String string = RDBMSQueryUtils.getClassNameFromDiscriminatorResultSetRow(discrimMapping, dismd, rs, ec);
                    return string;
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException sqe) {
            NucleusLogger.DATASTORE.error((Object)"Exception thrown on querying of discriminator for id", (Throwable)sqe);
            throw new NucleusDataStoreException(sqe.toString(), (Throwable)sqe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public static String getClassNameForIdUsingUnion(RDBMSStoreManager storeMgr, ExecutionContext ec, Object id, List<AbstractClassMetaData> rootCmds) {
        if (rootCmds == null || rootCmds.isEmpty() || id == null) {
            return null;
        }
        SQLExpressionFactory exprFactory = storeMgr.getSQLExpressionFactory();
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        Iterator<AbstractClassMetaData> rootCmdIter = rootCmds.iterator();
        AbstractClassMetaData sampleCmd = null;
        SQLStatement sqlStmtMain = null;
        while (rootCmdIter.hasNext()) {
            AbstractClassMetaData rootCmd = rootCmdIter.next();
            DatastoreClass rootTbl = storeMgr.getDatastoreClass(rootCmd.getFullClassName(), clr);
            if (rootTbl == null) {
                AbstractClassMetaData[] subcmds = storeMgr.getClassesManagingTableForClass(rootCmd, clr);
                if (subcmds == null || subcmds.length == 0) continue;
                for (int i = 0; i < subcmds.length; ++i) {
                    UnionStatementGenerator stmtGen = new UnionStatementGenerator(storeMgr, clr, clr.classForName(subcmds[i].getFullClassName()), true, null, null);
                    stmtGen.setOption("selectDnType");
                    if (sqlStmtMain == null) {
                        sampleCmd = subcmds[i];
                        sqlStmtMain = stmtGen.getStatement(ec);
                        JavaTypeMapping idMapping = sqlStmtMain.getPrimaryTable().getTable().getIdMapping();
                        PersistableIdMapping idParamMapping = new PersistableIdMapping((PersistableMapping)idMapping);
                        SQLExpression fieldExpr = exprFactory.newExpression(sqlStmtMain, sqlStmtMain.getPrimaryTable(), idMapping);
                        SQLExpression fieldVal = exprFactory.newLiteralParameter(sqlStmtMain, idParamMapping, id, "ID");
                        ((SelectStatement)sqlStmtMain).whereAnd(fieldExpr.eq(fieldVal), true);
                        continue;
                    }
                    SelectStatement sqlStmt = stmtGen.getStatement(ec);
                    JavaTypeMapping idMapping = sqlStmt.getPrimaryTable().getTable().getIdMapping();
                    PersistableIdMapping idParamMapping = new PersistableIdMapping((PersistableMapping)idMapping);
                    SQLExpression fieldExpr = exprFactory.newExpression(sqlStmt, sqlStmt.getPrimaryTable(), idMapping);
                    SQLExpression fieldVal = exprFactory.newLiteralParameter(sqlStmt, idParamMapping, id, "ID");
                    sqlStmt.whereAnd(fieldExpr.eq(fieldVal), true);
                    ((SelectStatement)sqlStmtMain).union(sqlStmt);
                }
                continue;
            }
            UnionStatementGenerator stmtGen = new UnionStatementGenerator(storeMgr, clr, clr.classForName(rootCmd.getFullClassName()), true, null, null);
            stmtGen.setOption("selectDnType");
            if (sqlStmtMain == null) {
                sampleCmd = rootCmd;
                sqlStmtMain = stmtGen.getStatement(ec);
                JavaTypeMapping idMapping = sqlStmtMain.getPrimaryTable().getTable().getIdMapping();
                PersistableIdMapping idParamMapping = new PersistableIdMapping((PersistableMapping)idMapping);
                SQLExpression fieldExpr = exprFactory.newExpression(sqlStmtMain, sqlStmtMain.getPrimaryTable(), idMapping);
                SQLExpression fieldVal = exprFactory.newLiteralParameter(sqlStmtMain, idParamMapping, id, "ID");
                ((SelectStatement)sqlStmtMain).whereAnd(fieldExpr.eq(fieldVal), true);
                continue;
            }
            SelectStatement sqlStmt = stmtGen.getStatement(ec);
            JavaTypeMapping idMapping = sqlStmt.getPrimaryTable().getTable().getIdMapping();
            PersistableIdMapping idParamMapping = new PersistableIdMapping((PersistableMapping)idMapping);
            SQLExpression fieldExpr = exprFactory.newExpression(sqlStmt, sqlStmt.getPrimaryTable(), idMapping);
            SQLExpression fieldVal = exprFactory.newLiteralParameter(sqlStmt, idParamMapping, id, "ID");
            sqlStmt.whereAnd(fieldExpr.eq(fieldVal), true);
            ((SelectStatement)sqlStmtMain).union(sqlStmt);
        }
        try {
            ManagedConnection mconn = storeMgr.getConnection(ec);
            SQLController sqlControl = storeMgr.getSQLController();
            if (ec.getSerializeReadForClass(sampleCmd.getFullClassName())) {
                sqlStmtMain.addExtension("lock-for-update", true);
            }
            try {
                PreparedStatement ps = SQLStatementHelper.getPreparedStatementForSQLStatement(sqlStmtMain, ec, mconn, null, null);
                String statement = ((SelectStatement)sqlStmtMain).getSQLText().toSQL();
                try (ResultSet rs = sqlControl.executeStatementQuery(ec, mconn, statement, ps);){
                    if (rs != null) {
                        while (rs.next()) {
                            try {
                                String string = rs.getString("DN_TYPE").trim();
                                return string;
                            }
                            catch (SQLException sQLException) {
                            }
                        }
                    }
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException sqe) {
            NucleusLogger.DATASTORE.error((Object)"Exception with UNION statement", (Throwable)sqe);
            throw new NucleusDataStoreException(sqe.toString());
        }
    }
}

