/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.request;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.StatementClassMapping;
import org.datanucleus.store.rdbms.mapping.StatementMappingIndex;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.java.PersistableMapping;
import org.datanucleus.store.rdbms.request.BulkRequest;
import org.datanucleus.store.rdbms.sql.SelectStatement;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.table.DatastoreClass;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.TypeConversionHelper;

public class LocateBulkRequest
extends BulkRequest {
    AbstractClassMetaData cmd = null;
    private StatementClassMapping[] mappingDefinitions;
    private StatementClassMapping resultMapping;

    public LocateBulkRequest(DatastoreClass table) {
        super(table);
    }

    protected String getStatement(DatastoreClass table, ObjectProvider[] ops, boolean lock) {
        SQLExpression expr;
        int[] nonPkFieldNums;
        VersionMetaData currentVermd;
        RDBMSStoreManager storeMgr = table.getStoreManager();
        ClassLoaderResolver clr = storeMgr.getNucleusContext().getClassLoaderResolver(null);
        SQLExpressionFactory exprFactory = storeMgr.getSQLExpressionFactory();
        this.cmd = storeMgr.getMetaDataManager().getMetaDataForClass(table.getType(), clr);
        SelectStatement sqlStatement = new SelectStatement(storeMgr, table, null, null);
        this.resultMapping = new StatementClassMapping();
        if (table.getIdentityType() == IdentityType.DATASTORE) {
            JavaTypeMapping datastoreIdMapping = table.getDatastoreIdMapping();
            SQLExpression expr2 = exprFactory.newExpression(sqlStatement, sqlStatement.getPrimaryTable(), datastoreIdMapping);
            int[] cols = sqlStatement.select(expr2, null);
            StatementMappingIndex datastoreIdx = new StatementMappingIndex(datastoreIdMapping);
            datastoreIdx.setColumnPositions(cols);
            this.resultMapping.addMappingForMember(-1, datastoreIdx);
        } else if (table.getIdentityType() == IdentityType.APPLICATION) {
            int[] pkNums = this.cmd.getPKMemberPositions();
            for (int i = 0; i < pkNums.length; ++i) {
                AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkNums[i]);
                JavaTypeMapping pkMapping = table.getMemberMappingInDatastoreClass(mmd);
                if (pkMapping == null) {
                    pkMapping = table.getMemberMapping(mmd);
                }
                SQLExpression expr3 = exprFactory.newExpression(sqlStatement, sqlStatement.getPrimaryTable(), pkMapping);
                int[] cols = sqlStatement.select(expr3, null);
                StatementMappingIndex pkIdx = new StatementMappingIndex(pkMapping);
                pkIdx.setColumnPositions(cols);
                this.resultMapping.addMappingForMember(mmd.getAbsoluteFieldNumber(), pkIdx);
            }
        } else {
            throw new NucleusUserException("Cannot locate objects using nondurable identity");
        }
        JavaTypeMapping verMapping = table.getVersionMapping(false);
        if (verMapping != null && (currentVermd = table.getVersionMetaData()) != null && currentVermd.getFieldName() == null) {
            SQLExpression expr4 = exprFactory.newExpression(sqlStatement, sqlStatement.getPrimaryTable(), verMapping);
            int[] cols = sqlStatement.select(expr4, null);
            StatementMappingIndex mapIdx = new StatementMappingIndex(verMapping);
            mapIdx.setColumnPositions(cols);
            this.resultMapping.addMappingForMember(-2, mapIdx);
        }
        if ((nonPkFieldNums = this.cmd.getNonPKMemberPositions()) != null) {
            for (int i = 0; i < nonPkFieldNums.length; ++i) {
                AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(nonPkFieldNums[i]);
                JavaTypeMapping mapping = table.getMemberMapping(mmd);
                if (mapping == null || !mapping.includeInFetchStatement() || mapping instanceof PersistableMapping) continue;
                expr = exprFactory.newExpression(sqlStatement, sqlStatement.getPrimaryTable(), mapping);
                int[] cols = sqlStatement.select(expr, null);
                StatementMappingIndex mapIdx = new StatementMappingIndex(mapping);
                mapIdx.setColumnPositions(cols);
                this.resultMapping.addMappingForMember(mmd.getAbsoluteFieldNumber(), mapIdx);
            }
        }
        if (table.getMultitenancyMapping() != null) {
            JavaTypeMapping tenantMapping = table.getMultitenancyMapping();
            SQLExpression tenantExpr = exprFactory.newExpression(sqlStatement, sqlStatement.getPrimaryTable(), tenantMapping);
            SQLExpression tenantVal = exprFactory.newLiteral(sqlStatement, tenantMapping, storeMgr.getStringProperty("datanucleus.TenantID"));
            sqlStatement.whereAnd(tenantExpr.eq(tenantVal), true);
        }
        this.mappingDefinitions = new StatementClassMapping[ops.length];
        int inputParamNum = 1;
        for (int i = 0; i < ops.length; ++i) {
            this.mappingDefinitions[i] = new StatementClassMapping();
            if (table.getIdentityType() == IdentityType.DATASTORE) {
                JavaTypeMapping datastoreIdMapping = table.getDatastoreIdMapping();
                expr = exprFactory.newExpression(sqlStatement, sqlStatement.getPrimaryTable(), datastoreIdMapping);
                SQLExpression val = exprFactory.newLiteralParameter(sqlStatement, datastoreIdMapping, null, "ID");
                sqlStatement.whereOr(expr.eq(val), true);
                StatementMappingIndex datastoreIdx = new StatementMappingIndex(datastoreIdMapping);
                this.mappingDefinitions[i].addMappingForMember(-1, datastoreIdx);
                datastoreIdx.addParameterOccurrence(new int[]{inputParamNum++});
                continue;
            }
            if (table.getIdentityType() != IdentityType.APPLICATION) continue;
            SQLExpression pkExpr = null;
            int[] pkNums = this.cmd.getPKMemberPositions();
            for (int j = 0; j < pkNums.length; ++j) {
                AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkNums[j]);
                JavaTypeMapping pkMapping = table.getMemberMappingInDatastoreClass(mmd);
                if (pkMapping == null) {
                    pkMapping = table.getMemberMapping(mmd);
                }
                SQLExpression expr5 = exprFactory.newExpression(sqlStatement, sqlStatement.getPrimaryTable(), pkMapping);
                SQLExpression val = exprFactory.newLiteralParameter(sqlStatement, pkMapping, null, "PK" + j);
                BooleanExpression fieldEqExpr = expr5.eq(val);
                pkExpr = pkExpr == null ? fieldEqExpr : ((BooleanExpression)pkExpr).and(fieldEqExpr);
                StatementMappingIndex pkIdx = new StatementMappingIndex(pkMapping);
                this.mappingDefinitions[i].addMappingForMember(mmd.getAbsoluteFieldNumber(), pkIdx);
                int[] inputParams = new int[pkMapping.getNumberOfDatastoreMappings()];
                for (int k = 0; k < pkMapping.getNumberOfDatastoreMappings(); ++k) {
                    inputParams[k] = inputParamNum++;
                }
                pkIdx.addParameterOccurrence(inputParams);
            }
            pkExpr = (BooleanExpression)pkExpr.encloseInParentheses();
            sqlStatement.whereOr((BooleanExpression)pkExpr, true);
        }
        if (lock) {
            sqlStatement.addExtension("lock-for-update", Boolean.TRUE);
            return sqlStatement.getSQLText().toSQL();
        }
        return sqlStatement.getSQLText().toSQL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void execute(ObjectProvider[] ops) {
        if (ops == null || ops.length == 0) {
            return;
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            str = new StringBuilder();
            for (i = 0; i < ops.length; ++i) {
                if (i > 0) {
                    str.append(", ");
                }
                str.append(ops[i].getInternalObjectId());
            }
            NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"052223", (Object[])new Object[]{str.toString(), this.table}));
        }
        ec = ops[0].getExecutionContext();
        storeMgr = this.table.getStoreManager();
        cmd = ops[0].getClassMetaData();
        locked = ec.getSerializeReadForClass(cmd.getFullClassName());
        lockType = ec.getLockManager().getLockMode(ops[0].getInternalObjectId());
        if (lockType != 0 && (lockType == 3 || lockType == 4)) {
            locked = true;
        }
        statement = this.getStatement(this.table, ops, locked);
        try {
            mconn = storeMgr.getConnection(ec);
            sqlControl = storeMgr.getSQLController();
            try {
                ps = sqlControl.getStatementForQuery(mconn, statement);
lbl26:
                // 2 sources

                try {
                    for (i = 0; i < ops.length; ++i) {
                        block22: {
                            if (cmd.getIdentityType() != IdentityType.DATASTORE) break block22;
                            datastoreIdx = this.mappingDefinitions[i].getMappingForMemberPosition(-1);
                            for (j = 0; j < datastoreIdx.getNumberOfParameterOccurrences(); ++j) {
                                this.table.getDatastoreIdMapping().setObject(ec, ps, datastoreIdx.getParameterPositionsForOccurrence(j), ops[i].getInternalObjectId());
                            }
                            ** GOTO lbl26
                        }
                        if (cmd.getIdentityType() != IdentityType.APPLICATION) continue;
                        ops[i].provideFields(cmd.getPKMemberPositions(), storeMgr.getFieldManagerForStatementGeneration(ops[i], ps, this.mappingDefinitions[i]));
                    }
                    rs = sqlControl.executeStatementQuery(ec, mconn, statement, ps);
                    try {
                        missingOps = this.processResults(rs, ops);
                        if (missingOps != null && missingOps.length > 0) {
                            nfes = new NucleusObjectNotFoundException[missingOps.length];
                            for (i = 0; i < nfes.length; ++i) {
                                nfes[i] = new NucleusObjectNotFoundException("Object not found", missingOps[i].getInternalObjectId());
                            }
                            throw new NucleusObjectNotFoundException("Some objects were not found. Look at nested exceptions for details", nfes);
                        }
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException sqle) {
            msg = Localiser.msg((String)"052220", (Object[])new Object[]{ops[0].getObjectAsPrintable(), statement, sqle.getMessage()});
            NucleusLogger.DATASTORE_RETRIEVE.warn((Object)msg);
            exceptions = new ArrayList<SQLException>();
            exceptions.add(sqle);
            while ((sqle = sqle.getNextException()) != null) {
                exceptions.add(sqle);
            }
            throw new NucleusDataStoreException(msg, exceptions.toArray(new Throwable[exceptions.size()]));
        }
    }

    private ObjectProvider[] processResults(ResultSet rs, ObjectProvider[] ops) throws SQLException {
        ArrayList<ObjectProvider> missingOps = new ArrayList<ObjectProvider>();
        for (int i = 0; i < ops.length; ++i) {
            missingOps.add(ops[i]);
        }
        ExecutionContext ec = ops[0].getExecutionContext();
        while (rs.next()) {
            FieldManager resultFM = this.table.getStoreManager().getFieldManagerForResultProcessing(ec, rs, this.resultMapping, this.cmd);
            Object id = null;
            Object key = null;
            if (this.cmd.getIdentityType() == IdentityType.DATASTORE) {
                StatementMappingIndex idx = this.resultMapping.getMappingForMemberPosition(-1);
                JavaTypeMapping idMapping = idx.getMapping();
                key = idMapping.getObject(ec, rs, idx.getColumnPositions());
                if (IdentityUtils.isDatastoreIdentity((Object)key)) {
                    key = IdentityUtils.getTargetKeyForDatastoreIdentity((Object)key);
                }
            } else if (this.cmd.getIdentityType() == IdentityType.APPLICATION) {
                if (this.cmd.usesSingleFieldIdentityClass()) {
                    int[] pkFieldNums = this.cmd.getPKMemberPositions();
                    AbstractMemberMetaData pkMmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkFieldNums[0]);
                    key = pkMmd.getType() == Integer.TYPE ? Integer.valueOf(resultFM.fetchIntField(pkFieldNums[0])) : (pkMmd.getType() == Short.TYPE ? Short.valueOf(resultFM.fetchShortField(pkFieldNums[0])) : (pkMmd.getType() == Long.TYPE ? Long.valueOf(resultFM.fetchLongField(pkFieldNums[0])) : (pkMmd.getType() == Character.TYPE ? Character.valueOf(resultFM.fetchCharField(pkFieldNums[0])) : (pkMmd.getType() == Boolean.TYPE ? Boolean.valueOf(resultFM.fetchBooleanField(pkFieldNums[0])) : (pkMmd.getType() == Byte.TYPE ? Byte.valueOf(resultFM.fetchByteField(pkFieldNums[0])) : (pkMmd.getType() == Double.TYPE ? Double.valueOf(resultFM.fetchDoubleField(pkFieldNums[0])) : (pkMmd.getType() == Float.TYPE ? Float.valueOf(resultFM.fetchFloatField(pkFieldNums[0])) : (pkMmd.getType() == String.class ? resultFM.fetchStringField(pkFieldNums[0]) : resultFM.fetchObjectField(pkFieldNums[0])))))))));
                } else {
                    id = IdentityUtils.getApplicationIdentityForResultSetRow((ExecutionContext)ec, (AbstractClassMetaData)this.cmd, null, (boolean)true, (FieldManager)resultFM);
                }
            }
            ObjectProvider op = null;
            for (ObjectProvider missingOp : missingOps) {
                Object opKey;
                Object opId = missingOp.getInternalObjectId();
                if (this.cmd.getIdentityType() == IdentityType.DATASTORE) {
                    opKey = IdentityUtils.getTargetKeyForDatastoreIdentity((Object)opId);
                    if (opKey.getClass() != key.getClass()) {
                        opKey = TypeConversionHelper.convertTo((Object)opKey, key.getClass());
                    }
                    if (!opKey.equals(key)) continue;
                    op = missingOp;
                    break;
                }
                if (this.cmd.getIdentityType() != IdentityType.APPLICATION) continue;
                if (this.cmd.usesSingleFieldIdentityClass()) {
                    opKey = IdentityUtils.getTargetKeyForSingleFieldIdentity((Object)opId);
                    if (!opKey.equals(key)) continue;
                    op = missingOp;
                    break;
                }
                if (!opId.equals(id)) continue;
                op = missingOp;
                break;
            }
            if (op == null) continue;
            missingOps.remove(op);
            int[] selectedMemberNums = this.resultMapping.getMemberNumbers();
            int[] unloadedMemberNums = ClassUtils.getFlagsSetTo((boolean[])op.getLoadedFields(), (int[])selectedMemberNums, (boolean)false);
            if (unloadedMemberNums != null && unloadedMemberNums.length > 0) {
                op.replaceFields(unloadedMemberNums, resultFM);
            }
            if (op.getTransactionalVersion() != null || this.table.getVersionMapping(false) == null) continue;
            VersionMetaData currentVermd = this.table.getVersionMetaData();
            Object datastoreVersion = null;
            if (currentVermd == null) continue;
            if (currentVermd.getFieldName() == null) {
                StatementMappingIndex verIdx = this.resultMapping.getMappingForMemberPosition(-2);
                datastoreVersion = this.table.getVersionMapping(true).getObject(ec, rs, verIdx.getColumnPositions());
            } else {
                datastoreVersion = op.provideField(this.cmd.getAbsolutePositionOfMember(currentVermd.getFieldName()));
            }
            op.setVersion(datastoreVersion);
        }
        if (!missingOps.isEmpty()) {
            return missingOps.toArray(new ObjectProvider[missingOps.size()]);
        }
        return null;
    }
}

