/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.util.List;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.rdbms.sql.SQLText;
import org.datanucleus.store.rdbms.sql.expression.ExpressionUtils;
import org.datanucleus.store.rdbms.sql.expression.IntegerLiteral;
import org.datanucleus.store.rdbms.sql.expression.NumericExpression;
import org.datanucleus.store.rdbms.sql.expression.ParameterLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.StringExpression;
import org.datanucleus.store.rdbms.sql.method.AbstractSQLMethod;
import org.datanucleus.util.Localiser;

public class StringSubstring5Method
extends AbstractSQLMethod {
    @Override
    public SQLExpression getExpression(SQLExpression expr, List<SQLExpression> args) {
        if (args == null || args.size() == 0 || args.size() > 2) {
            throw new NucleusException(Localiser.msg((String)"060003", (Object[])new Object[]{"substring", "StringExpression", 0, "NumericExpression/IntegerLiteral/ParameterLiteral"}));
        }
        if (args.size() == 1) {
            SQLExpression one = ExpressionUtils.getLiteralForOne(this.stmt);
            SQLExpression startExpr = args.get(0);
            if (!(startExpr instanceof NumericExpression || startExpr instanceof IntegerLiteral || startExpr instanceof ParameterLiteral)) {
                throw new NucleusException(Localiser.msg((String)"060003", (Object[])new Object[]{"substring", "StringExpression", 0, "NumericExpression/IntegerLiteral/ParameterLiteral"}));
            }
            StringExpression strExpr = new StringExpression(this.stmt, null, null);
            SQLText sql = strExpr.toSQLText();
            sql.append("SUBSTRING(").append(expr).append(" FROM CAST(").append(startExpr.add(one)).append(" AS INTEGER))");
            return strExpr;
        }
        SQLExpression one = ExpressionUtils.getLiteralForOne(this.stmt);
        SQLExpression startExpr = args.get(0);
        if (!(startExpr instanceof NumericExpression)) {
            throw new NucleusException(Localiser.msg((String)"060003", (Object[])new Object[]{"substring", "StringExpression", 0, "NumericExpression"}));
        }
        SQLExpression endExpr = args.get(1);
        if (!(endExpr instanceof NumericExpression)) {
            throw new NucleusException(Localiser.msg((String)"060003", (Object[])new Object[]{"substring", "StringExpression", 1, "NumericExpression"}));
        }
        StringExpression strExpr = new StringExpression(this.stmt, null, null);
        SQLText sql = strExpr.toSQLText();
        sql.append("SUBSTRING(").append(expr).append(" FROM CAST(").append(startExpr.add(one)).append(" AS INTEGER) FOR CAST(").append(endExpr.sub(startExpr)).append(" AS INTEGER))");
        return strExpr;
    }
}

