/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.java;

import java.lang.reflect.Array;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.java.SingleFieldMultiMapping;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.store.types.converters.MultiColumnConverter;
import org.datanucleus.store.types.converters.TypeConverter;

public class TypeConverterMultiMapping
extends SingleFieldMultiMapping {
    TypeConverter converter;

    @Override
    public void initialize(RDBMSStoreManager storeMgr, String type) {
        super.initialize(storeMgr, type);
        ClassLoaderResolver clr = storeMgr.getNucleusContext().getClassLoaderResolver(null);
        Class fieldType = clr.classForName(type);
        this.converter = storeMgr.getNucleusContext().getTypeManager().getDefaultTypeConverterForType(fieldType);
        if (this.converter == null) {
            throw new NucleusUserException("Unable to find TypeConverter for converting " + fieldType + " to String");
        }
        if (!(this.converter instanceof MultiColumnConverter)) {
            throw new NucleusUserException("Not able to use " + this.getClass().getName() + " for java type " + type + " since provided TypeConverter " + this.converter + " does not implement MultiColumnConverter");
        }
        MultiColumnConverter multiConv = (MultiColumnConverter)this.converter;
        Class[] colTypes = multiConv.getDatastoreColumnTypes();
        for (int i = 0; i < colTypes.length; ++i) {
            this.addColumns(colTypes[i].getName());
        }
    }

    @Override
    public void initialize(AbstractMemberMetaData mmd, Table table, ClassLoaderResolver clr) {
        this.initialize(mmd, table, clr, null);
    }

    public void initialize(AbstractMemberMetaData mmd, Table table, ClassLoaderResolver clr, TypeConverter conv) {
        super.initialize(mmd, table, clr);
        if (mmd.getTypeConverterName() != null) {
            this.converter = table.getStoreManager().getNucleusContext().getTypeManager().getTypeConverterForName(mmd.getTypeConverterName());
        } else if (conv != null) {
            this.converter = conv;
        } else {
            throw new NucleusUserException("Unable to initialise mapping of type " + this.getClass().getName() + " for field " + mmd.getFullFieldName() + " since no TypeConverter was provided");
        }
        if (!(this.converter instanceof MultiColumnConverter)) {
            throw new NucleusUserException("Not able to use " + this.getClass().getName() + " for field " + mmd.getFullFieldName() + " since provided TypeConverter " + this.converter + " does not implement MultiColumnConverter");
        }
        MultiColumnConverter multiConv = (MultiColumnConverter)this.converter;
        Class[] colTypes = multiConv.getDatastoreColumnTypes();
        for (int i = 0; i < colTypes.length; ++i) {
            this.addColumns(colTypes[i].getName());
        }
    }

    public TypeConverter getTypeConverter() {
        return this.converter;
    }

    @Override
    public Class getJavaType() {
        return this.mmd != null ? this.mmd.getType() : this.storeMgr.getNucleusContext().getClassLoaderResolver(null).classForName(this.type);
    }

    @Override
    public void setObject(ExecutionContext ec, PreparedStatement ps, int[] exprIndex, Object value) {
        if (exprIndex == null) {
            return;
        }
        Object colArray = this.converter.toDatastoreType(value);
        if (colArray == null) {
            for (int i = 0; i < exprIndex.length; ++i) {
                this.getDatastoreMapping(i).setObject(ps, exprIndex[i], null);
            }
        } else {
            for (int i = 0; i < exprIndex.length; ++i) {
                Object colValue = Array.get(colArray, i);
                if (colValue == null) {
                    this.getDatastoreMapping(i).setObject(ps, exprIndex[i], null);
                    continue;
                }
                Class<?> colValCls = colValue.getClass();
                if (colValCls == Integer.TYPE || colValCls == Integer.class) {
                    this.getDatastoreMapping(i).setInt(ps, exprIndex[i], (Integer)colValue);
                    continue;
                }
                if (colValCls == Long.TYPE || colValCls == Long.class) {
                    this.getDatastoreMapping(i).setLong(ps, exprIndex[i], (Long)colValue);
                    continue;
                }
                if (colValCls == Double.TYPE || colValCls == Double.class) {
                    this.getDatastoreMapping(i).setDouble(ps, exprIndex[i], (Double)colValue);
                    continue;
                }
                if (colValCls == Float.TYPE || colValCls == Float.class) {
                    this.getDatastoreMapping(i).setFloat(ps, exprIndex[i], ((Float)colValue).floatValue());
                    continue;
                }
                if (colValCls == String.class) {
                    this.getDatastoreMapping(i).setString(ps, exprIndex[i], (String)colValue);
                    continue;
                }
                this.getDatastoreMapping(i).setObject(ps, exprIndex[i], colValue);
            }
        }
    }

    @Override
    public Object getObject(ExecutionContext ec, ResultSet resultSet, int[] exprIndex) {
        if (exprIndex == null) {
            return null;
        }
        Object[] valuesArr = null;
        Class[] colTypes = ((MultiColumnConverter)this.converter).getDatastoreColumnTypes();
        valuesArr = colTypes[0] == Integer.TYPE ? new int[exprIndex.length] : (colTypes[0] == Long.TYPE ? (Object[])new long[exprIndex.length] : (colTypes[0] == Double.TYPE ? (Object[])new double[exprIndex.length] : (colTypes[0] == Float.TYPE ? (Object[])new double[exprIndex.length] : (colTypes[0] == String.class ? (Object[])new String[exprIndex.length] : (Object[])new Object[exprIndex.length]))));
        boolean isNull = true;
        for (int i = 0; i < exprIndex.length; ++i) {
            String colJavaType = this.getJavaTypeForDatastoreMapping(i);
            if (colJavaType.equals("int") || colJavaType.equals("java.lang.Integer")) {
                Array.set(valuesArr, i, this.getDatastoreMapping(i).getInt(resultSet, exprIndex[i]));
            } else if (colJavaType.equals("long") || colJavaType.equals("java.lang.Long")) {
                Array.set(valuesArr, i, this.getDatastoreMapping(i).getLong(resultSet, exprIndex[i]));
            } else if (colJavaType.equals("double") || colJavaType.equals("java.lang.Double")) {
                Array.set(valuesArr, i, this.getDatastoreMapping(i).getDouble(resultSet, exprIndex[i]));
            } else if (colJavaType.equals("float") || colJavaType.equals("java.lang.Float")) {
                Array.set(valuesArr, i, Float.valueOf(this.getDatastoreMapping(i).getFloat(resultSet, exprIndex[i])));
            } else if (colJavaType.equals("java.lang.String")) {
                Array.set(valuesArr, i, this.getDatastoreMapping(i).getString(resultSet, exprIndex[i]));
            } else {
                Array.set(valuesArr, i, this.getDatastoreMapping(i).getObject(resultSet, exprIndex[i]));
            }
            if (!isNull || Array.get(valuesArr, i) == null) continue;
            isNull = false;
        }
        if (isNull) {
            return null;
        }
        return this.converter.toMemberType((Object)valuesArr);
    }
}

