/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.connectionpool;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import javax.sql.DataSource;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.rdbms.connectionpool.AbstractConnectionPoolFactory;
import org.datanucleus.store.rdbms.connectionpool.ConnectionPool;
import org.datanucleus.util.ClassUtils;

public class HikariCPConnectionPoolFactory
extends AbstractConnectionPoolFactory {
    @Override
    public ConnectionPool createConnectionPool(StoreManager storeMgr) {
        long maxLifeTime;
        long threshold;
        long idle;
        int size;
        String dbPassword;
        String dbDriver = storeMgr.getConnectionDriverName();
        String dbURL = storeMgr.getConnectionURL();
        String dbUser = storeMgr.getConnectionUserName();
        if (dbUser == null) {
            dbUser = "";
        }
        if ((dbPassword = storeMgr.getConnectionPassword()) == null) {
            dbPassword = "";
        }
        ClassLoaderResolver clr = storeMgr.getNucleusContext().getClassLoaderResolver(null);
        this.loadDriver(dbDriver, clr);
        ClassUtils.assertClassForJarExistsInClasspath((ClassLoaderResolver)clr, (String)"com.zaxxer.hikari.HikariConfig", (String)"hikaricp.jar");
        HikariConfig config = new HikariConfig();
        config.setDriverClassName(dbDriver);
        config.setJdbcUrl(dbURL);
        config.setUsername(dbUser);
        config.setPassword(dbPassword);
        if (storeMgr.hasProperty("datanucleus.connectionPool.maxPoolSize") && (size = storeMgr.getIntProperty("datanucleus.connectionPool.maxPoolSize")) >= 0) {
            config.setMaximumPoolSize(size);
        }
        if (storeMgr.hasProperty("datanucleus.connectionPool.maxIdle") && (idle = (long)storeMgr.getIntProperty("datanucleus.connectionPool.maxIdle")) >= 0L) {
            config.setIdleTimeout(idle);
        }
        if (storeMgr.hasProperty("datanucleus.connectionPool.leakThreshold") && (threshold = (long)storeMgr.getIntProperty("datanucleus.connectionPool.leakThreshold")) >= 0L) {
            config.setLeakDetectionThreshold(threshold);
        }
        if (storeMgr.hasProperty("datanucleus.connectionPool.maxLifetime") && (maxLifeTime = (long)storeMgr.getIntProperty("datanucleus.connectionPool.maxLifetime")) >= 0L) {
            config.setMaxLifetime(maxLifeTime);
        }
        HikariDataSource ds = new HikariDataSource(config);
        return new HikariCPConnectionPool(ds);
    }

    public class HikariCPConnectionPool
    implements ConnectionPool {
        final HikariDataSource dataSource;

        public HikariCPConnectionPool(HikariDataSource ds) {
            this.dataSource = ds;
        }

        @Override
        public void close() {
            this.dataSource.close();
        }

        @Override
        public DataSource getDataSource() {
            return this.dataSource;
        }
    }
}

