/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.util.ArrayList;
import java.util.List;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.expression.IntegerLiteral;
import org.datanucleus.store.rdbms.sql.expression.NumericExpression;
import org.datanucleus.store.rdbms.sql.expression.ParameterLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.StringExpression;
import org.datanucleus.store.rdbms.sql.expression.StringLiteral;
import org.datanucleus.store.rdbms.sql.method.AbstractSQLMethod;

public class StringLength3Method
extends AbstractSQLMethod {
    @Override
    public SQLExpression getExpression(SQLExpression expr, List<SQLExpression> args) {
        if (expr instanceof StringLiteral) {
            JavaTypeMapping m = this.exprFactory.getMappingForType(Integer.TYPE, false);
            String val = (String)((StringLiteral)expr).getValue();
            return new IntegerLiteral(this.stmt, m, val.length(), null);
        }
        if (expr instanceof StringExpression || expr instanceof ParameterLiteral) {
            ArrayList<SQLExpression> funcArgs = new ArrayList<SQLExpression>();
            funcArgs.add(expr);
            return new NumericExpression(this.stmt, this.getMappingForClass(Integer.TYPE), "LENGTH", funcArgs);
        }
        throw new NucleusException(LOCALISER.msg("060001", (Object)"length", (Object)expr));
    }
}

