/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.util.List;
import java.util.Map;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MapMetaData;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.MapLiteral;
import org.datanucleus.store.rdbms.sql.expression.NumericSubqueryExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.StringLiteral;
import org.datanucleus.store.rdbms.sql.method.AbstractSQLMethod;
import org.datanucleus.store.rdbms.table.DatastoreClass;
import org.datanucleus.store.rdbms.table.JoinTable;
import org.datanucleus.store.rdbms.table.Table;

public class MapSizeMethod
extends AbstractSQLMethod {
    @Override
    public SQLExpression getExpression(SQLExpression expr, List<SQLExpression> args) {
        if (args != null && args.size() > 0) {
            throw new NucleusException(LOCALISER.msg("060015", (Object)"size", (Object)"MapExpression"));
        }
        if (expr instanceof MapLiteral) {
            Map map = (Map)((MapLiteral)expr).getValue();
            return this.exprFactory.newLiteral(this.stmt, this.exprFactory.getMappingForType(Integer.TYPE, false), map.size());
        }
        AbstractMemberMetaData ownerMmd = expr.getJavaTypeMapping().getMemberMetaData();
        RDBMSStoreManager storeMgr = this.stmt.getRDBMSManager();
        JavaTypeMapping ownerMapping = null;
        Table mapTbl = null;
        if (ownerMmd.getMap().getMapType() == MapMetaData.MapType.MAP_TYPE_JOIN) {
            mapTbl = storeMgr.getTable(ownerMmd);
            ownerMapping = ((JoinTable)mapTbl).getOwnerMapping();
        } else if (ownerMmd.getMap().getMapType() == MapMetaData.MapType.MAP_TYPE_KEY_IN_VALUE) {
            AbstractClassMetaData valueCmd = storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForClass(ownerMmd.getMap().getValueType(), this.clr);
            mapTbl = storeMgr.getDatastoreClass(ownerMmd.getMap().getValueType(), this.clr);
            ownerMapping = ownerMmd.getMappedBy() != null ? mapTbl.getMemberMapping(valueCmd.getMetaDataForMember(ownerMmd.getMappedBy())) : ((DatastoreClass)mapTbl).getExternalMapping(ownerMmd, 5);
        } else if (ownerMmd.getMap().getMapType() == MapMetaData.MapType.MAP_TYPE_VALUE_IN_KEY) {
            AbstractClassMetaData keyCmd = storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForClass(ownerMmd.getMap().getKeyType(), this.clr);
            mapTbl = storeMgr.getDatastoreClass(ownerMmd.getMap().getKeyType(), this.clr);
            ownerMapping = ownerMmd.getMappedBy() != null ? mapTbl.getMemberMapping(keyCmd.getMetaDataForMember(ownerMmd.getMappedBy())) : ((DatastoreClass)mapTbl).getExternalMapping(ownerMmd, 5);
        } else {
            throw new NucleusException("Invalid map for " + expr + " in size() call");
        }
        SQLStatement subStmt = new SQLStatement(this.stmt, storeMgr, mapTbl, null, null);
        subStmt.setClassLoaderResolver(this.clr);
        JavaTypeMapping mapping = storeMgr.getMappingManager().getMappingWithDatastoreMapping(String.class, false, false, this.clr);
        SQLExpression countExpr = this.exprFactory.newLiteral(subStmt, mapping, "COUNT(*)");
        ((StringLiteral)countExpr).generateStatementWithoutQuotes();
        subStmt.select(countExpr, null);
        SQLExpression elementOwnerExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), ownerMapping);
        SQLExpression ownerIdExpr = this.exprFactory.newExpression(this.stmt, expr.getSQLTable(), expr.getSQLTable().getTable().getIdMapping());
        subStmt.whereAnd(elementOwnerExpr.eq(ownerIdExpr), true);
        JavaTypeMapping subqMapping = this.exprFactory.getMappingForType(Integer.class, false);
        NumericSubqueryExpression subqExpr = new NumericSubqueryExpression(this.stmt, subStmt);
        subqExpr.setJavaTypeMapping(subqMapping);
        return subqExpr;
    }
}

