/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.identifier;

import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.store.rdbms.adapter.DatastoreAdapter;
import org.datanucleus.store.rdbms.identifier.ColumnIdentifier;
import org.datanucleus.store.rdbms.identifier.DNIdentifierFactory;
import org.datanucleus.store.rdbms.identifier.DatastoreIdentifier;
import org.datanucleus.store.schema.naming.NamingCase;

public class DN2IdentifierFactory
extends DNIdentifierFactory {
    public DN2IdentifierFactory(DatastoreAdapter dba, ClassLoaderResolver clr, Map props) {
        super(dba, clr, props);
    }

    @Override
    public DatastoreIdentifier newJoinTableFieldIdentifier(AbstractMemberMetaData ownerFmd, AbstractMemberMetaData relatedFmd, DatastoreIdentifier destinationId, boolean embedded, int fieldRole) {
        if (destinationId != null) {
            RelationType relType = ownerFmd.getRelationType(this.clr);
            if (relType == RelationType.MANY_TO_MANY_BI && ownerFmd.hasCollection() && ownerFmd.getMappedBy() != null) {
                if (fieldRole == 3) {
                    fieldRole = 1;
                } else if (fieldRole == 1) {
                    fieldRole = 3;
                }
            }
            return this.newColumnIdentifier(destinationId.getIdentifierName(), embedded, fieldRole);
        }
        String baseName = null;
        baseName = fieldRole == 3 ? "ELEMENT" : (fieldRole == 4 ? "ELEMENT" : (fieldRole == 5 ? "KEY" : (fieldRole == 6 ? "VALUE" : "UNKNOWN")));
        return this.newColumnIdentifier(baseName);
    }

    public DatastoreIdentifier newForeignKeyFieldIdentifier(AbstractMemberMetaData ownerFmd, DatastoreIdentifier destinationId, boolean embedded, int fieldRole) {
        if (fieldRole == 1) {
            return this.newColumnIdentifier(ownerFmd.getName() + "." + destinationId.getIdentifierName(), embedded, fieldRole);
        }
        if (fieldRole == 7) {
            return this.newColumnIdentifier(ownerFmd.getName(), embedded, fieldRole);
        }
        throw new NucleusException("Column role " + fieldRole + " not supported by this method").setFatal();
    }

    @Override
    public DatastoreIdentifier newVersionFieldIdentifier() {
        String name = "VERSION";
        DatastoreIdentifier identifier = (DatastoreIdentifier)this.columns.get(name);
        if (identifier == null) {
            identifier = new ColumnIdentifier(this, name);
            this.columns.put(name, identifier);
        }
        return identifier;
    }

    @Override
    public DatastoreIdentifier newIndexFieldIdentifier(AbstractMemberMetaData mmd) {
        String name = "IDX";
        DatastoreIdentifier identifier = (DatastoreIdentifier)this.columns.get(name);
        if (identifier == null) {
            identifier = new ColumnIdentifier(this, name);
            this.columns.put(name, identifier);
        }
        return identifier;
    }

    @Override
    public DatastoreIdentifier newAdapterIndexFieldIdentifier() {
        return this.newIndexFieldIdentifier(null);
    }

    @Override
    public String generateIdentifierNameForJavaName(String javaName) {
        if (javaName == null) {
            return null;
        }
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < javaName.length(); ++i) {
            char c = javaName.charAt(i);
            if (c >= 'A' && c <= 'Z' && this.namingCase != NamingCase.MIXED_CASE && this.namingCase != NamingCase.MIXED_CASE_QUOTED) {
                s.append(c);
                continue;
            }
            if (c >= 'A' && c <= 'Z' && (this.namingCase == NamingCase.MIXED_CASE || this.namingCase == NamingCase.MIXED_CASE_QUOTED)) {
                s.append(c);
                continue;
            }
            if (c >= 'a' && c <= 'z' && (this.namingCase == NamingCase.MIXED_CASE || this.namingCase == NamingCase.MIXED_CASE_QUOTED)) {
                s.append(c);
                continue;
            }
            if (c >= 'a' && c <= 'z' && this.namingCase != NamingCase.MIXED_CASE && this.namingCase != NamingCase.MIXED_CASE_QUOTED) {
                s.append((char)(c - 32));
                continue;
            }
            if (c >= '0' && c <= '9' || c == '_') {
                s.append(c);
                continue;
            }
            if (c == '.') {
                s.append(this.wordSeparator);
                continue;
            }
            String cval = "000" + Integer.toHexString(c);
            s.append(cval.substring(cval.length() - (c > '\u00ff' ? 4 : 2)));
        }
        while (s.length() > 0 && s.charAt(0) == '_') {
            s.deleteCharAt(0);
        }
        if (s.length() == 0) {
            throw new IllegalArgumentException("Illegal Java identifier: " + javaName);
        }
        return s.toString();
    }
}

