/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.adapter;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.rdbms.adapter.BaseDatastoreAdapter;
import org.datanucleus.store.rdbms.identifier.IdentifierType;
import org.datanucleus.store.rdbms.schema.DB2TypeInfo;
import org.datanucleus.store.rdbms.schema.RDBMSColumnInfo;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.store.schema.StoreSchemaHandler;
import org.datanucleus.util.StringUtils;

public class DB2Adapter
extends BaseDatastoreAdapter {
    public static final String DB2_RESERVED_WORDS = "ACCESS,ALIAS,ALLOW,ASUTIME,AUDIT,AUX,AUXILIARY,BUFFERPOOL,CAPTURE,CCSID,CLUSTER,COLLECTION,COLLID,COMMENT,CONCAT,CONTAINS,COUNT_BIG,CURRENT_LC_PATH,CURRENT_SERVER,CURRENT_TIMEZONE,DATABASE,DAYS,DB2GENERAL,DB2SQL,DBA,DBINFO,DBSPACE,DISALLOW,DSSIZE,EDITPROC,ERASE,EXCLUSIVE,EXPLAIN,FENCED,FIELDPROC,FILE,FINAL,GENERATED,GRAPHIC,HOURS,IDENTIFIED,INDEX,INTEGRITY,ISOBID,JAVA,LABEL,LC_CTYPE,LINKTYPE,LOCALE,LOCATORS,LOCK,LOCKSIZE,LONG,MICROSECOND,MICROSECONDS,MINUTES,MODE,MONTHS,NAME,NAMED,NHEADER,NODENAME,NODENUMBER,NULLS,NUMPARTS,OBID,OPTIMIZATION,OPTIMIZE,PACKAGE,PAGE,PAGES,PART,PCTFREE,PCTINDEX,PIECESIZE,PLAN,PRIQTY,PRIVATE,PROGRAM,PSID,QYERYNO,RECOVERY,RENAME,RESET,RESOURCE,RRN,RUN,SCHEDULE,SCRATCHPAD,SECONDS,SECQTY,SECURITY,SHARE,SIMPLE,SOURCE,STANDARD,STATISTICS,STAY,STOGROUP,STORES,STORPOOL,STYLE,SUBPAGES,SYNONYM,TABLESPACE,TYPE,VALIDPROC,VARIABLE,VARIANT,VCAT,VOLUMES,WLM,YEARS";

    public DB2Adapter(DatabaseMetaData metadata) {
        super(metadata);
        this.reservedKeywords.addAll(StringUtils.convertCommaSeparatedStringToSet((String)DB2_RESERVED_WORDS));
        this.supportedOptions.add("LockWithSelectForUpdate");
        this.supportedOptions.add("IdentityColumns");
        this.supportedOptions.add("Sequences");
        this.supportedOptions.add("AnalysisMethods");
        this.supportedOptions.add("StoredProcs");
        this.supportedOptions.add("UseUnionAll");
        this.supportedOptions.add("OrderByWithNullsDirectives");
        this.supportedOptions.remove("BooleanExpression");
        this.supportedOptions.remove("DeferredConstraints");
        this.supportedOptions.remove("NullsInCandidateKeys");
        this.supportedOptions.remove("ColumnOptions_NullsKeyword");
        this.supportedOptions.remove("FkDeleteActionDefault");
        this.supportedOptions.remove("FkUpdateActionDefault");
        this.supportedOptions.remove("FkUpdateActionCascade");
        this.supportedOptions.remove("FkUpdateActionNull");
    }

    @Override
    public void initialiseTypes(StoreSchemaHandler handler, ManagedConnection mconn) {
        super.initialiseTypes(handler, mconn);
        DB2TypeInfo sqlType = new DB2TypeInfo("FLOAT", 6, 53, null, null, null, 1, false, 2, false, false, false, null, 0, 0, 0);
        this.addSQLTypeForJDBCType(handler, mconn, (short)6, sqlType, true);
        sqlType = new DB2TypeInfo("NUMERIC", 2, 31, null, null, "PRECISION,SCALE", 1, false, 2, false, false, false, null, 0, 31, 0);
        this.addSQLTypeForJDBCType(handler, mconn, (short)2, sqlType, true);
        sqlType = new DB2TypeInfo("BIGINT", -5, 20, null, null, null, 1, false, 2, false, true, false, null, 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)-5, sqlType, true);
        sqlType = new DB2TypeInfo("XML", 2009, Integer.MAX_VALUE, null, null, null, 1, false, 2, false, false, false, null, 0, 0, 0);
        this.addSQLTypeForJDBCType(handler, mconn, (short)2009, sqlType, true);
        sqlType = new DB2TypeInfo("SMALLINT", 5, 5, null, null, null, 1, false, 2, false, true, false, null, 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)-7, sqlType, true);
    }

    @Override
    public String getVendorID() {
        return "db2";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSchemaName(Connection conn) throws SQLException {
        try (Statement stmt = conn.createStatement();){
            String string;
            String stmtText = "VALUES (CURRENT SCHEMA)";
            ResultSet rs = stmt.executeQuery(stmtText);
            try {
                if (!rs.next()) {
                    throw new NucleusDataStoreException("No result returned from " + stmtText).setFatal();
                }
                string = rs.getString(1).trim();
            }
            catch (Throwable throwable) {
                rs.close();
                throw throwable;
            }
            rs.close();
            return string;
        }
    }

    @Override
    public int getDatastoreIdentifierMaxLength(IdentifierType identifierType) {
        if (identifierType == IdentifierType.CANDIDATE_KEY) {
            return 18;
        }
        if (identifierType == IdentifierType.FOREIGN_KEY) {
            return 18;
        }
        if (identifierType == IdentifierType.INDEX) {
            return 18;
        }
        if (identifierType == IdentifierType.PRIMARY_KEY) {
            return 18;
        }
        return super.getDatastoreIdentifierMaxLength(identifierType);
    }

    @Override
    public SQLTypeInfo newSQLTypeInfo(ResultSet rs) {
        return new DB2TypeInfo(rs);
    }

    @Override
    public RDBMSColumnInfo newRDBMSColumnInfo(ResultSet rs) {
        RDBMSColumnInfo info = new RDBMSColumnInfo(rs);
        short dataType = info.getDataType();
        switch (dataType) {
            case 91: 
            case 92: 
            case 93: {
                info.setDecimalDigits(0);
                break;
            }
        }
        return info;
    }

    @Override
    public String getDropDatabaseStatement(String schemaName, String catalogName) {
        throw new UnsupportedOperationException("DB2 does not support dropping schema with cascade. You need to drop all tables first");
    }

    @Override
    public String getDropTableStatement(Table table) {
        return "DROP TABLE " + table.toString();
    }

    @Override
    public String getAutoIncrementStmt(Table table, String columnName) {
        return "VALUES IDENTITY_VAL_LOCAL()";
    }

    @Override
    public String getAutoIncrementKeyword() {
        return "generated always as identity (start with 1)";
    }

    @Override
    public String getContinuationString() {
        return "";
    }

    @Override
    public String getSequenceCreateStmt(String sequence_name, Integer min, Integer max, Integer start, Integer increment, Integer cache_size) {
        if (sequence_name == null) {
            throw new NucleusUserException(LOCALISER.msg("051028"));
        }
        StringBuilder stmt = new StringBuilder("CREATE SEQUENCE ");
        stmt.append(sequence_name);
        stmt.append(" AS INTEGER ");
        if (start != null) {
            stmt.append(" START WITH " + start);
        }
        if (increment != null) {
            stmt.append(" INCREMENT BY " + increment);
        }
        if (min != null) {
            stmt.append(" MINVALUE " + min);
        }
        if (max != null) {
            stmt.append(" MAXVALUE " + max);
        }
        if (cache_size != null) {
            stmt.append(" CACHE " + cache_size);
        } else {
            stmt.append(" NOCACHE");
        }
        return stmt.toString();
    }

    @Override
    public String getSequenceNextStmt(String sequence_name) {
        if (sequence_name == null) {
            throw new NucleusUserException(LOCALISER.msg("051028"));
        }
        StringBuilder stmt = new StringBuilder("VALUES NEXTVAL FOR ");
        stmt.append(sequence_name);
        return stmt.toString();
    }

    @Override
    public String getRangeByRowNumberColumn() {
        return "row_number()over()";
    }

    @Override
    public boolean isStatementCancel(SQLException sqle) {
        return sqle.getErrorCode() == -952;
    }

    @Override
    public boolean isStatementTimeout(SQLException sqle) {
        if (sqle.getSQLState() != null && sqle.getSQLState().equalsIgnoreCase("57014") && (sqle.getErrorCode() == -952 || sqle.getErrorCode() == -905)) {
            return true;
        }
        return super.isStatementTimeout(sqle);
    }
}

