/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.lang.reflect.Array;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.FetchPlan;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ArrayMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.mapping.MappingHelper;
import org.datanucleus.store.rdbms.mapping.StatementClassMapping;
import org.datanucleus.store.rdbms.mapping.datastore.AbstractDatastoreMapping;
import org.datanucleus.store.rdbms.scostore.AbstractArrayStore;
import org.datanucleus.store.rdbms.scostore.BackingStoreHelper;
import org.datanucleus.store.rdbms.scostore.IteratorStatement;
import org.datanucleus.store.rdbms.sql.DiscriminatorStatementGenerator;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLStatementHelper;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.UnionStatementGenerator;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.table.DatastoreClass;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;

public class FKArrayStore
extends AbstractArrayStore {
    private String clearNullifyStmt;
    private String updateFkStmt;

    public FKArrayStore(AbstractMemberMetaData mmd, RDBMSStoreManager storeMgr, ClassLoaderResolver clr) {
        super(storeMgr, clr);
        this.setOwner(mmd);
        ArrayMetaData arrmd = mmd.getArray();
        if (arrmd == null) {
            throw new NucleusUserException(LOCALISER.msg("056000", (Object)mmd.getFullFieldName()));
        }
        this.elementType = mmd.getType().getComponentType().getName();
        Class element_class = clr.classForName(this.elementType);
        if (ClassUtils.isReferenceType((Class)element_class)) {
            this.emd = storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForImplementationOfReference(element_class, null, clr);
            if (this.emd != null) {
                this.elementType = this.emd.getFullClassName();
            }
        } else {
            this.emd = storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForClass(element_class, clr);
        }
        if (this.emd == null) {
            throw new NucleusUserException(LOCALISER.msg("056003", (Object)element_class.getName(), (Object)mmd.getFullFieldName()));
        }
        this.elementInfo = this.getElementInformationForClass();
        if (this.elementInfo != null && this.elementInfo.length > 1) {
            throw new NucleusUserException(LOCALISER.msg("056045", (Object)this.ownerMemberMetaData.getFullFieldName()));
        }
        this.elementMapping = this.elementInfo[0].getDatastoreClass().getIdMapping();
        this.elementsAreEmbedded = false;
        this.elementsAreSerialised = false;
        String mappedByFieldName = mmd.getMappedBy();
        if (mappedByFieldName != null) {
            AbstractMemberMetaData eofmd;
            AbstractClassMetaData eoCmd = storeMgr.getMetaDataManager().getMetaDataForClass(element_class, clr);
            AbstractMemberMetaData abstractMemberMetaData = eofmd = eoCmd != null ? eoCmd.getMetaDataForMember(mappedByFieldName) : null;
            if (eofmd == null) {
                throw new NucleusUserException(LOCALISER.msg("056024", (Object)mmd.getFullFieldName(), (Object)mappedByFieldName, (Object)element_class.getName()));
            }
            if (!clr.isAssignableFrom(eofmd.getType(), mmd.getAbstractClassMetaData().getFullClassName())) {
                throw new NucleusUserException(LOCALISER.msg("056025", (Object)mmd.getFullFieldName(), (Object)eofmd.getFullFieldName(), (Object)eofmd.getTypeName(), (Object)mmd.getAbstractClassMetaData().getFullClassName()));
            }
            String ownerFieldName = eofmd.getName();
            this.ownerMapping = this.elementInfo[0].getDatastoreClass().getMemberMapping(eofmd);
            if (this.ownerMapping == null) {
                throw new NucleusUserException(LOCALISER.msg("056046", (Object)mmd.getAbstractClassMetaData().getFullClassName(), (Object)mmd.getName(), (Object)this.elementType, (Object)ownerFieldName));
            }
            if (this.isEmbeddedMapping(this.ownerMapping)) {
                throw new NucleusUserException(LOCALISER.msg("056026", (Object)ownerFieldName, (Object)this.elementType, (Object)eofmd.getTypeName(), (Object)mmd.getClassName()));
            }
        } else {
            this.ownerMapping = this.elementInfo[0].getDatastoreClass().getExternalMapping(mmd, 5);
            if (this.ownerMapping == null) {
                throw new NucleusUserException(LOCALISER.msg("056047", (Object)mmd.getAbstractClassMetaData().getFullClassName(), (Object)mmd.getName(), (Object)this.elementType));
            }
        }
        this.orderMapping = this.elementInfo[0].getDatastoreClass().getExternalMapping(mmd, 4);
        if (this.orderMapping == null) {
            throw new NucleusUserException(LOCALISER.msg("056048", (Object)mmd.getAbstractClassMetaData().getFullClassName(), (Object)mmd.getName(), (Object)this.elementType));
        }
        this.relationDiscriminatorMapping = this.elementInfo[0].getDatastoreClass().getExternalMapping(mmd, 6);
        if (this.relationDiscriminatorMapping != null) {
            this.relationDiscriminatorValue = mmd.getValueForExtension("relation-discriminator-value");
            if (this.relationDiscriminatorValue == null) {
                this.relationDiscriminatorValue = mmd.getFullFieldName();
            }
        }
        this.containerTable = this.elementInfo[0].getDatastoreClass();
        if (mmd.getMappedBy() != null && this.ownerMapping.getTable() != this.containerTable) {
            this.containerTable = this.ownerMapping.getTable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateElementFk(ObjectProvider ownerOP, Object element, Object owner, int index) {
        boolean retval;
        if (element == null) {
            return false;
        }
        String updateFkStmt = this.getUpdateFkStmt();
        ExecutionContext ec = ownerOP.getExecutionContext();
        try {
            ManagedConnection mconn = this.storeMgr.getConnection(ec);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, updateFkStmt, false);
                try {
                    int jdbcPosition = 1;
                    if (this.elementInfo.length > 1) {
                        DatastoreClass table = this.storeMgr.getDatastoreClass(element.getClass().getName(), this.clr);
                        if (table != null) {
                            ps.setString(jdbcPosition++, table.toString());
                        } else {
                            NucleusLogger.PERSISTENCE.info((Object)(">> FKArrayStore.updateElementFK : need to set table in statement but dont know table where to store " + element));
                        }
                    }
                    if (owner == null) {
                        this.ownerMapping.setObject(ec, ps, MappingHelper.getMappingIndices(jdbcPosition, this.ownerMapping), null);
                        jdbcPosition += this.ownerMapping.getNumberOfDatastoreMappings();
                    } else {
                        jdbcPosition = BackingStoreHelper.populateOwnerInStatement(ownerOP, ec, ps, jdbcPosition, this);
                    }
                    jdbcPosition = BackingStoreHelper.populateOrderInStatement(ec, ps, index, jdbcPosition, this.orderMapping);
                    if (this.relationDiscriminatorMapping != null) {
                        jdbcPosition = BackingStoreHelper.populateRelationDiscriminatorInStatement(ec, ps, jdbcPosition, this);
                    }
                    jdbcPosition = BackingStoreHelper.populateElementInStatement(ec, ps, element, jdbcPosition, this.elementMapping);
                    sqlControl.executeStatementUpdate(ec, mconn, updateFkStmt, ps, true);
                    retval = true;
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("056027", (Object)updateFkStmt), (Throwable)e);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUpdateFkStmt() {
        if (this.updateFkStmt == null) {
            FKArrayStore fKArrayStore = this;
            synchronized (fKArrayStore) {
                int i;
                StringBuilder stmt = new StringBuilder("UPDATE ");
                if (this.elementInfo.length > 1) {
                    stmt.append("?");
                } else {
                    stmt.append(this.elementInfo[0].getDatastoreClass().toString());
                }
                stmt.append(" SET ");
                for (i = 0; i < this.ownerMapping.getNumberOfDatastoreMappings(); ++i) {
                    if (i > 0) {
                        stmt.append(",");
                    }
                    stmt.append(this.ownerMapping.getDatastoreMapping(i).getColumn().getIdentifier().toString());
                    stmt.append(" = ");
                    stmt.append(((AbstractDatastoreMapping)this.ownerMapping.getDatastoreMapping(i)).getUpdateInputParameter());
                }
                for (i = 0; i < this.orderMapping.getNumberOfDatastoreMappings(); ++i) {
                    stmt.append(",");
                    stmt.append(this.orderMapping.getDatastoreMapping(i).getColumn().getIdentifier().toString());
                    stmt.append(" = ");
                    stmt.append(((AbstractDatastoreMapping)this.orderMapping.getDatastoreMapping(i)).getUpdateInputParameter());
                }
                if (this.relationDiscriminatorMapping != null) {
                    for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreMappings(); ++i) {
                        stmt.append(",");
                        stmt.append(this.relationDiscriminatorMapping.getDatastoreMapping(i).getColumn().getIdentifier().toString());
                        stmt.append(" = ");
                        stmt.append(((AbstractDatastoreMapping)this.relationDiscriminatorMapping.getDatastoreMapping(i)).getUpdateInputParameter());
                    }
                }
                stmt.append(" WHERE ");
                BackingStoreHelper.appendWhereClauseForMapping(stmt, this.elementMapping, null, true);
                this.updateFkStmt = stmt.toString();
            }
        }
        return this.updateFkStmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear(ObjectProvider ownerOP) {
        boolean deleteElements = false;
        if (this.ownerMemberMetaData.getArray().isDependentElement()) {
            NucleusLogger.DATASTORE.debug((Object)LOCALISER.msg("056034"));
            deleteElements = true;
        } else if (this.ownerMapping.isNullable() && this.orderMapping.isNullable()) {
            NucleusLogger.DATASTORE.debug((Object)LOCALISER.msg("056036"));
            deleteElements = false;
        } else {
            NucleusLogger.DATASTORE.debug((Object)LOCALISER.msg("056035"));
            deleteElements = true;
        }
        if (deleteElements) {
            ownerOP.isLoaded(this.ownerMemberMetaData.getAbsoluteFieldNumber());
            Object[] value = (Object[])ownerOP.provideField(this.ownerMemberMetaData.getAbsoluteFieldNumber());
            if (value != null && value.length > 0) {
                ownerOP.getExecutionContext().deleteObjects(value);
            }
        } else {
            String clearNullifyStmt = this.getClearNullifyStmt();
            try {
                ExecutionContext ec = ownerOP.getExecutionContext();
                ManagedConnection mconn = this.storeMgr.getConnection(ec);
                SQLController sqlControl = this.storeMgr.getSQLController();
                try {
                    PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, clearNullifyStmt, false);
                    try {
                        int jdbcPosition = 1;
                        jdbcPosition = BackingStoreHelper.populateOwnerInStatement(ownerOP, ec, ps, jdbcPosition, this);
                        if (this.relationDiscriminatorMapping != null) {
                            BackingStoreHelper.populateRelationDiscriminatorInStatement(ec, ps, jdbcPosition, this);
                        }
                        sqlControl.executeStatementUpdate(ec, mconn, clearNullifyStmt, ps, true);
                    }
                    finally {
                        sqlControl.closeStatement(mconn, ps);
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (SQLException e) {
                throw new NucleusDataStoreException(LOCALISER.msg("056013", (Object)clearNullifyStmt), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getClearNullifyStmt() {
        if (this.clearNullifyStmt == null) {
            FKArrayStore fKArrayStore = this;
            synchronized (fKArrayStore) {
                int i;
                StringBuilder stmt = new StringBuilder("UPDATE ");
                if (this.elementInfo.length > 1) {
                    stmt.append("?");
                } else {
                    stmt.append(this.elementInfo[0].getDatastoreClass().toString());
                }
                stmt.append(" SET ");
                for (i = 0; i < this.ownerMapping.getNumberOfDatastoreMappings(); ++i) {
                    if (i > 0) {
                        stmt.append(", ");
                    }
                    stmt.append(this.ownerMapping.getDatastoreMapping(i).getColumn().getIdentifier().toString() + " = NULL");
                }
                for (i = 0; i < this.orderMapping.getNumberOfDatastoreMappings(); ++i) {
                    stmt.append(", ");
                    stmt.append(this.orderMapping.getDatastoreMapping(i).getColumn().getIdentifier().toString() + " = NULL");
                }
                if (this.relationDiscriminatorMapping != null) {
                    for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreMappings(); ++i) {
                        stmt.append(", ");
                        stmt.append(this.relationDiscriminatorMapping.getDatastoreMapping(i).getColumn().getIdentifier().toString() + " = NULL");
                    }
                }
                stmt.append(" WHERE ");
                BackingStoreHelper.appendWhereClauseForMapping(stmt, this.ownerMapping, null, true);
                if (this.relationDiscriminatorMapping != null) {
                    BackingStoreHelper.appendWhereClauseForMapping(stmt, this.relationDiscriminatorMapping, null, false);
                }
                this.clearNullifyStmt = stmt.toString();
            }
        }
        return this.clearNullifyStmt;
    }

    @Override
    public boolean set(ObjectProvider ownerOP, Object array) {
        if (array == null) {
            return true;
        }
        for (int i = 0; i < Array.getLength(array); ++i) {
            this.validateElementForWriting(ownerOP.getExecutionContext(), Array.get(array, i), null);
        }
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            Object obj = Array.get(array, i);
            this.updateElementFk(ownerOP, obj, ownerOP.getObject(), i);
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    @Override
    public Iterator iterator(ObjectProvider ownerOP) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public IteratorStatement getIteratorStatement(ClassLoaderResolver clr, FetchPlan fp, boolean addRestrictionOnOwner) {
        SQLStatement sqlStmt = null;
        SQLExpressionFactory exprFactory = this.storeMgr.getSQLExpressionFactory();
        StatementClassMapping iteratorMappingClass = new StatementClassMapping();
        if (this.elementInfo[0].getDatastoreClass().getDiscriminatorMetaData() != null && this.elementInfo[0].getDatastoreClass().getDiscriminatorMetaData().getStrategy() != DiscriminatorStrategy.NONE) {
            String elementType = this.ownerMemberMetaData.getArray().getElementType();
            if (ClassUtils.isReferenceType((Class)clr.classForName(elementType))) {
                String[] clsNames = this.storeMgr.getNucleusContext().getMetaDataManager().getClassesImplementingInterface(elementType, clr);
                Class[] cls = new Class[clsNames.length];
                for (int i = 0; i < clsNames.length; ++i) {
                    cls[i] = clr.classForName(clsNames[i]);
                }
                sqlStmt = new DiscriminatorStatementGenerator(this.storeMgr, clr, cls, true, null, null).getStatement();
            } else {
                sqlStmt = new DiscriminatorStatementGenerator(this.storeMgr, clr, clr.classForName(this.elementInfo[0].getClassName()), true, null, null).getStatement();
            }
            this.iterateUsingDiscriminator = true;
            SQLStatementHelper.selectFetchPlanOfSourceClassInStatement(sqlStmt, iteratorMappingClass, fp, sqlStmt.getPrimaryTable(), this.emd, 0);
        } else {
            for (int i = 0; i < this.elementInfo.length; ++i) {
                Class elementCls = clr.classForName(this.elementInfo[i].getClassName());
                UnionStatementGenerator stmtGen = new UnionStatementGenerator(this.storeMgr, clr, elementCls, true, null, null);
                stmtGen.setOption("selectNucleusType");
                iteratorMappingClass.setNucleusTypeColumnName("NUCLEUS_TYPE");
                SQLStatement subStmt = stmtGen.getStatement();
                if (sqlStmt == null) {
                    SQLStatementHelper.selectFetchPlanOfSourceClassInStatement(subStmt, iteratorMappingClass, fp, subStmt.getPrimaryTable(), this.emd, 0);
                } else {
                    SQLStatementHelper.selectFetchPlanOfSourceClassInStatement(subStmt, null, fp, subStmt.getPrimaryTable(), this.emd, 0);
                }
                if (sqlStmt == null) {
                    sqlStmt = subStmt;
                    continue;
                }
                sqlStmt.union(subStmt);
            }
        }
        if (addRestrictionOnOwner) {
            SQLTable ownerSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(sqlStmt, sqlStmt.getPrimaryTable(), this.ownerMapping);
            SQLExpression ownerExpr = exprFactory.newExpression(sqlStmt, ownerSqlTbl, this.ownerMapping);
            SQLExpression ownerVal = exprFactory.newLiteralParameter(sqlStmt, this.ownerMapping, null, "OWNER");
            sqlStmt.whereAnd(ownerExpr.eq(ownerVal), true);
        }
        if (this.relationDiscriminatorMapping != null) {
            SQLTable distSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(sqlStmt, sqlStmt.getPrimaryTable(), this.relationDiscriminatorMapping);
            SQLExpression distExpr = exprFactory.newExpression(sqlStmt, distSqlTbl, this.relationDiscriminatorMapping);
            SQLExpression distVal = exprFactory.newLiteral(sqlStmt, this.relationDiscriminatorMapping, this.relationDiscriminatorValue);
            sqlStmt.whereAnd(distExpr.eq(distVal), true);
        }
        if (this.orderMapping != null) {
            SQLTable orderSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(sqlStmt, sqlStmt.getPrimaryTable(), this.orderMapping);
            SQLExpression[] orderExprs = new SQLExpression[this.orderMapping.getNumberOfDatastoreMappings()];
            boolean[] descendingOrder = new boolean[this.orderMapping.getNumberOfDatastoreMappings()];
            orderExprs[0] = exprFactory.newExpression(sqlStmt, orderSqlTbl, this.orderMapping);
            sqlStmt.setOrdering(orderExprs, descendingOrder);
        }
        return new IteratorStatement(this, sqlStmt, iteratorMappingClass);
    }
}

