/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.BooleanLiteral;
import org.datanucleus.store.rdbms.sql.expression.CharacterLiteral;
import org.datanucleus.store.rdbms.sql.expression.FloatingPointLiteral;
import org.datanucleus.store.rdbms.sql.expression.IntegerLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLLiteral;
import org.datanucleus.store.rdbms.sql.expression.StringExpression;
import org.datanucleus.store.types.converters.TypeConverter;

public class StringLiteral
extends StringExpression
implements SQLLiteral {
    private final String value;

    public StringLiteral(SQLStatement stmt, JavaTypeMapping mapping, Object value, String parameterName) {
        super(stmt, null, mapping);
        this.parameterName = parameterName;
        if (value == null) {
            this.value = null;
        } else if (value instanceof String) {
            this.value = (String)value;
        } else if (value instanceof Character) {
            this.value = ((Character)value).toString();
        } else {
            TypeConverter converter;
            Class type = value.getClass();
            if (mapping != null) {
                type = mapping.getJavaType();
            }
            if ((converter = stmt.getRDBMSManager().getNucleusContext().getTypeManager().getTypeConverterForType(type, String.class)) != null) {
                this.value = (String)converter.toDatastoreType(value);
            } else {
                throw new NucleusException("Cannot create " + this.getClass().getName() + " for value of type " + value.getClass().getName());
            }
        }
        if (parameterName != null) {
            this.st.appendParameter(parameterName, mapping, this.value);
        } else {
            this.setStatement();
        }
    }

    public void generateStatementWithoutQuotes() {
        this.st.clearStatement();
        this.st.append(this.value.replace("'", "''"));
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public BooleanExpression eq(SQLExpression expr) {
        if (this.isParameter() || expr.isParameter()) {
            return new BooleanExpression(this, Expression.OP_EQ, expr);
        }
        if (expr instanceof StringLiteral) {
            return new BooleanLiteral(this.stmt, this.stmt.getSQLExpressionFactory().getMappingForType(Boolean.TYPE, false), this.value.equals(((StringLiteral)expr).value));
        }
        return super.eq(expr);
    }

    @Override
    public BooleanExpression ne(SQLExpression expr) {
        if (this.isParameter() || expr.isParameter()) {
            return new BooleanExpression(this, Expression.OP_NOTEQ, expr);
        }
        if (expr instanceof StringLiteral) {
            return new BooleanLiteral(this.stmt, this.stmt.getSQLExpressionFactory().getMappingForType(Boolean.TYPE, false), !this.value.equals(((StringLiteral)expr).value));
        }
        return super.ne(expr);
    }

    @Override
    public BooleanExpression lt(SQLExpression expr) {
        if (this.isParameter() || expr.isParameter()) {
            return new BooleanExpression(this, Expression.OP_LT, expr);
        }
        if (expr instanceof StringLiteral) {
            return new BooleanLiteral(this.stmt, this.stmt.getSQLExpressionFactory().getMappingForType(Boolean.TYPE, false), this.value.compareTo(((StringLiteral)expr).value) < 0);
        }
        return super.lt(expr);
    }

    @Override
    public BooleanExpression le(SQLExpression expr) {
        if (this.isParameter() || expr.isParameter()) {
            return new BooleanExpression(this, Expression.OP_LTEQ, expr);
        }
        if (expr instanceof StringLiteral) {
            return new BooleanLiteral(this.stmt, this.stmt.getSQLExpressionFactory().getMappingForType(Boolean.TYPE, false), this.value.compareTo(((StringLiteral)expr).value) <= 0);
        }
        return super.le(expr);
    }

    @Override
    public BooleanExpression gt(SQLExpression expr) {
        if (this.isParameter() || expr.isParameter()) {
            return new BooleanExpression(this, Expression.OP_GT, expr);
        }
        if (expr instanceof StringLiteral) {
            return new BooleanLiteral(this.stmt, this.stmt.getSQLExpressionFactory().getMappingForType(Boolean.TYPE, false), this.value.compareTo(((StringLiteral)expr).value) > 0);
        }
        return super.gt(expr);
    }

    @Override
    public BooleanExpression ge(SQLExpression expr) {
        if (this.isParameter() || expr.isParameter()) {
            return new BooleanExpression(this, Expression.OP_GTEQ, expr);
        }
        if (expr instanceof StringLiteral) {
            return new BooleanLiteral(this.stmt, this.stmt.getSQLExpressionFactory().getMappingForType(Boolean.TYPE, false), this.value.compareTo(((StringLiteral)expr).value) >= 0);
        }
        return super.ge(expr);
    }

    @Override
    public SQLExpression add(SQLExpression expr) {
        if (expr.isParameter() || this.isParameter()) {
            return super.add(expr);
        }
        if (expr instanceof StringLiteral) {
            return new StringLiteral(this.stmt, this.mapping, (Object)this.value.concat(((StringLiteral)expr).value), null);
        }
        if (expr instanceof CharacterLiteral) {
            return new StringLiteral(this.stmt, this.mapping, (Object)this.value.concat(((SQLLiteral)((Object)expr)).getValue().toString()), null);
        }
        if (expr instanceof IntegerLiteral || expr instanceof FloatingPointLiteral || expr instanceof BooleanLiteral) {
            return new StringLiteral(this.stmt, this.mapping, (Object)this.value.concat(((SQLLiteral)((Object)expr)).getValue().toString()), null);
        }
        return super.add(expr);
    }

    @Override
    public void setNotParameter() {
        if (this.parameterName == null) {
            return;
        }
        this.parameterName = null;
        this.st.clearStatement();
        this.setStatement();
    }

    protected void setStatement() {
        if (this.value == null) {
            this.st.append('\'').append('\'');
        } else {
            this.st.append('\'').append(this.value.replace("'", "''")).append('\'');
        }
    }
}

