/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.store.rdbms.mapping.datastore.DatastoreMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.CharacterLiteral;
import org.datanucleus.store.rdbms.sql.expression.IntegerLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLLiteral;

public class BooleanLiteral
extends BooleanExpression
implements SQLLiteral {
    private final Boolean value;

    public BooleanLiteral(SQLStatement stmt, JavaTypeMapping mapping, Object value, String parameterName) {
        super(stmt, null, mapping);
        this.parameterName = parameterName;
        if (value == null) {
            this.value = null;
        } else if (value instanceof Boolean) {
            this.value = (Boolean)value;
        } else {
            throw new NucleusException("Cannot create " + this.getClass().getName() + " for value of type " + (value != null ? value.getClass().getName() : null));
        }
        if (parameterName != null) {
            this.st.appendParameter(parameterName, mapping, this.value);
        } else {
            this.setStatement();
        }
    }

    public BooleanLiteral(SQLStatement stmt, JavaTypeMapping mapping, Boolean value) {
        super(stmt, null, mapping);
        this.value = value;
        this.hasClosure = true;
        this.setStatement();
    }

    @Override
    public Object getValue() {
        return (boolean)this.value;
    }

    @Override
    public BooleanExpression and(SQLExpression expr) {
        if (expr instanceof BooleanExpression) {
            return this.value != false ? (BooleanExpression)expr : this;
        }
        return super.and(expr);
    }

    @Override
    public BooleanExpression eor(SQLExpression expr) {
        if (expr instanceof BooleanExpression) {
            return this.value != false ? expr.not() : (BooleanExpression)expr;
        }
        return super.eor(expr);
    }

    @Override
    public BooleanExpression ior(SQLExpression expr) {
        if (expr instanceof BooleanExpression) {
            return this.value != false ? this : (BooleanExpression)expr;
        }
        return super.ior(expr);
    }

    @Override
    public BooleanExpression not() {
        if (this.hasClosure) {
            return new BooleanLiteral(this.stmt, this.mapping, this.value == false);
        }
        return new BooleanLiteral(this.stmt, this.mapping, this.value == false, null);
    }

    @Override
    public BooleanExpression eq(SQLExpression expr) {
        if (this.isParameter() || expr.isParameter()) {
            return new BooleanExpression(this, Expression.OP_EQ, expr);
        }
        if (expr instanceof BooleanLiteral) {
            BooleanLiteral exprLit = (BooleanLiteral)expr;
            return new BooleanLiteral(this.stmt, this.mapping, this.value == exprLit.value);
        }
        if (expr instanceof BooleanExpression) {
            DatastoreMapping datastoreMapping = expr.mapping.getDatastoreMapping(0);
            if (datastoreMapping.isStringBased()) {
                return new BooleanExpression(expr, Expression.OP_EQ, new CharacterLiteral(this.stmt, this.mapping, (Object)(this.value != false ? "Y" : "N"), null));
            }
            if ((datastoreMapping.isBitBased() || datastoreMapping.isIntegerBased()) && !this.stmt.getDatastoreAdapter().supportsOption("BitIsReallyBoolean")) {
                return new BooleanExpression(expr, Expression.OP_EQ, new IntegerLiteral(this.stmt, this.mapping, this.value != false ? 1 : 0, null));
            }
            if (this.stmt.getDatastoreAdapter().supportsOption("BooleanExpression")) {
                return new BooleanExpression(this, Expression.OP_EQ, expr);
            }
            return this.and(expr).ior(this.not().and(expr.not()));
        }
        return super.eq(expr);
    }

    @Override
    public BooleanExpression ne(SQLExpression expr) {
        if (this.isParameter() || expr.isParameter()) {
            return new BooleanExpression(this, Expression.OP_NOTEQ, expr);
        }
        if (expr instanceof BooleanLiteral) {
            BooleanLiteral exprLit = (BooleanLiteral)expr;
            return new BooleanLiteral(this.stmt, this.mapping, this.value != exprLit.value);
        }
        if (expr instanceof BooleanExpression) {
            DatastoreMapping datastoreMapping = expr.mapping.getDatastoreMapping(0);
            if (datastoreMapping.isStringBased()) {
                return new BooleanExpression(expr, Expression.OP_NOTEQ, new CharacterLiteral(this.stmt, this.mapping, (Object)(this.value != false ? "Y" : "N"), null));
            }
            if ((datastoreMapping.isBitBased() || datastoreMapping.isIntegerBased()) && !this.stmt.getDatastoreAdapter().supportsOption("BitIsReallyBoolean")) {
                return new BooleanExpression(expr, Expression.OP_NOTEQ, new IntegerLiteral(this.stmt, this.mapping, this.value != false ? 1 : 0, null));
            }
            if (this.stmt.getDatastoreAdapter().supportsOption("BooleanExpression")) {
                return new BooleanExpression(this, Expression.OP_NOTEQ, expr);
            }
            return this.and(expr.not()).ior(this.not().and(expr));
        }
        return super.ne(expr);
    }

    @Override
    public void setNotParameter() {
        if (this.parameterName == null) {
            return;
        }
        this.parameterName = null;
        this.st.clearStatement();
        this.setStatement();
    }

    protected void setStatement() {
        if (this.hasClosure) {
            this.st.append(this.value != false ? "TRUE" : "(1=0)");
        } else {
            DatastoreMapping datastoreMapping = this.mapping.getDatastoreMapping(0);
            if (datastoreMapping.isStringBased()) {
                this.st.append(this.value != false ? "'Y'" : "'N'");
            } else if ((datastoreMapping.isBitBased() || datastoreMapping.isIntegerBased()) && !this.stmt.getDatastoreAdapter().supportsOption("BitIsReallyBoolean")) {
                this.st.append(this.value != false ? "1" : "0");
            } else {
                this.st.append(this.value != false ? "TRUE" : "(1=0)");
            }
        }
    }
}

