/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.StoredProcQueryParameterMode;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.connection.ManagedConnectionResourceListener;
import org.datanucleus.store.query.AbstractStoredProcedureQuery;
import org.datanucleus.store.query.NoQueryResultsException;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.QueryNotUniqueException;
import org.datanucleus.store.query.QueryResult;
import org.datanucleus.store.query.ResultObjectFactory;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.adapter.DatastoreAdapter;
import org.datanucleus.store.rdbms.query.AbstractRDBMSQueryResult;
import org.datanucleus.store.rdbms.query.ForwardQueryResult;
import org.datanucleus.store.rdbms.query.RDBMSQueryUtils;
import org.datanucleus.store.rdbms.query.ResultMetaDataROF;
import org.datanucleus.store.rdbms.query.ScrollableQueryResult;
import org.datanucleus.util.NucleusLogger;

public class StoredProcedureQuery
extends AbstractStoredProcedureQuery {
    CallableStatement stmt;

    public StoredProcedureQuery(StoreManager storeMgr, ExecutionContext ec, StoredProcedureQuery query) {
        super(storeMgr, ec, (AbstractStoredProcedureQuery)query);
    }

    public StoredProcedureQuery(StoreManager storeMgr, ExecutionContext ec) {
        super(storeMgr, ec, (String)null);
    }

    public StoredProcedureQuery(StoreManager storeMgr, ExecutionContext ec, String procName) {
        super(storeMgr, ec, procName);
    }

    protected void compileInternal(Map parameterValues) {
        DatastoreAdapter dba = ((RDBMSStoreManager)this.storeMgr).getDatastoreAdapter();
        if (!dba.supportsOption("StoredProcs")) {
            throw new NucleusUserException("This RDBMS does not support stored procedures!");
        }
    }

    public boolean processesRangeInDatastoreQuery() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object executeQuery(Map parameters) {
        this.inputParameters = new HashMap();
        if (this.implicitParameters != null) {
            this.inputParameters.putAll(this.implicitParameters);
        }
        if (parameters != null) {
            this.inputParameters.putAll(parameters);
        }
        this.prepareDatastore();
        boolean failed = true;
        long start = 0L;
        if (this.ec.getStatistics() != null) {
            start = System.currentTimeMillis();
            this.ec.getStatistics().queryBegin();
        }
        try {
            Object object = this.performExecute(this.inputParameters);
            return object;
        }
        finally {
            if (this.ec.getStatistics() != null) {
                if (failed) {
                    this.ec.getStatistics().queryExecutedWithError();
                } else {
                    this.ec.getStatistics().queryExecuted(System.currentTimeMillis() - start);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object performExecute(Map parameters) {
        Boolean bl;
        RDBMSStoreManager storeMgr = (RDBMSStoreManager)this.getStoreManager();
        ManagedConnection mconn = storeMgr.getConnection(this.ec);
        try {
            Connection conn = (Connection)mconn.getConnection();
            StringBuffer stmtStr = new StringBuffer("CALL " + this.procedureName);
            stmtStr.append("(");
            if (this.storedProcParams != null && !this.storedProcParams.isEmpty()) {
                Iterator paramIter = this.storedProcParams.iterator();
                while (paramIter.hasNext()) {
                    paramIter.next();
                    stmtStr.append("?");
                    if (!paramIter.hasNext()) continue;
                    stmtStr.append(",");
                }
            }
            stmtStr.append(")");
            this.stmt = conn.prepareCall(stmtStr.toString());
            boolean hasOutputParams = false;
            if (this.storedProcParams != null && !this.storedProcParams.isEmpty()) {
                for (AbstractStoredProcedureQuery.StoredProcedureParameter param : this.storedProcParams) {
                    if (param.getMode() == StoredProcQueryParameterMode.IN || param.getMode() == StoredProcQueryParameterMode.INOUT) {
                        if (param.getType() == Integer.class) {
                            if (param.getName() != null) {
                                this.stmt.setInt(param.getName(), (int)((Integer)parameters.get(param.getName())));
                            } else {
                                this.stmt.setInt(param.getPosition(), (int)((Integer)parameters.get(param.getPosition())));
                            }
                        } else if (param.getType() == Long.class) {
                            if (param.getName() != null) {
                                this.stmt.setLong(param.getName(), (long)((Long)parameters.get(param.getName())));
                            } else {
                                this.stmt.setLong(param.getPosition(), (long)((Long)parameters.get(param.getPosition())));
                            }
                        } else if (param.getType() == Short.class) {
                            if (param.getName() != null) {
                                this.stmt.setShort(param.getName(), (short)((Short)parameters.get(param.getName())));
                            } else {
                                this.stmt.setShort(param.getPosition(), (short)((Short)parameters.get(param.getPosition())));
                            }
                        } else if (param.getType() == Double.class) {
                            if (param.getName() != null) {
                                this.stmt.setDouble(param.getName(), (double)((Double)parameters.get(param.getName())));
                            } else {
                                this.stmt.setDouble(param.getPosition(), (double)((Double)parameters.get(param.getPosition())));
                            }
                        } else if (param.getType() == Float.class) {
                            if (param.getName() != null) {
                                this.stmt.setFloat(param.getName(), ((Float)parameters.get(param.getName())).floatValue());
                            } else {
                                this.stmt.setFloat(param.getPosition(), ((Float)parameters.get(param.getPosition())).floatValue());
                            }
                        } else if (param.getType() == Boolean.class) {
                            if (param.getName() != null) {
                                this.stmt.setBoolean(param.getName(), (boolean)((Boolean)parameters.get(param.getName())));
                            } else {
                                this.stmt.setBoolean(param.getPosition(), (boolean)((Boolean)parameters.get(param.getPosition())));
                            }
                        } else if (param.getType() == String.class) {
                            if (param.getName() != null) {
                                this.stmt.setString(param.getName(), (String)parameters.get(param.getName()));
                            } else {
                                this.stmt.setString(param.getPosition(), (String)parameters.get(param.getPosition()));
                            }
                        } else if (param.getType() == java.util.Date.class) {
                            if (param.getName() != null) {
                                this.stmt.setDate(param.getName(), (Date)parameters.get(param.getName()));
                            } else {
                                this.stmt.setDate(param.getPosition(), (Date)parameters.get(param.getPosition()));
                            }
                        } else if (param.getType() == BigInteger.class) {
                            if (param.getName() != null) {
                                this.stmt.setLong(param.getName(), ((BigInteger)parameters.get(param.getName())).longValue());
                            } else {
                                this.stmt.setLong(param.getPosition(), ((BigInteger)parameters.get(param.getPosition())).longValue());
                            }
                        } else if (param.getType() == BigDecimal.class) {
                            if (param.getName() != null) {
                                this.stmt.setDouble(param.getName(), ((BigDecimal)parameters.get(param.getName())).doubleValue());
                            } else {
                                this.stmt.setDouble(param.getPosition(), ((BigDecimal)parameters.get(param.getPosition())).doubleValue());
                            }
                        } else {
                            throw new NucleusException("Dont currently support stored proc input params of type " + param.getType());
                        }
                    }
                    if (param.getMode() != StoredProcQueryParameterMode.OUT && param.getMode() != StoredProcQueryParameterMode.INOUT) continue;
                    if (param.getType() == Integer.class) {
                        if (param.getName() != null) {
                            this.stmt.registerOutParameter(param.getName(), 4);
                        } else {
                            this.stmt.registerOutParameter((int)param.getPosition(), 4);
                        }
                    } else if (param.getType() == Long.class) {
                        if (param.getName() != null) {
                            this.stmt.registerOutParameter(param.getName(), 4);
                        } else {
                            this.stmt.registerOutParameter((int)param.getPosition(), 4);
                        }
                    } else if (param.getType() == Short.class) {
                        if (param.getName() != null) {
                            this.stmt.registerOutParameter(param.getName(), 4);
                        } else {
                            this.stmt.registerOutParameter((int)param.getPosition(), 4);
                        }
                    } else if (param.getType() == Double.class) {
                        if (param.getName() != null) {
                            this.stmt.registerOutParameter(param.getName(), 8);
                        } else {
                            this.stmt.registerOutParameter((int)param.getPosition(), 8);
                        }
                    } else if (param.getType() == Float.class) {
                        if (param.getName() != null) {
                            this.stmt.registerOutParameter(param.getName(), 6);
                        } else {
                            this.stmt.registerOutParameter((int)param.getPosition(), 6);
                        }
                    } else if (param.getType() == Boolean.class) {
                        if (param.getName() != null) {
                            this.stmt.registerOutParameter(param.getName(), 16);
                        } else {
                            this.stmt.registerOutParameter((int)param.getPosition(), 16);
                        }
                    } else if (param.getType() == String.class) {
                        if (param.getName() != null) {
                            this.stmt.registerOutParameter(param.getName(), 12);
                        } else {
                            this.stmt.registerOutParameter((int)param.getPosition(), 12);
                        }
                    } else if (param.getType() == java.util.Date.class) {
                        if (param.getName() != null) {
                            this.stmt.registerOutParameter(param.getName(), 91);
                        } else {
                            this.stmt.registerOutParameter((int)param.getPosition(), 91);
                        }
                    } else if (param.getType() == BigInteger.class) {
                        if (param.getName() != null) {
                            this.stmt.registerOutParameter(param.getName(), -5);
                        } else {
                            this.stmt.registerOutParameter((int)param.getPosition(), -5);
                        }
                    } else if (param.getType() == BigDecimal.class) {
                        if (param.getName() != null) {
                            this.stmt.registerOutParameter(param.getName(), 8);
                        } else {
                            this.stmt.registerOutParameter((int)param.getPosition(), 8);
                        }
                    } else {
                        throw new NucleusException("Dont currently support stored proc output params of type " + param.getType());
                    }
                    hasOutputParams = true;
                }
            }
            if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_NATIVE.debug((Object)stmtStr.toString());
            }
            boolean hasResultSet = this.stmt.execute();
            if (hasOutputParams) {
                for (AbstractStoredProcedureQuery.StoredProcedureParameter param : this.storedProcParams) {
                    if (param.getMode() != StoredProcQueryParameterMode.OUT && param.getMode() != StoredProcQueryParameterMode.INOUT) continue;
                    Object value = null;
                    if (param.getType() == Integer.class) {
                        value = param.getName() != null ? Integer.valueOf(this.stmt.getInt(param.getName())) : Integer.valueOf(this.stmt.getInt(param.getPosition()));
                    } else if (param.getType() == Long.class) {
                        value = param.getName() != null ? Long.valueOf(this.stmt.getLong(param.getName())) : Long.valueOf(this.stmt.getLong(param.getPosition()));
                    } else if (param.getType() == Short.class) {
                        value = param.getName() != null ? Short.valueOf(this.stmt.getShort(param.getName())) : Short.valueOf(this.stmt.getShort(param.getPosition()));
                    } else if (param.getType() == Double.class) {
                        value = param.getName() != null ? Double.valueOf(this.stmt.getDouble(param.getName())) : Double.valueOf(this.stmt.getDouble(param.getPosition()));
                    } else if (param.getType() == Float.class) {
                        value = param.getName() != null ? Float.valueOf(this.stmt.getFloat(param.getName())) : Float.valueOf(this.stmt.getFloat(param.getPosition()));
                    } else if (param.getType() == Boolean.class) {
                        value = param.getName() != null ? Boolean.valueOf(this.stmt.getBoolean(param.getName())) : Boolean.valueOf(this.stmt.getBoolean(param.getPosition()));
                    } else if (param.getType() == String.class) {
                        value = param.getName() != null ? this.stmt.getString(param.getName()) : this.stmt.getString(param.getPosition());
                    } else if (param.getType() == java.util.Date.class) {
                        value = param.getName() != null ? this.stmt.getDate(param.getName()) : this.stmt.getDate(param.getPosition());
                    } else if (param.getType() == BigInteger.class) {
                        value = param.getName() != null ? Long.valueOf(this.stmt.getLong(param.getName())) : Long.valueOf(this.stmt.getLong(param.getPosition()));
                    } else if (param.getType() == BigDecimal.class) {
                        value = param.getName() != null ? Double.valueOf(this.stmt.getDouble(param.getName())) : Double.valueOf(this.stmt.getDouble(param.getPosition()));
                    } else {
                        throw new NucleusUserException("Dont currently support output parameters of type=" + param.getType());
                    }
                    if (this.outputParamValues == null) {
                        this.outputParamValues = new HashMap();
                    }
                    if (param.getName() != null) {
                        this.outputParamValues.put(param.getName(), value);
                        continue;
                    }
                    this.outputParamValues.put(param.getPosition(), value);
                }
            }
            bl = hasResultSet;
        }
        catch (Throwable throwable) {
            try {
                mconn.release();
                throw throwable;
            }
            catch (SQLException e) {
                throw new NucleusDataStoreException(LOCALISER.msg("059027", (Object)this.procedureName), (Throwable)e);
            }
        }
        mconn.release();
        return bl;
    }

    public boolean hasMoreResults() {
        if (this.stmt == null) {
            throw new NucleusUserException("Cannot check for more results until the stored procedure has been executed");
        }
        try {
            return this.stmt.getMoreResults();
        }
        catch (SQLException sqle) {
            return false;
        }
    }

    public int getUpdateCount() {
        if (this.stmt == null) {
            throw new NucleusUserException("Cannot check for update count until the stored procedure has been executed");
        }
        ManagedConnection mconn = this.storeMgr.getConnection(this.ec);
        try {
            ++this.resultSetNumber;
            int n = this.stmt.getUpdateCount();
            return n;
        }
        catch (SQLException sqle) {
            throw new NucleusDataStoreException("Exception from CallableStatement.getUpdateCount", (Throwable)sqle);
        }
        finally {
            mconn.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getNextResults() {
        QueryResult qr;
        if (this.stmt == null) {
            throw new NucleusUserException("Cannot check for more results until the stored procedure has been executed");
        }
        ManagedConnection mconn = this.storeMgr.getConnection(this.ec);
        try {
            ++this.resultSetNumber;
            ResultSet rs = this.stmt.getResultSet();
            qr = this.getResultsForResultSet((RDBMSStoreManager)this.storeMgr, rs, mconn);
            if (this.shouldReturnSingleRow()) {
                if (qr == null || qr.size() == 0) {
                    throw new NoQueryResultsException("No query results were returned");
                }
                Iterator qrIter = qr.iterator();
                Object firstRow = qrIter.next();
                if (qrIter.hasNext()) {
                    throw new QueryNotUniqueException();
                }
                Object e = firstRow;
                return e;
            }
            QueryResult queryResult = qr;
            return queryResult;
        }
        catch (SQLException sqle) {}
        {
            finally {
                if (qr != null) {
                    this.close(qr);
                }
            }
        }
        {
            throw new NucleusDataStoreException("Exception from CallableStatement.getResultSet", (Throwable)sqle);
        }
        finally {
            mconn.release();
        }
    }

    protected QueryResult getResultsForResultSet(RDBMSStoreManager storeMgr, ResultSet rs, ManagedConnection mconn) throws SQLException {
        ResultObjectFactory rof = null;
        rof = this.resultMetaDatas != null ? new ResultMetaDataROF(storeMgr, this.resultMetaDatas[this.resultSetNumber]) : RDBMSQueryUtils.getResultObjectFactoryForNoCandidateClass(storeMgr, rs, this.resultClasses != null ? this.resultClasses[this.resultSetNumber] : null);
        String resultSetType = RDBMSQueryUtils.getResultSetTypeForQuery((Query)this);
        AbstractRDBMSQueryResult qr = null;
        qr = resultSetType.equals("scroll-insensitive") || resultSetType.equals("scroll-sensitive") ? new ScrollableQueryResult((Query)this, rof, rs, null) : new ForwardQueryResult((Query)this, rof, rs, null);
        ScrollableQueryResult qr1 = qr;
        ManagedConnection mconn1 = mconn;
        ManagedConnectionResourceListener listener = new ManagedConnectionResourceListener((QueryResult)qr1, mconn1){
            final /* synthetic */ QueryResult val$qr1;
            final /* synthetic */ ManagedConnection val$mconn1;
            {
                this.val$qr1 = queryResult;
                this.val$mconn1 = managedConnection;
            }

            public void transactionFlushed() {
            }

            public void transactionPreClose() {
                this.val$qr1.disconnect();
            }

            public void managedConnectionPreClose() {
                if (!StoredProcedureQuery.this.ec.getTransaction().isActive()) {
                    this.val$qr1.disconnect();
                }
            }

            public void managedConnectionPostClose() {
            }

            public void resourcePostClose() {
                this.val$mconn1.removeListener((ManagedConnectionResourceListener)this);
            }
        };
        mconn.addListener(listener);
        ((AbstractRDBMSQueryResult)qr).addConnectionListener(listener);
        return qr;
    }
}

