/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.datastore;

import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.exceptions.NullValueException;
import org.datanucleus.store.rdbms.mapping.datastore.AbstractDatastoreMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.java.SingleFieldMapping;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.util.StringUtils;

public class TinyIntRDBMSMapping
extends AbstractDatastoreMapping {
    protected TinyIntRDBMSMapping(RDBMSStoreManager storeMgr, JavaTypeMapping mapping) {
        super(storeMgr, mapping);
    }

    public TinyIntRDBMSMapping(JavaTypeMapping mapping, RDBMSStoreManager storeMgr, Column col) {
        super(storeMgr, mapping);
        this.column = col;
        this.initialize();
    }

    private void initialize() {
        if (this.column != null) {
            Object[] validValues;
            this.column.checkPrimitive();
            if (this.getJavaTypeMapping() instanceof SingleFieldMapping && (validValues = ((SingleFieldMapping)this.getJavaTypeMapping()).getValidValues(0)) != null) {
                String constraints = this.storeMgr.getDatastoreAdapter().getCheckConstraintForValues(this.column.getIdentifier(), validValues, this.column.isNullable());
                this.column.setConstraints(constraints);
            }
            if (this.getJavaTypeMapping().getJavaType() == Boolean.class) {
                StringBuffer constraints = new StringBuffer("CHECK (" + this.column.getIdentifier() + " IN (0,1)");
                if (this.column.isNullable()) {
                    constraints.append(" OR " + this.column.getIdentifier() + " IS NULL");
                }
                constraints.append(')');
                this.column.setConstraints(constraints.toString());
            }
        }
        this.initTypeInfo();
    }

    @Override
    public boolean isIntegerBased() {
        return true;
    }

    @Override
    public SQLTypeInfo getTypeInfo() {
        if (this.column != null && this.column.getColumnMetaData().getSqlType() != null) {
            return this.storeMgr.getSQLTypeInfoForJDBCType(-6, this.column.getColumnMetaData().getSqlType());
        }
        return this.storeMgr.getSQLTypeInfoForJDBCType(-6);
    }

    @Override
    public void setBoolean(Object ps, int param, boolean value) {
        try {
            ((PreparedStatement)ps).setInt(param, value ? 1 : 0);
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055001", (Object)"boolean", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public boolean getBoolean(Object rs, int param) {
        boolean value;
        block4: {
            try {
                int intValue = ((ResultSet)rs).getInt(param);
                if (intValue == 0) {
                    value = false;
                    break block4;
                }
                if (intValue == 1) {
                    value = true;
                    break block4;
                }
                throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055006", (Object)"Types.TINYINT", (Object)("" + intValue)));
            }
            catch (SQLException e) {
                throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055002", (Object)"Boolean", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
            }
        }
        return value;
    }

    @Override
    public void setInt(Object ps, int param, int value) {
        try {
            ((PreparedStatement)ps).setInt(param, value);
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055001", (Object)"int", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public int getInt(Object rs, int param) {
        int value;
        try {
            value = ((ResultSet)rs).getInt(param);
            if ((this.column == null || this.column.getColumnMetaData() == null || !this.column.getColumnMetaData().isAllowsNull()) && ((ResultSet)rs).wasNull()) {
                throw new NullValueException(LOCALISER_RDBMS.msg("055003", (Object)this.column));
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055002", (Object)"int", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
        return value;
    }

    @Override
    public void setLong(Object ps, int param, long value) {
        try {
            ((PreparedStatement)ps).setLong(param, value);
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055001", (Object)"int", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public long getLong(Object rs, int param) {
        int value;
        try {
            value = ((ResultSet)rs).getInt(param);
            if ((this.column == null || this.column.getColumnMetaData() == null || !this.column.getColumnMetaData().isAllowsNull()) && ((ResultSet)rs).wasNull()) {
                throw new NullValueException(LOCALISER_RDBMS.msg("055003", (Object)this.column));
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055002", (Object)"int", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
        return value;
    }

    @Override
    public void setByte(Object ps, int param, byte value) {
        try {
            ((PreparedStatement)ps).setInt(param, value);
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055001", (Object)"byte", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public byte getByte(Object rs, int param) {
        byte value;
        try {
            value = ((ResultSet)rs).getByte(param);
            if ((this.column == null || this.column.getColumnMetaData() == null || !this.column.getColumnMetaData().isAllowsNull()) && ((ResultSet)rs).wasNull()) {
                throw new NullValueException(LOCALISER_RDBMS.msg("055003", (Object)this.column));
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055002", (Object)"byte", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
        return value;
    }

    @Override
    public void setObject(Object ps, int param, Object value) {
        block8: {
            try {
                if (value == null) {
                    if (this.column != null && this.column.isDefaultable() && this.column.getDefaultValue() != null && !StringUtils.isWhitespace((String)this.column.getDefaultValue().toString())) {
                        ((PreparedStatement)ps).setInt(param, Integer.valueOf(this.column.getDefaultValue().toString()));
                    } else {
                        ((PreparedStatement)ps).setNull(param, this.getTypeInfo().getDataType());
                    }
                    break block8;
                }
                if (value instanceof Byte) {
                    ((PreparedStatement)ps).setInt(param, ((Byte)value).shortValue());
                    break block8;
                }
                if (value instanceof BigInteger) {
                    ((PreparedStatement)ps).setInt(param, ((BigInteger)value).shortValue());
                    break block8;
                }
                if (value instanceof Boolean) {
                    ((PreparedStatement)ps).setInt(param, (Boolean)value != false ? 1 : 0);
                    break block8;
                }
                throw new NucleusException("TinyIntRDBMSMapping.setObject called for " + StringUtils.toJVMIDString((Object)value) + " but not supported");
            }
            catch (SQLException e) {
                throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055001", (Object)"Byte", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
            }
        }
    }

    @Override
    public Object getObject(Object rs, int param) {
        Comparable<BigInteger> value;
        try {
            int d = ((ResultSet)rs).getInt(param);
            value = this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_MATH_BIGINTEGER) ? (((ResultSet)rs).wasNull() ? null : BigInteger.valueOf(d)) : (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_LANG_BOOLEAN) ? (Comparable<Boolean>)(((ResultSet)rs).wasNull() ? null : (d == 1 ? Boolean.TRUE : Boolean.FALSE)) : (Comparable<Boolean>)(((ResultSet)rs).wasNull() ? null : Byte.valueOf(((ResultSet)rs).getByte(param))));
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055002", (Object)"Byte", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
        return value;
    }
}

