/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.datastore;

import java.io.IOException;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.datatype.BlobImpl;
import org.datanucleus.store.rdbms.mapping.datastore.AbstractLargeBinaryRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.table.Column;

public class BlobRDBMSMapping
extends AbstractLargeBinaryRDBMSMapping {
    protected BlobRDBMSMapping(RDBMSStoreManager storeMgr, JavaTypeMapping mapping) {
        super(storeMgr, mapping);
    }

    public BlobRDBMSMapping(JavaTypeMapping mapping, RDBMSStoreManager storeMgr, Column col) {
        super(mapping, storeMgr, col);
    }

    @Override
    public SQLTypeInfo getTypeInfo() {
        if (this.column != null && this.column.getColumnMetaData().getSqlType() != null) {
            return this.storeMgr.getSQLTypeInfoForJDBCType(2004, this.column.getColumnMetaData().getSqlType());
        }
        return this.storeMgr.getSQLTypeInfoForJDBCType(2004);
    }

    @Override
    public Object getObject(Object rs, int param) {
        byte[] bytes = null;
        try {
            bytes = ((ResultSet)rs).getBytes(param);
            if (bytes == null) {
                return null;
            }
        }
        catch (SQLException sqle) {
            try {
                Blob blob = ((ResultSet)rs).getBlob(param);
                if (blob == null) {
                    return null;
                }
                bytes = blob.getBytes(1L, (int)blob.length());
                if (bytes == null) {
                    return null;
                }
            }
            catch (SQLException sqle2) {
                throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055002", (Object)"Object", (Object)("" + param), (Object)this.column, (Object)sqle2.getMessage()), (Throwable)sqle2);
            }
        }
        return this.getObjectForBytes(bytes, param);
    }

    @Override
    public void setObject(Object ps, int param, Object value) {
        super.setObject(ps, param, value);
    }

    @Override
    public void setString(Object ps, int param, String value) {
        try {
            if (this.getDatastoreAdapter().supportsOption("BlobSetUsingSetString")) {
                if (value == null) {
                    if (this.column.isDefaultable() && this.column.getDefaultValue() != null) {
                        ((PreparedStatement)ps).setString(param, this.column.getDefaultValue().toString().trim());
                    } else {
                        ((PreparedStatement)ps).setNull(param, this.getTypeInfo().getDataType());
                    }
                } else {
                    ((PreparedStatement)ps).setString(param, value);
                }
            } else if (value == null) {
                if (this.column != null && this.column.isDefaultable() && this.column.getDefaultValue() != null) {
                    ((PreparedStatement)ps).setBlob(param, new BlobImpl(this.column.getDefaultValue().toString().trim()));
                } else {
                    ((PreparedStatement)ps).setNull(param, this.getTypeInfo().getDataType());
                }
            } else {
                ((PreparedStatement)ps).setBlob(param, new BlobImpl(value));
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055001", (Object)"String", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
        catch (IOException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055001", (Object)"String", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public String getString(Object rs, int param) {
        String value;
        try {
            if (this.getDatastoreAdapter().supportsOption("BlobSetUsingSetString")) {
                value = ((ResultSet)rs).getString(param);
            } else {
                byte[] bytes = ((ResultSet)rs).getBytes(param);
                if (bytes == null) {
                    value = null;
                } else {
                    BlobImpl blob = new BlobImpl(bytes);
                    value = (String)blob.getObject();
                }
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055002", (Object)"String", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
        return value;
    }
}

