/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import org.datanucleus.ClassConstants;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.mapped.DatastoreAdapter;
import org.datanucleus.store.mapped.mapping.InterfaceMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.OIDMapping;
import org.datanucleus.store.mapped.mapping.PersistableMapping;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.util.Localiser;

public abstract class BaseContainerStore {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.Localisation", (ClassLoader)ClassConstants.NUCLEUS_CONTEXT_LOADER);
    protected RDBMSStoreManager storeMgr;
    protected DatastoreAdapter dba;
    protected JavaTypeMapping ownerMapping;
    protected AbstractMemberMetaData ownerMemberMetaData;
    protected RelationType relationType;
    protected boolean allowNulls = false;

    protected BaseContainerStore(RDBMSStoreManager storeMgr) {
        this.storeMgr = storeMgr;
        this.dba = this.storeMgr.getDatastoreAdapter();
    }

    protected void setOwner(AbstractMemberMetaData mmd, ClassLoaderResolver clr) {
        this.ownerMemberMetaData = mmd;
        if (Boolean.TRUE.equals(this.ownerMemberMetaData.getContainer().allowNulls())) {
            this.allowNulls = true;
        }
        this.relationType = this.ownerMemberMetaData.getRelationType(clr);
    }

    public RDBMSStoreManager getStoreManager() {
        return this.storeMgr;
    }

    public JavaTypeMapping getOwnerMapping() {
        return this.ownerMapping;
    }

    protected boolean isEmbeddedMapping(JavaTypeMapping mapping) {
        return !InterfaceMapping.class.isAssignableFrom(mapping.getClass()) && !OIDMapping.class.isAssignableFrom(mapping.getClass()) && !PersistableMapping.class.isAssignableFrom(mapping.getClass());
    }

    public ObjectProvider getObjectProviderForEmbeddedPCObject(ObjectProvider op, Object obj, AbstractMemberMetaData ownerMmd, short pcType) {
        ExecutionContext ec = op.getExecutionContext();
        ObjectProvider objSM = ec.findObjectProvider(obj);
        if (objSM == null) {
            objSM = ec.newObjectProviderForEmbedded(obj, false, op, ownerMmd.getAbsoluteFieldNumber());
        }
        objSM.setPcObjectType(pcType);
        return objSM;
    }

    protected boolean allowsBatching() {
        return this.storeMgr.allowsBatching();
    }

    public RelationType getRelationType() {
        return this.relationType;
    }

    public AbstractMemberMetaData getOwnerMemberMetaData() {
        return this.ownerMemberMetaData;
    }

    public DatastoreAdapter getDatastoreAdapter() {
        return this.dba;
    }
}

